;
; $DELTATIME = [[days -][hours][:[minutes][:[seconds][.ticks]]]
;	     = " $DELTATIME ["]
;
Version 1.1
;
Include	<saphir/CLD.h>
;
Character Sets

;
Flags	= EXPLICITBLANKING
;
Definitions
Clear
	long tree
	long start
	long times[7]
;
Rules

State	Initial
Trans	'"'
Trans	p$Lambda,Deltatime,SetStart,,,0

State	Head
Trans	p$Blank,Head
Trans	p$Lambda,,SetStart,,,1

State
Trans	!Deltatime

State	Tail
Trans	'"',p$Exit
Trans	p$Eos,p$Exit
Trans	p$Blank,Tail
Trans	p$Lambda,p$Fail,FreeTree

State	Deltatime
Trans	!Days
Trans	p$Lambda

State
Trans	p$Decimal,,SetTime,,,2
Trans	p$Lambda

State
Trans	':'
Trans	p$Lambda,p$Exit,MakeTree

State
Trans	p$Decimal,,SetTime,,,3
Trans	p$Lambda

State
Trans	':'
Trans	p$Lambda,p$Exit,MakeTree

State
Trans	p$Decimal,,SetTime,,,4
Trans	p$Lambda

State
Trans	'.',,SetDigit
Trans	p$Lambda,p$Exit,MakeTree

State
Trans	p$Decimal,,SetTime,,,5
Trans 	p$Lambda

State
Trans	p$Lambda,p$Exit,MakeTree

State	Days
Trans	p$Decimal,,SetTime,,,1
Trans	p$Lambda

State
Trans	p$Blank,p$Exit,BlankAllowed
Trans	'-',p$Exit
Trans	p$Lambda,p$Fail,ClearTime,,,1

;
Inline

static long maxtimes[5] = { 0,23,59,59,0 };
static int blankallowed;

static SetStart(pcb,ba)
PCB *pcb;
long ba;
{
 pcb->pcb_start = (long)pcb->sys_pcb.pcb_line;
 blankallowed = ba;
 return parse_exit;
}

static BlankAllowed()
{
 return blankallowed ? parse_exit : parse_fail;
}

static SetDigit(pcb)
PCB *pcb;
{
 pcb->pcb_times[6] = -((long)pcb->sys_pcb.pcb_line);
 return parse_exit;
}

static SetTime(pcb,ix)
PCB *pcb;
long ix;
{
 pcb->pcb_times[ix] = pcb->sys_pcb.pcb_token;
 return parse_exit;
}

static ClearTime(pcb,ix)
PCB *pcb;
long ix;
{
 pcb->pcb_times[ix] = 0;
 return parse_exit;
}

static MakeTree(pcb)
PCB *pcb;
{
 char *start,*createValue();
 int len,ix;

 pcb->pcb_times[0] = 'DELT';
 for ( ix = 6 ; --ix ; )
  if ( (pcb->pcb_times[ix] < 0) || 
       (maxtimes[ix-1] && (pcb->pcb_times[ix] > maxtimes[ix-1])) )
   return parse_fail;
 start = (char *)pcb->pcb_start;
 if ( (len = pcb->sys_pcb.pcb_line-start) <= 0 ) return parse_fail;
 if ( pcb->pcb_times[6] ) pcb->pcb_times[6] += (long)pcb->sys_pcb.pcb_line;
 if ( !(pcb->pcb_tree = 
        (long)createValue(start,len,-1,sizeof(pcb->pcb_times),pcb->pcb_times)) )
  return CDU_NOMEM;
 return parse_exit;
}

static FreeTree(pcb)
PCB *pcb;
{
 free(pcb->pcb_tree);
 return parse_exit;
}
