;
; $DATETIME = [absolute][+- delta]
; absolute  = [[date :][time]]
; date      = [[dd][-[mmm][-[yyyy]]]]
;	    = yesterday | today | tomorrow
;
Version 1.1
;
Include	<saphir/CLD.h>
;
Character Sets
;
Flags	    = EXPLICITBLANKING
Abbrevation = UNIQUE
;
Definitions
Clear
	long tree
	long start
	long start2
	long times[16]
	long key
	 TOMORROW	=	$01
	 YESTERDAY	=	$02
	 GOTDAY		=	$10
	 GOTMONTH	=	$20
	 GOTYEAR	=	$40
	 GOTALL		=	$70
;
Rules

State	Initial
Trans	'"'
Trans	p$Lambda,Datetime,SetStart,,,0

State	Head
Trans	p$Blank,Head
Trans	p$Lambda,,SetStart,,,1

State
Trans	!Datetime

State	Tail
Trans	'"',p$Exit
Trans	p$Eos,p$Exit
Trans	p$Blank,Tail
Trans	p$Lambda,p$Fail,FreeTree

State	Datetime
Trans	!Date
Trans	p$Lambda,Time

State
Trans	p$Blank,,BlankAllowed
Trans	':'
Trans	p$Lambda,p$Exit,MakeTree

State	Time
Trans	p$Decimal,,SetTime,,,4
Trans	p$Lambda

State
Trans	':'
Trans	p$Lambda,Combine

State
Trans	p$Decimal,,SetTime,,,5
Trans	p$Lambda

State
Trans	':'
Trans	p$Lambda,Combine

State
Trans	p$Decimal,,SetTime,,,6
Trans	p$Lambda

State
Trans	'.',,SetDigit,,,8
Trans	p$Lambda,Combine

State
Trans	p$Decimal,,SetTime,,,7
Trans 	p$Lambda,,EndDigit,,,8

State	Combine
Trans	'-',,SetTime,,,9
Trans	'+',,SetTime,,,9
Trans	p$Lambda,p$Exit,MakeTree

State
Trans	!Days
Trans	p$Lambda

State
Trans	p$Decimal,,SetTime,,,11
Trans	p$Lambda

State
Trans	':'
Trans	p$Lambda,p$Exit,MakeTree

State
Trans	p$Decimal,,SetTime,,,12
Trans	p$Lambda

State
Trans	':'
Trans	p$Lambda,p$Exit,MakeTree

State
Trans	p$Decimal,,SetTime,,,13
Trans	p$Lambda

State
Trans	'.',,SetDigit,,,15
Trans	p$Lambda,p$Exit,MakeTree

State
Trans	p$Decimal,,SetTime,,,14
Trans 	p$Lambda,,EndDigit,,,15

State
Trans	p$Lambda,p$Exit,MakeTree

State	Days
Trans	p$Decimal,,SetTime,,,10
Trans	p$Lambda

State
Trans	'-',p$Exit
Trans	p$Lambda,p$Fail,ClearTime,,,10

State	Date
Trans	'TODAY',p$Exit
Trans	'TOMORROW',p$Exit,,TOMORROW,key
Trans	'YESTERDAY',p$Exit,,YESTERDAY,key
Trans	p$Decimal,,SetTime,GOTDAY,key,1
Trans	p$Lambda

State
Trans	'-'
Trans	p$Lambda,p$Fail,ClearTime,,,1

State	Month
Trans	'APR',,SetMonth,GOTMONTH,key,4
Trans	'AUG',,SetMonth,GOTMONTH,key,8
Trans	'DEC',,SetMonth,GOTMONTH,key,12
Trans	'FEB',,SetMonth,GOTMONTH,key,2
Trans	'JAN',,SetMonth,GOTMONTH,key,1
Trans	'JUL',,SetMonth,GOTMONTH,key,7
Trans	'JUN',,SetMonth,GOTMONTH,key,6
Trans	'MAR',,SetMonth,GOTMONTH,key,3
Trans	'MAY',,SetMonth,GOTMONTH,key,5
Trans	'NOV',,SetMonth,GOTMONTH,key,11
Trans	'OCT',,SetMonth,GOTMONTH,key,10
Trans	'SEP',,SetMonth,GOTMONTH,key,9
Trans	p$Lambda

State
Trans	'-'
Trans	p$Lambda,p$Exit

State
Trans	p$Decimal,p$Exit,SetTime,GOTYEAR,key,3
Trans	p$Lambda,p$Exit

;
Inline

#include <time.h>
#define ONEDAY		(24L*60L*60L)

static long maxtimes[15] = { 31,12,9999,23,59,59,0,0,0,0,23,59,59,0,0 };
static int blankallowed;

static SetStart(pcb,ba)
PCB *pcb;
long ba;
{
 pcb->pcb_start = (long)pcb->sys_pcb.pcb_line;
 blankallowed = ba;
 return parse_exit;
}

static BlankAllowed()
{
 return blankallowed ? parse_exit : parse_fail;
}

static SetTime(pcb,ix)
PCB *pcb;
long ix;
{
 pcb->pcb_times[ix] = pcb->sys_pcb.pcb_token;
 if ( ix == 9 )
  pcb->pcb_start2 = (long)pcb->sys_pcb.pcb_line;
 else if ( (ix == 7) || (ix == 14) )
  pcb->pcb_times[ix+1] += (long)pcb->sys_pcb.pcb_line;
 return parse_exit;
}

static SetMonth(pcb,mm)
PCB *pcb;
long mm;
{
 pcb->pcb_times[2] = mm;
 return parse_exit;
}

static SetDigit(pcb,ix)
PCB *pcb;
long ix;
{
 pcb->pcb_times[ix] = -((long)pcb->sys_pcb.pcb_line);
 return parse_exit;
}

static EndDigit(pcb,ix)
PCB *pcb;
long ix;
{
 if ( pcb->pcb_times[ix] )
  pcb->pcb_times[ix] += (long)pcb->sys_pcb.pcb_line;
 return parse_exit;
}

static ClearTime(pcb,ix)
PCB *pcb;
long ix;
{
 pcb->pcb_times[ix] = 0;
 if ( ix == 1 ) pcb->pcb_times[2] = pcb->pcb_times[3] = pcb->pcb_key = 0;
 return parse_exit;
}

static MakeTree(pcb)
PCB *pcb;
{
 struct tm *tm_now,*localtime();
 char *start,*createValue();
 time_t now;
 int len,ix;

 pcb->pcb_times[0] = 'TIME';
 if ( pcb->pcb_start2 && (pcb->pcb_start2 == (long)pcb->sys_pcb.pcb_line) )
  return parse_fail;
 if ( pcb->pcb_key != GOTALL )
  {
   time(&now);
   if ( pcb->pcb_key == YESTERDAY )
    now -= ONEDAY;
   else if ( pcb->pcb_key == TOMORROW )
    now += ONEDAY;
   if ( !(tm_now = localtime(&now)) ) return CDU_NOMEM;
   if ( (pcb->pcb_key&GOTDAY) != GOTDAY )
    pcb->pcb_times[1] = tm_now->tm_mday;
   if ( (pcb->pcb_key&GOTMONTH) != GOTMONTH )
    pcb->pcb_times[2] = tm_now->tm_mon+1;
   if ( (pcb->pcb_key&GOTYEAR) != GOTYEAR )
    pcb->pcb_times[3] = 1900+tm_now->tm_year;
  }
 for ( ix = 16 ; --ix ; )
  if ( (pcb->pcb_times[ix] < 0) ||
       (maxtimes[ix-1] && (pcb->pcb_times[ix] > maxtimes[ix-1])) )
   return parse_fail;
 if ( (pcb->pcb_times[1] < 1) || (pcb->pcb_times[2] < 1) ||
      (pcb->pcb_times[3] < 1970) )
  return parse_fail;
 start = (char *)pcb->pcb_start;
 if ( (len = pcb->sys_pcb.pcb_line-start) <= 0 ) return parse_fail;
 if ( !(pcb->pcb_tree = 
        (long)createValue(start,len,1,sizeof(pcb->pcb_times),pcb->pcb_times)) )
  return CDU_NOMEM;
 return parse_exit;
}

static FreeTree(pcb)
PCB *pcb;
{
 free(pcb->pcb_tree);
 return parse_exit;
}
