;
; $ACL =  '(' <security> | <default> | <access> ')'
;      = " $ACL ["]
;
; <security>   = ALARM_JOURNAL=SECURITY [, [<options>] [, [<acc_access>]]]
; <default>    = DEFAULT_PROTECTION {, [<options>} {, [<acc_access>]]}
; <access>     = IDENTIFIER=<ident> {, [,options>} {, [<acc_access>]]}
; <options>    = OPTIONS=<option> {+ <option>}
; <option>     = DEFAULT | PROTECTED | NOPROPAGATE | NONE | HIDDEN
; <acc_access> = <acckind> | <prokind>
; <acckind>    = ACCESS=<acckey> {+ <acckey>}
; <prokind>    = <prokey>=<acckey> {+ <acckey>}
; <prokey>     = SYSTEM | OWNER | GROUP | WORLD
; <acckey>     = READ | WRITE | EXECUTE | DELETE | CONTROL | SUCCESS |
;                FAILURE | NONE
; <ident>      = %X<hex> | <symbol> | <|[ <uicid> [ , <uicid>] ]|>
; <uicid>      = <octal> | * | <symbol>
;
Version 1.1
;
Include <saphir/CLD.h>
;
Character Sets

Legal       = 1..255
SymbolStart = 'A'..'Z','a'..'z','0'..'9','_','$'
SymbolChars = 'A'..'Z','a'..'z','0'..'9','_','$'
;
Flags       =
Abbrevation = UNIQUE
; 
Definitions
Clear
     long tree
     long start
     long kind
     long value[11]
      isALARM        = 1
      isDEFAULT      = 2
      isIDENTIFIER   = 3
      aclDEFAULT     = $01
      aclPROTECTED   = $02
      aclNOPROPAGATE = $04
      aclHIDDEN      = $08
      aclNOOPTIONS   = $1f
      aclNOKIND      = 0
      aclSTATE       = 1
      aclIDENT       = 2
      aclIDENTLEN    = 4
      aclOPTIONS     = 6
      aclSYSTEM      = 7
      aclOWNER       = 8
      aclGROUP       = 9
      aclWORLD       = 10
      aclREAD        = $0001
      aclWRITE       = $0002
      aclEXECUTE     = $0004
      aclDELETE      = $0008
      aclCONTROL     = $0010
      aclSUCCESS     = $0020
      aclFAILURE     = $0040
      aclNOKEYS      = $1fff
;
Rules

State Initial
Trans '"',DoString,SetStart
Trans p$Lambda,,SetStart

State
Trans '('

State
Trans 'ALARM_JOURNAL',alarm,SetState,,,isALARM
Trans 'DEFAULT_PROTECTION',NoOptions,SetState,,,isDEFAULT
Trans 'IDENTIFIER',identifier,SetState,,,isIDENTIFIER
Trans ')',p$Exit,MakeTree,,,0

State alarm
Trans '='
Trans ':'

State
Trans 'SECURITY',NoOptions

State Options
Trans 'ACCESS',Access,StartKind,,,aclNOKIND
Trans 'GROUP',Access,StartKind,,,aclGROUP
Trans 'OPTIONS'
Trans 'OWNER',Access,StartKind,,,aclOWNER
Trans 'SYSTEM',Access,StartKind,,,aclSYSTEM
Trans 'WORLD',Access,StartKind,,,aclWORLD
Trans p$Lambda,NoOptions

State 
Trans '='
Trans ':'

State Option
Trans 'DEFAULT',,AddOption,,,aclDEFAULT
Trans 'HIDDEN',,AddOption,,,aclHIDDEN
Trans 'NONE',,AddOption,,,aclNOOPTIONS
Trans 'NOPROPAGATE',,AddOption,,,aclNOPROPAGATE
Trans 'PROTECTED',,AddOption,,,aclPROTECTED
Trans p$Lambda,NoOptions

State
Trans '+',Option
Trans p$Lambda

State NoOptions
Trans ',',Options
Trans ')',p$Exit,MakeTree,,,0

State Access
Trans '='
Trans ':'

State AccKey
Trans 'CONTROL',,AddKey,,,aclCONTROL
Trans 'DELETE',,AddKey,,,aclDELETE
Trans 'EXECUTE',,AddKey,,,aclEXECUTE
Trans 'FAILURE',,AddKey,,,aclFAILURE
Trans 'NONE',,AddKey,,,aclNOKEYS
Trans 'READ',,AddKey,,,aclREAD
Trans 'SUCCESS',,AddKey,,,aclSUCCESS
Trans 'WRITE',,AddKey,,,aclWRITE
Trans p$Lambda,NoOptions

State
Trans '+',AccKey
Trans p$Lambda,NoOptions

State identifier
Trans '='
Trans ':'

State
Trans '%',hexid
Trans '[',uicid1
Trans '<',uicid2
Trans p$Symbol,NoOptions,SetIdent,,,0

State hexid
Trans 'X'

State
Trans p$Hex,NoOptions,SetIdent,,,1

State uicid1
Trans !uicid

State
Trans ']',NoOptions

State uicid2
Trans !uicid

State
Trans '>',NoOptions

State uicid
Trans !uic

State
Trans ','
Trans p$Lambda,p$Exit

State uic
Trans '*',p$Exit,SetIdent,,,2
Trans p$Octal,p$Exit,SetIdent,,,3
Trans p$Symbol,p$Exit,SetIdent,,,0

State DoString
Trans '"'
Trans p$Eos,p$Exit,MakeTree,,,2
Trans p$Any,DoString

State
Trans '"',DoString
Trans p$Lambda,p$Exit,MakeTree,,,1

;
Inline

#define vSTATE    pcb->pcb_value[aclSTATE]
#define vIDENT(n) pcb->pcb_value[aclIDENT+(n)]
#define vLEN(n)   pcb->pcb_value[aclIDENTLEN+(n)]
#define vOPTIONS  pcb->pcb_value[aclOPTIONS]
#define vACCESS   pcb->pcb_value[pcb->pcb_kind]

static SetStart(pcb)
PCB *pcb;
{
 pcb->pcb_start = (long)pcb->sys_pcb.pcb_line;
 return parse_exit;
}

static SetState(pcb,val)
PCB *pcb;
long val;
{
 vSTATE = val;
 return parse_exit;
}

static AddOption(pcb,opt)
PCB *pcb;
long opt;
{
 if ( ((opt == aclNOOPTIONS) && vOPTIONS && (vOPTIONS != aclNOOPTIONS)) ||
      ((opt != aclNOOPTIONS) && (vOPTIONS == aclNOOPTIONS)) ) 
  return parse_check;
 vOPTIONS |= opt;
 return parse_exit;
}

static StartKind(pcb,kind)
PCB *pcb;
long kind;
{
 if ( (kind == aclNOKIND) == (vSTATE == isDEFAULT) ) return parse_fail;
 pcb->pcb_kind = (kind == aclNOKIND) ? aclOWNER : kind;
 return parse_exit;
}

static AddKey(pcb,key)
PCB *pcb;
long key;
{
 if ( (vSTATE != isALARM) && ((key == aclFAILURE) || (key == aclSUCCESS)) )
  return parse_fail;
 if ( ((key == aclNOKEYS) && vACCESS && (vACCESS != aclNOKEYS)) ||
      ((key != aclNOKEYS) && (vACCESS == aclNOKEYS)) )
  return parse_check;
 vACCESS |= key;
 return parse_exit;
}

static SetIdent(pcb,what)
PCB *pcb;
long what;
{
 int ix = vLEN(0) ? 1 : 0;
 long uic;

 switch (what)
  {
   case 0 : vIDENT(ix) = pcb->sys_pcb.pcb_token-pcb->pcb_start;
            vLEN(ix) = pcb->sys_pcb.pcb_line-(char *)pcb->sys_pcb.pcb_token;
            break;
   case 1 : vIDENT(0) = pcb->sys_pcb.pcb_token;
            vLEN(0) = -1;
            break;
   case 2 : vIDENT(ix) = 0177777;
            vLEN(ix) = -1;
            break;
   case 3 : if ( ((uic = pcb->sys_pcb.pcb_token) < 0) || (uic > 037776) )
             return parse_fail;
            vIDENT(ix) = uic;
            vLEN(ix) = -1;
            break;
  }
 return parse_exit;
}

static MakeTree(pcb,sub)
PCB *pcb;
long sub;
{
 char *start,*createValue();
 int len,up=2;

 if ( (vOPTIONS&aclNOOPTIONS) == aclNOOPTIONS ) vOPTIONS &= ~aclNOOPTIONS;
 if ( (vACCESS&aclNOKEYS) == aclNOKEYS ) vACCESS &= ~aclNOKEYS;
 if ( sub )
  {
   up = 0;
   if ( sub == 2 ) sub = 0;
  }
 start = (char *)pcb->pcb_start;
 if ( (len = pcb->sys_pcb.pcb_line-start-sub) <= 0 ) return parse_fail;
 if ( !(pcb->pcb_tree = 
        (long)createValue(start,len,up,sizeof(pcb->pcb_value),pcb->pcb_value)) )
  return CDU_NOMEM;
 return parse_exit;
}
