/*
  Verwaltung von logischen Namen.
*/
#ifdef RPC_HDR
%#include <saphir/vmsdef.h>

%#define PRORD	 	    0x01
%#define PROWR		    0x02
%#define PRODE		    0x08
%#define PROSYSTEM(p)	    (p)
%#define PROOWNER(p)	    ((p)<<4)
%#define PROGROUP(p)	    ((p)<<8)
%#define PROWORLD(p)	    ((p)<<12)
#endif

#include <saphir/vmsdef.h>

/*
  Verwaltungsstrukturen
*/
typedef string tab_n<LNM$C_TABNAMLEN>;
typedef string any_n<LNM$C_NAMLENGTH>;

struct equiv_t
       {
	any_n	name;			/* Text des Wertes			*/
	int	flags;			/* Optionen des Wertes			*/
       };

union loginfo switch (int table)
      {
       case TRUE  : long    tptr;
       case FALSE : equiv_t wert<>;
      };

struct logname
       {
	any_n	name;			/* Logischer Name 			*/
	tab_n	parent;			/* Name der Vatertabelle		*/
	int	id;			/* Eindeutige Kennung			*/
 	int	flags;			/* Optionen       			*/
	int	acmode;			/* Zugriffsmode	  			*/
        loginfo info;			/* Wert des Namens			*/
       };

struct table
       {
	tab_n	name;			/* Adresse des Namens im logischen Namen*/
	tab_n	parent;			/* Name der Vatertabelle		*/
	int	acmode;			/* Zugriffsmode				*/
	int	quota;			/* Groesse	 			*/
	int	free;			/* Freie Bytes				*/
	int	protection;		/* Zugriffsschutz 			*/
	int	pid;			/* Erzeugender Prozess			*/
	int	uid;			/* Erzeuger				*/
	int	gid;			/* Dessen Gruppe			*/
	int	insysdir;		/* In LNM$SYSTEM_DIRECTORY definiert	*/
	long	partab;			/* Adresse der Vatertabelle		*/
	int	nalloc;			/* Reservierte Eintraege		*/
 	logname	names<>;		/* Logische Namen			*/	
       };

/*
  Uebergabestrukturen
*/
struct crelnt_t
       {
	tab_n	name;			/* Name der Tabelle			*/
	int	pid;			/* Prozesskontext			*/
	int	flags;			/* Optionen				*/
	int	acmode;			/* Zugriffsmode				*/
	int	quota;			/* Quota				*/
	int	prot;			/* Zugriffsschutz			*/
 	tab_n	parent;			/* Vatertabelle				*/
       };

struct crelnm_t
       {
	any_n	name;			/* Name					*/
	int	pid;			/* Prozesskontext			*/
	int	flags;			/* Optionen				*/
	int	acmode;			/* Zugriffsmode				*/
	equiv_t names<>;		/* Assoziierte Namen    		*/
	tab_n	parent;			/* Vatertabelle				*/
       };

struct dellnm_t
       {
	any_n	name;			/* Logischer Name			*/
	int	pid;			/* Prozesskennung			*/
	int	acmode;			/* Zugriffsmode				*/
	tab_n	parent;			/* Vatertabelle				*/
       };

struct trnlnm_t
       {
	any_n	name;			/* Logischer Name			*/
	int	pid;			/* Prozesskennung			*/
	int	acmode;			/* Zugriffsmode				*/
	int	flags;			/* Optionen				*/
	tab_n	parent;			/* Vatertabelle				*/
       };

struct dumplnt_t
       {
	tab_n	name;			/* Name der Tabelle     		*/
	tab_n	parent;			/* Name der Vatertabelle		*/
	int	pid;			/* Prozesskennung			*/
       };

/*
  Verteiler. Bei Erstinstallation kann die erste RPC-Definition entfallen
*/
#ifndef RPC_CLNT
program LNMPROG_OLD {
        version LNMVERS_OLD {
		logname CRELNT_OLD(crelnt_t) 	=	1;
		logname CRELNM_OLD(crelnm_t)	=	2;
		int DELLNM_OLD(dellnm_t)	=	3;
		logname TRNLNM_OLD(trnlnm_t)	=	4;
		table DUMPLNT_OLD(dumplnt_t)	=	5;
		int SPAWN_OLD(int)		=	6;
        } = 1;
} = 0x20000302;
#endif

program LNMPROG {
        version LNMVERS {
		logname CRELNT(crelnt_t) 	=	1;
		logname CRELNM(crelnm_t)	=	2;
		int DELLNM(dellnm_t)		=	3;
		logname TRNLNM(trnlnm_t)	=	4;
		table DUMPLNT(dumplnt_t)	=	5;
		int SPAWN(int)			=	6;
        } = 1;
} = 390329;

#ifdef RPC_SVC
%#define crelnt_old_1	crelnt_1
%#define crelnm_old_1	crelnm_1
%#define dellnm_old_1	dellnm_1
%#define trnlnm_old_1	trnlnm_1
%#define dumplnt_old_1	dumplnt_1
%#define spawn_old_1	spawn_1
#endif
