#!/usr/bin/csh

#
# Befehl mit Abfrage auf Fehler ausfuehren
#
alias check  '\!* ; if ( $status != 0 ) exit $status'
alias action 'echo "+++" \!*'
alias error  'echo "***" \!*'

#
# Umgebung
#
set nonomatch
set path = (. $path)

#
# Defaults setzen
#
if ( ! $?BINDIR ) then
  set BINDIR = /usr/bin
endif
if ( ! $?LIBDIR ) then
  set LIBDIR = /usr/lib
endif
if ( ! $?INCDIR ) then
  set INCDIR = /usr/include
endif

if ( ($#argv >= 2) && ("$2" != "") ) then
  set DIRDEF = "$2"
else if ( ! $?DIRDEF ) then
  set DIRDEF = saphir
endif
  
#
# lnm.csh header|objects [DIRDEF]
#
# DIRDEF ist der Projektname. Er darf nur Buchstaben, Zahlen und _
# enthalten
#
if ( "$DIRDEF" == "" ) then
  error no project name given 
#
# Kurze Erklaerung
#
USAGE:
  cat << EOF
*** 
*** 
***  USAGE: $0 header|objects [DIRDEF]
*** 
***    header  will create alle header files
***    objects will create all objects and exeutables
***    DIRDEF  is the name of the project (saphir)
*** 
*** 
EOF
  exit 1
endif
echo "$DIRDEF" | grep > /dev/null '[^A-Za-z0-9_]'
if ( $status == 0 ) then
  error project name '"'"$DIRDEF"'"' must be built from A-Za-z0-9_
  goto USAGE
endif

#
# Informationen anzeigen
#
set LIBDIR1 = "$INCDIR"/"$DIRDEF"
set LIBDIR2 = "$LIBDIR1"/lnm
set OBJLIB = "$LIBDIR"/lib"$DIRDEF".a
cat << EOF
+++
+++  directory for executables      =   $BINDIR
+++  directory for includes         =   $INCDIR
+++  directory for libraries        =   $LIBDIR
+++
+++  project include directory      =   $LIBDIR1
+++  project object library         =   $OBJLIB
+++  lnm include directory          =   $LIBDIR2
+++
EOF

#
# Systemdirectories suchen
#
if ( ! -d "$BINDIR" ) then
  error directory "$BINDIR" for executable does not exist
  exit 1
endif
if ( ! -d "$INCDIR" ) then
  error directory "$INCDIR" for includes does not exist
  exit 1
endif
if ( ! -d "$LIBDIR" ) then
  error directory "$LIBDIR" for libraries does not exist
  exit 1
endif

#
# Systemdirectories erzeugen
#
if ( ! -d "$LIBDIR1" ) then
  action creating project include directory "$LIBDIR1"
  check mkdir "$LIBDIR1"
endif
if ( ! -d "$LIBDIR2" ) then
  action creating logical name server directory "$LIBDIR2"
  check mkdir "$LIBDIR2"
endif

#
# Aufrauemen
#
set CLEAN="lnm lnm.[ho] lnm_svc.[co] lnm_xdr.[co] lnm_clnt.[co] vmsdef.INC vmsdef.csh"
action cleaning up
rm -f $CLEAN

#
# Befehl auswerten
#
if ( "$1" == "header" ) then
#
# Headerdateien kopieren
#
  action copying VMS definitions for C
  check cp vmsdef.h "$LIBDIR1"
  action creating VMS definitions for FORTRAN
  check make vmsdef.INC vmsdef.csh
  action copying VMS definitions for FORTRAN
  check cp vmsdef.INC vmsdef.csh "$LIBDIR1"
  action creating lnm definitions
  check make lnm.h
  action copying lnm definitions
  check cp lnm.h "$LIBDIR2"
else if ( "$1" == "objects" ) then
#
# Dateien erzeugen
#
  action creating objects
  check make lnm lnm_clnt.o OBJLIB="$OBJLIB"
#
# Library aufbauen
#
  action copying objects
  check ar rv "$OBJLIB" lnm_clnt.o lnm_xdr.o
#
# Server kopieren
#
  action copying logical name server
  check cp lnm "$BINDIR"/lnmd
else
  goto USAGE
endif

#
# Aufraeumen
#
action cleaning up
rm -f $CLEAN

#
# Fertig
#
action logical name server "$1" installation complete

