#define DEF
#include <saphir/DCL/symbols.h>

#include "dcl.h"
#include "command.h"

/*
  CLIROUTINE Tabelle. Die Routinen sind ueber die verschiedenen Programmdateien
  verteilt. Es koennen von CLD nur solche CLIROUTINEn gefunden werden, die in
  der Umsetzungstabelle vorhanden sind.
*/
int CLIdefine(),CLIassign(),CLIcretable(),CLIdeassign(),CLIshowtran();
int CLIsetdef(),CLIshowdef(),CLIsetverify(),CLIsetprompt(),CLIseton();
int CLIshowsymbl(),CLIsetsymbol(),CLIdelsym();
int CLIlogout(),CLIexit();
int CLImcr(),CLIrun();
int CLIrecall();
int CLIcdu();

static struct MAP CLIroutines[] =
       {
	{ "ASSIGN",    CLIassign    },
	{ "CDU",       CLIcdu	    },
	{ "CRETABLE",  CLIcretable  },
        { "DEASSIGN",  CLIdeassign  },
	{ "DEFINE",    CLIdefine    },
	{ "DELSYM",    CLIdelsym    },
	{ "EXIT",      CLIexit	    },
	{ "LOGOUT",    CLIlogout    },
	{ "MCR",       CLImcr	    },
	{ "RECALL",    CLIrecall    },
	{ "RUN" ,      CLIrun       },
	{ "SETDEF",    CLIsetdef    },
	{ "SETON",     CLIseton	    },
	{ "SETPROMPT", CLIsetprompt },
	{ "SETSYMBOL", CLIsetsymbol },
	{ "SETVERIFY", CLIsetverify },
	{ "SHOWDEF" ,  CLIshowdef   },
	{ "SHOWSYMBL", CLIshowsymbl },
	{ "SHOWTRAN",  CLIshowtran  }
       };

/*
  Routinen.
*/
static int dcl$get_input_(),dcl$get_prompt_();

/* 
  Prompt.
*/
char pro[64] = "$ ";

/*
  Struktur des RECALL Buffers, siehe auch 'getinput.c'.
*/
struct EDITcontrol
       {
	int  size;
	int  cnt;
	int  cur;
	char buf[sizeof(int)];
       };

/*
  Zaehler fuer den RECALL Buffer.
*/
static int Ecnt;

/*
  Abkuerzung fuer den RECALL Buffer.
*/
#define Ebuf(n)			(EDITctrl->buf+(n)*(EDITctrl->size+1))

/*
  Aufruf als Shell mit 'dcl', sonst 'DCL'.
*/
#define SHELLNAME		"dcl"
#define SHELLLEN		(sizeof(SHELLNAME)-1)

/*
  MACROs
*/
#define PARSE_DEFAULTS		&cdu$table_,dcl$get_prompt_,dcl$get_input_

/*
  DCL Command Interpreter.
*/
main(argc,argv)
int argc;
char **argv;
{
 int res,cmdlen,ix,lst,len,tab=LIB$K_CLI_GLOBAL_SYM,usecom = 0,syscom,entercom;
 char hostname[100],*cmd = 0,*uname,*vname,*xname,dir[MAXPATHLEN];
 commandLevel *cur;
 struct passwd *me;
 dellnm_t deluser;
 crelnm_t login;
 equiv_t wert;
 logname *new;

 /* Initialisierung */
 useDollar = 0;
 /* - NOVERIFY */
 VerifyFlag = 0;
 /* - Commandfile SYS$INPUT */
 curLevel = inpLevel = 0;
 comfile[0].filename = 0;
 comfile[0].fd = dup(0);
 comfile[0].isopen = 1;
 comfile[0].issystem = 0;
 comfile[0].onflag = 1;
 setbuf(stdin,(char *)0);
 /* - Exceptionhandler */
 signal(SIGINT,CLIlogout);
 /* - Spezialmodus fuer SET COMMAND */
 if ( (argc == 3) && !strcmp(argv[1],"-d") ) exit(dumpTable(&cdu$table_,argv[2]));
 /* - Einsatz als Kommandoprozessor unter UNIX: SHELLNAME <UNIX dateiname> */
 if ( argc >= 2 )
  {
   /* Zweites Argument */
   xname = argv[1];
   /* Laenge des Arguments */
   len = strlen(argv[0]);
   /* Dateiname vergleichen */
   if ( usecom = ((len >= SHELLLEN) && !strcmp(argv[0]+len-SHELLLEN,SHELLNAME) &&
                  ((len == SHELLLEN) || (argv[0][len-SHELLLEN-1] == '/'))) )
    /* Dateinamen umwandeln */
    if ( !(xname = gen_vms(argv[1],0)) )
     {
      fprintf(stderr,"no file %s\n",argv[1]);
      exit(4);
     }
  }
 /* - Prompt */
 gethostname(hostname,sizeof(hostname));
 sprintf(pro,"_%s$ ",hostname);
 /* - Command Definition Utility */
 CLIcallmap = CLIroutines;
 nCLIcallmap = sizeof(CLIroutines)/sizeof(CLIroutines[0]);
 /* - Eingabe */
 EDITsize = 256;
 EDITcnt = 20;
 EDITinsert = 0;
 Ecnt = 0;
 /* - Befehlszeile uebernehmen */
 if ( argc >= 2 ) 
  {
   /* Laenge ermitteln */
   cmdlen = usecom+strlen(xname)+1;
   for ( ix = 2 ; ix < argc ; ) cmdlen += strlen(argv[ix++])+1;
   if ( cmdlen >= COMMAND_MAXLENGTH )
    {
     fprintf(stderr,"command line too long\n");
     exit(2);
    } 
   if ( !(cmd = malloc(COMMAND_MAXLENGTH)) ) out_of_memory();
   /* -- Befehlsdatei ausfuehren */
   strcpy(cmd,usecom ? "@" : "");
   /* Erstes Argument eventuell umgesetzt */
   strcat(cmd,xname);
   if ( (ix = 2) < argc ) strcat(cmd," ");
   /* -- Zeile aufsetzen */
   while ( ix < argc )
    {
     strcat(cmd,argv[ix++]);
     if ( ix < argc ) strcat(cmd," ");
    }
   /* -- Verhindert den Uebergang in den interaktiven Modus */
   usecom++;
  }
 /* - Defaultdirectory */
 if ( !(uname = getcwd(dir,sizeof(dir))) || !(makeDefaultDir(uname)&1) ) out_of_memory();
 /* - SYS$LOGIN */
 if ( !(me = getpwuid(getuid())) || !(vname = gen_vms(me->pw_dir,1)) ) out_of_memory();
 wert.name = vname;
 wert.flags = 0;
 login.name = "SYS$LOGIN";
 login.pid = getpid();
 login.flags = 0;
 login.acmode = PSL$C_SUPER;
 login.names.names_val = &wert;
 login.names.names_len = 1;
 login.parent = "LNM$PROCESS";
 if ( new = (logname *)execLNM(crelnm_1,&login) ) clnt_freeres(lnmlibLNM,xdr_logname,new);
 free(vname);
 /* - Symbole */
 start_symbol_server();
 /* - Systemdateien zuerst abarbeiten */
 syscom = entercom = 1;
 /* - $RESTART */
 vname = getenv("RESTART") ? "TRUE" : "FALSE";
 lib$set_symbol_("$RESTART",vname,&tab,sizeof("$RESTART")-1,strlen(vname));
 /* - $STATUS und $SEVERITY */
 Status = SS$_NORMAL;
 NewStatus = 1;
 /* Die ewige Schleife */
 while ( curLevel >= 0 )
  {
   /* Letzten Fehler festhalten */
   if ( NewStatus ) setStatus();
   NewStatus = 1;
   Status = SS$_NORMAL;
   /* Kein IMAGE */
   CLIimage = 0;
   /* Zeile einlesen */
   lst = EDITctrl ? EDITctrl->cur : 0;
   /* Standarddateien abgearbeitet */
   if ( syscom && !entercom && (curLevel <= (usecom == 2)) ) syscom = 0;
   /* Vorgegebene Zeile bearbeiten */
   if ( ((usecom == 2) || !syscom) && cmd ) 
    {
     /* Symbole ersetzen */
     res = replace_symbols(cmd,strlen(cmd),COMMAND_MAXLENGTH-1,(struct t_marker *)0);
     /* Zeile ausfuehren */
     if ( res < 0 )
      Status = CLI$_EXPSYN;
     else
      Status = cli$dcl_parse_(cmd,PARSE_DEFAULTS,pro,res,strlen(pro));
     /* Aufraeumen */
     free(cmd);
     cmd = 0;
     /* Neue Datei gestartet */
     if ( usecom == 2 )
      if ( syscom && (curLevel == 1) )
       /* SYS$INPUT */
       inpLevel = 1;
      else
       /* SYS$INPUT */
       inpLevel = 0;
    } 
   else if ( !entercom ) 
    {
     /* Kommanddodatei oeffnen */
     for ( ; ; )
      {
       /* Aktuelle Datei */
       cur = comfile+curLevel;
       if ( cur->isopen ) break;
       /* Datei oeffnen */
       if ( cur->fd == -1 )
	if ( !(uname = translate_vms(cur->filename)) || (uname == (char *)-1) )
	 Status = SS$_BADFILENAME;
	else if ( (cur->fd = open(uname,O_RDONLY)) != - 1 )
	 cur->isopen = 1;
        else if ( !(uname = translate_vms_default(cur->filename,".com")) ||
             	  (uname == (char *)-1) )
         Status = SS$_BADFILENAME;
        else if ( (cur->fd = open(uname,O_RDONLY)) == -1 )
	 Status = SS$_NOSUCHFILE;
	else
         cur->isopen = 1;
       else
	cur->isopen = 1;
       /* Datei ok ? */
       if ( cur->fd == -1 )
        {
	 if ( cur->issystem )
	  /* Ignorieren */
	  Status = CLI$_EOF;
	 else
	  {
	   /* Fehler anzeigen */
           fprintf(stderr,"*** problems with file %s.\n",cur->filename);
	   /* Nur die aktuelle Datei beenden */
           termCommand();
	  }
         break;
        }
       /* Dateikanal auf stdin legen */
       close(0);
       if ( dup2(cur->fd,0) != -1 ) break;
       /* Das wars - rien ne va plus */
       perror("dup2 stdin");
       exit(3);
      }
     /* Befehl ausfuehren */
     if ( Status&1 ) Status = cli$dcl_parse_(NOSTR,PARSE_DEFAULTS,pro,strlen(pro));
    }
   /* Systemkommandodateien */
   if ( entercom )
    {
     /* Nur einmal */
     entercom = 0;
     lst = curLevel;
     /* - SYS$LOGIN:LOGIN.COM */
     setupFile("sys$login:login.com");
     comfile[curLevel].issystem = 1;
     /* - SYS$MANAGER:SYLOGIN.COM */
     setupFile("sys$manager:sylogin.com");
     comfile[curLevel].issystem = 1;
     /* - Probleme beim Aufsetzen */
     if ( (curLevel-lst) != 2 ) out_of_memory();
     /* - Naechste Zeile aus SYLOGIN */
     continue;
    }
   /* Zaehler korrigieren */
   if ( EDITctrl )
    {
     if ( (lst = EDITctrl->cur-lst) < 0 ) lst += EDITcnt;
     Ecnt += lst;
    }
   /* Warnung ignorieren */
   if ( Status == CLI$_PARMDEL ) Status = CLI$_NORMAL;
   /* Ende der Datei */
   if ( Status == CLI$_EOF )
    {
     /* Aktuelle Datei beenden, falls nicht interaktiv */
     if ( !curLevel && isatty(comfile[0].fd) ) 
      fprintf(stderr,"*** EXIT ***\n");
     else
      termCommand();
     NewStatus = 0;
    }
   else
    {
     /* Weiter bearbeiten */
     if ( Status&1 )
      {
       NoLog = 0;
       res = cli$dispatch_();
       if ( !(res&1) ) Status = res;
       /* Logische Namen im USER_MODE entfernen */
       if ( CLIimage )
	{
	 /* Kein Name bedeutet alle Namen */
	 deluser.name = "";
         deluser.pid = getpid();
         deluser.acmode = PSL$C_USER;
         deluser.parent = "LNM$DCL_LOGICAL";
	 execLNM(dellnm_1,&deluser);
	 /* Status aus sys$exit_ ermitteln */
         if ( Status&1 ) getStatus();
	}
      }
     /* Fehler bearbeiten bei SET ON */
     if ( ((short)Status) != 1 )
      {
       /* Kein /NOLOG */
       if ( !NoLog ) printf("*** DCL %s: %08X\n",Status&1 ? "WARNING" : "ERROR",Status);
       /* SET ON beendet alle (!) Kommandodateien bis zu einem SET NOON */
       if ( !(Status&1) )
	while ( (curLevel > 0) && comfile[curLevel].onflag ) 
	 termCommand();
      }
    }
   /* Aufhoeren */
   if ( usecom && !curLevel && !cmd ) termCommand();
  }
 /* Fehlercode setzen */
 exit(!(Status&1));
}

/*
   Bearbeitung einer Kommandodatei beenden.
*/
static termCommand()
{
 commandLevel *cur = comfile+curLevel--;

 /* Datei schliessen */
 if ( cur->filename ) free(cur->filename);
 if ( cur->fd != -1 ) close(cur->fd);
 /* Lokale Symbole entfernen */
 symbol_operation(SYM$OP_ENDFILE,NOINT,NOSTR,0,NOSTR,0,NOSTR,0,NOINT);
 /* SYS$INPUT */
 if ( curLevel < inpLevel ) inpLevel = 0;
}

/*
  LOGOUT
  	[/BRIEF] 
	[/FULL] 
	[/HANGUP]
*/
CLIlogout()
{
 /* Fertig */
 exit(0);
}

/*
  RECALL 
	[/ALL] 
	[/ERASE] 
	[p1]
*/
CLIrecall()
{
 char p1[256],*s1,*s2,c1,c2;
 int p1len,ix,ic,ip;

 /* Nur wenn Informationen da sind */
 if ( !EDITctrl ) return;
 /* Alle Zeilen loeschen */
 if ( PRESENT("ERASE")&1 )
  {
   memset(EDITctrl->buf,0,(EDITsize+1)*(EDITcnt+1));
   EDITctrl->cur = Ecnt = 0;
  }
 else
  {
   /* Diesen Eintrag loeschen */
   if ( !EDITctrl->cur-- ) EDITctrl->cur += EDITcnt;
   *Ebuf(EDITctrl->cur) = '\0';
   Ecnt--;
   if ( PRESENT("ALL")&1 )
    /* Inhalt der Zeilenbuffer ausgeben */
    for ( ix = EDITcnt, ic = EDITctrl->cur ; ix-- ; )
     {
      if ( *Ebuf(ic) ) printf("%d %s\n",Ecnt-ix,Ebuf(ic));
      if ( ++ic == EDITcnt ) ic = 0;
     }
   else if ( VALUE("P1",p1,&p1len)&1 )
    {
     /* Umsetzen in eine Zahl */
     p1[p1len] = '\0';
     /* Zahl auslesen und auf Bereichsgrenzen testen */
     if ( toint(&ic,p1) && (ic > 0) && (ic > Ecnt-EDITcnt-1) && (ic <= Ecnt) )
      {
       /* RECALL ausfuehren */
       if ( (EDITredo = EDITctrl->cur+ic-Ecnt-1) < 0 ) EDITredo += EDITcnt;
       return;
      } 
     /* Zeile suchen */
     for ( ix = EDITcnt, ic = EDITctrl->cur ; ix-- ; )
      {
       if ( !ic-- ) ic += EDITcnt;
       /* Vergleich durchfuehren */
       s1 = p1;
       s2 = Ebuf(ic);
       for ( ip = p1len ; ip-- ; )
	{
         c1 = *s1++;
	 if ( !(c2 = *s2++) ) break;
	 if ( (c1 >= 'a') && (c1 <= 'z') ) c1 += 'A'-'a';
	 if ( (c2 >= 'a') && (c1 <= 'z') ) c2 += 'A'-'a';
	 if ( c1 != c2 ) break;
        }
       if ( ip >= 0 ) continue;
       /* Zeile erneut einlesen */
       EDITredo = ic;
       return;
      }
     /* Fehler melden */
     Status = CLI$_CMDNOTFND;
    }
  }
}

/*
  SET PROMPT [= OPTION]
  	/CARRIAGE_RETURN
*/
CLIsetprompt()
{
 int plen;

 /* Prompt setzen */
 if ( VALUE("PROMPT",pro,&plen)&1 )
  pro[plen] = '\0';
 else
  strcpy(pro,"$ ");
}

/*
  SET [NO]ON
*/
CLIseton()
{
 if ( curLevel > 0 )
  switch (PRESENT("ON"))
   { 
    case CLI$_PRESENT : comfile[curLevel].onflag = 1;
    		        break;
    case CLI$_NEGATED : comfile[curLevel].onflag = 0;
     		        break;
   }
}

/*
  EXIT [P1]
*/
CLIexit()
{
 static char expr[1024];
 int elen,res,tmp;

 /* Ausdruck */
 if ( VALUE("P1",expr,&elen)&1 )
  {
   /* Auswerten */
   expr[elen] = '\0';
   Status = (res = dcl$solve_expression(expr,&tmp)) ? res : tmp;
  }
 /* Datei beenden */
 if ( curLevel > 0 ) termCommand();
}

/*
  Ausgabe abschalten, falls gewuenscht.
*/
get_nolog()
{
 if ( PRESENT("LOG") == CLI$_NEGATED ) NoLog = 1;
}

/*
  Schutzmaske einlesen.
  	[WORLD[=list]]
	[OWNER[=list]]
	[GROUP[=list]]
	[SYSTEM[=list]]
*/
get_protection(from)
char *from;
{
 /* Werte durchgehen */
 if ( !(cli$present_(from,strlen(from))&1) ) return -1;
 /* Alle Teilfelder einlesen */
 return PROWORLD(get_pro(from,"WORLD"))|PROSYSTEM(get_pro(from,"SYSTEM"))|
        PROOWNER(get_pro(from,"OWNER"))|PROGROUP(get_pro(from,"GROUP"));
}

static get_pro(pref,val)
char *pref,*val;
{
 static char keybuf[256],res[256];
 int plen = strlen(pref),vlen = strlen(val),rlen,prot = 0;

 /* Name ermitteln */
 if ( plen+vlen+2 > sizeof(keybuf) ) return 0;
 strcpy(keybuf,pref);
 strcat(keybuf,".");
 strcat(keybuf,val);
 /* Wert ermitteln */
 if ( !(cli$get_value_(keybuf,res,&rlen,plen+1+vlen,sizeof(res)-1)&1) ) return 0;
 res[rlen] = '\0';
 /* Auswerten */
 while ( rlen-- )
  switch (res[rlen])
   {
    case 'R' :
    case 'r' : prot |= PRORD;
               break;
    case 'W' :
    case 'w' : prot |= PROWR;
               break;
    case 'D' :
    case 'd' : prot |= PRODE;
               break;
    default  : return 0;
   }
 /* Ergebnis melden */
 return prot;
}

/*
  Laenge eines Namens ohne den Filesuffix ermitteln.
*/
namelen(name)
char *name;
{
 int len = strlen(name),i;
 char *scan;

 /* Punkt suchen */
 for ( scan = name+(i=len) ; i && (*--scan != '.') && (*scan != '/') ; i-- );
 /* Auswerten */
 if ( !i || (*scan != '.') ) return len;
 /* Suffix gefunden */
 return (i-1);
}

/*
  VAX/VMS-Dateinamen umwandeln und mit einer Endung versehen.
*/
make_vms(name,nlen,suff,size)
char *name,*suff;
int nlen,size;
{
 char *nptr;
 
 /* Name sauber abschliessen */
 name[nlen] = '\0';
 /* Umwandeln in die UNIX Notation */
 if ( !(nptr = translate_vms_default(name,suff)) || (nptr == (char *)-1) ) return 0;
 /* Kontrolltest */
 if ( ((nlen = strlen(nptr))+1) > size ) return 0;
 /* Name an die richtige Stelle kopieren */
 strcpy(name,nptr);
 return 1;
}

/*
  VAX/VMS-Dateiname erzeugen.
*/
char *gen_vms(uname,isdir)
char *uname;
int isdir;
{
 static char result[1024],real[MAXPATHLEN+1];
 char *lst;
 int rix,len;
  
 /* Umwandeln */
 if ( !realpath(uname,real) ) strcpy(real,uname);
 /* Ist ein Verzeichnis */
 if ( isdir && (!(len = strlen(real)) || (real[len-1] != '/')) ) strcat(real,"/");
 /* Absoluter Name */
 if ( *(uname = real) == '/' )
  {
   uname++;
   strcpy(result,ROOTNAME);
   rix = sizeof(ROOTNAME)-1;
  } 
 else
  rix = 0;
#ifdef USEUCX
 /* Aufraeumen fuer VAX/VMS UCX */
 while ( lst = strstr(uname,".dir") ) memmove(lst,lst+4,strlen(lst+4)+1);
#endif
 /* Name */
 if ( strchr(uname,'/') ) 
  {
   result[rix++] = '[';
   if ( rix == 1 ) result[rix++] = '.';
  }
 strcpy(result+rix,uname);
 /* Umwandeln */
 for ( uname = result+rix, lst = 0 ; *uname ; uname++ )
  if ( *uname == '/' )
   *(lst = uname) = '.';
 if ( lst ) *lst = ']';
 /* Fertig */
 return strdup(result);
}

/********************************************************************************
*
* Programme vom DCL aus ausfuehren.
*
********************************************************************************/

/*
  Programm ausfuehren.
*/
DCLexec(va_alist)
va_dcl
{
 char *cmd,*fil[3];
 char *argv[20];
 va_list args;
 int res,i;

 /* Bearbeitung einer variablen Liste von Parametern */
 va_start(args);
 /* Feste Argumente einlesen */
 cmd = va_arg(args,char *);
 for ( i = 0 ; i < 3 ; fil[i++] = va_arg(args,char *) );
 /* Parameter einlesen */
 argv[0] = cmd;
 for ( i = 1 ; (i < 19) && (argv[i] = va_arg(args,char *)) ; i++ );
 argv[i] = NOSTR;
 /* Bearbeiten der Liste beenden */
 va_end(args); 
 /* Neuen Prozess erzeugen */
 switch (fork())
  {
   case -1 : return -1;
   case  0 : /* I/O-Kanaele umsetzen */
     	     if ( fil[0] )
	      {
	       close(0);
	       open(fil[0],O_RDONLY);
	      }
     	     if ( fil[1] )
	      {
	       close(1);
	       open(fil[1],O_WRONLY);
	      }
     	     if ( fil[2] )
     	      if ( fil[2] == (char *)-1 )
	       {
	        close(2);
	        dup(1);
	       }
     	      else
	       {
	        close(2);
	        open(fil[2],O_WRONLY);
	       }
     	     /* Befehl ausfuehren */
     	     execvp(cmd,argv);
     	     exit(1);
   default : wait(&res);
     	     return WIFEXITED(res) ? WEXITSTATUS(res) : 256;     
  }
}

/********************************************************************************
*
* Erste Phase der Bearbeitung einer Eingabezeile.
*
********************************************************************************/

struct t_marker
       {
	struct t_marker *next;
	char		symbol[256];
       };
static char value[1024];
static int inside;

/*
  Befehlszeile teilweise einlesen und explizite Symbolumwandlungen mit
  ' durchfuehren.
*/
static dcl$get_input_(res,pro,len,rlen,plen)
char *res,*pro;
int *len,rlen,plen;
{
 static char *built = 0;
 static int ball = 0;
 int clen,code,mlen;

 /* Befehl ausfuehren */
 code = lib$get_input_(res+useDollar,pro,&clen,rlen-useDollar,plen);
 /* $ von einer EOF Kennung in setInputChannel */
 if ( useDollar )
  {
   /* Ende der Datei noch verschieben */
   if ( code == CLI$_EOF )
    {
     code = SS$_NORMAL;
     clen = 1;
    }
   /* $ einsetezen */
   *res = '$';
   clen++;
  }
 useDollar = 0;
 if ( len ) *len = clen;
 if ( !(code&1) ) return code;
 /* Kopieren */
 if ( rlen+1 > ball )
  {
   /* Alten Bereich freigeben */
   if ( ball ) 
    {
     free(built);
     ball = 0;
    }
   /* Neuen Bereicht erzeugen */
   if ( !(built = malloc(rlen+1)) ) out_of_memory();
   /* Laenge merken */
   ball = rlen+1;
  }
 memmove(built,res,clen);
 /* Ausgeben */
 if ( !isatty(0) && (VerifyFlag&VerifyPROCEDURE) ) 
  {
   built[clen] = '\0'; 
   puts(built);
  }
 /* Symbole umwandeln (Phase I) */
 inside = 0;
 if ( (mlen = replace_symbols(built,clen,rlen,(struct t_marker *)0)) < 0 ) return CLI$_EXPSYN;
 /* Korrigieren */
 memmove(res,built,mlen);
 memset(res+mlen,' ',rlen-mlen);
 if ( len ) *len = mlen;
 /* Fertig */
 return code;
}

/*
  Suchen der Symbols und ersetzen.
*/
static replace_symbols(buf,curlen,maxlen,slist)
char *buf;
int curlen,maxlen;
struct t_marker *slist;
{
 int ix,is,pos,pos1,flags,vlen,nlen,inline2;
 struct t_marker mine;
 char ch;

 /* Verketten */
 mine.next = slist;
 /* Symbolanfang suchen */
 for ( ix = 0 ; ix < curlen ; ix++ )
  {  
   if ( (ch = buf[ix]) == '\'' )
    if ( inside == 1 )
     {
      inside |= 2;
      continue;
     }
    else
     {
      /* Symbol einkreisen */
      pos = ix++;
      for ( is = 0, ch = '\0', inline2 = 0 ; ix < curlen ; ix++ )
       if ( ch || ((buf[ix] != ' ') && (buf[ix] != '\t')) )
        {
	 /* Symbole koennen SEHR merkwuerdig aussehen */
	 if ( (ch = buf[ix]) == '"' )
	  inline2 = !inline2;
         else if ( !inline2 )
	  if ( (ch >= 'a') && (ch <= 'z') ) 
	   ch += 'A'-'a';
	  else if ( !issymchar(ch) && (ch != '"') )
	   break;
         /* Zeichen eintragen */
	 if ( is < sizeof(mine.symbol) ) mine.symbol[is++] = ch;
        }
      /* Symbol aus dem String eleminieren */
      if ( ch == '\'' ) ix++;
      if ( inside ) pos--;
      memmove(buf+pos,buf+ix,curlen-ix);
      curlen -= ix-pos;
      /* Bearbeiten */
      if ( is && (is < sizeof(mine.symbol)) )
       {
	mine.symbol[is] = '\0';
	/* Rekursionen vermeiden */
	for ( slist = mine.next ; slist ; slist = slist->next )
	 if ( !strcmp(mine.symbol,slist->symbol) )
	  return -1;
	/* Wert suchen */
	if ( lib$get_symbol_(mine.symbol,value,&vlen,NOINT,is,sizeof(value))&1 )
	 {
	  if ( curlen+vlen > maxlen ) return -1;
	  /* Rekursion durchfuehren */
	  memmove(buf+(maxlen-(curlen-pos)),buf+pos,curlen-pos);
	  memmove(buf+pos,value,vlen);
	  if ( inside )
	   nlen = vlen;
	  else if ( (nlen = replace_symbols(buf+pos,vlen,maxlen-curlen,&mine)) < 0 ) 
	   return -1;
	  /* Ergebnis aufsetzen */
	  memmove(buf+pos+nlen,buf+(maxlen-(curlen-pos)),curlen-pos);
	  pos += nlen;
	  curlen += nlen;
	  /* Aufhoeren */
	  if ( inside == -1 ) break;
	 }
       }
      /* Fertig */
      ix = pos-1;
     }
   else if ( ch == '"' )
    inside = !inside;
   else if ( (ch == '!') && !inside )
    {
     inside = -1;
     break;
    }
   inside &= 1;
  }
 /* Fertig */
 return curlen;
}

/*
  Parameter einlesen, dabei & Symbole umwandeln.
*/
static dcl$get_prompt_(res,pro,len,rlen,plen)
char *res,*pro;
int *len,rlen,plen;
{
 char *dcl$replace_ampersand();
 int code,clen;

 /* Zeile einlesen */
 code = dcl$get_input_(res,pro,&clen,rlen,plen);
 if ( len ) *len = clen;
 /* Symbole ersetzen */ 
 if ( code&1 )
  if ( dcl$replace_ampersand(res,&clen,rlen) )
   {
    memset(res+clen,' ',rlen-clen);
    if ( len ) *len = clen;
   }
  else
   code = CLI$_EXPSYN;
 /* Fertig */
 return code;
}

/*
  Symbolzeichen.
*/
issymchar(ch)
char ch;
{
 return (((ch >= 'A') && (ch <= 'Z')) || ((ch >= 'a') && (ch <= 'z')) || 
	 ((ch >= '0') && (ch <= '9')) || (ch == '$') || (ch == '_'));
}

/*
  Kein Speicher mehr.
*/
out_of_memory()
{
 fprintf(stderr,"out of memory\n");
 exit(2);
}

/*
  Status als Symbol eintragen.
*/
setStatus()
{
 static char num[20];
 int tab = LIB$K_CLI_GLOBAL_SYM;

 /* $STATUS */
 sprintf(num,"%%X%08X",Status);
 lib$set_symbol_("$STATUS",num,&tab,sizeof("$STATUS")-1,strlen(num));
 /* $SEVERITY */
 sprintf(num,"%d",Status&7);
 lib$set_symbol_("$SEVERITY",num,&tab,sizeof("$SEVERITY")-1,strlen(num));
}

/*
  Fehlercode auslesen.
*/
getStatus()
{
 static char value[100];
 int res,vlen,n;
 char ch;

 /* Auslesen */
 res = lib$get_symbol_("$STATUS",value,&vlen,NOINT,sizeof("$STATUS")-1,sizeof(value)-1);
 if ( (res != SS$_NORMAL) || (vlen != 10) || memcmp(value,"%X",2) ) return;
 /* Dekodieren */
 for ( n = 8, res = 0 ; n-- ; )
  {
   if ( ((ch = value[9-n]) >= 'a') && (ch <= 'f') )
    ch += 'A'-'a';
   else if ( ((ch < '0') || (ch > '9')) && ((ch < 'A') || (ch > 'F')) )
    return;
   if ( ch >= 'A' ) 
    ch += 10-'A';
   else
    ch += 0-'0';
   res = res*16+ch;
  }
 /* Fertig */
 Status = res;
}

/*
  Zahl umrechnen.
*/
toint(ip,str)
int *ip;
char *str;
{
 char *more;

 /* Umwandeln */
 errno = 0;
 return ((((*ip = strtoul(str,&more,10)) != -1) || !errno) && more && !*more && (more != str));
}

