#include "dcl.h"

/*
  Maximale Anzahl von Werte eines logischen Namens.
*/
#define MAXWERT 		128

/*
  DEFINE/ASSIGN P1 P2
  	[/SYSTEM]
	[/GROUP]
	[/JOB]
	[/PROCESS]
	[/USER_MODE]
	[/SUPERVISOR_MODE]
	[/EXECUTIVE_MODE]
	[/TABLE=table]
	[/LOG]
	[/NAME_ATTRIBUTES=name_attributes]
	[/TRANSLATION_ATTRIBUTES=translation_attributes]
*/
CLIdefine()
{
 doDefineAssign(0);
}

CLIassign()
{
 doDefineAssign(1);
}

static doDefineAssign(assign)
int assign;
{
 static char table[256],name[256],equ[MAXWERT+1][LNM$C_NAMLENGTH+1];
 static equiv_t wert[MAXWERT];
 int tlen,len,res,aflags,nlen,dflags;
 crelnm_t newlnm;
 logname *lnm;
 
 /* Tabelle ermitteln */
 get_table(table);
 /* Zugriffsmode ermitteln */
 newlnm.acmode = get_acmode();
 /* Output abschalten, falls noetig */
 get_nolog();
 /* Attribute einlesen */
 newlnm.flags = get_flags(0);
 /* Logischen Namen einlesen */
 if ( !((res = VALUE(assign ? "P2" : "P1",name,&nlen))&1) ) return;
 if ( assign && nlen && (name[nlen-1] == ':') ) nlen--;
 name[nlen] = '\0';
 /* Defaultwerte fuer TRANSLATION_ATTRIBUTES ermitteln */
 dflags = 0;
 if ( PRESENT("CONCEALED")&1 ) dflags |= LNM$M_CONCEALED;
 if ( PRESENT("TERMINAL")&1 ) dflags |= LNM$M_TERMINAL;
 /* Struktur initialisieren */
 newlnm.name = name;
 newlnm.pid = getpid();
 newlnm.parent = table;
 newlnm.names.names_len = 0;
 newlnm.names.names_val = wert;
 /* Strings einlesen */
 do
  {
   /* Name auslesen */
   res = VALUE(assign ? "P1" : "P2",equ[newlnm.names.names_len],&len);
   if ( (res != CLI$_COMMA) && (res != CLI$_CONCAT) && (res != CLI$_NORMAL) ) break;
   if ( newlnm.names.names_len == MAXWERT )
    {
     Status = SS$_BADPARAM;
     return;
    }
   /* Namen in Hochkommas bearbeiten */
   if ( (len >= 2) &&
        (equ[newlnm.names.names_len][0] == '"') && 
        (equ[newlnm.names.names_len][len-1] == '"') )
    memcpy(equ[newlnm.names.names_len],equ[newlnm.names.names_len]+1,len -= 2);
   /* Text sauber abschliessen */
   equ[newlnm.names.names_len][len] = '\0';
   /* Attribute ermitteln */
   if ( PRESENT("TRANSLATION_ATTRIBUTES") == CLI$_LOCPRES )
    {
     aflags = 0;
     if ( PRESENT("CONCEALED")&1 ) aflags |= LNM$M_CONCEALED;
     if ( PRESENT("TERMINAL")&1 ) aflags |= LNM$M_TERMINAL;
    }
   else
    aflags = dflags;
   /* Eintragen */
   wert[newlnm.names.names_len].name = equ[newlnm.names.names_len];
   wert[newlnm.names.names_len].flags = aflags;
   newlnm.names.names_len++;
  }
 while ( res != CLI$_NORMAL );
 /* Befehl ausfuehren */
 if ( !(lnm = (logname *)execLNM(crelnm_1,&newlnm)) )
  Status = SS$_ACCVIO;
 else
  {
   /* Ergebnis auswerten */
   if ( lnm->acmode < 0 )
    Status = -lnm->acmode;
   else if ( lnm->flags&LNM$M_SUPERSEDE )
    Status = SS$_SUPERSEDE;
   clnt_freeres(lnmlibLNM,xdr_logname,lnm);
  }
}

/*
  CREATE/NAME P1
  	[/USER_MODE]
	[/SUPERVISOR_MODE]
	[/EXECUTIVE_MODE]
	[/ATTRIBUTES=attribute_keywords]
	[/PARENT_TABLE=table]
	[/QUOTA=number]
	[/PROTECTION=protection]
	[/LOG]
*/
CLIcretable()
{
 static char name[256],parent[256],buf[256];
 int flags,acmode,nlen,plen,blen;
 crelnt_t newlnt;
 logname *lnm;

 /* Zugriffsmode ermitteln */
 newlnt.acmode = get_acmode();
 /* Flags ermitteln */
 newlnt.flags = get_flags(1);
 /* Ausgabe abschalten, falls gewuenscht */
 get_nolog();
 /* Name der Tabelle einlesen */
 if ( !(VALUE("P1",name,&nlen)&1) ) return;
 name[nlen] = '\0';
 /* Name der Vatertabelle einlesen */
 if ( VALUE("PARENT_TABLE",parent,&plen)&1 )
  parent[plen] = '\0';
 else
  strcpy(parent,"LNM$PROCESS_DIRECTORY");
 /* Quoten einlesen */
 if ( !(VALUE("QUOTA",buf,&blen)&1) )
  newlnt.quota = -1;
 else
  {
   buf[blen] = '\0';
   if ( (newlnt.quota = atoi(buf)) <= 0 ) newlnt.quota = -1;
  }
 /* Schutzmaske einlesen */
 newlnt.prot = get_protection("PROTECTION");
 /* Initialisierung */
 newlnt.name = name;
 newlnt.parent = parent;
 newlnt.pid = getpid();
 /* Befehl ausfuehren */
 if ( !(lnm = (logname *)execLNM(crelnt_1,&newlnt)) )
  Status = SS$_ACCVIO;
 else
  {
   /* Auswerten der Antwort */
   if ( lnm->acmode < 0 )
    Status = -lnm->acmode;
   else if ( lnm->flags&LNM$M_EXISTS )
    Status = SS$_NORMAL;
   else if ( lnm->flags&LNM$M_SUPERSEDE )
    Status = SS$_SUPERSEDE;
   else
    Status = SS$_LNMCREATED;
   clnt_freeres(lnmlibLNM,xdr_logname,lnm);
  }
}

/*
  DEASSIGN [P1]
  	[/SYSTEM]
	[/GROUP]
	[/JOB]
	[/PROCESS]
	[/USER_MODE]
	[/SUPERVISOR_MODE]
	[/EXECUTIVE_MODE]
	[/TABLE=table]
	[/ALL]
*/
CLIdeassign()
{
 static char name[256],table[256];
 int nlen,*res;
 dellnm_t del;
 
 /* Tabelle ermitteln */
 get_table(table);
 /* Zugriffsmode ermitteln */
 del.acmode = get_acmode();
 /* Alles oder nichts */
 if ( PRESENT("ALL")&1 )
  name[0] = '\0';
 else if ( !(VALUE("P1",name,&nlen)) )
  return;
 else
  name[nlen] = '\0';
 /* Struktur aufsetzen */
 del.name = name;
 del.parent = table;
 del.pid = getpid();
 /* Befehl ausfuehren */
 if ( res = (int *)execLNM(dellnm_1,&del) )
  Status = *res ? *res : SS$_NORMAL;
 else
  Status = SS$_ACCVIO;
}

/*
  SHOW TRANSLATION P2
  	[/TABLE=table]
*/
CLIshowtran()
{
 static char table[256],name[256];
 int tlen,nlen;
 trnlnm_t trn;
 logname *lnm;

 /* Tabellenname einlesen */
 if ( VALUE("TABLE",table,&tlen)&1 )
  table[tlen] = '\0';
 else
  strcpy(table,"LNM$DCL_LOGICAL");
 /* Logischen Namen einlesen */
 if ( !(VALUE("P2",name,&nlen)&1) ) return;
 name[nlen] = '\0';
 /* Struktur zusammensetzen */
 trn.name = name;
 trn.parent = table;
 trn.pid = getpid();
 trn.acmode = PSL$C_USER;
 trn.flags = 0;
 /* Ausfuehren */
 if ( !(lnm = (logname *)execLNM(trnlnm_1,&trn)) )
  Status = SS$_ACCVIO;
 else
  {
   /* Antwort auswerten */
   if ( lnm->acmode < 0 )
    printf("  %s = \"\"  (UNDEFINED)\n",name);
   else if ( (lnm->info.table == TRUE) || !lnm->info.loginfo_u.wert.wert_len )
    printf("  %s = \"\"  (%s)\n",name,lnm->parent);
   else
    printf("  %s = \"%s\"  (%s)\n",name,lnm->info.loginfo_u.wert.wert_val[0].name,lnm->parent);
   clnt_freeres(lnmlibLNM,xdr_logname,lnm);
  }
}

/*
  Zugriffsmode ermitteln.
*/
static get_acmode()
{
 if ( PRESENT("USER_MODE")&1 ) return PSL$C_USER;
 if ( PRESENT("EXECUTIVE_MODE")&1 ) return PSL$C_EXEC;
 return PSL$C_SUPER;
}

/*
  Flags einlesen.
*/
static get_flags(all)
int all;
{
 int flags = 0;

 if ( PRESENT("CONFINE")&1 ) flags |= LNM$M_CONFINE;
 if ( PRESENT("NO_ALIAS")&1 ) flags |= LNM$M_NO_ALIAS;
 if ( all & !(PRESENT("SUPERSEDE")&1) ) flags |= LNM$M_CREATE_IF;
 return flags;
}

/*
  Tabellenname einlesen.
*/
static get_table(tab)
char tab[256];
{
 int tlen;

 if ( cli$get_value_("TABLE",tab,&tlen,5,256-1)&1 )
  tab[tlen] = '\0';
 else if ( PRESENT("SYSTEM")&1 )
  strcpy(tab,"LNM$SYSTEM");
 else if ( PRESENT("GROUP")&1 )
  strcpy(tab,"LNM$GROUP");
 else if ( PRESENT("JOB")&1 )
  strcpy(tab,"LNM$JOB");
 else
  strcpy(tab,"LNM$PROCESS");
}

/*
  Logical Name Manager ansprechen.
*/
execLNM(func,para)
int (*func)();
char *para;
{
 int retries,res;

 /* Mehrmals versuchen */
 for ( retries = 2 ; retries-- ; )
  {
   /* Verbindung herstellen, falls noetig */
   if ( !lnmlibATTACH(0) ) continue;
   /* Ausfuehren, falls moeglich */
   if ( res = (*func)(para,lnmlibLNM) ) return res;
   /* Fehler bearbeiten */
   clnt_destroy(lnmlibLNM);
   lnmlibLNM = 0;
  }
 /* Fehler melden */
 return 0;
}

