#include "dcl.h"

/*
  Defaultdirectory.
*/
char *DefDir = 0;

/*
  SET DEFAULT P2
*/
CLIsetdef()
{
 static char NewDir[256];
 int nlen,res;
 char *name;
 
 /* P2 */
 if ( !(VALUE("P2",NewDir,&nlen)&1) ) return;
 NewDir[nlen] = '\0';
 /* Umsetzen */
 if ( !(name = translate_vms_default(NewDir,DefDir)) || (name == (char *)-1) )
  {
   Status = SS$_BADFILENAME;
   return;
  }
 /* Aufsetzen und benutzen */
 res = makeDefaultDir(name);
 if ( res&1 ) 
  setDefaultDir();
 else 
  Status = res;
}

/*
  SHOW DEFAULT
*/
CLIshowdef()
{ 
 /* Anzeigen */
 printf("  %s\n",DefDir);
 /* Fehlercode ermitteln */
 if ( !setDefaultDir() ) Status = SS$_NOSUCHFILE;
}

/*
  Initialer Wert fuer die Defaultdirectory.
*/
makeDefaultDir(dd)
char *dd;
{
 /* Umwandeln */
 if ( !(dd = gen_vms(dd,1)) ) return SS$_BADFILENAME;
 /* Abspeichern */
 if ( DefDir ) free(DefDir);
 DefDir = dd;
 /* Fertig */
 return SS$_NORMAL;
}

/*
  Directory aendern.
*/
static setDefaultDir()
{
 char *name;

 /* Umwandeln */
 if ( !DefDir || !(name = translate_vms(DefDir)) || (name == (char *)-1) ) return 0;
 /* Benutzen */
 return !chdir(name);
}
