#include <saphir/CLD.h>

#include <saphir/DCL/symbols.h>

#include "dcl.h"
#include "command.h"

/*
  SET [NO]VERIFY[=what]
*/
CLIsetverify()
{
 int ima,pro;

 switch (PRESENT("VERIFY"))
  {
   case CLI$_PRESENT : /* Wert ermitteln */
     		       ima = PRESENT("IMAGE");
     		       pro = PRESENT("PROCEDURE");
		       /* SET VERIFY */
		       if ( (ima == CLI$_ABSENT) && (pro == CLI$_ABSENT) )
			VerifyFlag = VerifyPROCEDURE|VerifyIMAGE;
     		       else
			{
			 /* SET VERIFY=what */
			 /* - [NO]IMAGE */
			 if ( ima == CLI$_PRESENT )
			  VerifyFlag |= VerifyIMAGE;
			 else if ( ima == CLI$_NEGATED )
			  VerifyFlag &= ~VerifyIMAGE;
			 /* - [NO]PROCEDURE */
			 if ( pro == CLI$_PRESENT )
			  VerifyFlag |= VerifyPROCEDURE;
			 else if ( pro == CLI$_NEGATED )
			  VerifyFlag &= ~VerifyPROCEDURE;			  
			}
     		       break;
   case CLI$_NEGATED : VerifyFlag = 0;
     		       break;
  }
}

/*
  @ file parameter
*/
dcl$start_file(pcb,clean)
struct epcbCLD *pcb;
long clean;
{
 int res = parse_exit,n,tab = LIB$K_CLI_LOCAL_SYM,len;
 commandLevel *cur = comfile+(curLevel+1);
 char sym[2] = "P1",*value;
 struct descriptor *des;

 /* Neue Ebene erzeugen */
 if ( curLevel == DCLMAXLEVEL-1 )
  res = CLI$_EXPSYN;
 else
  {
   /* Level Initialisieren */
   cur->filename = pcb->pcb_filename.text;
   cur->fd = -1;
   cur->isopen = cur->issystem = 0;
   cur->onflag = (cur-1)->onflag;
   /* Neue Ebene Symbole erzeugen */
   res = symbol_operation(SYM$OP_STARTFILE,NOINT,NOSTR,0,NOSTR,0,NOSTR,0,NOINT);
   /* Symbole definieren */
   for ( des = &pcb->pcb_p8, n = 8 ; (res&1) && n-- ; des-- )
    {
     /* Name des Symbols */
     sym[1] = '1'+n;
     /* Default ist "" */
     len = 0;
     if ( value = des->text )
      len = des->len;
     else
      value = "";
     /* Definieren */
     res = lib$set_symbol_(sym,value,&tab,sizeof(sym),len);
    }
   /* Fehlercode testen */
   if ( res&1 ) 
    {     
     res = parse_exit;
     comfile[curLevel++].isopen = 0;
    }
   else if ( n != 8 )
    symbol_operation(SYM$OP_ENDFILE,NOINT,NOSTR,0,NOSTR,0,NOSTR,0,NOINT);
  }
 /* Aufraeumen */
 if ( res == parse_exit )
  pcb->pcb_filename.text = 0;
 else if ( clean )
  cleanCommand(pcb,0);
 /* Ferig */
 return res;
}

/*
  Kommandodatei aufsetzen.
*/
setupFile(name)
char *name;
{
 struct epcbCLD compcb;

 /* Aufsetzen */
 if ( !(compcb.pcb_filename.text = strdup(name)) ) return;
 compcb.pcb_filename.len = strlen(compcb.pcb_filename.text);
 compcb.pcb_p1.text = compcb.pcb_p2.text = compcb.pcb_p3.text = compcb.pcb_p4.text = 0;
 compcb.pcb_p5.text = compcb.pcb_p6.text = compcb.pcb_p7.text = compcb.pcb_p8.text = 0;
 /* Ausfuehren */
 dcl$start_file(&compcb,0L);
 /* Aufraeumen */
 if ( compcb.pcb_filename.text ) free(compcb.pcb_filename.text);
}

/*
  $ file parameter
*/
dcl$foreign_command(pcb,clean)
struct epcbCLD *pcb;
long clean;
{
 char *pname,*buf;
 int res,len;

 /* Programm suchen und starten */
 res = exe_name(pcb->pcb_filename.text,"sys$system:.exe",&pname);
 /* Speicher reservieren */
 if ( res == parse_exit )
  {
   len = strlen(pname)+1+pcb->pcb_rightside.len+1;
   if ( !(buf = malloc(len)) ) res = CDU_NOMEM;
  }
 /* Fehler melden */
 if ( res != parse_exit )
  {
   if ( clean ) cleanCommand(pcb,0);
   return res;
  }
 /* Befehl zusammenbauen */
 strcpy(buf,pname);
 strcat(buf," ");
 strcat(buf,pcb->pcb_rightside.text);
 /* Statuscode eintragen */
 setStatus();
 /* Lesen aus der aktuellen Datei */
 setInputChannel(buf);
 free(buf);
 /* Image ausgefuehrt */
 CLIimage = 1;
 /* Aufraeumen fur cli$dcl_parse_ */
 return parse_exit; 
}

/*
  Name einer Programmdatei ermitteln.
*/
static exe_name(file,def,res)
char *file,*def,**res;
{
 /* Mit der VMS Endung versehen */
 if ( !(*res = translate_vms_default(file,def)) || (*res == (char *)-1) ) 
  return SS$_NOSUCHFILE;
 if ( !access(*res,X_OK) ) return 0;
 /* Normal umsetzen */
 if ( !(*res = translate_vms(file)) || (*res == (char *)-1) ) return SS$_NOSUCHFILE;
 /* Alles in Ordung */
 return 0;
}

/*
  MCR P1 [P2]
*/
CLImcr()
{
 static char file[256],para[1024];
 extern char *createValue();
 struct epcbCLD compcb;
 int flen,plen,res;
 
 /* Einlesen */
 if ( !(VALUE("P1",file,&flen)&1) ) return;
 if ( !(VALUE("P2",para,&plen)&1) ) plen = 0;
 /* Umsetzen */
 file[flen] = '\0';
 compcb.pcb_filename.text = file;
 compcb.pcb_filename.len = flen;
 if ( !(compcb.pcb_rightside.text = createValue(para,plen,4,0)) )
  {
   Status = CLI$_EXPSYN;
   return;
  }
 compcb.pcb_rightside.len = strlen(compcb.pcb_rightside.text);
 /* Ausfuehren */
 if ( res = dcl$foreign_command(&compcb,0L) ) Status = res;
 /* Aufraeumen */
 free(compcb.pcb_rightside.text);
}

/*
  RUN FILE_SPEC
       /DEBUG
*/
CLIrun()
{
 static char prog[256];
 char *dbx,*prg,*all;
 int plen,res;
 
 /* Parameter */
 if ( !(VALUE("P1",prog,&plen)&1) ) return;
 /* Dateiname */
 prog[plen] = '\0';
 /* Programm suchen und starten */
 if ( res = exe_name(prog,".exe",&prg) )
  {
   Status = res;
   return;
  }
 strcpy(prog,prg);
 /* Debugger */
 if ( !(PRESENT("DEBUG")&1) )
  dbx = 0;
 else if ( !(dbx = translate_vms(DEBUGNAME)) || (dbx == (char *)-1) || !strcmp(dbx,DEBUGNAME) )
  dbx = "dbx";
 /* Zusammensetzen */
 if ( !(all = malloc((dbx ? (strlen(dbx)+1) : 0)+strlen(prog)+1)) )
  {
   Status = SS$_INSFMEM;
   return;
  }
 *all = '\0';
 if ( dbx )
  {
   strcpy(all,dbx);
   strcat(all," ");
  }
 strcat(all,prog);
 /* Statuscode setzen */
 setStatus();
 /* Ausfuehren */
 setInputChannel(all);
 free(all);
 /* Image ausgefuehrt */
 CLIimage = 1;
}

/*
  Eingabekanal fuer einen Aufruf aufsetzen.
    SYS$INPUT == "SYS$COMMAND"	Eingabe von 'inpLevel'
    	      == SYS$COMMAND	Eingabe vom Resultat
	      	 undefiniert	Eingabe aus der Kommandodatei
*/
setInputChannel(cmd)
char *cmd;
{
 int pipe = 0,stol;
 char *sysin,cur;
 FILE *pcmd;

 /* Aktuellen Kanal schliessen */
 comfile[curLevel].isopen = 0;
 close(0);
 /* SYS$INPUT undefiniert */
 if ( !(sysin = translate_vms("SYS$INPUT")) || (sysin == (char *)-1) || 
      !strcmp(sysin,"sys$input") )
  {
   dup2(comfile[curLevel].fd,0);
   pipe = (curLevel > 0);
  }
 /* SYS$INPUT == "SYS$COMMAND[:]" */
 else if ( !strcmp(sysin,"sys$command") )
  {
   dup2(comfile[inpLevel].fd,0);
   pipe = (inpLevel > 0);
  }
 /* Echte neue Datei */
 else
  open(sysin,O_RDONLY);
 /* Ausfuehren */
 if ( !pipe ) return system(cmd);
 /* Spezialmodus mit SYS$INPUT in der Kommandodatei */
 if ( !(pcmd = popen(cmd,"w")) )
  {
   Status = SS$_NOSUCHFILE;
   return 1;
  }
 /* Kommandodatei bis zum naechsten $ lesen */
 for ( stol = 1 ; read(0,&cur,1) == 1 ; )
  if ( stol && (cur == '$') )
   {
    /* Pseudozeilenende */
    useDollar = 1;
    break;
   }
  else
   {
    /* Normales Zeichen */
    stol = (cur == '\n');
    fputc(cur,pcmd);
    /* Anzeigen */
    if ( !isatty(0) && (VerifyFlag&VerifyIMAGE) ) putchar(cur);
   }
 /* Fertig */
 pclose(pcmd);
 return 0;
}
