#include "dcl.h"

/*
  Feste Teile einer CDU-Tabelle im Zwischenformat.
*/
static char *CDUline[] = 
       {
	"\n",
	"struct MAP { int noop; };\n",
	"\n",
	"struct\n",
	"\t{\n",
	"\t int version;\n",
	"\t int verbs;\n",
	"\t char *table;\n",
	"\t int tsize;\n",
	"\t struct MAP *map;\n",
	"\t int msize;\n",
	"\t char *admin;\n"
       };

/*
  MACRO-Texte.
*/
#define CDUTEMPDIR		"/tmp"
#define CDUTEMP			"/tmp/DCLcdu%08X%s"
#define OBJLIB			"-lsaphir"
#define DCLLIB			"-lDCL"

/*
  Aendern des Suffices von 'CDUtemp'.
*/
#define CDUsuff(s,u)		{ sprintf(CDUtemp,CDUTEMP,getpid(),s);if (u) unlink(CDUtemp); }

/*
  Dateinamen fuer das Arbeiten mit CDU, 'CDUtemp' wird der jeweiligen Situation
  angepasst.
*/
static char CDUtemp[] = "/tmp/DCLcduXXXXXXXX.cld";
static char CDUnull[] = "/dev/null";

/*
  CDU-Tabelle im Standardzwischenformat ausgeben.
*/
dumpTable(tbl,name)
struct CDUtable *tbl;
char *name;
{
 struct CDUverbtab *scan;
 int lcnt = 0,i,len;
 unsigned char *mem;
 FILE *out;

 /* Datei anlegen */
 if ( !loadCDU(tbl) || !(out = fopen(name,"w")) ) return 1;
 /* Datenfeld so ausgeben, dass readTable es verstehen kann */
 fprintf(out,"static char TAB[] = \"\\\n");
 for ( i = tbl->verbs, scan = tbl->vtab ; i-- ; scan++ )
  if ( scan->name == scan->parent )
   for ( len = scan->msize, mem = (unsigned char *)scan->mem ; len-- ; )
    {
     fprintf(out,"\\%o",*mem++);
     if ( ++lcnt == 16 )
      {
       fprintf(out,"\\\n");
       lcnt = 0;
      }
    }
 /* ROUTINE-Tabelle ausgeben. Sie wird im DCL durch die CLIROUTINE-Tabelle ersetzt. */
 fprintf(out,"\\0\\\n\";\n");
 /* Konstante Zeilen ausgeben */
 for ( i = 0 ; i < (sizeof(CDUline)/sizeof(CDUline[0])) ; ) fprintf(out,CDUline[i++]);
 /* Strukturwerte ausgeben */
 fprintf(out,"\t} cdu$table_ = { 0x%04x,%d,TAB,sizeof(TAB)-2,0,0,0 };\n\n",
	     tbl->version,tbl->verbs);
 /* Datei schliessen und Erfolg melden */
 fclose(out);
 return 0;
}

/*
  CDU-Tabelle im Standardformat einlesen und Struktur daraus ableiten. Wie dumpTable
  arbeitet diese Routine eng mit der CLD-Library und dem CDU-Compiler zusammen. Aenderungen
  dort muessen daher auch hier vermerkt werden.
*/
#define READERROR()	{ err = 1; break; }

static struct CDUtable *readTable(name)
char *name;
{
 int all = 0,used = 0,err = 0,val,lcnt,sign;
 char *mem,line[256],*nmem,*scan,*num;
 struct CDUtable *nt;
 FILE *in;

 /* Datei oeffnen */
 if ( !(in = fopen(name,"r")) ) return 0;
 /* Strukturspeicher allokatieren */ 
 if ( !(nt = (struct CDUtable *)malloc(sizeof(*nt))) )
  err = 1;
 else
  {
   /* Anfangsinformation einlesen */
   if ( !readExpect(in,"static char TAB[] = \"\\\n") )
    err = 1;
   else
    {
     /* Zeilen einlesen */
     while ( !(err = !fgets(scan = line,sizeof(line),in)) )
      {
       /* Speicher reservieren */
       if ( all == used )
	{
	 if ( !(nmem = malloc(all+1024)) ) READERROR();
	 if ( all )
	  {
	   memmove(nmem,mem,all);
	   free(mem);
	  }
	 all += 1024;
	 mem = nmem;
	}
       /* Ende der Tabelle */
       if ( !strcmp(line,"\";\n") ) break; 
       /* Konistenztest */
       if ( *scan++ != '\\' ) READERROR();
       /* Zeile einlesen */
       for ( lcnt = 0 ; *scan != '\n' ; lcnt++ )
	{
	 /* Wert ermitteln */
	 for ( val = 0, num = scan ; (*scan >= '0') && (*scan <= '7') ; )
	  val = val*8+(*scan++-'0');
	 /* Konsistenztest, und Wert ueberpruefen */
	 if ( !(scan-num) || ((scan-num) > 3) || (*scan++ != '\\') || (val > 255) )
	  READERROR();
	 /* Wert abspeichern */
	 mem[used++] = val;
	}
       /* Naechste Zeile oder Ende vorbereiten */
       if ( err ) break;
       if ( lcnt == 16 ) continue;
       if ( readExpect(in,"\";\n") ) break;
       /* So nicht */
       READERROR();
      }
     /* Null anhaengen */
     if ( !err ) mem[used++] = '\0';
     /* Version und Zahl der Verben einlesen */
     if ( !err )
      if ( (used&1) || !used || !(used -= 2) )
       err = 1;
      else
       {
	/* Konstante Zeilen abtesten */
	for ( val = 0 ; val < (sizeof(CDUline)/sizeof(CDUline[0])) ; )
	 if ( !readExpect(in,CDUline[val++]) )
	  READERROR();
	/* Letzte Zeile einlesen und dekodieren */
	if ( !err && !(err = !fgets(line,sizeof(line),in)) )
	 if ( memcmp(line,"\t} cdu$table_ = { 0x",20) )
	  err = 1;
	 else
	  {
	   /* Versionsnummer einlesen */
	   for ( num = scan = line+20, val = 4 ; val-- ; scan++ )
	    if ( (*scan < '0') || (*scan > 'f') || ((*scan > '9') && (*scan < 'a')) )
	     READERROR();
	   if ( !err ) 
	    if ( *scan != ',' )
	     err = 1;
	    else
	     {
	      *scan++ = '\0';
	      sscanf(num,"%x",&val);
	      /* Versionsnummer mit der aktuellen CLD Version vergleichen */
	      if ( val != cdu$table_.version )
	       err = 1;
	      else
	       {
	        /* Zahl der Verben einlesen */
	        for ( num = scan ; (*scan >= '0') && (*scan <= '9') ; scan++ );
	        if ( !(scan-num) || ((scan-num) > 4) || !readExpect(in,"\n") ||
		     strcmp(scan,",TAB,sizeof(TAB)-2,0,0,0 };\n") )
	         err = 1;
	        else
	         {
		  /* Struktur komplettieren */
		  nt->version = CDUVERSION;
		  nt->verbs = atoi(num);
		  nt->table = mem;
		  nt->tsize = used;
		  nt->map = 0;
		  nt->msize = 0;
		  nt->vtab = 0;
		  /* Und in eine CDU-Tabelle umwandeln */
		  if ( !loadCDU(nt) ) err = 1;
	    	 }
	       }  
	     }
	  }
       }
    }
  }
 /* Ausfraeumen und Ergebnis melden */
 fclose(in);
 if ( !err ) return nt;
 if ( all ) free(mem);
 if ( nt ) free(nt);
 return 0;
}

/*
  Zeile einlesen und mit einem Erwartungswert vergleichen.
*/
static readExpect(f,str)
FILE *f;
char *str;
{
 static char line[256];

 return (fgets(line,sizeof(line),f) && !strcmp(line,str));
}
 
/*
  SET COMMAND
  	/DELETE=verbs
	/OBJECT[=file]
	/REPLACE
	/SYMBOLS=file
*/
CLIcdu()
{
 /* Generelle Optionen einlesen */
 get_nolog();
 /* Aktion ausfuehren */
 if ( PRESENT("DELETE")&1 )
  Status = SCdelete();
 else if ( PRESENT("OBJECT")&1 ) 
  Status = SCobject();
 else if ( PRESENT("REPLACE")&1 ) 
  Status = SCreplace();
 else if ( PRESENT("SYMBOLS")&1 )
  Status = SCsymbols();
}

/*
  SET COMMAND/DELETE=verbs
  	/CLI=cli
	/LOG
	/OUTPUT[=file]
	/TABLES[=file]
*/
static SCdelete()
{
 static char tab[256],verb[256],out[256];
 int tlen,vlen,olen,res;
 char *tname;

 /* Ausgabetabelle /OUTPUT[=file] ermitteln */
 if ( res = get_out(out,&olen,sizeof(out)) ) return res;
 /* Eingabetabelle /TABLES[=file] ermitteln */
 if ( res = get_tables(tab,&tlen,sizeof(tab),olen != -1) ) return failDCL(olen,res);
 /* Verben /DELETE=verbs einlesen und loeschen */
 do
  {
   /* Naechstes Verb ermitteln */
   res = VALUE("DELETE",verb,&vlen);
   if ( (res != CLI$_COMMA) && (res != CLI$_NORMAL) ) return failDCL(olen,res);
   verb[vlen] = verb[4] = '\0';
   /* Verb und alle Synonyme suchen und eleminieren */
   deleteVerb(verb,cdu$table_.vtab,&cdu$table_.verbs,1);
  }
 while ( res != CLI$_NORMAL );
 /* Fertig */
 if ( olen == -1 ) return SS$_NORMAL;
 /* Neue DCL Shell erzeugen */
 newDCL(out);
}

/*
  Elemination aller Verben, deren Name oder Synonyme auf den vorgegebenen auf vier
  Zeichen Laenge gekuerzten Namen passen.
*/
static deleteVerb(verb,vtab,vptr,clean)
char *verb;
struct CDUverbtab *vtab;
int *vptr,clean;
{
 int verbs,res,clen,sum = 0;
 struct CDUverbtab *scan;
 char comp[5],*name;

 /* Verb und alle Synonyme suchen und eleminieren */
 for ( ; ; )
  {
   /* Verb suchen */
   for ( verbs = *vptr, scan = vtab, name = 0 ; verbs-- ; scan++ )
    {
     /* Relevanten Teil des Namens ermitteln */
     if ( (clen = strlen(scan->name)) > 4 ) clen = 4;
     memmove(comp,scan->name,clen);
     comp[clen] = '\0';
     /* Mit dem relevanten Teil der Eingabe vergleichen */
     if ( strcmp(verb,comp) ) continue;
     /* Gefunden */
     name = scan->parent;
     break;
    }
   /* Fertig */
   if ( !name ) return sum;
   sum++;
   /* Alle Synonyme loeschen */
   for ( scan = vtab+(verbs = *vptr) ; verbs-- ; )
    if ( name == (--scan)->parent )
     {
      /* Speicher freigeben */
      if ( clean && (scan->name == scan->parent) ) freepcb(scan->pcb);
      /* Tabelle korrigieren */
      memmove((char *)scan,(char *)(scan+1),((*vptr-verbs)-1)*sizeof(*scan));
      (*vptr)--;
     }
  }
}

/*
  SET COMMAND/OBJECT[=file] [CLD_SPEC]
  	/CLI=cli
	/LISTING[=file]
	/LOG
*/
static SCobject()
{
 static char list[256],obj[256],cld[256];
 int llen,olen,clen,res,dolist = 0;

 /* Listdatei /LISTING=file ermitteln */
 if ( !(VALUE("LISTING",list,&llen)&1) )
  if ( PRESENT("LISTING")&1 )
   dolist = 1;
  else
   llen = -1;
 else if ( !make_vms(list,llen,".lis",sizeof(list)) )
  return SS$_NOSUCHFILE;
 /* Objektdatei /OBJECT[=file] ermitteln */
 if ( !(VALUE("OBJECT",obj,&olen)&1) )
  olen = -1;
 else if ( !make_vms(obj,olen,".o",sizeof(obj)) )
  return SS$_NOSUCHFILE;
 /* Alle CLD-Dateien durchgehen und bearbeiten */
 do
  {
   /* Naechsten Namen einlesen */
   res = VALUE("CLD_SPEC",cld,&clen);
   if ( (res != CLI$_NORMAL) && (res != CLI$_COMMA) && (res != CLI$_CONCAT) ) break;
   /* Name validieren */
   if ( !make_vms(cld,clen,".cld",sizeof(cld)) ) continue;
   /* Listdatei ermitteln */
   if ( !dolist )
    clen = llen;
   else if ( ((clen = namelen(cld))+4) < sizeof(list) )
    {
     strcpy(list,cld);
     strcpy(list+clen,".lis");
    }
   else
    clen = -1;
   /* Datei bearbeiten */
   if ( !DCLexec("CDU",CDUnull,CDUnull,NoLog ? CDUnull : NOSTR,
		 "-l",(clen == -1) ? CDUnull : list,cld,NOSTR) )
    /* Objektdatei umbenennen */
    if ( (olen != -1) && (((clen = namelen(cld))+2) < sizeof(cld)) )
     {
      strcpy(cld+clen,".o");
      /* Umbenennung durchfuehren */
      if ( strcmp(cld,obj) ) 
       {
	DCLexec("cp",CDUnull,CDUnull,NoLog ? CDUnull : NOSTR,cld,obj,NOSTR);
	unlink(cld);
       }
      /* Nur fuer die jeweils erste Datei */
      olen = -1;
     }
  }
 while ( res != CLI$_NORMAL );
 /* Fertig */
 return SS$_NORMAL;
}

/*
  SET COMMAND/REPLACE [CLD_SPEC]
  	/CLI=cli
	/LISTING[=file]
	/LOG
	/OUTPUT[=file]
	/TABLES[=file]
*/
static SCreplace()
{
 static char list[256],out[256],tab[256],cld[256];
 int llen,olen,tlen,clen,res,dolist = 0;

 /* Listdatei ermitteln */
 if ( !(VALUE("LISTING",list,&llen)&1) )
  if ( PRESENT("LISTING")&1 )
   dolist = 1;
  else
   llen = -1;
 else if ( !make_vms(list,llen,".lis",sizeof(list)) )
  return SS$_NOSUCHFILE;
 /* Ausgabetabelle /OUTPUT[=file] ermitteln */
 if ( res = get_out(out,&olen,sizeof(out)) ) return res;
 /* Eingabetabelle /TABLES[=file] ermitteln */
 if ( res = get_tables(tab,&tlen,sizeof(tab),olen != -1) ) return failDCL(olen,res);
 /* Alle CLD-Dateien durchgehen und bearbeiten */
 do
  {
   /* Naechsten Namen einlesen */
   res = VALUE("CLD_SPEC",cld,&clen);
   if ( (res != CLI$_NORMAL) && (res != CLI$_COMMA) && (res != CLI$_CONCAT) ) break;
   /* Name validieren */
   if ( !make_vms(cld,clen,".cld",sizeof(cld)) ) continue;
   /* Listdatei ermitteln */
   if ( !dolist )
    clen = llen;
   else if ( ((clen = namelen(cld))+4) < sizeof(list) )
    {
     strcpy(list,cld);
     strcpy(list+clen,".lis");
    }
   else
    clen = -1;
   /* Datei bearbeiten */
   if ( replaceFile(cld,(clen != -1) ? list : NOSTR) < 0 ) Status = SS$_NOSUCHFILE;
  }
 while ( res != CLI$_NORMAL );
 /* Fertig */
 if ( olen == -1 ) return Status;
 newDCL(out);
}

/*
  Neuen DCL-Interpreter erzeugen.
*/
static newDCL(name)
char *name;
{
 char *cwd;
 int res;

 /* Auf die temporaere Directory setzen */
 cwd = getcwd(NOSTR,256);
 if ( chdir(CDUTEMPDIR) == -1 ) sys$exit_(SS$_NOSUCHFILE);
 /* Temporaeren Dateinamen erzeugen */
 CDUsuff(".c",1);
 /* Datei herausschreiben und uebersetzen */
 if ( !(res = dumpTable(&cdu$table_,CDUtemp)) )
  res = DCLexec("cc",CDUnull,CDUnull,NoLog ? CDUnull : NOSTR,"-O","-c",CDUtemp,NOSTR);
 /* Quelldatei loeschen */
 unlink(CDUtemp);
 if ( !res )
  {
   /* Ergebnis erstellen */
   if ( cwd ) chdir(cwd);
   CDUsuff(".o",0);
   res = DCLexec("cc",CDUnull,CDUnull,NoLog ? CDUnull : NOSTR,
		 "-O","-o",name,CDUtemp,DCLLIB,OBJLIB,NOSTR);
   /* Objektdatei loeschen */
   unlink(CDUtemp);
  }
 sys$exit_(res ? SS$_NOSUCHFILE : SS$_NORMAL);
}

/*
  Fehler bearbeiten, eventuell 'fork' beenden.
*/
static failDCL(olen,code)
int olen,code;
{
 /* Kein Subprozess */
 if ( olen == -1 ) return code;
 /* Subprozess */
 sys$exit_(code);
}

/*
  CDU-Tabelle aus einem anderen DCL-Interpreter auslesen.
*/
static get_dcl(name)
char *name;
{
 struct CDUtable *nt;
 int res = 0;

 /* Temporaeren Dateinamen erzeugen */
 CDUsuff("",1);
 /* Partner auffordern, die Tabelle zu erstellen */
 if ( !DCLexec(name,CDUnull,NoLog ? CDUnull : NOSTR,NoLog ? CDUnull : NOSTR,
	       "-d",CDUtemp,NOSTR) )
  /* Tabelle einlesen */
  if ( nt = readTable(CDUtemp) )
   {
    if ( loadCDU(nt) )
     {
      cdu$table_ = *nt;
      res = 1;
     }
    free(nt);
   }
 /* Zwischendatei loeschen */
 unlink(CDUtemp);
 /* Ergebnis melden */
 return res;
}

/*
  Ausgabetabelle ermitteln.
*/
static get_out(out,olen,size)
char *out;
int *olen,size;
{
 /* Qualifier /OUTPUT[=file] einlesen */
 if ( !(cli$get_value_("OUTPUT",out,olen,sizeof("OUTPUT")-1,size-1)&1) )
  {
   *olen = -1;
   return 0;
  }
 /* Dateiname umwandeln */
 if ( !make_vms(out,*olen,NOSTR,size) ) return SS$_NOSUCHFILE;
 /* Kindprozess erzeugen */
 switch (fork())
  {
   case -1 : return SS$_ACCVIO;
   case  0 : return 0;
   default : /* Statuscode setzen */
     	     setStatus();
     	     /* Synchronisieren */
     	     wait(NOINT);
     	     CLIimage = 1;
     	     return SS$_NORMAL;
  }
}

/*
  Eingabetabelle ermitteln.
*/
static get_tables(tab,tlen,size,got)
char *tab;
int *tlen,size,got;
{
 
 /* Name der Tabelle /TABLES[=file] einlesen */
 if ( !(cli$get_value_("TABLES",tab,tlen,sizeof("TABLES")-1,size-1)&1) )
  {
   *tlen = -1;
   return 0;
  }
 /* Dateiname umwandeln und Tabelle einlesen */
 if ( !make_vms(tab,*tlen,NOSTR,size) || !get_dcl(tab) ) return failDCL(got-1,SS$_NOSUCHFILE);
 /* Alles in Ordung */
 return 0;
}

/*
  Speicher einer CDU-Tabelle freigeben.
*/
static freeCDU(tab,deltab)
struct CDUtable *tab;
int deltab;
{
 struct CDUverbtab *scan;
 int i;

 /* Alle Parserkontrollbloescke freigeben */
 for ( i = tab->verbs, scan = tab->vtab ; i-- ; scan++ )
  if ( scan->name == scan->parent )
   freepcb(scan->pcb);
 /* Verbtabelle freigeben */
 free(tab->vtab);
 /* Rest nicht bei der primaeren Tabelle */
 if ( deltab ) 
  {
   /* Parsertabelle freigeben */
   free(tab->table);
   /* Tabelle selbst freigeben */
   free(tab);
  }
}

/*
  Datei einlesen und Verben in der aktuellen Tabelle ersetzen.
*/
static replaceFile(name,list)
char *name,*list;
{
 int sum,clen,i,nverbs,err;
 char cname[5],*mem,*fill;
 struct CDUtable *nt,keep;
 struct CDUverbtab *scan;

 /* Name der Listdatei ermitteln */
 if ( !list ) list = CDUnull;
 /* Temporaeren Dateinamen erzeugen */
 CDUsuff(".cld",1);
 /* Benutzerdatei kopieren */
 if ( DCLexec("cp",CDUnull,CDUnull,CDUnull,name,CDUtemp,NOSTR) ) return -1;
 /* Datei uebersetzen und Quelltext loeschen */
 err = DCLexec("CDU",CDUnull,CDUnull,NoLog ? CDUnull : NOSTR,"-cnl",list,CDUtemp,NOSTR);
 unlink(CDUtemp);
 /* Name der Ergebnisdatei ermitteln */
 CDUsuff(".c",0);
 if ( !err )
  /* Tabelle einlesen */
  if ( !(nt = readTable(CDUtemp)) )
   err = 1;
  else
   {
    /* Alte Tabelle vermerken */
    keep = cdu$table_;
    /* Alte Tabelle aufraeumen */
    for ( i = 0, nverbs = nt->verbs, scan = nt->vtab ; i < nverbs ; i++, scan++ )
     {
      /* Relevanten Teil des Namens extrahieren */
      if ( (clen = strlen(scan->name)) > 4 ) clen = 4;
      memmove(cname,scan->name,clen);
      cname[clen] = '\0';
      /* Und loeschen */
      deleteVerb(cname,cdu$table_.vtab,&cdu$table_.verbs);
     }
    /* Benoetigten Speicher berechnen */
    for ( sum = nt->tsize, i = cdu$table_.verbs, scan = cdu$table_.vtab ; i-- ; scan++ )
     if ( scan->name == scan->parent )
      sum += scan->msize;
    /* Speicher fuer Gesamttabelle reservieren und diese fuellen */
    if ( !(mem = malloc(sum)) )
     err = 1;
    else
     {
      memmove(mem,nt->table,nt->tsize);
      fill = mem+nt->tsize;
      for ( i = cdu$table_.verbs, scan = cdu$table_.vtab ; i-- ; scan++ )
       if ( scan->name == scan->parent )
        {
         memmove(fill,scan->mem,scan->msize);
         fill += scan->msize;
        }
      /* Vorherigen Speicher freigeben */
      freeCDU(&cdu$table_,0);
      freeCDU(nt,1);
      /* Gemeinsamen Speicherbereich herstellen */
      cdu$table_.verbs += nverbs;
      cdu$table_.vtab = 0;
      cdu$table_.table = mem;
      cdu$table_.tsize = sum;
      /* Und Tabelle initialisieren */
      if ( !loadCDU(&cdu$table_) )
       {
	/* Restaurieren */
	cdu$table_ = keep;
	cdu$table_.vtab = 0;
	err = 1;
       }
      else
       /* Aufraeumen */
       free(keep.table);
     }
   }
 /* C-Quelldatei loeschen */
 unlink(CDUtemp);
 /* Ergebnis melden */
 return err ? -1 : nverbs;
}

/*
  SET COMMAND/SYMBOLS=file
*/
static SCsymbols()
{
 return SS$_NOSUCHFILE;
}

