/*
  Nur EINE Programmdatei sollte #define DEF definieren um die Variablen anzulegen.
  Alle anderen referenzieren die Variablen nur.
*/
#ifndef DEF
#define DEF 	extern
#endif

/*
  Zur Umsetzung von UNIX Dateinamen in VAX/VMS Dateinamen unter Verwendung von logischen
  Namen wird zur Vereinfachung der UNIX Bezugspunkt / mit dem logischen Namen ROOTNAME
  assoziiert. Das macht anders als unter VAX/VMS Sinn, da JEDE Datei so zu erreichen
  ist.
*/
#ifndef ROOTNAME
#define ROOTNAME		"sys$sysroot:"
#endif

/*
  Logischer Name des Debuggers.
*/
#ifndef DEBUGNAME
#define DEBUGNAME		"dbg$name"
#endif

/*
  Jede Menge Definitionen.
*/
#include <pwd.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <varargs.h>

#include <rpc/rpc.h>

#include <sys/file.h>
#include <sys/wait.h>
#include <sys/param.h>
#include <sys/signal.h>
#include <sys/socket.h>

#include <saphir/CLI.h>
#include <saphir/CLIdef.h>
#include <saphir/vmsdef.h>

#include <saphir/lnm/lnm.h>

/*
  Schnittstelle zum Command Definition Utility CDU.
*/
extern struct CDUtable cdu$table_;

/*
  Schnittstelle zu lib$get_input_ fuer den RECALL Befehl.
*/
extern int EDITsize,EDITcnt,EDITinsert,EDITredo;
extern struct EDITcontrol *EDITctrl;

/*
  Externe C-Routinen.
*/
extern char *malloc(),*getcwd(),*strdup(),*realpath(),*getwd();

/* 
  Externe BOSSLIB/VMSSUPPORT Routinen.
*/
extern char *translate_vms(),*translate_vms_default(),*gen_vms();
extern int lib$get_input_(),cli$dcl_parse_(),cli$dispatch_();
extern struct epcb *getpcb();
struct CDUtable *readTable();

/*
  Status, Aenderung und Ausgabe desselben.
*/
DEF int Status,NoLog,NewStatus;

/*
  Prompt und Defaultdirectory - letztere in VAX/VMS Notation.
*/
DEF char pro[],*DefDir;

/*
  Generelle MACROs.
*/
#define NOSTR                   ((char *)0)
#define NOFCT                   ((int (*))0)
#define NOINT			((int *)0)

/*
  MACROs fuer die CLD Library mit ihrer FORTRAN Schnittstelle.
*/
#define PRESENT(n)              cli$present_(n,sizeof(n)-1)
#define VALUE(n,o,r)		cli$get_value_(n,o,r,sizeof(n)-1,sizeof(o)-1)

/*
  Schnittstellen der DCL Shell zur CLD Library.
*/
extern int nCLIcallmap,CLIimage;
extern struct MAP *CLIcallmap;

/*
  Operationsmodi fuer SET [NO]ON und SET [NO]VERIFY.
*/
DEF int VerifyFlag;
#define VerifyPROCEDURE		0x01
#define VerifyIMAGE		0x02

/*
  Bereich fuer Kommanddodateien. 'comfile[0]' ist immer fuer stdin reserviert.
*/
#define DCLMAXLEVEL		33
typedef struct commandLevel
	{
	 char			*filename;
	 int			fd;
	 int			isopen;
	 int			issystem;
	 int			onflag;
	} commandLevel;
DEF commandLevel comfile[DCLMAXLEVEL];
DEF int curLevel,inpLevel;

/*
  Dollar erzeugen.
*/
DEF int useDollar;

/*
  RPC-Handle fuer die Benutzung logischer Namen.
*/
extern CLIENT *lnmlibLNM;

