;
; Mit dieser Tabelle erkennt das CDUtility das Format einer Eingabezeile. Es
; erfolgt eine Vorzerlegung nach VERB und Rest der Zeile.
;
Version 1.0
;
Include <saphir/parser.h>
;
Character Sets
	Legal		= 1..255
	SymbolStart	= 'A'..'Z','a'..'z','$','_'
	SymbolChars	= 'A'..'Z','a'..'z','$','0'..'9','_','*'
;
Flags	    = explicitblanking
Abbrevation = unique
;
Definitions
Clear
 	descriptor 		symbol	
	COMMAND_MAXLENGTH 	= 1025
	long			start
	long			sstart
	long			flags
	  DOLLAR	= $001
	  OFFSET	= $002
	  STRING	= $004
	  GLOBAL	= $008
	  RESET		= $010
	  RESETDONE	= $020
	  AMPER		= $040
	  AMPERDONE	= $080
	  FOREIGN	= $100
	  COMMAND	= $200
	descriptor 		offset
	descriptor 		size
	descriptor 		rightside
	descriptor		filename
	descriptor		p1
	descriptor		p2
	descriptor		p3
	descriptor		p4
	descriptor		p5
	descriptor		p6
	descriptor		p7
	descriptor		p8
;	
Rules

;
; command = ['$'] line
; line    = 
;	  = '!' comment
;	  = '#' comment (UNIX)
;	  = '@' file p1 p2 p3 p4 p5 p6 p7 p8
;	  = ['&']SYMBOL [ '[' expression ',' expression ']' ] [':'] ['='] '=' expression
;	  = ['&']SYMBOL line2
;
State
Trans '#',p$Exit
Trans p$Lambda,,MarkLine

State Initial
Trans !Analyze,p$Exit,CheckReset,,,1
Trans p$Lambda,Initial,CheckReset,,,0

;
; {(' '|'\t')}
;
State Analyze
Trans !NoBlanks

;
; ['$'] {(' '|'\t')}
;
State
Trans '$',,,DOLLAR,flags
Trans p$Lambda,line

State 
Trans !NoBlanks

;
; (<EOS>|'!' {<any>}|'@' <callfile>|['&'])
;
State line
Trans p$Eos,p$Exit
Trans '!',p$Exit
Trans '@',callfile,Ampersand
Trans '&',,,AMPER,flags
Trans p$Lambda

;
; <symbol> 
;
State
Trans p$Symbol,,,,symbol

;
; ('[' <offset>|{(' '|'\t')})
; 
State
Trans p$Lambda,replace,TestFlag,,,RESETDONE
Trans '[',offset,,OFFSET,flags
Trans !NoBlanks

;
; (':' <assstr>|'=' <assign>|REST_OF_LINE)
;
State
Trans ':',assstr,,STRING,flags
Trans '=',assign
Trans p$Lambda

State replace
Trans p$Lambda,,dcl$replace_symbol

State
Trans p$Lambda,,TestFlag,,,FOREIGN
Trans p$Lambda,p$Exit

;
; '$'
;
State
Trans '$'

;
; {(' '|'\t')} FILE
;
State
Trans !NoBlanks

State
Trans #FILE,,SetResult,,,filename

;
; {(' '|'\t')} <string>
;
State
Trans !string,p$Exit,dcl$foreign_command,,,1

;
; {(' '|'\t')} EXPRESSION
;
State offset
Trans !NoBlanks

State
Trans #EXPRESSION,,SetResult,,,offset

;
; {(' '|'\t')} ','
;
State
Trans !NoBlanks

State
Trans ','

;
; {(' '|'\t')} EXPRESSION
;
State
Trans !NoBlanks

State
Trans #EXPRESSION,,SetResult,,,size

;
; {(' '|'\t')} ']'
;
State
Trans !NoBlanks

State
Trans ']'

;
; {(' '|'\t')} (':' <assstr>|'=' <assign>)
;
State
Trans !NoBlanks

State
Trans ':',assstr,,STRING,flags
Trans '='

;
; ['='] <string>
;
State assign
Trans '=',,,GLOBAL,flags
Trans p$Lambda

;
; {(' '|'\t')} EXPRESSION
;
State
Trans !NoBlanks

State
Trans #EXPRESSION,,SetResult,,,rightside

;
; <EndLine>
;
State
Trans !EndLine,p$Exit,dcl$assign_symbol

;
; {(' '|'\t')} ('!' {<any>}|<EOS>)
;
State EndLine
Trans !NoBlanks

State
Trans '!',p$Exit
Trans p$Eos,p$Exit

;
; '='
;
State assstr
Trans '='

;
; ['=']
;
State
Trans '=',,,GLOBAL,flags
Trans p$Lambda

State
Trans !string,p$Exit,dcl$assign_symbol

;
; {(' '|'\t')} <string>
;
State defstring
Trans !EndLine,p$Fail
Trans !NoBlanks,built,SetStart

State string
Trans !NoBlanks,,SetStart

State built
Trans !noend
Trans p$Lambda,p$Exit,SetEnd

State
Trans '"',quoted
Trans !goon
Trans p$Lambda,p$Exit,SetEndCheck
Trans p$Any,built

State
Trans p$Any,built

State quoted
Trans '"',built
Trans p$Eos,p$Exit,SetEnd
Trans p$Any,quoted

State noend
Trans !EndLine,p$Fail
Trans p$Lambda,p$Exit

State goon
Trans p$Blank,p$Fail
Trans p$Lambda,p$Exit

;
; {(' '|'\t')} FILE
;
State callfile
Trans !NoBlanks,,,COMMAND,flags

State
Trans #FILE,,SetResult,,,filename

;
; {(' '|'\t')} <string>
;
State
Trans !NoBlanks

State
Trans !defstring,,SetString,,,p1
Trans p$Lambda,docall

;
; {(' '|'\t')} <string>
;
State
Trans !NoBlanks

State
Trans !defstring,,SetString,,,p2
Trans p$Lambda,docall

;
; {(' '|'\t')} <string>
;
State
Trans !NoBlanks

State
Trans !defstring,,SetString,,,p3
Trans p$Lambda,docall

;
; {(' '|'\t')} <string>
;
State
Trans !NoBlanks

State
Trans !defstring,,SetString,,,p4
Trans p$Lambda,docall

;
; {(' '|'\t')} <string>
;
State
Trans !NoBlanks

State
Trans !defstring,,SetString,,,p5
Trans p$Lambda,docall

;
; {(' '|'\t')} <string>
;
State
Trans !NoBlanks

State
Trans !defstring,,SetString,,,p6
Trans p$Lambda,docall

;
; {(' '|'\t')} <string>
;
State
Trans !NoBlanks

State
Trans !defstring,,SetString,,,p7
Trans p$Lambda,docall

;
; {(' '|'\t')} <string>
;
State
Trans !NoBlanks

State
Trans !defstring,,SetString,,,p8
Trans p$Lambda

;
; <EndLine>
;
State docall
Trans !EndLine,p$Exit,dcl$start_file,,,1

;
; {(' '|'\t')}
;
State NoBlanks
Trans p$Blank,p$Exit
Trans p$Lambda,p$Exit

;
inline

/*
  Ergebnistext einer Expressionauswertung uebernehmen. 'mod' kann auch von dem
  Modul FILE kommen. Wie fuer alle CLD Module ist pcb_tree ein wohldefiniertes 
  Element.
*/
static SetResult(pcb,res,mod)
PCB *pcb;
struct descriptor *res;
struct epcbEXPRESSION *mod;
{
 res->len = strlen(res->text = (char *)mod->pcb_tree);
 return parse_exit;
}

/*
  Zeichenkette uebernehmen.
*/
static SetString(pcb,res)
PCB *pcb;
struct descriptor *res;
{
 *res = pcb->pcb_rightside;
 pcb->pcb_rightside.text = 0;
 return parse_exit;
}

/*
  Zeile erneut bearbeiten.
*/
static CheckReset(pcb,cleanonly)
PCB *pcb;
long cleanonly;
{
 /* Aufraeumen */
 cleanCommand(pcb,0);
 if ( cleanonly ) return parse_exit;
 /* Geht es nochmal von vorne los ? */
 if ( !(pcb->pcb_flags&RESET) ) return parse_fail;
 /* Initialisieren */
 pcb->pcb_symbol.text = 0;
 pcb->pcb_symbol.len = 0;
 pcb->pcb_flags = (pcb->pcb_flags&AMPERDONE)|RESETDONE;
 return parse_exit;
}

/*
  Position merken.
*/
static SetStart(pcb)
PCB *pcb;
{
 pcb->pcb_sstart = (long)pcb->sys_pcb.pcb_line;
 return parse_exit;
}

/*
  Ende des Strings.
*/
static SetEnd(pcb)
PCB *pcb;
{
 extern char *createValue();
 char *start = (char *)pcb->pcb_sstart;
 int len = pcb->sys_pcb.pcb_line-start,mode;

 /* Operationsmode */
 mode = (pcb->pcb_flags&FOREIGN) ? 4 : 3;
 /* Umwandeln */
 if ( !(pcb->pcb_rightside.text = createValue(start,len,mode,0)) ) return CDU_NOMEM;
 pcb->pcb_rightside.len = strlen(pcb->pcb_rightside.text);
 /* Kein Fehler */
 return parse_exit;
}

/*
  Ende des Strings beim Parsen der Parameter eines Dateiaufrufs.
*/
static SetEndCheck(pcb)
PCB *pcb;
{
 return (pcb->pcb_flags&COMMAND) ? SetEnd(pcb) : parse_fail;
}

/*
  Anfang der Zeile vermerken.
*/
int isFIRSTsymbol = 0;

static MarkLine(pcb)
PCB *pcb;
{
 /* Zeile beginnt hier */
 isFIRSTsymbol = 1;
 /* Merken */
 pcb->pcb_start = (long)pcb->sys_pcb.pcb_line;
 return parse_exit;
}

/*
  Ampersand Symbole ersetzen.
*/
static Ampersand(pcb)
PCB *pcb;
{
 int len = strlen(pcb->sys_pcb.pcb_line),done = pcb->sys_pcb.pcb_line-(char *)pcb->pcb_start;
 char *dcl$replace_ampersand();

 /* Ist das schon mal gemacht worden ? */
 if ( pcb->pcb_flags&AMPERDONE ) return parse_exit;
 /* Aber jetzt */
 pcb->pcb_flags |= AMPERDONE;
 if ( !dcl$replace_ampersand(pcb->sys_pcb.pcb_line,&len,COMMAND_MAXLENGTH-done-1) )
  return parse_fail;
 /* Zeile abschliessen */
 pcb->sys_pcb.pcb_line[len] = '\0';
 return parse_exit;
}

/*
  Bit testen.
*/
static TestFlag(pcb,flag)
PCB *pcb;
int flag;
{
 return (pcb->pcb_flags&flag) ? parse_exit : parse_fail;
}
