#include <errno.h>
#include <stdio.h>

#include <sys/param.h>

#include <saphir/CLI.h>
#include <saphir/vmsdef.h>

/*
  cli
     -ss symbol_name symbol_value table	lib$set_symbol_
     -gs symbol_name			lib$get_symbol_
     -ds symbol_name table		lib$delete_symbol_
     -tv vms_name			translate_vms
     -td vms_name default_name		translate_vms_default
     -uv unix_name is_directory	        -> vms_name
     -mw item pattern			match_wildcard
     -hp uid privilege			has_privilege
     -cv name				cli$get_value_
     -cp name				cli$present_ 
     -ex code				sys$exit_
*/
typedef struct map
	{
	 char	*selector;
	 int	(*function)();
	 int	npar;
	 int	errout;
	} map;

static int set_symbol(),get_symbol(),delete_symbol();
static int to_unix(),to_unix_default(),to_vms();
static int get_value(),present();
static int authorize();
static int match();
static int sexit();

map list[] = 
    {
     { "-ss" ,set_symbol      ,3 ,SS$_BADPARAM },
     { "-gs" ,get_symbol      ,1 ,SS$_BADPARAM },
     { "-ds" ,delete_symbol   ,2 ,SS$_BADPARAM },
     { "-tv" ,to_unix 	      ,1 ,0            },
     { "-td" ,to_unix_default ,2 ,0            },
     { "-uv" ,to_vms	      ,2 ,0	       },
     { "-mw" ,match	      ,2 ,0            },
     { "-hp" ,authorize       ,2 ,0            },
     { "-cv" ,get_value	      ,1 ,CLI$_ABSENT  },
     { "-cp" ,present	      ,1 ,CLI$_ABSENT  },
     { "-ex" ,sexit	      ,1 ,0	       }
    };
#define NLIST		(sizeof(list)/sizeof(list[0]))

main(argc,argv)
int argc;
char **argv;
{
 int ix = 1,np,n;
 char *cur;

 while ( ix < argc )
  {
   cur = argv[ix++];
   for ( n = NLIST ; n-- && strcmp(cur,list[n].selector) ; );
   if ( n < 0 ) continue;
   if ( (np = argc-ix) < list[n].npar )
    printf("%d\n",list[n].errout);
   else
    {
     (*(list[n].function))(argv+ix);
     ix += list[n].npar;
    }
  }
}

static int set_symbol(argv)
char **argv;
{
 int tab;
 
 tab = atoi(argv[2]);
 printf("%d\n",lib$set_symbol_(argv[0],argv[1],&tab,strlen(argv[0]),strlen(argv[1])));
}

static int get_symbol(argv)
char **argv;
{
 static char value[1024];
 int vlen,res;

 res = lib$get_symbol_(argv[0],value,&vlen,(int *)0,strlen(argv[0]),sizeof(value)-1);
 if ( !(res&1) ) vlen = 0;
 value[vlen] = 0;
 printf("%d,%s\n",res,value);
}

static int delete_symbol(argv)
char **argv;
{
 int tab;
 
 tab = atoi(argv[1]);
 printf("%d\n",lib$delete_symbol_(argv[0],&tab,strlen(argv[0])));
}

static int to_unix(argv)
char **argv;
{
 char *res,*translate_vms();

 res = translate_vms(argv[0]);
 if ( res == (char *)-1 ) res = 0;
 printf("%d,%s\n",res != 0,res ? res : "");
}

static int to_unix_default(argv)
char **argv;
{
 char *res,*translate_vms_default();

 res = translate_vms_default(argv[0],argv[1]);
 if ( res == (char *)-1 ) res = 0;
 printf("%d,%s\n",res != 0,res ? res : "");
}

static int to_vms(argv)
char **argv;
{
 static char result[1024],real[MAXPATHLEN+1];
 char *lst,*uname = argv[0],*realpath(),*strstr();
 int rix,len,isdir = atoi(argv[1]);
  
 /* Umwandeln */
 if ( !realpath(uname,real) ) strcpy(real,uname);
 /* Ist ein Verzeichnis */
 if ( isdir && (!(len = strlen(real)) || (real[len-1] != '/')) ) strcat(real,"/");
 /* Absoluter Name */
 if ( *(uname = real) == '/' )
  {
   uname++;
   strcpy(result,"sys$sysroot:");
   rix = sizeof("sys$sysroot:")-1;
  } 
 else
  rix = 0;
 /* Aufraeumen fuer VAX/VMS UCX */
 while ( lst = strstr(uname,".dir") ) memmove(lst,lst+4,strlen(lst+4)+1);
 /* Name */
 if ( strchr(uname,'/') ) 
  {
   result[rix++] = '[';
   if ( rix == 1 ) result[rix++] = '.';
  }
 strcpy(result+rix,uname);
 /* Umwandeln */
 for ( uname = result+rix, lst = 0 ; *uname ; uname++ )
  if ( *uname == '/' )
   *(lst = uname) = '.';
 if ( lst ) *lst = ']';
 /* Fertig */
 printf("1,%s\n",result);
}

static int match(argv)
char **argv;
{ 
 printf("%d\n",match_wildcard(argv[0],argv[1]));
}

static int authorize(argv)
char **argv;
{
 printf("%d\n",has_privilege(atoi(argv[0]),argv[1]));
}

static int get_value(argv)
char **argv;
{ 
 static char value[1024];
 int res,vlen;

 res = cli$get_value_(argv[0],value,&vlen,strlen(argv[0]),sizeof(value)-1);
 if ( !(res&1) ) vlen = 0;
 value[vlen] = '\0';
 printf("%d,%s\n",res,value);
}

static int present(argv)
char **argv;
{
 printf("%d\n",cli$present_(argv[0],strlen(argv[0])));
}

static int sexit(argv)
char **argv;
{
 puts("1");
 sys$exit_(atoi(argv[0]));
}
