#include <grp.h>
#include <pwd.h>
#include <stdio.h>

#include <rpc/rpc.h>

#include <sys/socket.h>

#include <saphir/CLI.h>
#include <saphir/CLIdef.h>
#include <saphir/vmsdef.h>

#include <saphir/lnm/lnm.h>

extern char *malloc(),*strchr(),*strdup(),*strpbrk(),*translate_vms_default();
extern struct passwd *getpwuid();
extern struct group *getgrgid();

#define NOSTR                   ((char *)0)
#define NOFCT                   ((int (*))0)

#define PRESENT(n)              cli$present_(n,sizeof(n)-1)
#define VALUE(n,o,r)		cli$get_value_(n,o,r,sizeof(n)-1,sizeof(o)-1)

#define MAXNAMLEN		255
#define NTAB			4

struct TabInfo
       {
	char	name[MAXNAMLEN+1];
	char	dir[MAXNAMLEN+1];
	char	par[MAXNAMLEN+1];
	int	table;
	int	quota;
	int	free;
	int	acmode;
	int	prot;
	int     uid;
	int     gid;
	int	dup;
       };

struct TabInfo ttab0[] = 
       {
        { "LNM$PROCESS_DIRECTORY","LNM$PROCESS_DIRECTORY" },
        { "LNM$SYSTEM_DIRECTORY","LNM$SYSTEM_DIRECTORY" }
       };

int done[NTAB],ntab[NTAB],atab[NTAB];
struct TabInfo *ttab[NTAB];
CLIENT *LNM;

#define TOFF(n)			((n)*sizeof(struct TabInfo))
#define TAB(i,n)		(ttab[i][n])
#define TTAB(t,n)	       	((t)[n].name)

/*
  DCL SHOW
*/
main()
{
 static int cleanup();
 char option[256];
 int olen;

 /* Initialiserung */
 atexit(cleanup);
 /* Was ist zu tun */
 if ( !(VALUE("OPTION",option,&olen)&1) ) sys$exit_(SS$_BADPARAM);
 option[olen] = '\0';
 /* Gewuenschte Operation ausfuehren */
 if ( !strcmp(option,"LOGICAL") ) sys$exit_(SHOWlogical());
 /* Noch nicht implementierte Operation */
 sys$exit_(SS$_BADPARAM);
}

/*
  SHOW LOGICAL
	[/OUTPUT=file]
	[/SYSTEM]
	[/GROUP]
	[/PROCESS]
	[/JOB]
	[/ALL]
	[/TABLE=tables]
	[/DESCENDANTS]
	[/STRUCTURE]
	[/ACCESS_MODE=acmode]
	[/FULL]
	p1
	[p2]
*/
SHOWlogical()
{
 int acmode = PSL$C_USER,res,len,got = 0,full = 0,wild = 0,ln,i,j,fst,desc = 0;
 char name[256],*nptr = name;
 FILE *outf = 0;
 dumplnt_t dump;
 trnlnm_t trn;
 logname *lnm;
 table *lnt;

 /* Globale Verwaltungsvariablen initialisieren */
 memset(done,0,sizeof(done));
 memset(ntab,0,sizeof(ntab));
 /* Ausgabedatei oeffnen */
 if ( (res = PRESENT("OUTPUT")) == CLI$_NEGATED )
  strcpy(name,"/dev/null");
 else if ( (res == CLI$_PRESENT) && (VALUE("OUTPUT",name,&len)&1) )
  {
   /* Name ins UNIX-Format umwandeln */
   name[len] = '\0';
   switch ((int)(nptr = translate_vms_default(name,".lis")))
    {
     case -1 : return SS$_BADFILENAME;
     case  0 : return SS$_ACCVIO;
    }
  }
 else 
  outf = stdout;
 if ( !outf && !(outf = fopen(nptr,"w")) ) return SS$_NOSUCHFILE;
 /* Parameter ermitteln */
 if ( PRESENT("DESCENDANTS")&1 ) desc = 1;
 if ( PRESENT("FULL")&1 ) full = 1;
 /* Zugriffsmode ermitteln */
 if ( PRESENT("SUPERVISOR_MODE")&1 )
  acmode = PSL$C_SUPER;
 else if ( PRESENT("EXECUTIVE_MODE")&1 )
  acmode = PSL$C_EXEC;
 else if ( PRESENT("KERNEL_MODE")&1 )
  acmode = PSL$C_KERNEL;
 /* Strukturanalyse der Tabellen logischer Namen */
 if ( PRESENT("STRUCTURE")&1 )
  {
   /* Strukturen komplett einlesen */
   fillAll(1);
   /* Alle Directories ausgeben */
   for ( i = 0 ; i < ntab[0] ; i++ ) viewStructure(outf,TTAB(ttab[0],i),full,0);
   /* Alles in Ordnung */
   fclose(outf);
   return ntab[0] ? SS$_NORMAL : SS$_IVLOGTAB;
  }
 /* Tabellen ermitteln */
 if ( PRESENT("PROCESS")&1 ) addTable("LNM$PROCESS",desc);
 if ( PRESENT("JOB")&1 ) addTable("LNM$JOB",desc);
 if ( PRESENT("GROUP")&1 ) addTable("LNM$GROUP",desc);
 if ( PRESENT("SYSTEM")&1 ) addTable("LNM$SYSTEM",desc);
 do
  {
   /* Naechste Tabelle einlesen */
   res = VALUE("TABLE",name,&len);
   if ( (res != CLI$_COMMA) && (res != CLI$_NORMAL) ) break;
   /* Tabelle eintragen */
   got = 1;
   addTables(name,len,desc);
  }
 while ( res != CLI$_NORMAL );
 /* Defaulttabelle angeben */
 if ( !got && !ntab[2] ) addTable("LNM$DCL_LOGICAL",desc);
 /* Mindestens eine Tabelle erforderlich */
 if ( !ntab[2] ) return SS$_IVLOGTAB;
 /* Logische Namen einlesen */
 if ( PRESENT("ALL")&1 )
  got = 0;
 else
  {
   /* Logische Namen einlesen */
   got = wild = 0;
   do
    {
     /* Naechsten Namen einlesen */
     res = VALUE("LOGNAME",name,&len);
     if ( (res != CLI$_COMMA) && (res != CLI$_CONCAT) && (res != CLI$_NORMAL) ) break;
     /* Logischen Namen vermerken */
     got = 1;
     if ( len && (name[len-1] == ':') ) len--;
     name[len] = '\0';
     addName(name,3,1);
     /* Wildcards vermerken */
     if ( strpbrk(name,"*%") ) wild = 1;
    }
   while ( res != CLI$_NORMAL );
  }
 /* Default einsetzen */
 if ( !got )
  {
   /* Wildcard */
   wild = 1;
   addName("*",3,1);
  }
 /* Normale Umsetzung */
 if ( !wild )
  /* Logische Namen in allen Tabellen suchen und anzeigen */
  for ( ln = got = 0 ; ln < ntab[3] ; )
   {
    for ( i = 0 ; i < ntab[2] ; i++ )
     {
      /* Suchstruktur aufsetzen */
      trn.name = TTAB(ttab[3],ln);
      trn.parent = TTAB(ttab[2],i);
      trn.pid = getpid();
      trn.acmode = acmode;
      trn.flags = 0;
      /* LNM kontaktieren */
      if ( lnm = (logname *)execLNM(trnlnm_1,&trn) )
       if ( lnm->acmode < 0 )
	clnt_freeres(LNM,xdr_logname,lnm);
       else
        {
         /* Ergebnis auswerten */
         got = 1;
         viewName(outf,lnm,full,0,1);
        }
     }
   /* Leerzeile zwischen den logischen Namen */
   if ( ++ln < ntab[3] ) fprintf(outf,"\n");
  }
 else
  {
   /* Alle Tabellen durchgehen */
   for ( i = 0 ; i < ntab[2] ; i++ )
    if ( TAB(2,i).table == TRUE )
     {
      /* Tabelle anzeigen */
      viewTable(outf,&TAB(2,i),full,0,1);
      fst = 0;
      /* Zugehoerige logische Namen ermitteln und anzeigen */
      dump.name = TTAB(ttab[2],i);
      dump.parent = TAB(2,i).dir;
      dump.pid = getpid();
      if ( !(lnt = (table *)execLNM(dumplnt_1,&dump)) ) continue;
      if ( lnt->nalloc >= 0 )
       /* Alle logischen Namen durchgehen */
       for ( ln = 0, lnm = lnt->names.names_val ; ln < lnt->names.names_len ; ln++, lnm++ )
        {
	 /* Vergleich mit den Wildcardmasken */
	 for ( j = ntab[3] ; j-- && !match_wildcard(lnm->name,TTAB(ttab[3],j)) ; );
	 /* Logischer Name passt ? */
	 if ( j < 0 ) continue;
	 if ( !fst ) fprintf(outf,"\n");
	 viewName(outf,lnm,full,0,0);
	 fst = got = 1;
        }
      /* Speicher freigeben */
      clnt_freeres(LNM,xdr_table,lnt);
     }
  }
 /* Fertig */
 fclose(outf);
 return got ? SS$_NORMAL : SS$_NOLOGNAM;
}

/*
  Tabellennamen umsetzen und alle passenden Tabellen suchen.
*/
addTables(name,len,desc)
char *name;
int len,desc;
{
 int i;

 /* Name abschliessen */
 name[len] = '\0';
 /* Name umsetzen */
 if ( !strpbrk(name,"%*") )
  /* Normale Tabelle eintragen */
  addTable(name,desc);
 else
  {
   /* Und alle Tabellen suchen */
   fillAll(desc);
   /* Alle Namen durchsuchen */
   for ( i = 0 ; i < ntab[1] ; i++ )
    if ( !TAB(1,i).dup && match_wildcard(TTAB(ttab[1],i),name) )
     translateTable(TTAB(ttab[1],i),2,desc);
  }
}

/*
  Alle Tabellen ermitteln.
*/
fillAll(ext)
int ext;
{
 struct TabInfo *tab;
 table *lnt,*tbl,tmp;
 struct TabInfo *ti;
 dumplnt_t dump,req;
 logname *lnm;
 int i,j,nt;

 /* Maximal einmal */
 if ( done[1] ) return;
 done[1] = 1;
 /* Defaultdirectories ermitteln */
 translateTable("LNM$DIRECTORIES",0,0);
 /* Alle Defaultdirectories nach Tabellen durchsuchen */
 if ( nt = ntab[0] )
  tab = ttab[0];
 else
  {
   tab = ttab0;
   nt = sizeof(ttab0)/sizeof(ttab0[0]);
  }
 for ( i = 0 ; i < nt ; i++ )
  {
   /* Eine Directory auslesen */
   dump.name = TTAB(tab,i);
   dump.parent = tab[i].dir;
   dump.pid = getpid();
   if ( !(lnt = (table *)execLNM(dumplnt_1,&dump)) ) continue;
   /* Daten sichern */
   tmp = *lnt;
   /* Ergebnis auswerten */
   if ( tmp.nalloc >= 0 )
    for ( j = 0, lnm = tmp.names.names_val ; j < tmp.names.names_len ; j++, lnm++ )
     /* Erweiterte Informationen einlesen */
     if ( addInfo(lnm,1) && ext && (lnm->info.table == TRUE) ) 
      {
       /* Struktur aufsetzen */
       req.name = lnm->name;
       req.parent = lnm->parent;
       req.pid = getpid();
       /* Tabelle suchen */
       if ( !(tbl = (table *)execLNM(dumplnt_1,&req)) ) continue;
       if ( tbl->nalloc >= 0 )
	{
         /* Informationen uebertragen */
	 ti = &TAB(1,ntab[1]-1);
         strcpy(ti->par,tbl->parent);
	 ti->quota = tbl->quota;
         ti->free = tbl->free;
	 ti->prot = tbl->protection;
	 ti->uid = tbl->uid;
	 ti->gid = tbl->gid;
        }
       /* Speicher freigeben */
       clnt_freeres(LNM,xdr_table,tbl);
      }
   /* Speicher freigeben */
   clnt_freeres(LNM,xdr_table,&tmp);  
  }
}

/* 
  Tabellenname umsetzen und in die Liste aller Tabellen anhaengen.
*/
addTable(name,desc)
char *name;
int desc;
{
 /* Suchliste ermitteln */
 translateTable("LNM$DIRECTORIES",0,0);
 /* Tabellenname uebertragen */
 translateTable(name,2,desc);
}

/* 
  Name einer Tabelle uebersetzen.
*/
translateTable(name,ix,desc)
char *name;
int ix,desc;
{
 struct TabInfo *tab;
 int n;

 /* Haben wir das schon mal gemacht */
 if ( done[ix] ) return;
 if ( ix != 2 ) done[ix] = 1;
 /* Tabelle der Directories ermitteln */
 if ( n = ntab[0] ) 
  tab = ttab[0];
 else
  {
   tab = ttab0;
   n = sizeof(ttab0)/sizeof(ttab0[0]);
  }
 /* Rekursive Schleife zum Uebersetzen des Namens */
 translateOne(name,tab,n,ix,10,desc);
}

/*
  Uebersetzung eines Namens einer Tabelle.
*/
translateOne(name,tab,n,ix,lev,desc)
char *name;
struct TabInfo *tab;
int n,ix,desc;
{
 int t,tlev,run,vlen,i;
 logname *lnm,tmp;
 trnlnm_t trn;
 equiv_t *val;

 /* Alle Tabellen durchgehen */
 for ( t = 0, run = 1 ; run && (t < n) ; t++ )
  {
   /* Logischen Namen suchen */
   trn.name = name;
   trn.parent = TTAB(tab,t);
   trn.pid = getpid();
   trn.acmode = PSL$C_USER;
   trn.flags = 0;
   /* LNM kontaktieren */
   if ( !(lnm = (logname *)execLNM(trnlnm_1,&trn)) ) continue;
   tmp = *lnm;
   /* Ergebnis bearbeiten */
   vlen = 0;
   if ( tmp.acmode >= 0 )
    if ( tmp.info.table == TRUE )
     {
      /* Schleife beenden */
      run = 0;
      /* Name eintragen */
      addInfo(&tmp,ix);
      /* Eventuell Kindtabellen eintragen */
      if ( desc )
       {
	/* Alle Tabellen einlesen */
	fillAll(1);
	/* Kinder dieser Tabelle suchen und eintragen */
	addChilds(tmp.name,ix);
       }
     }
    else if ( lev )
     {
      /* Nach der Rekursion aufhoeren */
      run = 0;
      /* Weitersuchen vorbereiten */
      vlen = tmp.info.loginfo_u.wert.wert_len;
      val = tmp.info.loginfo_u.wert.wert_val;
     }
   /* Rekursiv weitersuchen */
   for ( ; vlen-- ; val++ )
    { 
     tlev = (val->flags&LNM$M_TERMINAL) ? 0 : (lev-1);
     translateOne(val->name,tab,n,ix,tlev,desc);
    }
   /* Speicher freigeben */
   clnt_freeres(LNM,xdr_logname,&tmp);
  }
}

/*
  Alle Kindtabellen einer Tabelle in eine Liste eintragen.
*/
addChilds(name,tix)
char *name;
int tix;
{
 int i;

 /* Alle Tabellen durchsuchen */
 for ( i = 0 ; i < ntab[1] ; i++ )
  if ( (TAB(1,i).table == TRUE) && !strcmp(TAB(1,i).par,name) )
   if ( addName(TTAB(ttab[1],i),tix,1) )
    {
     /* Eintrag vervollstaendigen */
     TAB(tix,ntab[tix]-1) = TAB(1,i);
     /* Dessen Kindtabellen beruecksichtigen */
     addChilds(TTAB(ttab[1],i),tix);
    }
}

/*
  Name einer Tabelle logischer Namen in eine Liste eintragen. Dabei wird darauf geachtet,
  keinen Namen doppelt einzutragen.
*/
addName(name,tix,chk)
char *name;
int tix,chk;
{
 struct TabInfo *nt;
 int i,res = 1;

 /* Kontrollabfrage */
 if ( strlen(name) > MAXNAMLEN ) return 0;
 /* Name suchen */
 for ( i = ntab[tix] ; i-- ; )
  if ( !strcmp(TTAB(ttab[tix],i),name) )
   {
    /* Darf nicht doppelt sein */
    if ( chk ) return 0;
    /* Doppelter Name */
    res = 2;
    break;
   }
 /* Speicher zur Verfuegung stellen */
 if ( ntab[tix] == atab[tix] )
  {
   if ( !(nt = (struct TabInfo *)malloc(TOFF(atab[tix]+10))) ) return 0;
   if ( atab[tix] )
    {
     memcpy((char *)nt,(char *)ttab[tix],TOFF(atab[tix]));
     free(ttab[tix]);
    }
   ttab[tix] = nt;
   atab[tix] += 10;
  }
 /* Tabelle eintragen */
 strcpy(TTAB(ttab[tix],ntab[tix]++),name);
 /* Name eingetragen */
 return res;
}

/*
  Informationen einer Tabelle logischer Namen in eine Liste eintragen. In die Liste
  mit dem Index 1 - gefuellt von 'fillAll' - koennen Namen doppelt eingetragen werden.
  Sie sind besonders vermerkt.
*/
addInfo(lnm,tix)
logname *lnm;
int tix;
{
 struct TabInfo *ti;
 int dup;

 /* Name eintragen */
 if ( !(dup = addName(lnm->name,tix,tix != 1)) ) return 0;
 /* Rest eintragen */
 ti = &TAB(tix,ntab[tix]-1);
 strcpy(ti->dir,lnm->parent);
 strcpy(ti->par,"");
 if ( (ti->table = lnm->info.table) == TRUE ) ti->free = -2;
 ti->acmode = lnm->acmode;
 ti->dup = dup-1;
 /* Alles eingetragen */
 return 1;
}

/*
  Zeige eine logische Tabelle.
*/
viewTable(f,ti,full,off,norm)
FILE *f;
struct TabInfo *ti;
int full,off,norm;
{
 struct passwd *pw;
 struct group *gp;
 dumplnt_t dump;
 table *lnt;
 int spc;

 /* Eventuell Informationen vervollstaendigen */
 if ( full && (ti->free == -2) )
  {
   /* Struktur aufsetzen */
   dump.name = ti->name;
   dump.parent = ti->dir;
   dump.pid = getpid();
   /* Auslesen */
   if ( lnt = (table *)execLNM(dumplnt_1,&dump) )
    {
     /* Information auslesen */
     if ( lnt->nalloc >= 0 )
      {
       ti->quota = lnt->quota;
       ti->free = lnt->free;
       ti->prot = lnt->protection;
       ti->uid = lnt->uid;
       ti->gid = lnt->gid;
      }
     /* Speicher freigeben */
     clnt_freeres(LNM,xdr_table,lnt);
    }
  }
 /* Tabellenname ausgeben */
 if ( norm ) fprintf(f,"\n");
 for ( spc = off ; spc-- ; fprintf(f," ") );
 fprintf(f,"(%s)",ti->name);
 /* Volle Information ausgeben, falls noetig */
 if ( full && (ti->free != -2) )
  {
   /* Zugriffsmode */
   fprintf(f,"\t");
   switch (ti->acmode)
    {
     case PSL$C_USER   : fprintf(f,"[user]");
       			 break;
     case PSL$C_SUPER  : fprintf(f,"[super]");
       			 break;
     case PSL$C_EXEC   : fprintf(f,"[exec]");
       			 break;
     case PSL$C_KERNEL : fprintf(f,"[kernel]");
    }
   /* Quoten */
   if ( (ti->quota >= 0) && (ti->free >= 0) ) 
    fprintf(f,"  [Quota=(%d,%d)]",ti->free,ti->quota);
   /* Naechste Zeile */
   fprintf(f,"\n");
   for ( spc = (off+2+strlen(ti->name)+8)/8 ; spc-- ; fprintf(f,"\t") );
   /* Schutzcodes */
   if ( ti->prot == -1 )
    fprintf(f,"[no protection information]");
   else
    {
     fprintf(f,"[Protection=(");
     viewProtection(f,ti->prot,PROSYSTEM(1),",");
     viewProtection(f,ti->prot,PROOWNER(1),",");
     viewProtection(f,ti->prot,PROGROUP(1),",");
     viewProtection(f,ti->prot,PROWORLD(1),")]");
    }
   /* Benutzerkennung */
   if ( pw = getpwuid(ti->uid) )
    {
     fprintf(f,"  [Owner=[");
     if ( (pw->pw_gid != ti->gid) && (gp = getgrgid(ti->gid)) ) fprintf(f,"%s,",gp->gr_name);
     fprintf(f,"%s]]",pw->pw_name);
    }
  }
 /* Fertig */
 fprintf(f,"\n"); 
}

/*
  Schutzcode anzeigen.
*/
viewProtection(f,prot,base,end)
FILE *f;
int prot,base;
char *end;
{
 if ( prot&(PRORD*base) ) fprintf(f,"R");
 if ( prot&(PROWR*base) ) fprintf(f,"W");
 if ( prot&(PRODE*base) ) fprintf(f,"D");
 fprintf(f,end);
}

/*
  Zeige einen logischen Namen an.
*/
viewName(f,ilnm,full,lev,ext)
FILE *f;
logname *ilnm;
int full,lev,ext;
{
 logname lnm,*tlnm;
 trnlnm_t trn;
 int i,j,len;

 /* Logischen Namen lokal speichern */
 lnm = *ilnm;
 /* Level ausgeben */
 if ( !lev )
  fprintf(f," ");
 else if ( lnm.info.table == TRUE )
  {
   /* Tabelle gefunden */
   clnt_freeres(LNM,xdr_logname,&lnm);
   return;
  }
 else
  fprintf(f,"%1d",lev);
 /* Name ausgeben */
 fprintf(f,"  \"%s\"",lnm.name);
 /* Optionen anzeigen */
 if ( full )
  {
   fprintf(f," [");
   switch (lnm.acmode)
    {
     case PSL$C_USER   : fprintf(f,"user");
       			 break;
     case PSL$C_SUPER  : fprintf(f,"super");
       			 break;
     case PSL$C_EXEC   : fprintf(f,"exec");
       			 break;
     case PSL$C_KERNEL : fprintf(f,"kernel");
    }
   if ( lnm.flags&LNM$M_NO_ALIAS ) fprintf(f,",no_alias");
   if ( lnm.flags&LNM$M_CONFINE ) fprintf(f,",confine");
   if ( lnm.flags&LNM$M_NO_DELETE ) fprintf(f,",nodelete");
   if ( lnm.info.table == TRUE ) fprintf(f,",table");
   fprintf(f,"]");
  }
 else if ( lnm.info.table == TRUE )
  fprintf(f," [table]");
 /* Ersten Wert und Vatertabelle ausgeben */
 if ( (lnm.info.table == TRUE) || !lnm.info.loginfo_u.wert.wert_len )
  if ( ext )
   fprintf(f,"= \"\" (%s)\n",lnm.parent);
  else
   fprintf(f," = \"\"\n");
 else
  {
   for ( i = 0 ; i < lnm.info.loginfo_u.wert.wert_len ; i++ )
    {
     /* Wert ausgeben */
     if ( i ) fprintf(f,"\t");
     viewValue(f,lnm.info.loginfo_u.wert.wert_val+i,full);
     /* Vatertabelle anzeigen */
     if ( !i && ext ) fprintf(f," (%s)",lnm.parent);
     fprintf(f,"\n");
    }
   /* Alle Werte rekursiv ausgeben */
   if ( ext && (++lev < 10) )
    for ( i = 0 ; i < lnm.info.loginfo_u.wert.wert_len ; i++ )
     if ( !(lnm.info.loginfo_u.wert.wert_val[i].flags&LNM$M_TERMINAL) )
      {
       /* Name suchen und anzeigen */
       len = strlen(trn.name = lnm.info.loginfo_u.wert.wert_val[i].name);
       trn.pid = getpid();
       trn.acmode = PSL$C_USER;
       trn.flags = 0;
       /* Kontrolltests */
       if ( trn.name[0] == '_' ) continue;
       /* Name in allen Directories suchen */
       for ( j = 0, tlnm = 0 ; j < ntab[2] ; j++ )
	{
	 /* Vatertabelle einsetzen */
	 trn.parent = TTAB(ttab[2],j);
	 /* Logischen Namen suchen */
         if ( tlnm = (logname *)execLNM(trnlnm_1,&trn) )
	  {
	   if ( tlnm->acmode >= 0 ) break;
	   /* Speicher freigeben */
	   clnt_freeres(LNM,xdr_logname,tlnm);
	   tlnm = 0;
	  }
	 /* Eventuell Trennzeichen am Ende eleminieren */
	 if ( !len || (trn.name[len-1] != ':') ) continue;
	 trn.name[len-1] = '\0';
	 /* Veraenderten Namen suchen */
	 tlnm = (logname *)execLNM(trnlnm_1,&trn);
	 trn.name[len-1] = ':';
	 if ( tlnm )
	  {
	   if ( tlnm->acmode >= 0 ) break;
	   /* Speicher freigeben */
	   clnt_freeres(LNM,xdr_logname,tlnm);
	   tlnm = 0;
	  }
	}
       /* Und ausgeben, falls gefunden */
       if ( tlnm ) viewName(f,tlnm,full,lev,ext);
      }
  }
 /* Speicher freigeben */
 if ( lev || ext ) clnt_freeres(LNM,xdr_logname,&lnm);
}

/*
  Wert eines logischen Namens anzeigen.
*/
viewValue(f,val,full)
FILE *f;
equiv_t *val;
int full;
{
 int term = val->flags&LNM$M_TERMINAL,conc = val->flags&LNM$M_CONCEALED;

 /* Text ausgeben */
 fprintf(f," = \"%s\"",val->name);
 /* Optionen ausgeben */
 if ( !full || (!term && !conc) ) return;
 fprintf(f," [");
 if ( term ) fprintf(f,"terminal");
 if ( term && conc ) fprintf(f,",");
 if ( conc ) fprintf(f,"concealed");
 fprintf(f,"]"); 
}

/*
  Tabelle und alle darin erzeugten Kindtabellen anzeigen.
*/
viewStructure(f,name,full,off)
FILE *f;
char *name;
int full,off;
{
 int i,j;

 /* Tabelle suchen */
 for ( i = 0 ; i < ntab[1] ; i++ )
  if ( (TAB(1,i).table == TRUE) && !strcmp(TTAB(ttab[1],i),name) )
   break;
 if ( i == ntab[1] ) return;
 /* Tabelle anzeigen */
 viewTable(f,&TAB(1,i),full,off,0);
 /* Kindtabellen anzeigen */
 for ( off += 4, j = 0 ; j < ntab[1] ; j++ )
  if ( (i != j) && (TAB(1,j).table == TRUE) && !strcmp(TTAB(ttab[1],i),TAB(1,j).par) )
   viewStructure(f,TTAB(ttab[1],j),full,off);
}

/*
  Logical Name Manager ansprechen.
*/
execLNM(func,para)
int (*func)();
char *para;
{
 int retries,res,sockp;
 struct sockaddr_in me;

 /* Mehrmals versuchen */
 for ( retries = 2 ; retries-- ; )
  {
   /* Verbindung herstellen, falls noetig */
   if ( !LNM )
    {
     /* Initialisieren */
     sockp = RPC_ANYSOCK;
     me.sin_family = AF_INET;
     me.sin_addr.s_addr = htonl(INADDR_ANY);
     me.sin_port = htons(0);
     /* Probieren */
     if ( !(LNM = clnttcp_create(&me,LNMPROG,LNMVERS,&sockp,500,1000)) ) continue;
    } 
   auth_destroy(LNM->cl_auth);
   LNM->cl_auth = authunix_create_default();
   /* Ausfuehren, falls moeglich */
   if ( res = (*func)(para,LNM) ) return res;
   /* Fehler bearbeiten */
   clnt_destroy(LNM);
   LNM = 0;
  }
 /* Fehler melden */
 return 0;
}

/*
  Aufraeumen.
*/
static cleanup()
{
 /* Verbindung zum LNM */
 if ( LNM )
  {
   clnt_destroy(LNM);
   LNM = 0;
  }
}
