#!/usr/bin/csh

#
# Befehl mit Abfrage auf Fehler ausfuehren
#
alias check  '\!* ; if ( $status != 0 ) exit $status'
alias action 'echo "+++" \!*'
alias error  'echo "***" \!*'

#
# Umgebung
#
set nonomatch
set path = (. $path)

#
# Defaults setzen
#
if ( ! $?BINDIR ) then
  set BINDIR = /usr/bin
endif
if ( ! $?LIBDIR ) then
  set LIBDIR = /usr/lib
endif
if ( ! $?INCDIR ) then
  set INCDIR = /usr/include
endif

if ( ($#argv >= 1) && ("$1" != "") ) then
  set DIRDEF = "$1"
else if ( ! $?DIRDEF ) then
  set DIRDEF = saphir
endif
if ( ($#argv >= 2) && ("$2" != "") ) then
  set DCLDIR = "$2"
else if ( ! $?DCLDIR ) then
  set DCLDIR = /usr/dcl
endif
  
#
# DCL.csh [(DIRDEF | "") [DCLDIR]]
#
# DIRDEF ist der Projektname. Er darf nur Buchstaben, Zahlen und _
# enthalten
#
if ( "$DIRDEF" == "" ) then
  error no project name given 
#
# Kurze Erklaerung
#
USAGE:
  cat << EOF
*** 
*** 
***  USAGE: $0 [(DIRDEF | "") [DCLDIR]]
*** 
***    DIRDEF  is the name of the project (saphir)
***    DCLDIR  is the root of all DCL files (/usr/dcl)
*** 
*** 
EOF
  exit 1
endif
echo "$DIRDEF" | grep > /dev/null '[^A-Za-z0-9_]'
if ( $status == 0 ) then
  error project name '"'"$DIRDEF"'"' must be built from A-Za-z0-9_
  goto USAGE
endif

#
# Informationen anzeigen
#
set OBJLIB = "$LIBDIR"/lib"$DIRDEF".a
set DCLLIB = "$LIBDIR"/libDCL.a
cat << EOF
+++
+++  directory for executables      =   $BINDIR
+++  directory for includes         =   $INCDIR
+++  directory for libraries        =   $LIBDIR
+++
+++  project object library         =   $OBJLIB
+++  DCL support directory          =   $DCLDIR
+++  DCL object library             =   $DCLLIB
+++
EOF

#
# Systemdirectories suchen
#
if ( ! -d "$BINDIR" ) then
  error directory "$BINDIR" for executable does not exist
  exit 1
endif
if ( ! -d "$INCDIR" ) then
  error directory "$INCDIR" for includes does not exist
  exit 1
endif
if ( ! -d "$LIBDIR" ) then
  error directory "$LIBDIR" for libraries does not exist
  exit 1
endif

#
# Systemdirectories erzeugen
#
if ( ! -d "$DCLDIR" ) then
  action creating "$DCLDIR"
  check mkdir "$DCLDIR"
endif
foreach dir (com exe hlp init lib src bin)
  if ( ! -d "$DCLDIR"/"$dir" ) then
    action creating "$DCLDIR"/"$dir"
    check mkdir "$DCLDIR"/"$dir"
  endif
end
action copying prototype files
check cp init/*.proto "$DCLDIR"/init

#
# Aufrauemen
#
set EXECS=`ls | sed -n 's/^\([A-Z][A-Z]*\)\.c$/\1/p'`
set CLEAN="*.o dcl cli command.[ch] $EXECS"
set LOBJS="dcl_*.o command.o"
action cleaning up
rm -f $CLEAN

#
# Dateien erzeugen
#
action creating objects
check make dcl cli OBJLIB="$OBJLIB"

#
# Library aufbauen
#
action copying objects
check ar rv "$DCLLIB" $LOBJS

#
# Executables kopieren
#
action copying shells
check cp dcl "$BINDIR"/dcl
(cd "$BINDIR" ; check ln -s dcl DCL)
action copying utilities
check cp cli "$BINDIR"/cli

#
# Befehle erzeugen
#
action creating commands
check make $EXECS OBJLIB="$OBJLIB"
action copying commands
foreach exe ($EXECS)
  set low = `echo "$exe" | tr '[A-Z]' '[a-z]'`
  check cp "$exe" "$DCLDIR"/exe/"$low".exe
end
check cp *.exe "$DCLDIR"/exe

#
# Aufraeumen
#
action cleaning up
rm -f $CLEAN

#
# Fertig
#
action digital command language installation complete

