;
; Parsertabelle fr CDU
;
Version 1.0
;
Include <saphir/parser.h>
;
Character Sets
	Legal		= 1..255
	SymbolStart	= 'A'..'Z','a'..'z','$'
	SymbolChars	= 'A'..'Z','a'..'z','$','0'..'9','_'
	StringStart	= 'A'..'Z','a'..'z','0'..'9'
	StringChars	= 'A'..'Z','a'..'z','0'..'9'
	FileChars	= 1..255
;
Flags	    = 
Abbrevation = unique
;
Definitions
Clear
	long	tree		; MUSS als erstes stehen
	long	current
	long	image
	long	parameter
	long	qualifier
	long	disallows
	long	parcount
	long	CLI
	long    discarded
	long	valtab
	
	CDU_ILLPAR	=	100
	CDU_ILLQUAL	=	101
	CDU_ILLKEY	=	102
	CDU_ILLVAL	=	103
	CDU_NOPAR	=	104
	CDU_NOQUAL	=	105
	CDU_NOVAL	=	106
	CDU_NOSEP	=	107
	CDU_NOMEM	=	108
	CDU_GARB	=	109
	CDU_NOTIMP	=	110
	CDU_ILLNUM	=	111
	CDU_ILLPOS	=	112
	
	CDU_DEF		=	$01
	CDU_NEG		=	$02
	CDU_BAT		=	$03
	CDU_END		=	$04
	CDU_COPY	=	$05
	CDU_ALL		=	$0f

	CDU_LOCAL	=	$20
	CDU_GLOBAL	=	$30
	CDU_POS		=	$30

	CDU_START	=	0
	CDU_NOSTART	=	1

	DISABLE		=	$ffff

;
Rules
State

State	ReferenceActions
Trans	p$Lambda,,AddSeparator
Trans	p$Lambda,,AddValue
Trans	p$Lambda,,DefaultKeyword
Trans	p$Lambda,,DefaultParameter
Trans	p$Lambda,,DefaultQualifier
Trans	p$Lambda,,EndValue
Trans	p$Lambda,,Initialize
Trans	p$Lambda,,SetError
Trans	p$Lambda,,StartValue
Trans	p$Lambda,,SwitchParameter
Trans	p$Lambda,,SwitchQualifier
Trans	p$Lambda,,SwitchSyntax

State	ReferenceModules
Trans	#ACL,p$Exit
Trans	#DATETIME,p$Exit
Trans	#DEFAULT,p$Exit
Trans	#DELTATIME,p$Exit
Trans	#DEVICE,p$Exit
Trans	#DIRECTORY,p$Exit
Trans	#EXPRESSION,p$Exit
Trans	#FILE,p$Exit
Trans	#LOGICAL,p$Exit
Trans	#NODE,p$Exit
Trans	#NUMBER,p$Exit
Trans	#PROCESS,p$Exit
Trans	#QUOTED_STRING,p$Exit
Trans	#REST_OF_LINE,p$Exit
Trans	#SYMBOL,p$Exit
Trans	#UIC,p$Exit

;
Inline
 
#include <saphir/CLIdef.h>

#define value		val.text
#define list		val.next

#define base		((unsigned short *)pcb->sys_pcb.pcb_table2)
#define valtab		((unsigned short *)pcb->pcb_valtab)
#define root		((struct CDUelement *)pcb->pcb_tree)
#define act		((struct CDUelement *)pcb->pcb_current)
#define set_root(v)	(pcb->pcb_tree = (long)(v))
#define set_act(v)	(pcb->pcb_current = (long)(v))

#define get_ad(i)	valtab[i+0]
#define get_sy(i)	valtab[i+1]
#define get_fl(i)	valtab[i+2]

#define SKIPTEXT(s)	{while (*s++&0x00ff);}
#define SKIPDIS(s)      {while ((*s++&0xff00)!=0xff00);}
#define SKIPPROMPT(s)	{if (*s==-1) s+=2; else SKIPTEXT(s);}
#define SKIPPROMPTS(s)  {while (*s) SKIPPROMPT(s);s++;while (*s) SKIPPROMPT(s);s++;}

static struct CDUelement *newCDU()
{
 register struct CDUelement *new;
 char *malloc();

 if ( !(new = (struct CDUelement *)malloc(sizeof(*new))) ) return 0;
 new->next = new->prev = new->qualifier = 0;
 new->current = new->last = new->lastqual = 0;
 new->name = new->value = 0;
 new->flags = new->sep = new->islist = new->isparameter = new->isdiscarded = 0;
 return new;
}

static struct CDUelement *createList(pcb)
register PCB *pcb;
{
 register struct CDUelement *new;

 if ( !(new = newCDU()) ) return 0;
 act->islist = 1;
 act->list = new;
 new->prev = act;
 set_act(new);
 return new;
}

static struct CDUelement *createScratch(pcb)
register PCB *pcb;
{
 if ( (!root && !set_root(newCDU())) || !set_act(newCDU()) ) return 0;
 return act;
}

static changeSyntax(pcb,ptr)
register PCB *pcb;
register unsigned int ptr;
{
 register unsigned short *tptr = base+ptr;
 
 if ( *tptr++ ) pcb->pcb_qualifier = (tptr[-1] == DISABLE) ? 0 : ptr;
 if ( *tptr++ ) pcb->pcb_parameter = (tptr[-1] == DISABLE) ? 0 : ptr;
 if ( *tptr++ ) pcb->pcb_CLI = (tptr[-1] == DISABLE) ? 0 : tptr[-1];
 if ( *tptr++ )
  {
   pcb->pcb_image = (long)tptr;
   SKIPTEXT(tptr);
  }
 SKIPTEXT(tptr);
 if ( *tptr != 0xff00 ) pcb->pcb_disallows = (*tptr == DISABLE) ? 0 : (long)tptr;
}

static AddSeparator(pcb,sep)
PCB *pcb;
long sep;
{
 struct CDUelement *new;

 if ( !(new = newCDU()) ) return CDU_NOMEM;
 if ( new->next = act->list ) new->next->sep = sep;
 act->list = new;
 new->prev = act;
 set_act(new);
 return parse_exit;
}

static AddValue(pcb,id,mod)
PCB *pcb,*mod;
long id;
{
 struct CDUelement *n;

 if ( (get_fl(id)&CDU_ALL) == CDU_COPY )
  {
   act->value = (char *)mod->pcb_tree;
   set_act(act->prev);
  }
 return parse_exit;
}

static DefaultKeyword(pcb,id)
PCB *pcb;
long id;
{
 struct CDUelement *n;

 if ( act->islist ) AddSeparator(pcb,(long)',');
 act->name = (char *)(base+get_ad(id));
 act->flags = get_fl(id);
 if ( get_sy(id) == CDU_NOSTART )
  set_act(act->prev);
 else if ( !createList(pcb) )
  return CDU_NOMEM;
 return parse_fail;
}

static DefaultParameter(pcb,id)
PCB *pcb;
long id;
{
 struct CDUelement *n;

 if ( !createScratch(pcb) ) return CDU_NOMEM;
 act->next = root;
 root->prev = act;
 set_root(act);
 act->name = (char *)(base+get_ad(id));
 act->flags = get_fl(id);
 if ( get_sy(id) == CDU_NOSTART ) return parse_exit;
 if ( !createList(pcb) ) return CDU_NOMEM;
 return parse_fail;
}

static DefaultQualifier(pcb,id)
PCB *pcb;
long id;
{
 struct CDUelement *par0;

 if ( !createScratch(pcb) ) return CDU_NOMEM;
 for ( par0 = root ; par0->next ; par0 = par0->next );
 act->next = par0->qualifier;
 par0->qualifier = act;
 act->prev = par0;
 act->name = (char *)(base+get_ad(id));
 act->flags = get_fl(id);
 if ( get_sy(id) == CDU_NOSTART ) return parse_exit;
 if ( !createList(pcb) ) return CDU_NOMEM;
 return parse_fail;
}

static EndValue(pcb,id,mod)
PCB *pcb,*mod;
long id;
{
 struct CDUelement *o = 0;
 int flags;

 flags = get_fl(id);
 if ( (flags&CDU_ALL) == CDU_COPY )
  {
   act->value = (char *)mod->pcb_tree;
   set_act(act->prev);
  }
 else if ( (flags&CDU_ALL) == CDU_DEF )
  {
   act->value = (char *)(base+get_ad(id));
   act->flags = flags;
   set_act(act->prev);
  }
 else if ( !act->islist && !act->name && !act->value )
  {
   o = act;
   o->prev->list = o->next;
   set_act(act->prev);
  }
 set_act(act->prev);
 if ( o ) free(o);
 return parse_exit;
}

static Initialize(pcb,ptr)
PCB *pcb;
long ptr;
{
 valtab = base+(unsigned short)(ptr>>16);
 changeSyntax(pcb,ptr&0xffff);
 return parse_exit;
}

static SetError(pcb,errcode)
PCB *pcb;
long errcode;
{
 return errcode;
}

static StartValue(pcb,id)
PCB *pcb;
long id;
{
 int flags,syntax,curqual = pcb->pcb_qualifier,curpar = pcb->pcb_parameter;
 struct CDUelement *n,*q,*p;
 short *pnames;

 flags = get_fl(id);
 if ( ((flags&CDU_POS) == CDU_LOCAL) && !root->next )
  return CDU_ILLPOS;
 if ( syntax = get_sy(id) ) changeSyntax(pcb,syntax);
 act->name = (char *)(base+get_ad(id));
 act->flags = flags;
 if ( ((flags&CDU_ALL) == CDU_END) || ((flags&CDU_ALL) == CDU_NEG) )
  set_act(act->prev);
 else if ( !createList(pcb) )
  return CDU_NOMEM;
 if ( pcb->pcb_qualifier != curqual )
  for ( n = root ; n ; n = n->next )
   for ( p = (n->next ? n->List : n) ; p ; p = p->next )
    for ( q = p->qualifier ; q ; q = q->next )
     if ( !q->isdiscarded )
      {
       q->isdiscarded = 1;
       if ( q != act ) pcb->pcb_discarded = 1;
      }
 if ( pcb->pcb_parameter != curpar )
  {
   pnames = ((short *)(base+pcb->pcb_parameter))+3;
   SKIPTEXT(pnames);
   SKIPTEXT(pnames);
   SKIPDIS(pnames);
   SKIPPROMPTS(pnames);
   pnames = ((short *)base)+*pnames;
   for ( n = root ; n->next ; n = n->next );
   while ( n = n->prev )
    {
     n->name = (char *)(pnames+1);
     SKIPKEY(&pnames);
     pnames++;
    }
  }
 return parse_exit;
}

static SwitchParameter(pcb,id)
PCB *pcb;
long id;
{
 struct CDUelement *n;

 if ( pcb->pcb_parcount != get_sy(id) ) return parse_fail;
 pcb->pcb_parcount++;
 act->name = (char *)(base+get_ad(id));
 if ( !createList(pcb) ) return CDU_NOMEM;
 return parse_exit;
}

static SwitchQualifier(pcb,id)
PCB *pcb;
long id;
{
 struct CDUelement *addto;

 if ( pcb->pcb_qualifier != get_sy(id) ) return parse_fail;
 if ( get_ad(id) == CDU_NOSTART ) return parse_exit;
 if ( !root && !set_root(newCDU()) ) return CDU_NOMEM;
 if ( root->next )
  addto = root->List; 
 else
  addto = root;
 if ( !set_act(newCDU()) ) return CDU_NOMEM;
 act->next = addto->qualifier;
 addto->qualifier = act;
 act->prev = addto->prev;
 return parse_exit;
}

static SwitchSyntax(pcb,id)
PCB *pcb;
long id;
{
 if ( pcb->pcb_parameter != get_sy(id) ) return parse_fail;
 if ( get_ad(id) == CDU_NOSTART ) return parse_exit;
 if ( !createScratch(pcb) ) return CDU_NOMEM;
 act->next = root;
 root->prev = act;
 set_root(act);
 return parse_exit;
}

/*
  Reihenfolge der CDU-Liste der Eingabezeile anpassen.
*/
struct CDUelement *RearrangeRoot(pcb,batch)
PCB *pcb;
register int batch;
{
 register struct CDUelement *l,*r,**rp = (struct CDUelement **)&pcb->pcb_tree;

 for ( l = *rp, *rp = 0 ; r = l ; )
  {
   r->isparameter = 1;
   r->lastqual = r->qualifier;
   RearrangeList(&r->qualifier,batch,1);
   if ( r->islist )
    {
     r->last = r->list;
     RearrangeList(&r->list,batch,0);
    }
   r->flags |= CDU_GLOBAL;
   l = r->next;
   if ( *rp ) (*rp)->prev = r;
   r->next = *rp;
   r->prev = 0;
   *rp = r;
  }
 return root;
}

static RearrangeList(lp,batch,isqual)
register struct CDUelement **lp;
register int batch,isqual;
{
 register struct CDUelement *l,*r;

 for ( l = *lp, *lp = 0 ; r = l ; )
  {
   r->lastqual = r->qualifier;
   RearrangeList(&r->qualifier,batch,1);
   if ( r->islist )
    {
     r->last = r->list;
     RearrangeList(&r->list,batch,0);
    }
   if ( !isqual ) r->flags |= CDU_GLOBAL;
   if ( (r->flags&CDU_ALL) == CDU_BAT )
    if ( batch )
     r->flags = (r->flags&~CDU_ALL)|CDU_DEF;
    else
     r->isdiscarded = 1;
   l = r->next;
   if ( *lp ) (*lp)->prev = r;
   r->next = *lp;
   r->prev = 0;
   *lp = r;
  }
}

/*
  Allokatierten Speicherbereich freigeben.
*/
FreeTree(rt)
register struct CDUelement *rt;
{
 register struct CDUelement *cur = rt;

 while ( rt = cur )
  {
   FreeList(cur->qualifier);
   if ( cur->islist ) FreeList(cur->list);
   cur = cur->next;
   free(rt);
  }
}

FreeList(l)
struct CDUelement *l;
{
 register struct CDUelement *cur = l;

 while ( l = cur )
  {
   if ( cur->islist )
    FreeList(cur->list);
   else if ( cur->value && ((cur->flags&CDU_ALL) != CDU_DEF) )
    free(cur->value);
   cur = cur->next;
   free(l);
  }
}

/*
  Speicherplatz fuer Zeichenkette reservieren und mit Kopie aus der Eingabe-
  zeile fuellen.
*/
char *createValue(s,l,up,elen,extra)
register char *s;
register int l,up;
int elen;
char *extra;
{
 register char ch,*st;
 int more = 0,inner = 0;
 char *ns,*malloc();

 if ( up >= 0 ) up &= ~(more = up&128);
 if ( !(st = ns = malloc(l+elen+4)) ) return 0;
 if ( more ) *st++ = '"';
 switch (up)
  {
   case -1 : while ( l-- > 0 ) *st++ = *s++;
	     break;
   case  0 : while ( l-- > 0 ) 
   	      if ( (*st++ = *s++) == '"' )
	       {
	        s++;
		l--;
	       }
	     break;
   case  1 : for ( ; l-- > 0 ; *st++ = ch )
	      if ( ((ch = *s++) >= 'a') && (ch <= 'z') )
     	       ch += 'A'-'a';
	     break;
   case  2 : while ( l-- > 0 )
	      {
	       if ( ((ch = *s++) == ' ') || (ch == '\t') ) continue;
               if ( (ch >= 'a') && (ch <= 'z') ) ch += 'A'-'a';
	       *st++ = ch;
  	      }
	     break;
   case  3 : while ( l-- > 0 )
  	      {
   	       if ( (ch = *s++) == '"' )
		if ( !inner )
		 {
		  inner = 1;
		  continue;
		 }
		else if ( !l-- )
		 break;
		else if ( (ch = *s++) != '"' )
		 inner = 0; 
               if ( !inner && (ch >= 'a') && (ch <= 'z') ) ch += 'A'-'a';
	       *st++ = ch;
	      }
	     break;
   case  4 : while ( l-- > 0 )
  	      {
   	       if ( (ch = *s++) == '"' )
		if ( !inner )
		 {
		  inner = 1;
		  continue;
		 }
		else if ( !l-- )
		 break;
		else if ( (ch = *s++) != '"' )
		 inner = 0; 
               if ( !inner && (ch >= 'A') && (ch <= 'Z') ) ch += 'a'-'A';
	       *st++ = ch;
	      }
  }
 if ( more ) *st++ = '"';
 *st++ = '\0';
 if ( *st++ = elen ) bcopy(extra,st,elen);
 return ns;
}

/*
  Zeichenkette eines Wertes extrahieren und eventuell nach 'extra' Datenfeld
  selektieren und konvertieren.
*/
static int attTime(),attDelt();

struct {
 	char id[4];
	int  (*cvt)();
       } cvts[] = {
		   { "TIME", attTime },
		   { "DELT", attDelt }
		  };
#define CVTS	(sizeof(cvts)/sizeof(cvts[0]))

attachValue(str,ret,rlen)
char *str,**ret;
int *rlen;
{
 int i,len = strlen(str);
 char temp[4];

 if ( !str[len+1] ) return addWord(str,len,ret,rlen);
 for ( i = 4 ; i-- ; temp[i] = str[len+2+i] );
 for ( i = CVTS ; i-- && bcmp(cvts[i].id,temp,4) ; );
 if ( i < 0 ) return addWord(str,len,ret,rlen);
 return (*cvts[i].cvt)(str+len+6,ret,rlen); 
}

/*
  Unaligned longword lesen und zurueckgeben.
*/
static long peekL(str,ix)
unsigned char *str;
int ix;
{
 long res;
 
 str += ix*4;
 res = *str++;
 res = (res<<8)|*str++;
 res = (res<<8)|*str++;
 res = (res<<8)|*str;
 return res;
}

#define b(i)	peekL(ptr,i)

/*
  DATETIME = dd-mmm-jjjj-hh:mm:ss.cccc [+/- dddd-hh:mm:ss.cccc]
*/
static attTime(ptr,ret,rlen)
char *ptr,**ret;
int *rlen;
{
 static char buf[40];
 char *m = "JAN\0FEB\0MAR\0APR\0MAY\0JUN\0JUL\0AUG\0SEP\0OCT\0NOV\0DEC";
 int clen = b(7);

 if ( !clen ) clen = 2;
 if ( *rlen < (clen+22) ) return 0;
 sprintf(buf,"%%ld-%%s-%%4ld:%%02ld:%%02ld:%%02ld.%%0%dld",clen);
 sprintf(*ret,buf,b(0),m+4*(b(1)-1),b(2),b(3),b(4),b(5),b(6));
 clen = strlen(*ret);
 *ret += clen;
 *rlen -= clen;
 if ( !(buf[0] = b(8)) ) return 1;
 if ( !addWord(buf,1,ret,rlen) ) return 0;
 return attDelt(ptr+4*9,ret,rlen);
}

/*
  DELTATIME = dddd-hh:mm:ss.cccc
*/
static attDelt(ptr,ret,rlen)
char *ptr,**ret;
int *rlen;
{
 static char buf[40];
 int clen = b(5);

 if ( !clen ) clen = 2;
 if ( *rlen < (clen+15) ) return 0;
 sprintf(buf,"%%ld-%%02ld:%%02ld:%%02ld.%%0%dld",clen);
 sprintf(*ret,buf,b(0),b(1),b(2),b(3),b(4));
 clen = strlen(*ret);
 *ret += clen;
 *rlen -= clen;
 return 1;
}

/*
  Schluesselwort mit eventuellen Unterstrukturen ueberspringen.
*/
SKIPKEY(ptr)
short **ptr;
{
 short *cur = *ptr;

 /* Der Text des Namens */
 SKIPTEXT(cur);
 /* Unterstruktur */
 if ( *cur == -1 )
  cur += 2;
 else if ( *cur )
  /* Schluesselwortliste */
  while ( *++cur ) SKIPKEY(&cur);
 /* Ergebnis */
 *ptr = cur;
}

