#include "CDU.h"
extern char *predef[];

#ifdef DEVELOP

/*
  Der DEVELOP-Bereich wird nur in der Entwicklungsphase der Programms
  mitbersetzt und erlaubt die Ausgabe aller verwendeter Strukturen in
  einem menschenverstndlichen Format.
*/

ViewValue(v)
struct Value *v;
{
 printf("  VALUE(");
 if ( (v->flags&vcfCON) == vcfCON ) printf("CONCATENATE ");
 if ( (v->flags&vcfIMP) == vcfIMP ) printf("IMPCAT ");
 if ( (v->flags&vcfNCO) == vcfNCO ) printf("NOCONCATENATE ");
 if ( (v->flags&vcfLIS) == vcfLIS ) printf("LIST ");
 if ( (v->flags&vcfREQ) == vcfREQ ) printf("REQUIRED ");
 if ( v->defval ) printf("DEFAULT=\"%s\" ",v->defval);
 if ( v->typename )
  {
   printf("TYPE=");
   if ( v->type )
    printf("%s",v->type->name);
   else if ( v->predef != -1 )
    printf("%d(%s)",v->predef,predef[v->predef]);
   else
    printf("\"%s\"",v->typename);
  }
 puts(")");
}

ViewParameter(p)
struct Parameter *p;
{
 if ( (p->flags&idfPAR) == idfPAR )
  printf(" PARAMETER ");
 else if ( (p->flags&idfQUA) == idfQUA )
  printf(" QUALIFIER ");
 else
  printf(" KEYWORD ");
 printf("%s",p->name);
 if ( (p->flags&idfBAT) == idfBAT ) printf(",BATCH");
 if ( (p->flags&idfDEF) == idfDEF ) printf(",DEFAULT");
 if ( (p->flags&idfNEG) == idfNEG ) printf(",NEGATABLE");
 if ( (p->flags&idfNNE) == idfNNE ) printf(",NONNEGATABLE");
 if ( (p->flags&idfGLO) == idfGLO ) printf(",PLACEMENT=GLOBAL");
 if ( (p->flags&idfLOC) == idfLOC ) printf(",PLACEMENT=LOCAL");
 if ( (p->flags&idfPOS) == idfPOS ) printf(",PLACEMENT=POSITIONAL");
 if ( (p->flags&idfLAB) == idfLAB ) printf(",LABEL=%s",p->label);
 if ( (p->flags&idfPRO) == idfPRO ) printf(",PROMPT=\"%s\"",p->prompt);
 if ( (p->flags&idfSYN) == idfSYN )
  {
   printf(",SYNTAX=");
   if ( p->syntax )
    printf("%s",p->syntax->name);
   else
    printf("\"%s\"",p->synname);
  }
 printf("\n");
 if ( (p->flags&idfVAL) == idfVAL ) ViewValue(p->value);
}

ViewVerb(v)
struct Verb *v;
{
 struct Parameter *p;
 struct Expression *e;
 struct Synonym *s;

 printf("%s %s",v->isverb ? "VERB" : "SYNTAX",v->name);
 for ( s = curverb->synonym ; s ; s = s->next )
  printf(",SYNONYM=%s",s->text);
 if ( (v->flags&vfNDI) == vfNDI ) printf(",NODISALLOWS");
 if ( (v->flags&vfNPA) == vfNPA ) printf(",NOPARAMETERS");
 if ( (v->flags&vfNQU) == vfNQU ) printf(",NOQUALIFIERS");
 if ( (v->flags&vfPRE) == vfPRE ) printf(",PREFIX=%s",v->prefix);
 if ( (v->flags&vfCLI) == vfCLI ) printf(",CLIROUTINE=%s",v->image);
 if ( (v->flags&vfIMA) == vfIMA ) printf(",IMAGE=\"%s\"",v->image);
 if ( (v->flags&vfROU) == vfROU ) printf(",ROUTINE=%s",v->image);
 putchar('\n');
 for ( p = v->parameter ; p ; p = p->next )
  ViewParameter(p);
 for ( p = v->qualifier ; p ; p = p->next )
  ViewParameter(p);
 for ( e = v->disallow ; e ; e = e->next )
  {
   printf(" DISALLOW ");
   ViewExpression(e);
   putchar('\n');
  }
 printf("END %s\n",v->isverb ? "VERB" : "SYNTAX");
}

ViewType(t)
struct Type *t;
{
 struct Parameter *p;

 printf("TYPE %s\n",t->name);
 for ( p = t->keyword ; p ; p = p->next )
  ViewParameter(p);
 printf("END TYPE\n");
}

ViewReference(r)
struct Reference *r;
{
 char **scan;

 if ( r->def )
  {
   putchar('<');
   if ( r->base )
    printf("%s",r->base->name);
   else
    printf("\"%s\"",r->def);
   putchar('>');
  }
 for ( scan = r->names ; *scan ; )
  {
   printf("%s",*scan++);
   if ( *scan ) putchar('.');
  }
}

ViewExpression(e)
struct Expression *e;
{
 struct Reference *r;

 switch (e->kind)
  {
   case EK_ANY2 : printf("ANY2(");
		  for ( r = e->ereference ; r ; )
		   {
		    ViewReference(r);
		    if ( r = r->next ) putchar(',');
		   }
		  putchar(')');
		  break;
   case EK_NEG  : printf("NEG ");
   case EK_LEAF : ViewReference(e->ereference);
		  break;
   case EK_NOT  : printf("NOT ");
		  ViewExpression(e->eright);
		  break;
   case EK_AND  : ViewExpression(e->eleft);
		  printf(" AND ");
		  ViewExpression(e->eright);
		  break;
   case EK_OR   : ViewExpression(e->eleft);
		  printf(" OR ");
		  ViewExpression(e->eright);
		  break;
   case EK_SUB  : putchar('(');
		  ViewExpression(e->eright);
		  putchar(')');
		  break;
  }
}
#endif
