#include <stdio.h>
#ifdef MCH_AMIGA
#define X_OK	1
#else
#include <sys/file.h>
#endif

#include <saphir/CLI.h>
#include <saphir/CLIdef.h>

#define PCBDCL_INLINE
#include <saphir/modules/frame.h>
#include "command.h"
#include "DCL.h"

#define PUTTAB		"DCLTable"
#define PUTELM		"DCLElements"

#ifdef MCH_AMIGA
#define IMAGEDIR	"dcl:"
#define TNAMETAB	"t:DCLtab.XXXXXX"
#define TNAMEELM	"t:DCLelm.XXXXXX"
#else 
#define IMAGEDIR	"/usr/dcl/exe/"
#define TNAMETAB	"/tmp/DCLtab.XXXXXX"
#define TNAMEELM	"/tmp/DCLelm.XXXXXX"
#endif

int nCLIcallmap = 0,CLIimage = 0;
struct MAP *CLIcallmap = 0;

#define TABSIZE(t)	(sizeof(struct CDUverbtab)*(t)->verbs)
#define BADEL		((struct CDUelement *)1)

static struct CDUtable *ImageTable = 0;
static struct CDUelement *tree0 = 0;
static struct CDUverbtab *vtab0 = 0;
static short *pkeys0 = 0,*qkeys0 = 0;

static struct context Context = { 0, 0, 0, 0, 0, 0, 0, 0, 0 };
static struct epcbCLD *CMDpcb = 0;

#define SKIPTEXT(s)	{while (*s++&0x00ff);}
#define SKIPDIS(s)      {while ( (*s++&0xff00) != 0xff00 );}
#define SKIPPROMPT(s)	{if (*s==-1) s+=2; else SKIPTEXT(s);}
#define SKIPPROMPTS(s)  {while ( *s ) SKIPPROMPT(s);s++;\
   			 while ( *s ) SKIPPROMPT(s);s++;}

#define EXACT(a,b,e) 	((e && ((char *)(a) == b)) ||\
			 (!e && !strcmp((char *)(a),b)) )

#define index(p,i)	(((short *)p->sys_pcb.pcb_table2)+i)

/*
  Dem Benutzer nicht direkt zugaengliche Hilfsroutinen.
*/

/*
  CDU-VERBs in eine Tabelle eintragen. 'loadCDU' ueberprueft zuerst, ob die
  CDU-Tabelle bereits aktiviert worden ist. In diesem Fall wird sie natuerlich
  nicht nochmals geladen. Ansonsten werden alle benoetigten Parsertabellen
  geladen und die VERBs und SYNONYMs in eine sortierten VERB-Tabelle ein-
  geordnet.
*/
extern char *pcb_ctab;

loadCDU(table)
struct CDUtable *table;
{
 int ix,iy,vcnt,compare();
 struct CDUverbtab *cur;
 struct epcbCLD *getpcb();
 char *malloc(),*mem;
 short *scan,*tab;

 /* Erst einmal pruefen, ob es wirklich eine CDU-Tabelle ist */
 if ( (table->version != CDUVERSION) || (table->verbs <= 0) ) return 0; 
 /* Tabelle bereits aktiv --> fertig */
 if ( table->vtab ) return 1;
 /* Preparsertabelle laden falls noetig und Speicher reservieren */
 if ( (!CMDpcb && !(CMDpcb = getpcb(pcbCLD_module))) ||
      !(table->vtab = (struct CDUverbtab *)malloc(TABSIZE(table))) )
  return 0; 
 /* Bearbeiten aller VERBs in der neuen CDU-Tabelle */
 for ( ix = table->verbs, mem = table->table ; ix-- ; )
  {
   /* Tabelle aktivieren und eventuell untergeordnete Tabellen laden */
   cur = table->vtab+ix;
   cur->mem = mem;
   pcbCDU_module[1] = mem;
   if ( !(cur->pcb = (struct epcbCDU *)getpcb(pcbCDU_module)) ) return 0;
   mem = pcb_ctab;
   cur->msize = mem-cur->mem;
   /* CDU-Tabelle beginnen mit TRANS P$LAMBDA,,INITIALIZE,,,OFFSET */
   scan = tab = index(cur->pcb,0);
   if ( (*scan++ != 0x0a03) || (*scan++ != 5) ) return 0;
   scan++;
   if ( *scan++ != 6 ) return 0;
   scan = tab+*++scan;
   /* Syntax Identifikation */
   scan += 3;
   /* Name des auszufuehrenden Objektes */
   SKIPTEXT(scan);
   /* Prefix */
   SKIPTEXT(scan);
   /* DISALLOW-Ausdruecke */
   SKIPDIS(scan);
   /* Parameter PROMPTs */
   SKIPPROMPTS(scan);
   /* Offsets der Schluesselworttabellen */
   scan += 2;
   /* Name des VERBs */
   cur->parent = cur->name = (char *)scan;
   SKIPTEXT(scan);
   /* Liste der SYNONYMs durchgegehen */
   vcnt = 1;
   while ( *scan )
    {
     /* Die Verwaltungsstruktur eines SYNONYMS hat nur einen anderen Namen */
     vcnt++;
     table->vtab[--ix] = *cur;
     cur = table->vtab+ix;
     cur->name = (char *)scan;
     SKIPTEXT(scan); 
    } 
   /* VERB Zaehler einfuellen */
   for ( iy = vcnt ; iy-- ; table->vtab[ix+iy].verbs = vcnt ); 
  }
 /* VERB-Tabelle alphabetisch sortieren */
 qsort((char *)table->vtab,table->verbs,sizeof(struct CDUverbtab),compare);
 /* Erfolgsmeldung an das aufrufende Programm */
 return 1;
}

/*
  Hilfsroutine zum Sortieren der VERB-Tabelle, das die Namen zweier VERBs
  bzw. SYNONYMs vergleicht.
*/
static compare(el1,el2)
struct CDUverbtab *el1,*el2;
{
 return strcmp(el1->name,el2->name);
}

/*
  Fehler ins VAX-Format uebersetzen. Die Headerdatei CLI.h stellt die
  notwendigen Konstanten zusammen und wird aus der VAX-Datei SYS$LIBRARY:
  CLIDEF.H extrahiert.
*/
static translateError(uerr)
int uerr;
{
 switch (uerr)
  {
   case parse_exit  : return CLI$_NORMAL;
   case parse_abbr  : return CLI$_ABKEYW;
   case parse_table :
   case CDU_NOTIMP  : return CLI$_INVTAB;
   case CDU_ILLPAR  : return CLI$_ILLVAL;
   case CDU_ILLQUAL : return CLI$_IVQUAL;
   case CDU_ILLKEY  : return CLI$_IVKEYW;
   case CDU_ILLVAL  : return CLI$_IVVALU;
   case CDU_NOPAR   : return CLI$_INSFPRM;
   case CDU_NOQUAL  : return CLI$_NOQUAL;
   case CDU_NOVAL   : return CLI$_NOVALUE;
   case CDU_NOSEP   : return CLI$_NOLIST;
   case CDU_NOMEM   : return CLI$_COMPLX;
   case CDU_GARB    : return CLI$_MAXPARM;
   case CDU_ILLNUM  : return CLI$_NUMBER;
   case CDU_ILLPOS  : return CLI$_IVQLOC;
   default          : return CLI$_EXPSYN;
  }
}

/*
  Die folgenden Unterroutinen beschaeftigen sich mit der Auswertung der
  DISALLOW-Ausdruecke. Sie sind in der Lage, eine gegebene Schluesselwort-
  list zu validieren und ein etwaiges passendes Element aus der bereits
  analysierten Eingabezeile zu lokalisieren.
*/
static unsigned short *curdis;
static short *curbase;

#define OPLEAF	((int)exvEND)
#define OPANY2	((int)exvANY2)
#define OPNEG	((int)exvNEG)
#define OPNOT	((int)exvNOT)
#define OPAND	((int)exvAND)
#define OPOR	((int)exvOR)
#define OPSUB	((int)exvSTART)

#define ISABS	0
#define ISHERE	1
#define ISNEG	2
#define ISDEF	3

/*
  DISALLOW-Ausdruecke durchgehen bis ein Ausdruck erfuellt oder alle
  Ausdruecke abgearbeitet sind. Im letzteren Fall ist die Eingabezeile
  korrekt, ansonst erfolgt im Allgemeinen eine entsprechende Fehlermel-
  dung.
*/	
static processDisallows(base,dis)
short *base;
unsigned short *dis;
{
 /* Globale Variablen zur Vermeidung vieler Uebergabeparameter */
 curdis = dis;
 curbase = base;
 /* Alle Ausdruecke bearbeiten */
 while ( (*curdis&0xff00) != 0xff00 )
  {
   /* Ist ein Ausdurck wahr, so ist die Eingabezeile verboten */
   if ( processExpression() ) return 0;
   /* Ansonsten wird die Endkennung des einzelnen Ausdrucks uebersprungen */
   curdis++;
  }
 /* Eingabezeile ist korrekt */
 return 1;
}

/*
  Einen Ausdruck der DISALLOWS-Liste auswerten. Im wesentlichen verzweigt
  'processExpression' letztendlich in 'processReference', das eine Schluessel-
  wortlist validiert und lokalisiert. Der Rueckgabewert charakterisiert dann
  das Vorkommen des Eingabeelementes in der Zeile:
	ISABS	nicht vorhanden
	ISDEF	nicht vorhanden, aber als Defaultwert eigetragen
	ISNEG	mit einem NO-Prefix vorhanden
	ISHERE	Ohne NO-Prefix vorhanden
*/
static processExpression()
{
 int any2 = 0;

 switch (*curdis++)
  {
   case OPLEAF : return (processReference() == ISHERE); 
   case OPANY2 : while ( *curdis )
		  if ( (processReference() == ISHERE) && any2++ )
		   return 1; 
		 curdis++;
	         return 0;
   case OPNEG  : return (processReference() == ISNEG);
   case OPAND  : return processExpression()&processExpression();
   case OPOR   : return processExpression()|processExpression(); 
   case OPSUB  : return processExpression();
   case OPNOT  : return !processExpression();
  }
}

/*
  Nachsehen, ob ein Qualifier, Parameter oder Schluesselwort angegeben
  ist. Die meiste Arbeit hat die Routine, wenn 'base' noch 0 ist. In diesem
  Fall muessen Qualifier und Parameter untersucht werden, wobei natuerlich
  auch per Default gesetzte Eintraege beruecksichtigt werden muessen. Sobald
  aber 'base' ein CDUelement spezifiziert, muss nur noch in dessen Kontext
  weiter geforscht werden. Defaultwerte sind als Schluesselworte direkt der
  Liste zu entnehmen.
*/
static struct CDUelement *setElement(base,name)
struct CDUelement *base;
char *name;
{
 struct CDUelement *pars,*scan,*loc;

 /* Ohne 'Tree' gibt es keinerlei Eintraege */
 if ( !Tree ) return 0;
 /* Tail wird auf den letzten nicht-DEFAULT Parameter gesetzt */
 if ( !Tail  )
  {
   Tail = Tree;
   while ( Tail->next )
    {
     if ( (Tail->next->flags&CDU_ALL) == CDU_DEF ) break;
     Tail = Tail->next;
    }
  }
 /* Ohne 'base' arbeitet die Routine kontextfrei auf den primaeren Definition */
 if ( !base )
  {
   /* Durchsuchen der eingegebenen Parameter */
   for ( scan = Tail ; scan->prev ; scan = scan->prev )
    if ( scan->name == name ) return scan;
   /* Durchsuchen der DEFAULT Parameter */
   for ( scan = Tail ; scan = scan->next ; )
    if ( scan->name == name ) return scan;
   /* Den Parametern mitgegebene Qualifier vom letzten Parameter an */
   for ( base = Tail ; base->prev ; base = base->prev )
    for ( pars = base->last ; pars ; pars = pars->prev )
     {
      /* Zuletzt eingegebenen passenden Qualifier suchen */
      for ( scan = pars->lastqual, loc = 0 ; scan ; scan = scan->prev )
       if ( !scan->isdiscarded && (scan->name == name) )
        {
         loc = scan;
         break;
        }
      if ( !loc ) continue;
      /* Innerhalb von DISALLOWs sind alle Qualifier global */
      if ( (GetV == BADEL) || ((loc->flags&CDU_POS) == CDU_GLOBAL) ) return loc;
      /* Kontext eines frueheren CLI$GET_VALUEs beachten */
      if ( !GetV ) break;
      if ( !GetV->current )
       {
	if ( (GetV == base) && !GetV->List->next ) return loc;
       }
      else if ( GetV->current == pars )
       return loc;
     }
   /* Globale und DEFAULT Qualifier durchgehen */
   for ( base = Tree->qualifier, scan = 0 ; base ; base = base->next )
    if ( !base->isdiscarded && (base->name == name) )
     {
      if ( scan && ((base->flags&CDU_ALL) == CDU_DEF) ) break;
      scan = base;
     }
   if ( scan && ((scan->flags&CDU_ALL) != CDU_DEF) && 
                ((scan->flags&CDU_POS) != CDU_GLOBAL) )
    scan->flags |= CDU_GLOBAL; 
   return scan;
  }
 /* Das aktuelle Element muss eine Substruktur besitzen */
 else if ( base->islist )
  {
   /* Alle Subelement durchgehen und letztes Schluesselwort melden */
   for ( base = base->List, scan = 0 ; base ; base = base->next )
    if ( base->name == name )
     {
      if ( scan && ((base->flags&CDU_ALL) == CDU_DEF) ) return scan;
      scan = base;
     }
   return scan;
  } 
 return 0;
}

/*
  Rekursives Durchsuchen der Schluesselwortliste nach einem Namen. Alle
  intermediaeren Namen werden erkannt und gelistet. Ist eine Namensliste
  vervollstaendigt, so ruft die unterste Rekursionsstufe 'setElement' auf,
  sooft es noetig ist, d.h. soviel wie Rekursionsebenen vorhanden sind. Das
  positive oder negative Ergebnis wird dann einfach nach oben durchgeschlauft.
*/
struct recurse_list
       {
	struct recurse_list *next;
	char *name;
       };
#define recl0	((struct recurse_list *)0)
	
static struct CDUelement *locate(prev,name,tab,exact,cure)
struct recurse_list *prev;
char *name;
short *tab;
int exact;
struct CDUelement *cure;
{
 struct CDUelement *rec;
 struct recurse_list me,*turn,*keep,*cur;
 short *down;

 /* Ohne Schluesselworttabelle keine Auswertung */
 if ( !tab ) return 0;
 /* Rekursionen verketten */
 me.next = prev;
 /* Schluesselworttabelle rekursiv abarbeiten */
 while ( *tab )
  {
   /* Aktuelles Schluesselwort */
   me.name = (char *)(tab+1);
   /* Ist es das Gesuchte ? */
   if ( EXACT(tab+1,name,exact) )
    {
     /* Gefundene intermediaere Namen korrekt anordnen */
     for ( keep = &me, turn = 0 ; cur = keep ; )
      {
       keep = cur->next;
       cur->next = turn;
       turn = cur;
      }
     /* Namen den Eintraegen aus der Eingabezeile zuordnen */
     for ( ; turn ; turn = turn->next )
      if ( !(cure = setElement(cure,turn->name)) )
       return BADEL;
     /* Position zur Fortsetzung von 'match' vermerken und Erfolg melden */
     cure->newpos = tab;
     return cure; 
    }
   /* Text ueberspringen */
   down = tab;
   SKIPTEXT(down);
   /* Substruktur vorhanden ? */
   if ( *down )
    {
     /* Anfang der Subschluesselworttabelle suchen */
     if ( *down == -1 ) down = curbase+(unsigned short)down[1];
     /* Rekursionsdeadlocks durch ein Flag vermeiden */
     if ( !(*down&1) )
      { 
       /* Rekursionssperre setzen und Substruktur bearbeiten */
       *down++ |= 1;
       rec = locate(&me,name,down,exact,cure);
       /* Rekursionssperre loesen und eventuell Rekursion beenden */
       *--down &= ~1;
       if ( rec ) return rec;
      }
    }
   /* Naechstes Schluesselwort untersuchen */
   SKIPKEY(&tab);
   tab++;
  }
 /* Nichts gefunden */
 return 0;
}

/*
  Element suchen. Die Namensliste wurde entweder aus den DISALLOW-Ausdruecken
  erstellt oder kommt von einem Benutzer. Im letzteren Fall muss jeder Name
  Byte fuer Byte verglichen werden, bei den DISALLOW-Ausdruecken reicht ein
  einfacher Zeigervergleich. Diese Routine muss etwaige ausgelassene Eintraege
  finden.
*/
static struct CDUelement *match(namel,exact)
char **namel;
int exact;
{
 struct CDUelement *cure = 0,*newe;
 short *curk[2],*scan;
 char *cur,*got;
 int ix;

 /* Schluesselworttabellen aus dem 'Context' uebernehmen */
 curbase = index(VTab->pcb,0);
 curk[0] = QKeys;
 curk[1] = PKeys;
 /* Alle Namensfragmente durchgehen */
 while ( cur = *namel++ )
  {
   /* Beide Tabellen nach dem Namen durchsuchen */
   for ( ix = 2, got = 0 ; ix-- && !got ; )
    if ( scan = curk[ix] )
     /* Eine ganze Tabelle */
     while ( *scan )
      {
       if ( EXACT(scan+1,cur,exact) )
        {
	 /* Name gefunden, Schleifen beenden */
         got = (char *)scan;
         break;
        }
       /* Name nicht gefunden, Schluesselwort mit Substrukturen ueberspringen */
       SKIPKEY(&scan);
       scan++;
      }
   /* Auswertung der Suche */
   if ( !got )
    {
     /* Wird der Name nicht gefunden, muss rekursiv gesucht werden */
     if ( !(newe = locate(recl0,cur,curk[1],exact,cure)) &&
	  !(newe = locate(recl0,cur,curk[0],exact,cure)) )
      return BADEL;
     /* Name ist zwar legal, aber nicht in der Eingabezeile vorhanden */
     if ( (cure = newe) == BADEL ) return 0;
     /* Element lokalisiert, Fortsetzung der Suche an geeigneter Stelle */
     scan = cure->newpos;
    }
   /* Name wurde gefunden, also jetzt das Element zu lokalisieren */
   else if ( !(cure = setElement(cure,scan+1)) )
    return 0;
   /* Nach einem gefundenen Namen zu dessen Substruktur verzweigen */
   SKIPTEXT(scan);
   if ( *scan == -1 )
    curk[1] = curbase+(unsigned short)scan[1]+1;
   else if ( !*scan++ )
    curk[1] = 0;
   else
    curk[1] = scan;
   curk[0] = 0;
  }
 /* Ergebnis melden */
 return cure;
}

/*
  Schluesselwortliste ermitteln und Schluesselwort lokalisieren. Eine
  deartige Liste kann bis zu 8 Eintraege tief sein.
*/
static processReference()
{
 struct CDUelement *found;
 char *names[9];
 int ix = 0,off;

 /* Namesliste aufbauen, maximale Listenlaenge beachten */
 while ( off = *curdis++ )
  {
   if ( ix == 8 ) return ISABS;
   names[ix++] = (char *)(curbase+off);
  }
 names[ix] = 0;
 /* Element lokalisieren */
 if ( !(found = match(names,1)) || (found == BADEL) ) return ISABS;
 /* Geeigneten Rueckgabewert aufsetzen */
 switch (found->flags&CDU_ALL)
  {
   case CDU_NEG : return ISNEG;
   case CDU_DEF : return ISDEF;
   default      : return ISHERE;
  }
}

/*
  Vom Benutzer gelieferte Schluesselwortliste in eine Namensliste der maximalen
  Tiefe acht zerlegen und ueber 'match' ein Element der Eingabezeile lokali-
  sieren.
*/
static struct CDUelement *umatch(name,len)
char *name;
int len;
{
 static char buf[9][64];
 char *names[9],*base,ch;
 int nix,ix =0;

 /* Die durch Punkte getrennte Schluesselworte aufschluesseln */
 while ( len > 0 )
  {
   /* Neuen Buffer bereitstellen */
   names[ix] = base = buf[ix];
   if ( ix++ == 8 ) return BADEL;
   /* Buffer mit dem Schluesselwort in Grossschreibung fuellen */
   nix = 0;
   while ( len-- && ((ch = *name++) != '.') )
    {
     if ( (ch == ' ') || (ch == '\t') ) continue;
     if ( nix == (sizeof(buf[0])-1) ) return BADEL; 
     if ( (ch >= 'a') && (ch <= 'z') ) ch += 'A'-'a';
     base[nix++] = ch;
    }
   base[nix] = '\0';
  } 
 /* Namensliste beenden */
 names[ix] = 0;
 return match(names,0);
}

/*
  CLI-Tabelle eines Programms laden.
*/
static loadImage()
{
 if ( !ImageTable && !readImage() ) return 0;
 Tree = tree0;
 VTab = vtab0;
 Image = "NOCOMMAND";
 Kind = 0;
 Table = ImageTable;
 PKeys = pkeys0;
 QKeys = qkeys0;
 Tail = 0;
 GetV = BADEL;  
}

/*
  Primaere CDU-Tabelle laden. Name und Element werden dabei ueber die
  folgenden Environmentvariablen erhalten:
	CDUTable	= Name der Tabelle
	CDUElements	= Name der Elementdatei
*/
#define TR(b,l)		(fread(b,1,l,tab)==l)

static readImage()
{
 char *getenv(),*malloc(),*readString();
 char *env,*mem = 0,*pk = 0,*qk = 0;
 struct CDUelement *tree = 0,*last;
 int vers,verbs,size,res;
 struct CDUverbtab *cur;
 struct CDUtable *nt;
 FILE *tab;

 /* Tabellendatei oeffnen und Tabelle einlesen */
 if ( !(env = getenv(PUTTAB)) || !(tab = fopen(env,"r")) ) return 0;
 res = (TR(&vers,sizeof(vers)) && TR(&verbs,sizeof(verbs)) &&
        TR(&size,sizeof(size)) && (mem = malloc(size)) && TR(mem,size));
 fclose(tab);
 /* Speicherstruktur erzeugen und initialisieren */ 
 if ( res && (nt = (struct CDUtable *)malloc(sizeof(*nt))) )
  {
   nt->version = vers;
   nt->verbs = verbs;
   nt->table = mem;
   nt->tsize = size;
   nt->map = 0;
   nt->msize = 0;
   nt->vtab = 0;
   /* Struktur verketten und Elemente einlesen */
   if ( res = loadCDU(nt) ) ImageTable = nt;
   /* Elementdatei oeffnen und Elemente einlesen */
   if ( res && (env = getenv(PUTELM)) && (tab = fopen(env,"r")) )
    {
     /* Version ueberpruefen */
     if ( res = (TR(&vers,sizeof(vers)) && (vers == CDUVERSION)) )
      { 
       vtab0 = nt->vtab; 
       /* Rest einlesen */
       res = ((pk = readString(tab,2)) && (qk = readString(tab,2)) &&
              readAll(tab,&tree,&last));
       if ( res )
        {
	 /* Restliche Parameter in global vermerken */
	 pkeys0 = (short *)((pk == (char *)-1) ? 0 : pk);
	 qkeys0 = (short *)((qk == (char *)-1) ? 0 : qk);
	 tree0 = tree;
    	}
      }
     fclose(tab);
    }
  }
 /* Je nach Fehlercode beenden */
 if ( !res ) ImageTable = 0;
 return res;
}

/*
  Tabelle fuer den Aufruf eines IMAGEs rausschreiben und IMAGE aktivieren.
*/
static callImage()
{
 char new[100],*tnam = 0,*enam = 0,*iname,*mktemp(),*malloc(),*translate_vms_default(),*path;
 int vers = CDUVERSION,pid,res = 0;
 FILE *tab,*fopen();

 /* Legalen Kontext verifizieren */
 if ( !Table ) return CLI$_INVTAB;
 /* Temporare Datei fuer die Tabelle erstellen */
 strcpy(new,TNAMETAB);
 if ( mktemp(new) && (tab = fopen(new,"w")) )
  {
   /* Signifikanten Teil der Tabelle rausschreiben */
   fwrite(&vers,1,sizeof(vers),tab);
   fwrite(&VTab->verbs,1,sizeof(VTab->verbs),tab);
   fwrite(&VTab->msize,1,sizeof(VTab->msize),tab);
   fwrite(VTab->mem,1,VTab->msize,tab);
   fclose(tab);
   /* Tabellenname in der Form XXXX=NNNN zusammensetzen */
   if ( tnam = malloc(sizeof(PUTTAB)+1+strlen(new)) )
    {
     strcpy(tnam,PUTTAB);
     tnam[sizeof(PUTTAB)-1] = '=';
     strcpy(tnam+sizeof(PUTTAB),new);
    }
   else
    /* Bei Fehler Datei loeschen */
    unlink(new);
  }
 /* Aufhoeren, wenn es nicht geklappt hat */
 if ( !tnam ) return CLI$_INVTAB;
 /* Elementdatei erstellen */
 strcpy(new,TNAMEELM);
 if ( mktemp(new) && (tab = fopen(new,"w")) )
  {
   /* Elemente in die Datei schreiben */
   fwrite(&vers,1,sizeof(vers),tab);
   writeString(tab,PKeys,2);
   writeString(tab,QKeys,2);
   writeAll(tab,Tree);
   fclose(tab);
   /* Hilfsname der Form XXXX=NNNN zusammensetzten */
   if ( enam = malloc(sizeof(PUTELM)+1+strlen(new)) )
    {
     strcpy(enam,PUTELM);
     enam[sizeof(PUTELM)-1] = '=';
     strcpy(enam+sizeof(PUTELM),new);
    }
   else
    res = CLI$_INVTAB;
  }
 else
  {
   unlink(tnam+sizeof(PUTTAB));
   return CLI$_INVTAB;
  }
 /* Name des zu startenden Programms ermitteln */
 if ( !res )
#ifdef MCH_AMIGA
  if ( 1 ) 
#else
  if ( !(iname = translate_vms_default(Image,"SYS$SYSTEM:.EXE")) || (iname == (char *)-1) )
#endif
   {
    iname = new;
    if ( *Image == '/' )
     if ( strlen(Image) > (sizeof(new)-1) )
      res = CLI$_INVTAB;
     else
#ifdef MCH_AMIGA
      strcpy(new,Image+1);
#else
      strcpy(new,Image);
#endif
    else if ( (sizeof(IMAGEDIR)+strlen(Image)) > sizeof(new) )
     res = CLI$_INVTAB;
    else
     {
      strcpy(new,IMAGEDIR);
      strcpy(new+sizeof(IMAGEDIR)-1,Image);
     }
   }
 /* Testen auf Ausfuehrbarkeit des Files */
 if ( !res && access(iname,X_OK) ) res = CLI$_INVROUT;
 if ( !res )
  {
   /* Eigentlichen Dateinamen ermitteln */
   path = iname+strlen(iname);
   while ( (path-- > iname) && (*path != '/') && (*path != ']') && (*path != ':') );
   path++;
   /* ENVIRONMENT setzen und Programm aktivieren */
#ifdef MCH_AMIGA 
   setenv(PUTTAB,tnam+sizeof(PUTTAB));
   setenv(PUTELM,enam+sizeof(PUTELM));
   if ( fexecl(iname,path,(char *)0) ) res = wait();
#else
   if ( !(pid = fork()) )
    {
     putenv(tnam);
     putenv(enam);
     execl(iname,path,(char *)0);
     exit(1);
    }
   if ( pid != -1 ) wait((int *)0);
#endif
  }
 /* Aufraeumen und Fehlercode melden */
 unlink(tnam+sizeof(PUTTAB));
 unlink(enam+sizeof(PUTELM));
 free(tnam);
 free(enam);
 return res ? res : CLI$_NORMAL;
}
  
/*
  String in einen File schreiben. Je nach Art werden Extrabytes am Ende mit
  vermerkt.
*/
static writeString(fil,str,mode)
FILE *fil;
char *str;
int mode;
{
 char l;
 short off;
 
 if ( mode != 2 ) l = strlen(str);
 switch (mode)
  {
   case 1 : l += str[l+1]+2;
   case 0 : fwrite(&l,1,1,fil);
	    fwrite(str,1,l,fil);
	    break;
   case 2 : off = str ? (((short *)str)-index(VTab->pcb,0)) : -1;
	    fwrite(&off,1,sizeof(off),fil);
	    break; 
  }
}

/*
  String wieder korrekt auslesen.
*/
static char *readString(fil,mode)
FILE *fil;
int mode;
{
 char l,*new,*malloc();
 short off;

 if ( mode == 2 )
  {
   if ( fread(&off,1,sizeof(off),fil) != sizeof(off) ) return 0;
   return (char *)((off == -1) ? ((short *)-1) : index(vtab0->pcb,off));   
  }
 if ( (fread(&l,1,1,fil) != 1) || !(new = malloc(l+1)) ) return 0;
 if ( fread(new,1,l,fil) != l )
  {
   free(new);
   return 0;
  } 
 new[l] = '\0';
 return new;
}
 
/*
  Elementliste in eine Datei schreiben.
*/
#define ISLIST		0x01
#define ISPARAMETER	0x02
#define HASNAME		0x04
#define HASLIST		0x08
#define HASVALUE	0x10
#define HASQUALIFIER	0x20
#define ISEOF		0x80

static writeAll(fil,el)
FILE *fil;
struct CDUelement *el;
{
 char info[3];
 
 /* Liste durchgehen */
 for ( ; el ; el = el->next )
  /* Nur nicht eleminierte Elemente */
  if ( !el->isdiscarded )
   {
    /* Kontrollblock aufsetzen und rausschreiben */
    info[0] = el->flags;
    info[1] = el->sep;
    info[2] = 0;
    if ( el->islist ) info[2] |= ISLIST;
    if ( el->isparameter ) info[2] |= ISPARAMETER;
    if ( el->name ) info[2] |= HASNAME;
    if ( el->List ) info[2] |= HASLIST;
    if ( el->Value ) info[2] |= HASVALUE;
    if ( el->qualifier ) info[2] |= HASQUALIFIER;
    fwrite(info,1,sizeof(info),fil);
    if ( el->name )
     {
      /* Name und etwaige Subliste */
      writeString(fil,el->name,2);
      if ( el->List ) writeAll(fil,el->List);
     }
    else if ( el->Value )
     /* Wert */
     if ( (el->flags&CDU_ALL) == CDU_DEF )
      writeString(fil,el->Value,2);
     else
      writeString(fil,el->Value,1);
    /* Qualifier, falls vorhanden */
    if ( el->qualifier ) writeAll(fil,el->qualifier);
   }
 /* Ende der Liste markieren */
 info[0] = info[1] = 0;
 info[2] = ISEOF;
 fwrite(info,1,sizeof(info),fil);
}

/*
  Elementliste aus einer Datei lesen.
*/
static readAll(fil,first,last)
FILE *fil;
struct CDUelement **first,**last;
{
 struct CDUelement *cur;
 unsigned char info[3];

 /* Eine Liste von Elementen durchgehen */ 
 for ( *first = *last = 0 ; ; )
  {
   /* Optionsfeld einlesen */
   if ( fread(info,1,sizeof(info),fil) != sizeof(info) ) return 0;
   /* Ende einer Liste erkennen */
   if ( info[2] == ISEOF ) return 1;
   /* Neues Element erzeugen und initialisieren */
   if ( !(cur = (struct CDUelement *)malloc(sizeof(*cur))) ) return 0;
   cur->next = 0;
   cur->prev = *last;
   if ( *last ) (*last)->next = cur;
   if ( !*first ) *first = cur;
   *last = cur;
   cur->name = 0;
   cur->flags = info[0];
   cur->sep = info[1];
   cur->qualifier = cur->lastqual = 0;
   cur->islist = (info[2]&ISLIST) ? 1 : 0;
   cur->Value = 0;
   cur->List = cur->last = 0;
   cur->isdiscarded = 0;
   cur->isparameter = (info[2]&ISPARAMETER) ? 1 : 0;
   /* Name und Subelemente oder Wert einlesen */
   if ( info[2]&HASNAME )
    {
     if ( !(cur->name = readString(fil,2)) ) return 0;
     if ( cur->name == (char *)-1 ) cur->name = 0;
     if ( (info[2]&HASLIST) && !readAll(fil,&cur->List,&cur->last) ) return 0;
    }
   else if ( info[2]&HASVALUE )
    {
     if ( (cur->flags&CDU_ALL) == CDU_DEF )
      cur->Value = readString(fil,2);
     else
      cur->Value = readString(fil,1);
     if ( !cur->Value ) return 0;
     if ( cur->Value == (char *)-1 ) cur->Value = 0;
    }
   /* Qualifier einlesen */
   if ( (info[2]&HASQUALIFIER) && !readAll(fil,&cur->qualifier,&cur->lastqual) )
    return 0;
  }
}

/*
  Liste von Werten in einer Zeichenkette zusammenstellen.
*/
static addList(base,ret,rlen,qual)
struct CDUelement *base;
char **ret;
int *rlen,qual;
{
 int len,done = 0,more;
 char sep = '\0';

 /* Alle non-DEFAULT Elemente durchgehen */ 
 for ( ; base && ((base->flags&CDU_ALL) != CDU_DEF) ; base = base->next )
  {
   if ( base->isdiscarded ) continue;
   sep = '\0';
   /* Eventuell Trennzeichen ausgeben */
   if ( !done && !qual )
    {
     if ( !addWord(" ",1,ret,rlen) ) return 0;
     done = 1;
    }
   /* Name vorhanden */
   if ( base->name )
    {
     /* Trennzeichen fuer Qualifier */
     if ( (qual == 1) && !addWord("/",1,ret,rlen) ) return 0;
     /* Negation */
     if ( ((base->flags&CDU_ALL) == CDU_NEG) && !addWord("NO",2,ret,rlen) )
      return 0;
     /* Name in den String schreiben */
     if ( !addWord(base->name,0,ret,rlen) ) return 0;
     /* Liste mit allen Trennzeichen ausgeben */
     if ( base->islist && base->List )
      {
       more = (base->List->next && ((base->List->next->flags&CDU_ALL) != CDU_DEF));
       if ( !addWord("=",1,ret,rlen) ) return 0;
       if ( more && !addWord("(",1,ret,rlen) ) return 0; 
       if ( !addList(base->List,ret,rlen,2) ) return 0;
       if ( more && !addWord(")",1,ret,rlen) ) return 0; 
      }
    }
   /* Wert ausgeben. Dieser muss eventuell in frame.p interpretiert werden */
   else if ( !attachValue(base->Value,ret,rlen) )
    return 0;
   /* Liste der Qualifier */
   if ( base->qualifier && !addList(base->qualifier,ret,rlen,1) ) return 0;
   /* Trennzeichen zwischen Elementen einer Liste */
   if ( (sep = base->sep) && !addWord(&sep,1,ret,rlen) ) return 0;
  }
 /* Kommas am Ende sind unschoen */ 
 if ( sep ) 
  {
   (*ret)--;
   (*rlen)++;
  }
 /* Alles klar */
 return 1;
}

/*
  Ein Wort eintragen. Diese Routine wird auch von frame.p benutzt.
*/
addWord(str,slen,ret,rlen)
char *str,**ret;
int slen,*rlen;
{
 if ( !slen ) slen = strlen(str);
 if ( (*rlen -= slen) < 0 ) return 0;
 bcopy(str,*ret,slen);
 *ret += slen;
 return 1;
}

/*
  Dem Benutzer zugaengliche Routinen.
*/

/*
  Die Arbeit von CLI$DCL_PARSE vollzieht sich in folgenden Schritten:
  	1. Parsertabelle laden
	   nach dem ersten Laden wird die CDU-Parsertabelle globale vermerkt
	   und muss natuerlich nicht mehr nachgeladen werden
	2. Befehlszeile einlesen
	   Ist keine Befehlszeile 'cmd' angegeben, so versucht die Routine
	   eine Zeile ueber die 'readpro' Routine zu erhalten. Die Zeile
	   wird in jedem Fall in das lokale Feld 'line' kopiert und in das
	   C-Format umgesetzt. Die angegebene Zeile darf nicht mehr als 256
	   Zeichen haben. Zeilen die mit einem '-' enden werden durch weitere
	   Eingaben ergaenzt, solange die totale Zeilenlaenge 1024 Zeichen
	   nicht ueberschreitet.
	3. Freigabe der Strukturen des vorherigen Aufrufs
    	4. Voranalyse der Befehlszeile
	   Kommentar- und Leerzeilen werden erkannt. Das VERB der Zeile wird
	   erkannt und in einer lokalen Variablen bereitgestellt
	5. VERB finden
	   In der globalen VERB Tabelle wird das VERB und die dazugehoerige
	   Parsertabelle lokalisiert. Die Eindeutigkeit eines VERBs in den
	   ersten vier Zeichen wird dabei beruecksichtigt.
	6. Analyse der Befehlszeile
	   Der Rest der Befehlszeile wird gemaess der Definition des VERBs
	   untersucht und die Ergebnisse in einer Struktur abgelegt, die
	   CLI$DCL_PARSE ueber die Routine 'RearrangeRoot' erhaelt.
	7. Fehlende Parameter einlesen
	   Fehlen als REQUIRED markierte Parameter oder werden non-REQUIRED
	   Parameter im Zuge der Fortsetzung der REQUIRED Parameter eingelesen,
	   so wird versucht, diese Parameter ueber 'readpar' zu erhalten. Die
	   Befehlszeile wird dann neu analysiert bis alle Parameter eingelesen
	   sind oder der Benutzer eine Leerzeile zurueck liefert
	8. DISALLOWs auswerten
	   Verbotenen Kombinationen von Parameter und Qualifiern werden erkannt
	   und es erfolgt eine Fehlermeldung
*/
cli$dcl_parse_(cmd,table,readpar,readpro,prompt,clen,plen)
char *cmd,*prompt;
struct CDUtable *table;
int (*readpar)(),(*readpro)();
int clen,plen;
{
 static char line[257],all[COMMAND_MAXLENGTH],verb[5],hprompt[64];
 int res,ix,len,min,max,act,ip = 0,ic = 0,parget = 0,stop,errc,spc;
 struct CDUelement *RearrangeRoot();
 static struct epcbCDU *cpcb = 0;
 struct CDUverbtab *cur,*chk;
 short *scan;
 char c;

 /* Alte Werte loeschen */
 if ( Tree && (!ImageTable || (Tree != tree0)) ) FreeTree(Tree);
 Tree = 0;
 VTab = 0;
 /* CDUverbtab initialisieren */
 if ( cmd || readpro )
  res = loadCDU(table);
 else if ( res = loadImage() )
  return CLI$_NORMAL;
 if ( !res ) return CLI$_INVTAB;
 Table = table;
 /* Befehlszeile und Prompt wie uebergeben ermitteln */
 if ( cmd )
  {
   if ( ((ic = clen) < 0) || (ic > sizeof(line)-1) ) return CLI$_NOCOMD;
   bcopy(cmd,all,ic);
  }
 all[ic] = '\0';
 hprompt[0] = '_';
 if ( prompt )
  {
   ip = cmd ? plen : clen;
   if ( (ip < 0) || (ip > sizeof(hprompt)-2) ) return CLI$_NOCOMD;
   bcopy(prompt,hprompt+1,ip);
  }
 hprompt[ip+1] = '\0';
 /* Befehlszeile vervollstaendigen */
 for ( ; ; )
  { 
   if ( cmd )
    {
     /* - am Ende suchen */
     if ( (ix = contmode(cmd,ic)) == -1 ) break;
     ic = ix;
     ix = 0;
    }
   else
    ix = 1;
   if ( !readpro ) return CLI$_NOCOMD;
   res = (*readpro)(line,hprompt+ix,&len,sizeof(line),ip+1-ix);
   if ( !(res&1) ) return res;
   if ( (ic+len) > sizeof(all)-1 ) return CLI$_NOCOMD;
   bcopy(line,all+ic,len);
   (cmd = all)[ic += len] = '\0';
  }
 /* VERB mit Preparser lokalisieren */
 if ( parse(CMDpcb,all) ) return CLI$_EXPSYN;
 if ( !CMDpcb->pcb_symbol.text ) return CLI$_NORMAL;
 /* DCL ersetzte Symbole und kann die Laenge der Zeichenkette veraendern */
 ic = strlen(all);
 /* Signifikantes Prefix des VERBs ermitteln */
 bzero(verb,sizeof(verb));
 if ( (len = CMDpcb->pcb_symbol.len) > 4 ) len = 4;
 for ( ix = len ; ix-- ; )
  {
   if ( ((c = CMDpcb->pcb_symbol.text[ix]) >= 'a') && (c <= 'z') )
    c += 'A'-'a';
   verb[ix] = c;
  }
 /* VERB gemaess table->verbs mit PCB assoziieren */
 for ( min = 0, max = table->verbs, errc = CLI$_IVVERB ; ; )
  {
   cur = table->vtab+(act = (min+max)>>1);
   res = strcmp(verb,cur->name);
   if ( !res ) break;
   if ( res > 0 )
    {
     if ( min == act ) return errc;
     min = act+1;
    } 
   else
    {
     for ( ix = len ; ix-- && (cur->name[ix] == verb[ix]) ; );
     if ( ix < 0 )
      {
       /* Eindeutigkeit sicherstellen */
       if ( len == 4 ) break;
       stop = 1;
       if ( act > 0 )
        {
	 chk = cur-1;
         for ( ix = len ; ix-- && (chk->name[ix] == verb[ix]) ; );
 	 if ( ix < 0 ) stop = 0;
 	}
       if ( stop && (act < table->verbs-1) )
	{
	 chk = cur+1;
         for ( ix = len ; ix-- && (chk->name[ix] == verb[ix]) ; );
 	 if ( ix < 0 ) stop = 0;
	}
       if ( stop ) break;
       errc = CLI$_ABVERB;
      }
     if ( max == act ) return errc;
     max = act;
    }  
   if ( min >= max ) return errc; 
  }
 /* Rest der Befehlszeile auswerten */
 while ( !(res = parse(cpcb = (VTab = cur)->pcb,CMDpcb->sys_pcb.pcb_line)) )
  {
   /* Interne Form der Eingabezeile ermitteln, BATCH-Qualifier evt. entfernen */
   vms$lex_f$mode_(line,&len,sizeof(line)); 
   Tree = RearrangeRoot(cpcb,(len == 5) && !bcmp(line,"BATCH",5));
   /* Zahl der Parameter ermitteln */
   if ( !cpcb->pcb_parameter )
    {
     if ( Tree )
      {
       FreeTree(Tree->next);
       Tree->next = 0;
      }
     break;
    }
   /* Nach REQUIRED Parametern suchen */
   scan = index(cpcb,cpcb->pcb_parameter);
   scan++;
   if ( cpcb->pcb_parcount >= *scan++ ) break;
   scan++;
   SKIPTEXT(scan);
   SKIPTEXT(scan);
   SKIPDIS(scan);
   for ( ix = cpcb->pcb_parcount, ip = 0 ; ; )
    {
     if ( !*scan ) 
      {
       scan++;
       ip = 1;
      }
     if ( !ix-- ) break;
     SKIPPROMPT(scan);
    }
   if ( *scan == -1 ) scan = index(cpcb,(unsigned short)scan[1]);
   if ( ip && !parget ) break;
   /* Alte Ergebnisse freigeben */
   FreeTree(Tree);
   Tree = 0;
   VTab = 0;
   if ( !readpar ) return CLI$_NOCOMD;
   /* Prompt vorbereiten und Parameter einlesen */
   len = strlen(scan);
   if ( len > (sizeof(hprompt)-4) ) return CLI$_INVTAB;
   strcpy(hprompt,"__");
   strcpy(hprompt+2,(char *)scan);
   strcat(hprompt+2,": ");
   /* Solange eine Fortsetzungszeile erwuenscht ist */
   for ( spc = 1 ; ; spc = 0 )
    {
     res = (*readpar)(line,hprompt+spc,&len,sizeof(line),strlen(hprompt+spc));
     if ( !(res&1) ) return res;
     /* Fortsetzungszeile ermitteln */
     if ( (ix = contmode(line,len)) != -1 ) len = ix;
     /* Neuen Wert an die Zeile haengen */
     if ( len || spc )
      {
       if ( spc ) all[ic++] = ' ';
       if ( (ic+len) > sizeof(all)-1 ) return CLI$_NOCOMD;
       bcopy(line,all+ic,len);
       all[ic += len] = '\0';
      }
     /* Parameter bestimmen */
     if ( ix == -1 )
      {
       for ( ix = 0 ; (ix < len) && ((line[ix] == ' ') || (line[ix] == '\t')) ; ix++ );
       parget = (ix < len);
       /* Fertig */
       break;
      }
    }
  }
 /* Bei Fehlern sofort abbrechen */
 if ( res )
  {
   VTab = 0;
   return translateError(res);
  }
 /* Schluesselworttabellen suchen */
 PKeys = 0;
 if ( cpcb->pcb_parameter )
  {
   scan = index(cpcb,cpcb->pcb_parameter);
   scan += 3;
   SKIPTEXT(scan);
   SKIPTEXT(scan);
   SKIPDIS(scan);
   SKIPPROMPTS(scan);
   PKeys = index(cpcb,(unsigned short)*scan++);
  }
 QKeys = 0;
 if ( cpcb->pcb_qualifier )
  if ( cpcb->pcb_qualifier == cpcb->pcb_parameter )
   QKeys = index(cpcb,(unsigned short)*scan);
  else
   {
    scan = index(cpcb,cpcb->pcb_qualifier);
    scan += 3;
    SKIPTEXT(scan);
    SKIPTEXT(scan);
    SKIPDIS(scan);
    SKIPPROMPTS(scan);
    QKeys = index(cpcb,(unsigned short)*++scan);
   }  
 /* Image setzen */
 if ( Image = (char *)cpcb->pcb_image )
  Kind = Image-2;
 else
  {
   Image = cur->parent;
   Kind = 0;
  }
 /* Disallows suchen und auswerten */
 Tail = 0;
 GetV = BADEL;
 if ( cpcb->pcb_disallows )
  {
   scan = (short *)cpcb->pcb_disallows;
   if ( (*scan != -1) && !processDisallows(index(cpcb,0),scan) )
    {
     VTab = 0;
     return CLI$_EXPSYN;
    }
  }
 /* Ergebnis eventuell mit Warnung melden */
 return cpcb->pcb_discarded ? CLI$_PARMDEL : CLI$_NORMAL;
}

/* 
  Mode des letzten Zeichens ermitteln.
*/
static contmode(str,len)
char *str;
int len;
{
 int mode,ix;

 /* Alle Zeichen */
 for ( mode = 0, ix = 0 ; ix < len ; )
  {
   /* Kommentar */
   if ( !mode && (str[ix] == '!') ) return -1;
   /* Zeichenkette */
   if ( str[ix++] == '"' ) mode = !mode;
  }
 /* Fertig, falls Ende innerhalb einer Zeichenkette */
 if ( mode ) return -1;
 /* Fortsetzungszeile ermitteln */
 for ( ix = len ; ix-- && ((str[ix] == ' ') || (str[ix] == '\t')) ; );
 if ( (ix < 0) || (str[ix] != '-') ) return -1;
 /* Laenge melden */
 return ix;
}

/*
  Nachsehen, ob ein bestimmtes Element eingegeben wurde.
*/
cli$present_(ent,elen)
char *ent;
int elen;
{
 struct CDUelement *found;
 int isloc;

 /* Erst mal nachsehen, ob ueberhaupt eine Tabelle vorliegt */
 if ( !VTab && !loadImage() ) return CLI$_INVTAB;
 /* Initialisieren des urspruenglichen Kontext */
 if ( GetV == BADEL ) GetV = 0;
 /* Suchen nach dem Element */
 if ( found = umatch(ent,elen) )
  if ( found == BADEL )
   /* Schluesselwortliste illegal */
   return CLI$_IVKEYW;
  else
   {
    /* Je nach Situation Rueckgabewert suchen */
    isloc = (((found->flags&CDU_POS) != CDU_GLOBAL) && GetV);
    switch (found->flags&CDU_ALL)
     {
      case CDU_NEG : return isloc ? CLI$_LOCNEG : CLI$_NEGATED;
      case CDU_DEF : return CLI$_DEFAULTED;
      default      : return isloc ? CLI$_LOCPRES : CLI$_PRESENT;   
     }
   }
 /* Ist legal, aber nicht gefunden */
 return CLI$_ABSENT;
}

/*
  Auslesen des Wertes eines bestimmten Elementes. Die besonderen Schluessel-
  worte $VERB und $LINE werden separat behandelt.
*/
cli$get_value_(ent,ret,len,elen,rlen)
char *ent,*ret;
int *len,elen,rlen;
{
 static char *spc[2] = { "verb", "line" };
 struct CDUelement *found;
 int ix,clen,isloc;
 char *from,ch;

 /* Ergebnisfeld initialisieren */
 memset(ret,' ',rlen);
 if ( len ) *len = 0;
 /* Nachsehen, ob ueberhaupt eine Information vorliegt */
 if ( !VTab && !loadImage() ) return CLI$_INVTAB;
 /* Spezialfaelle untersuchen */
 from = ent;
 if ( (elen == 5) && (*from++ == '$') )
  {
   /* $VERB und $LINE identifizieren */
   for ( clen = 0, ix = -1 ; clen < 4 ; clen++ )
    {
     if ( ((ch = *from++) >= 'A') && (ch <= 'Z') ) ch += 'a'-'A';
     if ( ix == -1 )
      for ( ix = 2 ; ix-- && (ch != spc[ix][clen]) ; );
     else if ( ch != spc[ix][clen] )
      ix = -1;
     if ( ix == -1 ) break; 
    }
   if ( ix != -1 )
    {
     /* $VERB uerbertragen */
     clen = rlen; 
     if ( !addWord(VTab->parent,0,&ret,&rlen) ) return CLI$_STRTOOLNG;
     if ( ix && Tree )
      {
       /* $LINE zusammensetzen */
       if ( !addList(Tree->qualifier,&ret,&rlen,1) ) return CLI$_STRTOOLNG; 
       for ( found = Tree ; found = found->next ; )
        {
         if ( (found->flags&CDU_ALL) == CDU_DEF ) break;
	 if ( !addList(found->List,&ret,&rlen,0) ) return CLI$_STRTOOLNG;
        }	 
      }
     if ( len ) *len = clen-rlen; 
     return CLI$_NORMAL;
    }
  }
 /* Initialialen Kontext setzen, wenn noetig */
 if ( GetV == BADEL ) GetV = 0;
 /* Element lokalisieren */
 if ( found = umatch(ent,elen) )
  if ( found == BADEL )
   return CLI$_IVKEYW;
  else
   {
    /* Kontext aktualisieren */
    if ( found->isparameter ) GetV = found;
    /* Naechsten Wert der Liste identifizieren */
    if ( !found->islist || !found->List ) return CLI$_ABSENT;
    if ( !found->current )
     {
      found->current = found->List;
      if ( found->current->next )
       found = found->current;
      else
       {
	found->current = 0;
	found = found->List;
       }
     }
    else if ( !(found->current = found->current->next) )
     return CLI$_ABSENT;
    else
     found = found->current;
    /* Schluesselwortname oder aktuellen Wert ermitteln */
    if ( found->name )
     from = found->name;
    else
     from = found->Value;
    /* Text ins Ergebnisfeld kopieren */
    if ( (clen = strlen(from)) > rlen ) return CLI$_STRTOOLNG;
    bcopy(from,ret,clen);
    if ( len ) *len = clen;
    /* Korrekten Rueckgabewert liefern */
    switch (found->sep)
     {
      case ',' : return CLI$_COMMA;
      case '+' : return CLI$_CONCAT;
      default  : return CLI$_NORMAL;
     }
   } 
 /* Wert ist nicht vorhanden */ 
 return CLI$_ABSENT;
}

/*
  Ausgewaehlte Routine aufrufen.
*/
cli$dispatch_(userpar)
int userpar;
{
 struct MAP *map;
 int msize = 0;

 /* Gibt es eine geparste Eingabezeile ? */
 if ( !VTab ) return CLI$_NORMAL;
 if ( VTab == vtab0 ) return CLI$_INVROUT;
 /* Mal sehen, was fuer eine Art von Routine wir haben */
 if ( CLIimage = (!Kind || !bcmp(Kind,"IM",2)) )
  {
   /* IMAGE aktivieren */
   return callImage();
  }
 else
  {
   if ( !bcmp(Kind,"RO",2) )
    {
     /* ROUTINE benutzerprogramm */
     map = Table->map;
     msize = Table->msize;
    }
   else if ( !bcmp(Kind,"CR",2) )
    {
     /* CLIROUTINE systemprogramm */
     map = CLIcallmap;
     msize = nCLIcallmap;
    }
   /* Routine lokalisieren */
   while ( msize-- && strcmp((map++)->name,Image) );
   if ( msize < 0 ) return CLI$_INVROUT;
   /* Routine aufrufen */
   (*map[-1].entry)(userpar); 
   return CLI$_NORMAL;
  }
} 
