#!/usr/bin/csh

#
# Befehl mit Abfrage auf Fehler ausfuehren
#
alias check  '\!* ; if ( $status != 0 ) exit $status'
alias action 'echo "+++" \!*'
alias error  'echo "***" \!*'

#
# Umgebung
#
set nonomatch
set path = (. $path)

#
# Defaults setzen
#
if ( ! $?BINDIR ) then
  set BINDIR = /usr/bin
endif
if ( ! $?LIBDIR ) then
  set LIBDIR = /usr/lib
endif
if ( ! $?INCDIR ) then
  set INCDIR = /usr/include
endif

if ( ($#argv >= 2) && ("$2" != "") ) then
  set DIRDEF = "$2"
else if ( ! $?DIRDEF ) then
  set DIRDEF = saphir
endif
if ( ($#argv >= 3) && ("$3" != "") ) then
  set INCDEF = "$3"
else if ( ! $?INCDEF ) then
  set INCDEF = modules
endif
    
#
# cld.csh header|objects [(DIRDEF|"") [INCDEF]]
#
# DIRDEF ist der Projektname. Er darf nur Buchstaben, Zahlen und _
# enthalten
#
if ( "$DIRDEF" == "" ) then
  error no project name given 
#
# Kurze Erklaerung
#
USAGE:
  cat << EOF
*** 
*** 
***  USAGE: $0 header|objects [(DIRDEF|"") [INCDEF]]
*** 
***    header  will create the basic header files
***    objects will create library objects after installing all modules
***    DIRDEF  is the name of the project (saphir)
***    INCDEF  is the name of the module directory (modules)
*** 
*** 
EOF
  exit 1
endif
echo "$DIRDEF" | grep > /dev/null '[^A-Za-z0-9_]'
if ( $status == 0 ) then
  error project name '"'"$DIRDEF"'"' must be built from A-Za-z0-9_
  goto USAGE
endif

#
# INCDEF ist ein Unterverzeichnis in $INCDIR. Es muss immer mit einem 
# / beginnen und enden.
#
if ( "$INCDEF" == "" ) then
  set INCDEF = /
else
  set key = `echo "$INCDEF" | sed -n 's/^\(.\).*$/\1/p'`
  if ( "$key" != "/" ) then
    set INCDEF = /"$INCDEF"
  endif
  set key = `echo "$INCDEF" | sed -n 's/^.*\(.\)$/\1/p'`
  if ( "$key" != "/" ) then
    set INCDEF = "$INCDEF"/
  endif
endif

#
# Informationen anzeigen
#
set LIBDIR1 = "$INCDIR"/"$DIRDEF"
set LIBDIR2 = `echo "$LIBDIR1$INCDEF" | sed -n 's/^\(.*\)\/$/\1/p'`
set OBJLIB = "$LIBDIR"/lib"$DIRDEF".a
cat << EOF
+++
+++  directory for executables      =   $BINDIR
+++  directory for includes         =   $INCDIR
+++  directory for libraries        =   $LIBDIR
+++
+++  project include directory      =   $LIBDIR1
+++  project object library         =   $OBJLIB
+++  parser module directory        =   $LIBDIR2
+++
EOF

#
# Systemdirectories suchen
#
if ( ! -d "$BINDIR" ) then
  error directory "$BINDIR" for executable does not exist
  exit 1
endif
if ( ! -d "$INCDIR" ) then
  error directory "$INCDIR" for includes does not exist
  exit 1
endif
if ( ! -d "$LIBDIR" ) then
  error directory "$LIBDIR" for libraries does not exist
  exit 1
endif

#
# Systemdirectories erzeugen
#
if ( ! -d "$LIBDIR1" ) then
  action creating project include directory "$LIBDIR1"
  check mkdir "$LIBDIR1"
endif
if ( ! -d "$LIBDIR2" ) then
  action creating parser module directory "$LIBDIR2"
  check mkdir "$LIBDIR2"
endif

#
# Befehl auswerten
#
if ( "$1" == "header" ) then
#
# Aufrauemen
#
  set CLEAN="frame.[cht] CHARACTERSTRING.[ch]"
  action cleaning up
  rm -f $CLEAN
#
# Headerdateien kopieren
#
  action copying general header files
  check cp CLI.h CLI.INC CLI.csh CLIdef.h CLD.h $LIBDIR1
  action creating specific header files
  check make frame.c CHARACTERSTRING.c
  action copying specific header files
  check cp frame.h CHARACTERSTRING.h $LIBDIR2
#
# Aufraeumen
#
  action cleaning up
  rm -f $CLEAN
#
# Fertig
#
  action command language definition header installation complete
else if ( "$1" == "objects" ) then
#
# Aufrauemen
#
  set CLEAN="frame.[chto] command.[cho] DCL.[ch] clilib.o"
  action cleaning up
  rm -f $CLEAN
#
# Dateien erzeugen
#
  action creating objects
  check make frame.o command.o DCL.c clilib.o
#
# Dateien kopieren
#
  action copying objects
  check ar rv $OBJLIB frame.o command.o clilib.o

#
# Aufraeumen
#
  action cleaning up
  rm -f $CLEAN
#
# Fertig
#
  action command language definition library installation complete
else
  goto USAGE
endif

