#include "CDU.h"

/*
  Bearbeite alle in der aktuellen Zeile angefallenen Optionen. Da der
  Buffer der Zeile vermutlich bald mit dem Inhalt der naechsten Zeile
  aus der CDU-Eingabedatei ueberschrieben wird, muessen alle Zeichen-
  ketten an einen sicheren Ort kopiert werden.
*/
ProcessFlags(pcb)
REGISTER struct epcbDCL *pcb;
{
 ProcessStateFlags(pcb);
 ProcessValueFlags(pcb);
 ProcessIDFlags(pcb);
 switch (pcb->pcb_smState)
  {
   case smsSyntax :
   case smsVerb   : ProcessVerbFlags(pcb);
		    if ( (pcb->pcb_vState != vsStart) && !curname &&
		         (strlen(curname = dtoa(pcb->pcb_smName)) > 31) )
		     if ( pcb->pcb_smState == smsSyntax )
		      toolong("SYNTAX",31,0L);
		     else
		      toolong("VERB",31,0L);
		    break;
   case smsType   : if ( (pcb->pcb_tState != tsStart) && !curname &&
		         (strlen(curname = dtoa(pcb->pcb_smName)) > 31) )
		     toolong("TYPE",31,0L);
		    break;
  }
}

/*
  Neue Top-Level Optionen auswerten.
*/
static ProcessStateFlags(pcb)
REGISTER struct epcbDCL *pcb;
{
 REGISTER long todo;

 todo = pcb->pcb_smFlags&(~statedone);
 if ( todo )
  {
   statedone |= todo;
   if ( ((todo&smfModule) == smfModule) &&
        (strlen(module = dtoa(pcb->pcb_smModule)) > 31) )
    toolong("MODULE",31,0L);
   if ( ((todo&smfIdent) == smfIdent) &&
        (strlen(ident = dtoa(pcb->pcb_smIdent)) > 31) )
    toolong("IDENT",31,0L);
  }
}

/*
  Optionen eines VALUE Statements auswerten.
*/
static ProcessValueFlags(pcb)
REGISTER struct epcbDCL *pcb;
{
 REGISTER long todo;

 todo = pcb->pcb_vcFlags;
 if ( curval ) todo &= ~curval->flags;
 if ( todo )
  {
   newval();
   curval->flags |= todo;
   if ( ((todo&vcfDEF) == vcfDEF) &&
        (strlen(curval->defval = dtoa(pcb->pcb_vcDefault)) > 95) )
    toolong("DEFAULT",95,0L);
   if ( (todo&vcfTYP) == vcfTYP ) curval->typename = dtoa(pcb->pcb_vcType);
  }
}

/*
  Struktur fuer das aktuelle VALUE Statement erzeugen, falls noch nicht
  vorhanden.
*/
static newval()
{
 if ( curval ) return;
 if ( !(curval = MALLOC(struct Value,1)) ) nomem();
 curval->flags = curval->pflags = 0;
 curval->typename = curval->defval = 0;
 curval->type = 0;
 curval->predef = -1;
 curval->psyntax = 0;
 curval->ispar = curval->caddr = curval->daddr = 0;
}

/*
  Optionen eines Parameters, Qualifiers oder Schluesselwortes auswerten.
*/
static ProcessIDFlags(pcb)
REGISTER struct epcbDCL *pcb;
{
 REGISTER long todo;

 todo = pcb->pcb_idFlags;
 if ( curid ) todo &= ~curid->flags;
 if ( todo )
  {
   newid();
   curid->flags |= todo;
   if ( ((todo&idfLAB) == idfLAB) &&
        (strlen(curid->label = dtoa(pcb->pcb_idLabel)) > 31) )
    toolong("LABEL",31,0L);
   if ( ((todo&idfPRO) == idfPRO) &&
        (strlen(curid->prompt = dtoa(pcb->pcb_idPrompt)) > 31) )
    toolong("PROMPT",31,0L);
   if ( (todo&idfSYN) == idfSYN ) curid->synname = dtoa(pcb->pcb_idSyntax);
   if ( (todo&idfVAL) == idfVAL )
    {
     newval();
     curid->value = curval;
     curval->pflags = curid->flags;
    }
   if ( (todo&idfNAM) == idfNAM )
    {
     if ( strlen(curid->name = dtoa(pcb->pcb_vParameter)) > 31 )
      if ( (todo&idfPAR) == idfPAR )
       toolong("PARAMETER",31,0L);
      else
       toolong("QUALIFIER",31,0L);
    }
   else if ( ((todo&idfKEY) == idfKEY) &&
             (strlen(curid->name = dtoa(pcb->pcb_tKeyword)) > 31) )
    toolong("KEYWORD",31,0L);
  } 
}

/*
  Speicherbereich fuer den aktuelle Parameter, Qualifier oder Schluessel-
  wort erzeugen, falls noch nicht vorhanden.
*/
static newid()
{
 if ( curid ) return;
 if ( !(curid = MALLOC(struct Parameter,1)) ) nomem();
 curid->flags = 0;
 curid->name = curid->label = curid->prompt = curid->synname = 0;
 curid->value = curid->optval = 0;
 curid->syntax = 0;
 curid->caddr = curid->naddr = curid->laddr = curid->xaddr = 0;
}

/*
  Optionen eines VERBs oder einer SYNTAX auswerten.
*/
static ProcessVerbFlags(pcb)
REGISTER struct epcbDCL *pcb;
{
 REGISTER long todo;
 REGISTER struct Synonym *s;
 REGISTER char *lw,c;

 todo = pcb->pcb_vFlags;
 if ( curverb ) todo &= ~curverb->flags;
 if ( todo )
  {
   newverb();
   curverb->flags |= (todo&~vfSYN);
   if ( ((todo&vfCLI) == vfCLI) || ((todo&vfIMA) == vfIMA) ||
   	((todo&vfROU) == vfROU) )
    {
     curverb->image = dtoa(pcb->pcb_vImage);
     if ( (todo&vfIMA) == vfIMA )
      {
       if ( strlen(curverb->image) > 63 ) toolong("IMAGE",63,0L);
      }
     else if ( strlen(curverb->image) > 31 )
      if ( (todo&vfROU) == vfROU )
       toolong("ROUTINE",31,0L);
      else
       toolong("CLIROUTINE",31,0L);
     else if ( (todo&vfROU) == vfROU )
      for ( lw = curverb->image ; c = *lw++ ; )
       if ( (c >= 'A') && (c <= 'Z') )
	lw[-1] += 'a'-'A';
    }
   if ( (todo&vfPRE) == vfPRE ) curverb->prefix = dtoa(pcb->pcb_vPrefix);
   if ( (todo&vfSYN) == vfSYN )
    {
     if ( !(s = MALLOC(struct Synonym,1)) ) nomem();
     s->next = curverb->synonym;
     curverb->synonym = s;
     if ( strlen(s->text = dtoa(pcb->pcb_vSynonym)) > 31 )
      toolong("SYNONYM",31,0L);
     pcb->pcb_vFlags &= ~vfSYN;
    }
  } 
}

/*
  Aktuelles VERB oder SYNTAX erzeugen, falls nocht nicht vorhanden.
*/
static newverb()
{
 if ( curverb ) return;
 if ( !(curverb = MALLOC(struct Verb,1)) ) nomem();
 curverb->isverb = curverb->flags = 0;
 curverb->name = curverb->image = curverb->prefix = 0;
 curverb->synonym = 0;
 curverb->parameter = curverb->qualifier = 0;
 curverb->disallow = 0;
 curverb->verb = 0;
 curverb->npar = curverb->nqual = curverb->nneg = 0;
 curverb->ndval = curverb->ndef = curverb->pdef = curverb->caddr = 0;
 curverb->saddrP = curverb->saddrQ = curverb->iaddr = 0;
}

/*
  Aktuelles TYPE erzeugen, falls nocht nicht vorhanden. Es gibt keinerlei
  Optionen auf der Ebene einer TYPE Definition, darum entfaellt eine ent-
  sprechende Bearbeitungsroutine.
*/
static newtype()
{
 if ( curtype ) return;
 if ( !(curtype = MALLOC(struct Type,1)) ) nomem();
 curtype->name = 0;
 curtype->keyword = 0;
 curtype->verb = 0;
 curtype->nkey = curtype->ndef = curtype->ndval = curtype->nneg = 0;
 curtype->caddr = curtype->daddr = 0;
}

/*
  Ein PARAMETER oder QUALIFIER Statement ist beendet. Nun muessen alle
  angegebenen Optionen auf Konsistenz ueberprueft und die aktuelle Struktur
  in das gerade aktuelle VERB oder die aktuelle SYNTAX eingetragen werden.
*/
ProcessParameter(pcb)
struct epcbDCL *pcb;
{
 if ( !curid ) return;
 newverb();
 if ( (curid->flags&idfPAR) == idfPAR )
  {
   curid->next = curverb->parameter;
   curverb->parameter = curid;
   curverb->npar++;
   curid->flags |= idfVAL;
   newval();
   curval->ispar = 1;
   curid->value = curval;
   curval->pflags = curid->flags;
   if ( (curid->flags&idfDEF) == idfDEF ) curverb->pdef++;
   checkIDs();
   if ( (curid->flags&idfNEG) == idfNEG )
    error("NEGATABLE nicht erlaubt fuer Parameter",0L);
   if ( (curid->flags&idfNNE) == idfNNE )
    error("NONNEGATABLE nicht erlaubt fuer Parameter",0L);
   if ( (curid->flags&idfSYN) == idfSYN )
    error("SYNTAX nicht erlaubt fuer Parameter",0L);
  }
 else
  {
   curid->next = curverb->qualifier;
   curverb->qualifier = curid;
   curverb->nqual++;
   if ( ((curid->flags&idfDEF) == idfDEF) ||
        ((curid->flags&idfBAT) == idfBAT) )
    if ( curid->value )
     curverb->ndval++;
    else
     curverb->ndef++;
   if ( (curid->flags&idfNNE) != idfNNE )
    {
     curverb->nneg++;
     curid->flags |= idfNEG;
    }
   ValidateValue();
 }
}

/*
  Test auf Optionen, die Parameter und Schluesselworte nicht haben duerfen.
*/
static checkIDs()
{
 if ( (curid->flags&idfBAT) == idfBAT )
  error("BATCH nur fuer Qualifier erlaubt",0L);
 if ( ((curid->flags&idfLOC) == idfLOC) ||
      ((curid->flags&idfGLO) == idfGLO) ||
      ((curid->flags&idfPOS) == idfPOS) )
  error("PLACEMENT nur fuer Qualifier erlaubt",0L);
}

/*
  Die Definition eines einzelnen Schluesselwortes ist abgeschlossen. Die
  Optionen werden auf Legalitaet ueberprueft und das neue Schluesselwort
  in der Liste des aktuellen TYPEs vermerkt.
*/
ProcessKeyword(pcb)
struct epcbDCL *pcb;
{
 if ( !curid ) return;
 newtype();
 curid->next = curtype->keyword;
 curtype->keyword = curid;
 curtype->nkey++;
 if ( (curid->flags&idfNEG) == idfNEG ) curtype->nneg++;
 checkIDs();
 ValidateValue();
 if ( (curid->flags&idfDEF) == idfDEF )
  if ( curid->value )
   curtype->ndval++;
  else
   curtype->ndef++;
}

/*
  Ueberpruefung der Optionen eines VALUE Statements. Da diese Routine
  nur von Qualifiern uns Schluesselworten aufgerufen wird, kann sie
  gleichzeitig noch das Nichtvorhandensein eines Prompts feststellen.
*/
static ValidateValue()
{
 if ( ((curid->flags&idfPRO) == idfPRO) )
  error("PROMPT nur fuer PARAMETER erlaubt",0L);
 if ( !curid->value ) return;
 if ( (curid->value->flags&vcfCON) == vcfCON )
  error("CONCATENATE ist nur fuer Parameter zulaessig",0L);
 if ( (curid->value->flags&vcfIMP) == vcfIMP )
  error("IMPCAT ist nur fuer Parameter zulaessig",0L);
 if ( (curid->value->flags&vcfNCO) == vcfNCO )
  error("NOCONCATENATE ist nur fuer Parameter zulaessig",0L);
}

/*
  Abschluss einer VERB oder SYNTAX Definition. Die Parameter und Qualifier
  werden zum spaeteren Gebrauch alphabetisch sortiert und auf Eindeutig-
  keit ueberprueft. Alle Optionen der Definition werden gegen die CDU-Syntax
  getestet, was auch die Namen der Parameter mit einschliesst. Zuletzt wird
  die aktuelle VERB oder SYNTAX Struktur in die entsprechende globale
  Liste eingetragen.
*/
ProcessVerb(pcb)
struct epcbDCL *pcb;
{
 struct Parameter *p;
 int n,req = 1;

 newverb();
 curverb->CLIflags = pcb->pcb_vCLI;
 if ( pcb->pcb_smState == smsVerb ) curverb->isverb = 1;
 curverb->name = curname;
 if ( sortParameter(&curverb->parameter) == -1 )
  error("PARAMETER doppelt verwendet",0L);
 if ( (n = sortParameter(&curverb->qualifier)) == -1 )
  error("QUALIFIER doppelt verwendet",0L);
 else if ( n > 255 )
  error("Mehr als 255 QUALIFIER angegeben",0L);
 if ( ((curverb->flags&vfNDI) == vfNDI) && curverb->disallow )
  error("DISALLOW und NODISALLOWS gleichzeitig benutzt",0L);
 if ( ((curverb->flags&vfNPA) == vfNPA) && curverb->parameter )
  error("PARAMETER und NOPARAMETERS gleichzeitig benutzt",0L);
 if ( ((curverb->flags&vfNQU) == vfNQU) && curverb->qualifier )
  error("QUALIFIER und NOQUALIFIERS gleichzeitig benutzt",0L);
 if ( curverb->synonym && !curverb->isverb )
  error("SYNONYM ist nur fuer VERBs zulaessig",0L);
 for ( n = '1', p = curverb->parameter ; p ; p = p->next, n++ )
  if ( (p->name[0] != 'P') || (p->name[1] != n) || p->name[2] )
   {
    error("Parameternamen nicht von P1 bis P8: '%s'",p->name);
    break;
   }
  else if ( req )
   req = ((p->flags&vcfREQ) == vcfREQ);
  else if ( (p->flags&vcfREQ) == vcfREQ )
   error("Parameter '%s' darf nicht mehr REQUIRED sein",p->name);
 if ( curverb->isverb )
  addEntry(verb,curverb);
 else
  addEntry(syntax,curverb);
}

/*
  Sortieren einer Liste von Parametern, Qualifiern oder Schluesselworten.
  Ist ein Name doppelt in der Liste, so liefert die Routine eine -1,
  ansonsten die Zahl der Listeneintraege.
*/
static sortParameter(list)
REGISTER struct Parameter **list;
{
 REGISTER struct Parameter **prev,**min,*cur;
 REGISTER int n = 0,cmp;
 int err = 0;

 for ( ; *list ; n++, list = &(*list)->next )
  {
   prev = list;
   for ( min = prev ; *(prev = &(*prev)->next) ; )
    if ( !(cmp = strcmp((*prev)->name,(*min)->name)) )
     err = 1;
    else if ( cmp < 0 )
     min = prev;
   if ( min != list )
    {
     *min = (cur = *min)->next;
     cur->next = *list;
     *list = cur;
    }
  }
 return (err ? -1 : n);
}

/*
  Suchen eines Eintrags in einer der Listen. Durch die quivalenz von
  Adressen auf Strukturen wird hier nur eine Routine fuer alle drei
  Typen von Definitionen verwendet.
*/
struct Verb **getEntry(where,name)
struct Verb **where;
REGISTER unsigned char *name;
{
 REGISTER unsigned char *scan = name,hash = 0;
 REGISTER struct Verb **prev;
 
 while ( *scan ) hash += *scan++;
 prev = where+hash;
 while ( *prev && (strcmp((*prev)->name,(char *)name) < 0) )
  prev = &(*prev)->next;
 return prev;
}

/*
  Eintragen einer Struktur in die Verwaltungslisten. Durch die quivalenz
  von Adressen auf Strukturen wird hier nur eine Routine fuer alle drei
  Typen von Definitionen verwendet.
*/
static addEntry(where,what)
struct Verb **where;
REGISTER struct Verb *what;
{
 REGISTER struct Verb **prev = getEntry(where,what->name);

 if ( *prev && !strcmp((*prev)->name,what->name) )
  {
   error("Definitionsname '%s' mehrfach verwendet",what->name);
   what->next = (*prev)->next;
  }
 else
  what->next = *prev;
 *prev = what;
}

/*
  Abschluss einer TYPE Definition. Die Schluesselworte werden alphabetisch
  sortiert und gegen eine Obergrenze ueberprueft.
*/
ProcessType(pcb)
struct epcbDCL *pcb;
{
 int nkey;

 newtype();
 curtype->name = curname;
 if ( (nkey = sortParameter(&curtype->keyword)) == -1 )
  error("Keywordname doppelt benutzt",0L);
 else if ( nkey > 255 )
  error("Mehr als 255 Keywords benutzt",0L);
 addEntry(type,curtype);
}

/*
  Bei der Bearbeitung eines Ausdrucks ist es notwendig, Namen in eine
  entsprechende Referenzstruktur umzusetzten. Dabei folgt eine Unter-
  teilung in Definitionsname und Schluesselwortliste. Jedes Element der
  durch Punkt separierten Liste wird eigen adressiert. Dabei werden
  alle Punkt einfach durch Endkennungen ersetzt und die Anfangsadressen
  der einzelnen Schluesselworte in einer Nullterminierten Zeigerliste
  vermerkt.
*/
static struct Reference *ProcessReference(pcb)
REGISTER struct epcbDCL *pcb;
{
 REGISTER struct Reference *r;
 REGISTER char *temp,**a;
 REGISTER int i;

 if ( !pcb->pcb_exName.len ) return 0;
 if ( !(r = MALLOC(struct Reference,1)) ) nomem();
 r->next = 0;
 r->base = 0;
 if ( pcb->pcb_exDef.len )
  r->def = dtoa(pcb->pcb_exDef);
 else
  r->def = 0;
 if ( !(a = MALLOC(char *,pcb->pcb_exDots+2)) ||
      !(r->addrs = MALLOC(int *,pcb->pcb_exDots+1)) )
  nomem();
 r->names = a;
 for ( i = pcb->pcb_exDots, temp = dtoa(pcb->pcb_exName) ; ; ) 
  {
   *a++ = temp;
   if ( !i-- ) break;
   while ( *temp && (*temp != '.') ) temp++;
   *temp++ = '\0';
  }
 *a = 0;
 return r;
}

/*
  Bearbeitung eines DISALLOW Statements. Solange der Ausdruck nicht
  abgeschlossen ist, werden immer neue Knoten und Blaettern an den
  aufzubauenden Ausdrucksbaum angehaengt. Die unsymmetrische Rolle
  von AND und OR kommt durch die hoehere Auswerteprioritaet eines
  ANDs. Ist der Ausdruck abgeschlossen, wird er aus Konsistenz
  ueberprueft und in die Liste des aktuellen VERBs oder der aktuellen
  SYNTAX eingetragen.
*/
ProcessExpression(pcb)
REGISTER struct epcbDCL *pcb;
{
 REGISTER struct Reference *r;

 switch (pcb->pcb_exValue)
  {
   case exvANY2  : newexpr(EK_ANY2);
   		   break;
   case exvNEG   : newexpr(EK_NEG);
		   break;
   case exvNOT   : newexpr(EK_NOT);
		   break;
   case exvSTART : newexpr(EK_SUB);
		   break;
   case exvEND   : completeExpression(0);
		   completeExpression(1);
		   break;
   case exvAND   : completeExpression(0);
   		   newexpr(EK_AND);
   		   if ( curexpr->prev && (curexpr->prev->kind == EK_OR) )
   	 	    {
		     curexpr->eleft = curexpr->prev->eright;
		     curexpr->prev->eright = curexpr;
		    }
		   else if ( curexpr->eleft = curexpr->prev )
		    curexpr->prev = curexpr->prev->prev;
		   break;
   case exvOR    : completeExpression(0);
		   newexpr(EK_OR);
   		   if ( curexpr->eleft = curexpr->prev )
		    curexpr->prev = curexpr->prev->prev;
		   break;
  }
 if ( r = ProcessReference(pcb) )
  {
   if ( !curexpr ) newexpr(EK_LEAF);
   switch (curexpr->kind)
    {
     case EK_ANY2  : r->next = curexpr->ereference;
     case EK_LEAF  :
     case EK_NEG   : curexpr->ereference = r;
 		     break;
     case EK_AND   :
     case EK_OR    :
     case EK_NOT   :
     case EK_SUB   : newexpr(EK_LEAF);
     		     curexpr->ereference = r;
     		     break;
    }
  }  
 if ( pcb->pcb_exState == exsIdle )
  {
   do
    completeExpression(1);
   while ( curexpr->prev );
   ValidateExpression(pcb);
   newverb();
   curexpr->next = curverb->disallow;
   curverb->disallow = curexpr;
   curexpr = 0;
   pcb->pcb_exNesting = 0;
  }
}

/*
  Neue Ausdrucks-Struktur erzeugen und mit der bisher aktuellen verketten.
  Letzteres ermoeglicht eine linerare Auswertung von Ausdruecken trotz der
  durch Klammerung implizierten rekursiven Struktur.
*/
static newexpr(kind)
int kind;
{
 struct Expression *prev = curexpr;

 if ( !(curexpr = MALLOC(struct Expression,1)) ) nomem();
 curexpr->next = 0;
 curexpr->prev = prev;
 curexpr->kind = kind;
 curexpr->eleft = curexpr->eright = 0;
}

/*
  Ein Teilausdruck wurde abgeschlossen. Dann ist es notwendig, Blaetter
  und Knoten korrekt zu verbinden. Eine besondere Rolle spielen dabei
  geklammerte Ausdruecke, die ein Ueberschreiben der Priorisierungsregeln
  erlauben. hnlich muss ein nach einem OR ausgefuehrtes AND anders ver-
  kettet werden, als die Norm es vorschreibt.
*/
static completeExpression(always)
int always;
{
 if ( !curexpr->prev || (!always && (curexpr->prev->kind == EK_SUB)) )
  return;
 curexpr->prev->eright = curexpr;
 curexpr = curexpr->prev;
 if ( (curexpr->kind == EK_AND) && curexpr->prev &&
      (curexpr->prev->kind == EK_OR) )
  curexpr = curexpr->prev;
}

/*
  Ueberpruefung des aktuellen Ausdrucks auf Konsistenz sowie Zaehlung der
  Klammerebenen.
*/
static ValidateExpression(pcb)
struct epcbDCL *pcb;
{
 if ( pcb->pcb_exNesting > 0 )
  error("%ld offene Klammerebene(n)",pcb->pcb_exNesting);
 checkExpression(curexpr);
}

/*
  Rekursive Ueberpruefung des aktuellen Ausdrucks. Momentan ist die
  einzige Bedinungung, dass ein ANY2, wie der Name schon sagt, mindestens
  zwei Parameter haben sollte. Zudem muessen aber auch saemtliche offenen
  Referenzen ueberprueft werden.
*/
static checkExpression(e)
REGISTER struct Expression *e;
{
 switch (e->kind)
  {
   case EK_ANY2 : if ( !e->ereference->next )
		   error("ANY2 benoetigt mindestens zwei Parameter",0L);
   case EK_LEAF :
   case EK_NEG  : checkReference(e->ereference);
   		  break;
   case EK_AND  :
   case EK_OR   : checkExpression(e->eleft);
   case EK_NOT  :
   case EK_SUB  : checkExpression(e->eright);
   		  break;
  }
}

/*
  Referenzlisten duerfen aus hoechstens acht Elementen bestehen. Die
  folgende Routine ueberprueft alle Referenzen innerhalb einer Liste.
*/
static checkReference(r)
REGISTER struct Reference *r;
{
 REGISTER int i;

 for ( ; r ; r = r->next )
  {
   for ( i = 0 ; r->names[i++] ; );
   if ( i > 9 )
    {
     error("Definitionsliste hat mehr als 8 Elemente",0L);
     return;
    }
  }
}

