;
; Parsertabelle fuer den SET COMMAND Befehl vom DCL.
;
Version 	1.1
;
Include		<saphir/parser.h>
;
; VAX-Strings und Symbole
;
Character Sets
;
	Legal		= BLANK..255
	StringStart	= 'A'..'Z','a'..'z','0'..'9'
	StringChars	= 'A'..'Z','a'..'z','0'..'9'
	SymbolStart	= 'A'..'Z','a'..'z','$'
	SymbolChars	= 'A'..'Z','a'..'z','$','_','0'..'9'
;
; Die Schreibweise ist irrelevant aber Befehle drfen nicht abgekrzt
; werden.
;
Flags	    	=
Abbrevation 	=
;
Definitions
;
; Werte fuer STATEMENT
;
	long		smState
		smsIdle		= 	0
		smsDefine	=	1
		smsSyntax	=	2
		smsVerb		=	3
		smsType		=	4
	long		smFlags
		smfModule	=	$00000001
		smfIdent	=	$00000002
	descriptor	smModule
	descriptor	smIdent
	descriptor	smName
;
; Werte fuer VERB
;
	long		vState
		vsIdle		=	0
		vsStart		=	1
		vsSep		=	2
		vsClause	=	3
		vsImage		=	4
		vsParameter	=	5
		vsRoutine	=	6
		vsSynonym	=	7
		vsPrefix	=	8
		vsCLIStart	=	9
		vsCLIName	=	10
		vsCLISep	=	11		
	long		vFlags
		vfCFL		=	$00000001
		vfCLI		=	$80000002
		vfIMA		=	$80000004
		vfNDI		=	$00000008
		vfNPA		=	$00000010
		vfNQU		=	$00000020
		vfPRE		=	$00000040
		vfROU		=	$80000080
		vfSYN		=	$00000100
	descriptor	vImage
	descriptor	vParameter
	descriptor	vSynonym
	descriptor	vPrefix
	long		vCLI
		vcABB		=	$00000001
		vcFOR		=	$00000002
		vcIMM		=	$00000004
		vcMCR		=	$00000008
		vcNOS		=	$00000010
;
; Werte fuer TYPE
;
	long		tState
		tsIdle		=	0
		tsStart		=	1
		tsSep		=	2
		tsClause	=	3
		tsKey		=	4
	descriptor	tKeyword
;
; Werte fuer IDCLAUSE
;
	long		idState
		idsIdle		= 	0
		idsClause	=	1
		idsSep		=	2
		idsLab1		=	3
		idsLab2		=	4
		idsPla1		=	5
		idsPla2		=	6
		idsPro1		=	7
		idsPro2		=	8
		idsSyn1		=	9
		idsSyn2		=	10
	long		idFlags
		idfBAT		=	$00000001
		idfDEF		=	$00000002
		idfGLO		=	$40000004
		idfKEY		=	$20000008
		idfLAB		=	$00000010
		idfLOC		=	$40000020
		idfNAM		=	$00000040
		idfNEG		=	$80000080
		idfNNE		=	$80000100
		idfPAR		=	$20000200
		idfPOS		=	$40000400
		idfPRO		=	$00000800
		idfQUA		=	$20001000
		idfSYN		=	$00002000
		idfVAL		=	$00004000
	descriptor	idLabel
	descriptor	idPrompt
	descriptor	idSyntax
;
; Werte fuer VALUECLAUSE
;
	long		vcState
		vcsIdle		= 	0
		vcsStart	=	1
		vcsClause	=	2
		vcsSep		=	3
		vcsDef1		=	4
		vcsDef2		=	5
		vcsTyp1		=	6
		vcsTyp2		=	7
	long		vcFlags
		vcfCON		=	$80000001
		vcfDEF		=	$40000002
		vcfIMP		=	$80000004
		vcfLIS		=	$00000008
		vcfNCO		=	$80000010
		vcfREQ		=	$00000020 ; former 40000020
		vcfTYP		=	$00000040
	descriptor	vcDefault
	descriptor	vcType
;
; Werte fuer EXPRESSION
;
	long		exState
		exsIdle		= 	0
		exsRun		=	1
		exsName		=	2
		exsKey		=	3
		exsAnyStart	=	4
		exsAnyName	=	5
		exsAnySep	=	6
	long		exNesting
;
Clear
;
; Werte fuer STATMENT
;
	long		smNewline
;
; Werte fuer EXPRESSION
;
	long		exValue
		exvANY2		=	1
		exvNEG		=	2
		exvNOT		=	3
		exvAND		=	4
		exvOR		=	5
		exvSTART	=	6
		exvEND		=	7
	long		exDots
	descriptor	exName
	descriptor	exDef
;

Rules
;
; STATEMENT =
;	DEFINE SYNTAX name <VERBCLAUSE>
;	DEFINE TYPE name <TYPECLAUSE>
;	DEFINE VERB name <VERBCLAUSE>
;	IDENT <character string>
;	MODULE <symbol|string>
;
State	Initial,NAME
Trans	p$Lambda,,smaCmp,,,smsIdle
Trans	p$Lambda,IDefine,smaCmp,,,smsDefine
Trans	p$Lambda,Verb,smaCmp,,,smsSyntax
Trans	p$Lambda,Verb,smaCmp,,,smsVerb
Trans	p$Lambda,Type,smaCmp,,,smsType

State
Trans	12,p$Exit
Trans	'MODULE',IModule,,smfModule,smFlags,,CHECK
Trans	'IDENT',IIdent,,smfIdent,smFlags,,CHECK
Trans	'DEFINE',IDefine,smaSet,,,smsDefine
Trans	p$Lambda,Kommentar

State 	IModule
Trans	p$Symbol,Kommentar,,,smModule
Trans	p$String,Kommentar,,,smModule

State 	IIdent
Trans	#CHARACTERSTRING,Kommentar,,,smIdent

State	IDefine
Trans	'SYNTAX',Verb,smaSet,vsStart,vState,smsSyntax
Trans	'TYPE',Type,smaSet,tsStart,tState,smsType
Trans	'VERB',Verb,smaSet,vsStart,vState,smsVerb
Trans	p$Lambda,Kommentar

;
; KOMMENTAR =
;	['!' {<character>}] [LF] EOS
;
State	Kommentar,NAME
Trans	'!',p$Exit,,1,smNewline
Trans	LF,p$Exit,,1,smNewline
Trans	p$Eos,p$Exit,,1,smNewline

;
; VERB =
;	'CLIFLAGS' '(' <flag> { ',' <flag> } ')'
;	'CLIROUTINE' <symbol>
;	'DISALLOW' <expression>
;	'IMAGE' <character string>
;	'NODISALLOWS'
;	'NOPARAMETERS'
;	'NOQUALIFIERS'
;	'PARAMETER' <symbol|string> { IDCLAUSE }
;	'PREFIX' <symbol>
;	'QUALIFIER' <symbol|string> { IDCLAUSE }
;	'ROUTINE' <symbol>
;	'SYNONYM' <symbol>
;
State	Verb,NAME
Trans	p$Lambda,IDClause,idaBusy
Trans	p$Lambda,Expression,exaBusy
Trans	p$Lambda,VStart,vaCmp,,,vsStart
Trans	p$Lambda,VClause,vaCmp,,,vsClause
Trans	p$Lambda,VSep,vaCmp,,,vsSep
Trans	p$Lambda,VImage,vaCmp,,,vsImage
Trans	p$Lambda,VParameter,vaCmp,,,vsParameter
Trans	p$Lambda,VRoutine,vaCmp,,,vsRoutine
Trans	p$Lambda,VSynonym,vaCmp,,,vsSynonym
Trans	p$Lambda,VPrefix,vaCmp,,,vsPrefix
Trans	p$Lambda,VCLIStart,vaCmp,,,vsCLIStart
Trans	p$Lambda,VCLIName,vaCmp,,,vsCLIName
Trans	p$Lambda,VCLISep,vaCmp,,,vsCLISep

State	VStart
Trans	p$Symbol,VClause,vaSet,,smName,vsClause
Trans	p$String,VClause,vaSet,,smName,vsClause
Trans	p$Lambda,Kommentar

State	VClause
Trans	'CLIFLAGS',VCLIStart,vaSet,vfCFL,vFlags,vsCLIStart,CHECK
Trans	'CLIROUTINE',VRoutine,vaSet,vfCLI,vFlags,vsRoutine,CHECK
Trans	'DISALLOW',VDisallow,vaSet,,,vsSep
Trans	'IMAGE',VImage,vaSet,vfIMA,vFlags,vsImage,CHECK
Trans	'NODISALLOWS',VSep,vaSet,vfNDI,vFlags,vsSep,CHECK
Trans	'NOPARAMETERS',VSep,vaSet,vfNPA,vFlags,vsSep,CHECK
Trans	'NOQUALIFIERS',VSep,vaSet,vfNQU,vFlags,vsSep,CHECK
Trans	'PARAMETER',VParameter,vaSet,idfPAR,idFlags,vsParameter,CHECK
Trans	'PREFIX',VPrefix,vaSet,vfPRE,vFlags,vsPrefix,CHECK
Trans	'QUALIFIER',VParameter,vaSet,idfQUA,idFlags,vsParameter,CHECK
Trans	'ROUTINE',VRoutine,vaSet,vfROU,vFlags,vsRoutine,CHECK
Trans	'SYNONYM',VSynonym,vaSet,vfSYN,vFlags,vsSynonym,CHECK
Trans	!Kommentar,p$Exit
Trans	p$Lambda,p$Exit,vaSet,,,vsIdle

State	VCLIStart
Trans	'(',VCLIName,vaSet,,,vsCLIName
Trans	p$Lambda,Kommentar

State	VCLIName
Trans	'ABBREVIATE',VCLISep,vaSet,vcABB,vCLI,vsCLISep
Trans	'FOREIGN',VCLISep,vaSet,vcFOR,vCLI,vsCLISep
Trans	'IMMEDIATE',VCLISep,vaSet,vcIMM,vCLI,vsCLISep
Trans	'MCRIGNORE',VCLISep,vaSet,vcMCR,vCLI,vsCLISep
Trans	'NOSTATUS',VCLISep,vaSet,vcNOS,vCLI,vsCLISep
Trans	p$Lambda,Kommentar

State	VCLISep
Trans	',',VCLIName,vaSet,,,vsCLIName
Trans	')',VClause,vaSet,,,vsClause
Trans	p$Lambda,Kommentar

State	VSep
Trans	',',VClause,vaSet,,,vsClause
Trans	!Kommentar,p$Exit
Trans	p$Lambda,VClause,vaSet,,,vsClause

State	VDisallow
Trans	p$Lambda,Expression,exaSet,,,exsRun

State	VImage
Trans	#CHARACTERSTRING,VSep,vaSet,,vImage,vsSep
Trans	p$Lambda,Kommentar

State	VParameter
Trans	p$Symbol,,vaSet,,vParameter,vsSep
Trans	p$String,,vaSet,,vParameter,vsSep
Trans	p$Lambda,Kommentar

State
Trans	p$Lambda,IDClause,idaSet,idfNAM,idFlags,idsSep

State	VPrefix
Trans	p$Symbol,,vaSet,,vPrefix,vsSep
Trans	p$Lambda,Kommentar

State	VRoutine
Trans	p$Symbol,VSep,vaSet,,vImage,vsSep
Trans	p$Lambda,Kommentar

State	VSynonym
Trans	p$Symbol,p$Exit,vaSet,,vSynonym,vsSep
Trans	p$Lambda,Kommentar

;
; TYPE =
;	'KEYWORD' <symbol|string> IDCLAUSE
;
State	Type,NAME
Trans	p$Lambda,IDClause,idaBusy
Trans	p$Lambda,TClause,taCmp,,,tsClause
Trans	p$Lambda,TStart,taCmp,,,tsStart
Trans	p$Lambda,TSep,taCmp,,,tsSep
Trans	p$Lambda,TKey,taCmp,,,tsKey

State	TStart
Trans	p$Symbol,TClause,taSet,,smName,tsClause
Trans	p$String,TClause,taSet,,smName,tsClause
Trans	p$Lambda,Kommentar

State	TClause
Trans	'KEYWORD',TKey,taSet,,,tsKey
Trans	!Kommentar,p$Exit
Trans	p$Lambda,p$Exit,taSet,,,tsIdle

State	TSep
Trans	',',TClause,taSet,,,tsClause
Trans	!Kommentar,p$Exit
Trans	p$Lambda,TClause,taSet,,,tsClause

State	TKey
Trans	p$Symbol,,taSet,,tKeyword,tsSep
Trans	p$String,,taSet,,tKeyword,tsSep
Trans	p$Lambda,Kommentar

State
Trans	p$Lambda,IDClause,idaSet,idfKEY,idFlags,idsSep

;
; IDCLAUSE =
;	'BATCH'
;	'DEFAULT'
;	'LABEL' '=' <symbol|string>
;	'NEGATABLE'
;	'NONNEGATABLE'
;	'PLACEMENT' '=' ['GLOBAL'|'LOCAL'|'POSITIONAL']
;	'PROMPT' '=' <character string>
;	'SYNTAX' ['='] <symbol|string>
;	'VALUE' [ '(' { VALUECLAUSE } ')' ]
;
State	IDClause,NAME
Trans	p$Lambda,ValueClause,vcaBusy
Trans	p$Lambda,ICClause,idaCmp,,,idsClause
Trans	p$Lambda,ICSep,idaCmp,,,idsSep
Trans	p$Lambda,ICLab1,idaCmp,,,idsLab1
Trans	p$Lambda,ICLab2,idaCmp,,,idsLab2
Trans	p$Lambda,ICPla1,idaCmp,,,idsPla1
Trans	p$Lambda,ICPla2,idaCmp,,,idsPla2
Trans	p$Lambda,ICPro1,idaCmp,,,idsPro1
Trans	p$Lambda,ICPro2,idaCmp,,,idsPro2
Trans	p$Lambda,ICSyn1,idaCmp,,,idsSyn1
Trans	p$Lambda,ICSyn2,idaCmp,,,idsSyn2

State	ICClause
Trans	'BATCH',ICSep,idaSet,idfBAT,idFlags,idsSep,CHECK
Trans	'DEFAULT',ICSep,idaSet,idfDEF,idFlags,idsSep,CHECK
Trans	'LABEL',ICLab1,idaSet,idfLAB,idFlags,idsLab1,CHECK
Trans	'NEGATABLE',ICSep,idaSet,idfNEG,idFlags,idsSep,CHECK
Trans	'NONNEGATABLE',ICSep,idaSet,idfNNE,idFlags,idsSep,CHECK
Trans	'PLACEMENT',ICPla1,idaSet,,,idsPla1
Trans	'PROMPT',ICPro1,idaSet,idfPRO,idFlags,idsPro1,CHECK
Trans	'SYNTAX',ICSyn1,idaSet,idfSYN,idFlags,idsSyn1,CHECK
Trans	'VALUE',ICVal,idaSet,idfVAL,idFlags,idsSep,CHECK
Trans	!Kommentar,p$Exit
Trans	p$Lambda,p$Exit,idaSet,,,idsIdle

State	ICSep
Trans	',',ICClause,idaSet,,,idsClause
Trans	!Kommentar,p$Exit
Trans	p$Lambda,ICClause,idaSet,,,idsClause

State	ICLab1
Trans	'=',,idaSet,,,idsLab2
Trans	p$Lambda,Kommentar

State	ICLab2
Trans	p$Symbol,ICSep,idaSet,,idLabel,idsSep
Trans	p$String,ICSep,idaSet,,idLabel,idsSep
Trans	p$Lambda,Kommentar

State	ICPla1
Trans	'=',,idaSet,,,idsPla2
Trans	p$Lambda,Kommentar

State	ICPla2
Trans	'GLOBAL',ICSep,idaSet,idfGLO,idFlags,idsSep,CHECK
Trans	'LOCAL',ICSep,idaSet,idfLOC,idFlags,idsSep,CHECK
Trans	'POSITIONAL',ICSep,idaSet,idfPOS,idFlags,idsSep,CHECK
Trans	p$Lambda,Kommentar

State	ICPro1
Trans	'=',,idaSet,,,idsPro2
Trans	p$Lambda,Kommentar

State	ICPro2
Trans	#CHARACTERSTRING,ICSep,idaSet,,idPrompt,idsSep
Trans	p$Lambda,Kommentar

State	ICSyn1
Trans	'=',,idaSet,,,idsSyn2
Trans	p$Lambda

State	ICSyn2
Trans	p$Symbol,ICSep,idaSet,,idSyntax,idsSep
Trans	p$String,ICSep,idaSet,,idSyntax,idsSep
Trans	p$Lambda,Kommentar

State	ICVal
Trans	p$Lambda,ValueClause,vcaSet,,,vcsStart

;
; VALUECLAUSE =
;	'CONCATENATE'
;	'DEFAULT''=' <character string>
;	'IMPCAT'
;	'LIST'
;	'NOCONCATENATE'
;	'REQUIRED'
;	'TYPE''='<symbol>
;
State	ValueClause,NAME
Trans	p$Lambda,VCStart,vcaCmp,,,vcsStart
Trans	p$Lambda,VCClause,vcaCmp,,,vcsClause
Trans	p$Lambda,VCSep,vcaCmp,,,vcsSep
Trans	p$Lambda,VCDef1,vcaCmp,,,vcsDef1
Trans	p$Lambda,VCDef2,vcaCmp,,,vcsDef2
Trans	p$Lambda,VCDef1,vcaCmp,,,vcsTyp1
Trans	p$Lambda,VCDef2,vcaCmp,,,vcsTyp2

State	VCStart
Trans	'(',VCClause,vcaSet,,,vcsClause
Trans	!Kommentar,p$Exit
Trans	p$Lambda,Initial,vcaSet,,,vcsIdle

State	VCClause
Trans	'CONCATENATE',VCSep,vcaSet,vcfCON,vcFlags,vcsSep,CHECK
Trans	'DEFAULT',VCDef1,vcaSet,vcfDEF,vcFlags,vcsDef1,CHECK
Trans	'IMPCAT',VCSep,vcaSet,vcfIMP,vcFlags,vcsSep,CHECK
Trans	'LIST',VCSep,vcaSet,vcfLIS,vcFlags,vcsSep,CHECK
Trans	'NOCONCATENATE',VCSep,vcaSet,vcfNCO,vcFlags,vcsSep,CHECK
Trans	'REQUIRED',VCSep,vcaSet,vcfREQ,vcFlags,vcsSep,CHECK
Trans	'TYPE',VCTyp1,vcaSet,vcfTYP,vcFlags,vcsTyp1,CHECK
Trans	p$Lambda,Kommentar

State	VCSep
Trans	',',VCClause,vcaSet,,,vcsClause
Trans	')',Initial,vcaSet,,,vcsIdle
Trans	p$Lambda,Kommentar

State	VCDef1
Trans	'=',VCDef2,vcaSet,,,vcsDef2
Trans	p$Lambda,Kommentar

State	VCDef2
Trans	#CHARACTERSTRING,VCSep,vcaSet,,vcDefault,vcsSep
Trans	p$Lambda,Kommentar

State	VCTyp1
Trans	'=',VCTyp2,vcaSet,,,vcsTyp2
Trans	p$Lambda,Kommentar

State	VCTyp2
Trans	p$Symbol,VCSep,vcaSet,,vcType,vcsSep
Trans	p$Lambda,Kommentar

;
; EXPRESSION =
;	'ANY2' '(' <entity> { ',' <entity> } ')'
;	'NEG' <entity>
;	'NOT' <expression>
;	<expression> 'AND' <expression>
;	<expression> 'OR' <expression>
;	'(' <expression> ')'
; ENTITY =
;	[ '<' <symbol|string> '>' ] <symbol|string> {'.' <symbol|string>}
;
State	Expression
Trans	p$Lambda,ERun,exaCmp,,,exsRun
Trans	p$Lambda,EEntity,exaCmp,,,exsName
Trans	p$Lambda,EKey,exaCmp,,,exsKey
Trans	p$Lambda,EAnyStart,exaCmp,,,exsAnyStart
Trans	p$Lambda,EAnyName,exaCmp,,,exsAnyName
Trans	p$Lambda,EAnySep,exaCmp,,,exsAnySep

State	ERun
Trans	'ANY2',EAnyStart,exaSet,exvANY2,exValue,exsAnyStart
Trans	'NEG',EEntity,exaSet,exvNEG,exValue,exsName
Trans	'NOT',p$Exit,,exvNOT,exValue
Trans	'(',p$Exit,exaInc,exvSTART,exValue
Trans	p$Lambda,EEntity

State	EEntity
Trans	!Kommentar,p$Exit
Trans	p$Lambda,EName,exaBlanking,,,exsKey

State	EKey
Trans	'AND',p$Exit,exaSet,exvAND,exValue,exsRun
Trans	'OR',p$Exit,exaSet,exvOR,exValue,exsRun
Trans	')',p$Exit,exaDec,exvEND,exValue
Trans	!Kommentar,p$Exit
Trans	p$Lambda,p$Exit,exaSet,,,exsIdle

State	EAnyStart
Trans	'(',EAnyName,exaSet,,,exsAnyName
Trans	p$Lambda,Kommentar

State	EAnyName
Trans	!Kommentar,p$Exit
Trans	p$Lambda,EName,exaBlanking,,,exsAnySep

State	EAnySep
Trans	',',EAnyName,exaSet,,,exsAnyName
Trans	')',p$Exit,exaSet,,,exsKey
Trans	p$Lambda,Kommentar

State	EName
Trans	'<'
Trans	p$Symbol,EPath
Trans	p$String,EPath
Trans	p$Lambda,p$Fail,exaBlanking,,,0

State
Trans	p$Symbol
Trans	p$String
Trans	p$Lambda,p$Fail,exaBlanking,,,0

State
Trans	'>',,exaDef
Trans	p$Lambda,p$Fail,exaBlanking,,,0

State
Trans	p$Symbol
Trans	p$String
Trans	p$Lambda,p$Fail,exaBlanking,,,0

State	EPath
Trans	'.',,exaDot
Trans	p$Lambda,p$Exit,exaBlanking,,,0

State
Trans	p$Symbol,EPath
Trans	p$String,EPath
Trans	p$Lambda,p$Fail,exaBlanking,,,0

;
Inline

/* VALUECLAUSE */
smaCmp(pcb,val)
PCB *pcb;
long val;
{
 if ( pcb->pcb_smState == val ) return parse_exit;
 return parse_fail;
}

smaSet(pcb,val)
PCB *pcb;
long val;
{
 pcb->pcb_smState = val;
 return parse_exit;
}

/* VALUECLAUSE */
vcaCmp(pcb,val)
PCB *pcb;
long val;
{
 if ( pcb->pcb_vcState == val ) return parse_exit;
 return parse_fail;
}

vcaSet(pcb,val)
PCB *pcb;
long val;
{
 pcb->pcb_vcState = val;
 return parse_exit;
}

vcaBusy(pcb)
PCB *pcb;
{
 if ( pcb->pcb_vcState ) return parse_exit;
 return parse_fail;
}

/* IDCLAUSE */
idaCmp(pcb,val)
PCB *pcb;
long val;
{
 if ( pcb->pcb_idState == val ) return parse_exit;
 return parse_fail;
}

idaSet(pcb,val)
PCB *pcb;
long val;
{
 pcb->pcb_idState = val;
 return parse_exit;
}

idaBusy(pcb)
PCB *pcb;
{
 if ( pcb->pcb_idState ) return parse_exit;
 return parse_fail;
}

/* VERB */
vaCmp(pcb,val)
PCB *pcb;
long val;
{
 if ( pcb->pcb_vState == val ) return parse_exit;
 return parse_fail;
}

vaSet(pcb,val)
PCB *pcb;
long val;
{
 pcb->pcb_vState = val;
 return parse_exit;
}

vaBusy(pcb)
PCB *pcb;
{
 if ( pcb->pcb_vState ) return parse_exit;
 return parse_fail;
}

/* TYPE */
taCmp(pcb,val)
PCB *pcb;
long val;
{
 if ( pcb->pcb_tState == val ) return parse_exit;
 return parse_fail;
}

taSet(pcb,val)
PCB *pcb;
long val;
{
 pcb->pcb_tState = val;
 return parse_exit;
}

taBusy(pcb)
PCB *pcb;
{
 if ( pcb->pcb_tState ) return parse_exit;
 return parse_fail;
}

/* EXPRESSION */
exaCmp(pcb,val)
PCB *pcb;
long val;
{
 if ( pcb->pcb_exState == val ) return parse_exit;
 return parse_fail;
}

exaSet(pcb,val)
PCB *pcb;
long val;
{
 pcb->pcb_exState = val;
 return parse_exit;
}

exaBusy(pcb)
PCB *pcb;
{
 if ( pcb->pcb_exState ) return parse_exit;
 return parse_fail;
}

exaBlanking(pcb,state)
PCB *pcb;
long state;
{
 if ( state )
  {
   pcb->sys_pcb.pcb_flags |= 1;
   pcb->pcb_exName.text = pcb->sys_pcb.pcb_line;
   pcb->pcb_exState = state;
  }
 else
  {
   pcb->sys_pcb.pcb_flags &= ~1;
   pcb->pcb_exName.len = pcb->sys_pcb.pcb_line-pcb->pcb_exName.text;
  }
 return parse_exit;
}

exaDef(pcb)
PCB *pcb;
{
 pcb->pcb_exDef.text = pcb->pcb_exName.text+1;
 pcb->pcb_exDef.len = pcb->sys_pcb.pcb_line-pcb->pcb_exDef.text-1;
 pcb->pcb_exName.text = pcb->sys_pcb.pcb_line;
 return parse_exit;
}

exaInc(pcb)
PCB *pcb;
{
 pcb->pcb_exNesting++;
 pcb->pcb_exState = exsRun;
 return parse_exit;
}

exaDec(pcb)
PCB *pcb;
{
 if ( !pcb->pcb_exNesting-- ) return parse_fail;
 pcb->pcb_exState = exsKey;
 return parse_exit;
}

exaDot(pcb)
PCB *pcb;
{
 pcb->pcb_exDots++;
 return parse_exit;
}
