#define PCBCDU_INLINE

#define VERSION		"Command Definition Utility 1.4 by JMS 1990"

#include <stdio.h>
#include <saphir/modules/frame.h>
#include "DCL.h"

/*
  Diese Programm soll auch unter UNIX laufen.
*/
#ifdef MCH_AMIGA
#ifndef PARSER
#define	bzero(a,n)	setmem(a,n,0)
#define bcopy(a,b,n)	movmem(a,b,n)
#endif

#define REGISTER	register
#else
#define REGISTER
#endif

extern char *optarg,*getargs_error();
extern int opterr;

#ifndef DEF
#define DEF		extern
#endif

/*
  Konversion eines Parserdescriptors in einen C-String.
*/
#define dtoa(d)		makeStr((d).text,(int)((d).len))

/*
  Vereinfachung der Typumwandlung bei Speicherreservierungen.
*/
#ifndef MALLOC
#define MALLOC(t,n)	((t *)malloc((int)((n)*sizeof(t))))
#endif

/*
  Suchen gewisser Informationen in diversen Hashtabellen. Diese Macros
  ersparen die lstige Typenkonversion.
*/
#define getVerb(n)	(*getEntry(verb,n))
#define getSyntax(n)	(*getEntry(syntax,n))
#define getType(n)	(*(struct Type **)getEntry(type,n))

/*
  Informationen eines VALUE-Statements. Das TYPE-Feld wird erst in der
  zweiten Phase des Programmes gefuellt.
*/
struct Value
       {
	struct Value *next;
	long 	     flags;
	char 	     *typename;
	char 	     *defval;
	struct Type  *type;
	int	     ispar;	/* PARAMETER 		 */
	struct Verb  *psyntax;	/* Syntax des PARAMETERs */
	int	     predef;
	int	     caddr;	/* Code      		 */
	int	     daddr;	/* Defaultstring	 */
	int	     laddr;	/* Defaultcode		 */
	long	     pflags;	/* Uebergeordnete Flags  */
       };

/*
  Diese Struktur umschliesst PARAMETER-, QUALIFIER- und KEYWORD-Statements.
  Die verschiedenen Statements werden nach FLAGS selektiert und dann in
  die entsprechenden Listen einsortiert. Die Felder VALUE und SYNTAX werden
  in Phase eins nocht nicht benoetigt.
*/
struct Parameter
       {
	struct Parameter *next;
	long 	         flags;
	char		 *name;
	char 	         *label;
	char 	         *prompt;
	char 	         *synname;
	struct Value     *value;
	struct Value     *optval;
	struct Verb      *syntax;
	int		 caddr;		/* Code   	*/
	int		 naddr;		/* Name   	*/
	int		 laddr;		/* Label  	*/
	int		 xaddr;		/* NEGATED name */
       };

/*
  Ein Synonym eines VERBs.
*/
struct Synonym
       {
	struct Synonym  *next;
	char		*text;
       };

/*
  Ein VERB oder eine SYNTAX. Die Parameter und Qualifier sind entsprechend
  der oben erwhnten Flags in separate Listen einsortiert.
*/
struct Verb
       {
	struct Verb	  *next;
	char		  *name;
	int 		  isverb;
	long 		  flags;
	long		  CLIflags;
	char 		  *image;
	struct Synonym	  *synonym;
	char		  *prefix;
	struct Parameter  *parameter;
	struct Parameter  *qualifier;
	struct Expression *disallow;
	int		  npar;		/* Parameter 		   	 */
	int		  nqual;	/* Qualifier 		   	 */
	int		  ndval;	/* VALUE DEFAULT|BATCH Qualifier */
	int		  pdef;		/* DEFAULT Parameter      	 */
	int		  ndef;		/* DEFAULT|BATCH Qualifier 	 */
	int		  nneg;		/* NEGATABLE Qualifier     	 */
	struct Verb	  *syntax;
	struct Verb	  *verb;
	int		  nsyntax;
	int		  caddr;	/* Qualifier   		   	 */
	int		  dqaddr;	/* Defaultwerte von Qualifiern   */
	int		  dpaddr;	/* Defaultwerte von Parametern   */
	int		  paddr;	/* Parameter			 */
	int		  saddrP;	/* Parametertabelle	   	 */
	int		  saddrQ;	/* Qualifiertabelle		 */
	int		  iaddr;	/* Informationsliste		 */
       };

/*
  Ein TYPE ist im wesentlichen eine Liste aus Schluesselworten.
*/
struct Type
       {
	struct Type	 *next;
        char		 *name;
	struct Parameter *keyword;
	int		 nkey;		/* Schluesselworte 	    */
	int		 ndval;		/* VALUE DEFAULT	    */
	int		 ndef;		/* DEFAULT	 	    */
	int		 nneg;		/* NEGATABLE Schluesselworte */
	struct Verb	 *verb;
	int		 caddr;		/* Code 	   	    */
	int		 daddr;		/* Default KEYWORD 	    */
	int		 kaddr;		/* Namensliste		    */
       };

/*
  In der ersten Phase wird eine Referenz mit dem zerlegten Namen gefuellt
  und dann im zweiten Schritt mit der entsprechenden Struktur assoziiert.
  Die Referenz bezieht sich letztendlich immer auf einen Parameter, einen
  Qualifier oder ein Schluesselwort.
*/
struct Reference
       {
	struct Reference *next;
	char		 *def;
	char		 **names;
	int		 **addrs;
	struct Verb	 *base;
       };

/*
  Ein DISALLOW Ausdruck ist entweder ein Blatt, ein ANY2, einer der beiden
  monadischen Operatoren NEG und NOT oder ein zusammengesetzter Ausdruck.
  Je nach Art verweit der Ausdruck dann auf eine Referenz oder verzweigt
  rekursiv in Unterausdruecke.
*/
union Part
      {
       struct Expression *expression;
       struct Reference  *reference;
      };

/*
  Ein DISALLOW Ausdruck mit allen notwendigen Feldern. Der Eintrag PREV
  erlaubt eine nicht-rekursive Strategie zum Aufbau eines verschachtelten
  Ausdrucks.
*/
struct Expression
       {
	struct Expression *next;
	struct Expression *prev;
	int	   	  kind;
	union Part 	  sides[2];
       };
#define EK_LEAF		((int)exvEND)
#define EK_ANY2		((int)exvANY2)
#define EK_NEG		((int)exvNEG)
#define ereference	sides[0].reference
#define EK_NOT		((int)exvNOT)
#define EK_SUB		((int)exvSTART)
#define eright		sides[1].expression
#define EK_AND		((int)exvAND)
#define EK_OR		((int)exvOR)
#define eleft		sides[0].expression

/*
  Globale Varaiblen:
	INF		: Eingabedatei mit dem CDU-Quelltext
	TAB		: Parsertabelle
	LST		: Listingdatei
	OBJ		: Linkdatei
	NOOBJ		: Nur C-Quelldatei erzeugen
  	KEEP		: C-Quelldatei nicht loeschen
	VERBOSE		: Diverse Ausgaben taetigen
	STATEDONE	: Bereits bearbeitete Top-Level Optionen
	NOMODULE	: MODULE Deklaration ignorieren
	DEFMODULE	: MODULE Defaultwert
*/
DEF int noobj,keep,verbose,nomodule;
DEF FILE *inf,*tab,*lst,*obj;
DEF char *defmodule;
DEF long statedone;

/*
	MODULE		: Name eines etwaigen MODULE Statements
	IDENT		: Name eines etwaigen IDENT Statements
	CURNAME		: Buffer fuer den Namen der aktuellen Definition
	CURVAL		: Aktuell ausgewertes VALUE Statement
	CURID		: Aktuell ausgewerteter Parameter, Qualifier oder
			  Schluesselwort
	CURVERB		: Aktuell ausgewertetes VERB oder SYNTAX
	CURTYPE		: Aktuell ausgewerteter TYPE
	CUREXPR		: Aktuell ausgewertetes DISALLOW Statement
*/
DEF char *module,*ident,*curname;
DEF struct Value *curval;
DEF struct Parameter *curid;
DEF struct Verb *curverb;
DEF struct Type *curtype;
DEF struct Expression *curexpr;

/*
	ERRORS		: Zahl der Fehler bis jetzt
	LINENO		: Zeilennummer
*/
DEF int errors,lineno;
/*
  Speicherfelder fuer die Definitionen.
*/
DEF struct Verb *verb[256],*syntax[256];
DEF struct Type *type[256];

/*
  Routinen.
*/
char *malloc(),*makeStr();
struct Verb **getEntry();
FILE *fopen();

