#define DEF
#include "CDU.h"

#define USAGE "USAGE: %s eingabe [-ckdvn] [-l listing] [-m modulename]"

/*
  Das Hauptprogramm analysiert die Befehlszeile, oeffnet alle notwendigen
  Dateien und liest dann in der ersten Phase die Eingabedatei Zeile fuer
  Zeile ein. Je nach durch den Parser gesetzten Optionen werden dann die
  entsprechenden Bearbeitungsroutinen aufgerufen. Trat in dieser Phase
  kein Fehler auf, so wird im zweiten Schritt versucht, alle Referenzen
  aufzuloesen. Ist auch dies vollstaendig moeglich, wird als Abschluss eine
  Commandtable erstellt.
*/
main(argc,argv)
int argc;
char **argv;
{
 REGISTER struct epcbDCL *pcb;
 char *iname = 0,*lname = 0,*tname = 0,*oname = 0,*makeName();
 int more,sel;
 struct epcbDCL *getpcb();

 noobj = keep = verbose = nomodule = 0;
 defmodule = "cdu$table";
 while ( (sel = getargs(argc,argv,"cdkvnl:m:!1")) != EOF )
  switch (sel)
   {
    case 'c' : noobj = keep = 1;
	       break;
    case 'd' : keep = 0;
	       break;
    case 'k' : keep = 1;
	       break;
    case 'v' : verbose = 1;
      	       break;
    case 'm' : defmodule = optarg;
    case 'n' : nomodule = 1;
      	       break;
    case 'l' : if ( lname )
    		{
     		 error("Mehr als eine Listdatei angegeben",0L);
		 exit(1);
		}
    	       lname = optarg;
    	       break;
    case '1' : iname = optarg;
    	       break;
   }
 if ( opterr )
  {
   fprintf(stderr,"Befehl illegal: %s\n",getargs_error());
   error(USAGE,*argv);
   exit(1);
  }
 if ( !iname )
  {
   error("Keine Eingabedatei angegeben",0L);
   exit(1);
  }
 iname = makeName(iname,".cld",0);
 oname = makeName(iname,".c",1); 
 tname = makeName(iname,".o",1);
 if ( verbose ) puts(VERSION);
 if ( !(inf = fopen(iname,"r")) )
  error("Eingabedatei '%s' nicht gefunden",iname);
 else if ( !(obj = fopen(oname,"w")) )
  error("Objektdatei '%s' kann nicht geoeffnet werden",oname);
 else if ( lname && !(lst = fopen(lname,"w")) )
  error("Listdatei '%s' kann nicht geoeffnet werden",lname); 
 else if ( !(pcb = getpcb(pcbDCL_module)) )
  error("Modul DCL nicht gefunden",0L);
 else
  {
   reset(pcb,2);
   do
    {
     more = doline(pcb);
     ProcessFlags(pcb);
     if ( inExpression(pcb) )
      ProcessExpression(pcb);
     else if ( defineDone(pcb) )
      {
       if ( pcb->pcb_smState == smsType )
	ProcessType(pcb);
       else
	ProcessVerb(pcb);
       reset(pcb,1);
      } 
     else if ( clauseDone(pcb) )
      {
       if ( (pcb->pcb_idFlags&idfNAM) == idfNAM )
	ProcessParameter(pcb);
       else
	ProcessKeyword(pcb);
       reset(pcb,0);
      }
    }
   while ( more );
   if ( pcb->pcb_smState != smsIdle )
    error("Unerwartetes Ende der Datei",0L);
   freepcb(pcb);
  }
 if ( inf ) fclose(inf);
 if ( !errors ) Resolve();
 if ( !errors ) Generate(oname,tname);
 if ( verbose ) printf("%d Zeile(n) bei %d Fehler(n)\n",lineno,errors);
 if ( !errors ) exit(0);
 fclose(obj);
 unlink(oname);
 exit(1);
}

/*
  Erzeuge einen Dateinamen mit Endung.
*/
static char *makeName(old,suf,create)
REGISTER char *old;
char *suf;
int create;
{
 REGISTER char *scan;
 REGISTER int l;
 char *ns;
 
 scan = old+(l = strlen(old));
 while ( (--scan >= old) && (*scan != '.') );
 if ( scan >= old )
  {
   if ( !create ) return old;
   l = scan-old;
  }
 if ( !(ns = MALLOC(char,l+strlen(suf)+1)) ) nomem();
 bcopy(old,ns,l);
 strcpy(ns+l,suf);
 return ns;
}

/*
  Lesen und Analysieren einer Eingabezeile. Syntaxfehler werden schon hier
  bearbeitet und garnicht erst an das Hauptprogramm weitergegeben. Durch
  die nicht zeilenorientierte Struktur einer CDU-Dateien ist eine besondere
  Behandlung fuer das Dateiende notwendig.
*/
static doline(pcb)
REGISTER struct epcbDCL *pcb;
{
 static char line[1024];
 static int over = 0;
 REGISTER char *pos;
 int res = 1;
 char *parse_error();

 for ( ; ; )
  {
   if ( !pcb->pcb_smNewline )
    pos = pcb->sys_pcb.pcb_line;
   else if ( over )
    return 0;
   else if ( fgets(pos = line,sizeof(line),inf) )
    lineno++;
   else
    {
     pos = "\014";
     over = 1;
    }
   if ( !(res = parse(pcb,pos)) ) return 1;
   error(parse_error(res));
   if ( !over ) fprintf(stderr,">>>> %s\n",pcb->sys_pcb.pcb_line);
   reset(pcb,2);
  }
}

/*
  Eine spezielle Fehlermeldung, die zum sofortigen Programmabbruch fuehrt.
*/
nomem()
{
 fprintf(stderr,"Kein Spicher mehr vorhanden\n");
 exit(2);
}

/*
  Fehler mit Zeilennummer ausgeben und Fehlerzaehler aktualisieren.
*/
error(mess,p1)
char *mess,*p1;
{
 static char errmess[256];
 
 sprintf(errmess,"Zeile %6d: %s\n",lineno,mess);
 fprintf(stderr,errmess,p1);
 errors++;
}

/*
  Spezielle Fehlermeldung bei berlangen Argumenten.
*/
toolong(name,max,p1)
char *name,*p1;
int max;
{
 static char errmess[256];
 
 sprintf(errmess,"Zeile %6d: %s hat mehr als %d Zeichen\n",lineno,name,max);
 fprintf(stderr,errmess,p1);
 errors++;
}

/*
  Nach gewissen Arbeitsschritten sind Variablen im PCB auf wohldefinierte
  Werte zu setzen, genau wie ein paar der globalen Variablen dieses Pro-
  grammes. Je nach Wert von ALL wird dabei die Parsertabelle teilweise
  bis vollstaendig in ihren Urzustand versetzt.
*/
reset(pcb,all)
REGISTER struct epcbDCL *pcb;
int all;
{
 if ( all )
  {
   if ( all == 2 ) pcb->pcb_smNewline = 1;
   pcb->pcb_smState = smsIdle;
   curname = 0;
   pcb->pcb_vState = vsIdle;
   pcb->pcb_vFlags = pcb->pcb_vCLI = 0;
   curverb = 0;
   curtype = 0;
   pcb->pcb_tState = tsIdle;
  }
 pcb->pcb_idState = idsIdle;  
 pcb->pcb_idFlags = 0;
 curid = 0;
 pcb->pcb_vcState = vcsIdle;
 pcb->pcb_vcFlags = 0;
 curval = 0;
 pcb->pcb_exState = exsIdle;
 pcb->pcb_exNesting = 0;
 curexpr = 0;
}

/*
  Konversion eines Parserdescriptors in einen normalen C-String. Diese
  Routine wird normalerweise im Zusammenhang mit dem DTOA Macro verwendet.
*/
char *makeStr(s,l)
REGISTER char *s;
REGISTER int l;
{
 REGISTER char first = '.',*st;
 REGISTER int ix;
 char *ns;

 if ( (l >= 2) && ((first = *s) == '"') )
  {
   s++;
   l -= 2;
  }
 if ( !(st = ns = MALLOC(char,l+1)) ) nomem();
 if ( first == '"' )
  {
   for ( ix = 0 ; ix++ < l ; )
    if ( (*st++ = *s++) == '"' )
     {
      l--;
      s++;
     }
  }
 else
  for ( ix = 0 ; ix++ < l ; *st++ = first )
   if ( ((first = *s++) >= 'a') && (first <= 'z') )
    first += 'A'-'a';
 *st = '\0';
 return ns;
}

/*
  Teste, ob eine Definition abgeschlossen wurde.
*/
static defineDone(pcb)
REGISTER struct epcbDCL *pcb;
{
 return (((pcb->pcb_smState == smsVerb) ||
	 (pcb->pcb_smState == smsSyntax)) && (pcb->pcb_vState == vsIdle)) ||
	((pcb->pcb_smState == smsType) && (pcb->pcb_tState == tsIdle));
}

/*
  Teste, ob ein Parameter, Qualifier oder Schluesselwort abgeschlossen
  wurde.
*/
static clauseDone(pcb)
REGISTER struct epcbDCL *pcb;
{
 return ((((pcb->pcb_smState == smsVerb) ||
	  (pcb->pcb_smState == smsSyntax)) && (pcb->pcb_vState == vsSep)) ||
	 ((pcb->pcb_smState == smsType) && (pcb->pcb_tState == tsSep))) &&
	(pcb->pcb_idState == idsIdle);
}

/*
  Teste, ob gerade ein DISALLOW analysiert wird.
*/
static inExpression(pcb)
struct epcbDCL *pcb;
{
 return (curexpr || (pcb->pcb_exState != exsIdle));
}
