#include rms
#include lnmdef
#include psldef
#include descrip

struct item_list_3
       {
	short blen;
	short code;
	char  *addr;
	short *rlen;
       };

static $DESCRIPTOR(DEFTAB,"LNM$FILE_DEV");

#define NOSTR		((char *)0)
#define MAXSIZE		255

/*
  Uebersetze einen VAX/VMS Dateinamen in einen BOSS/UNIX-Dateinamen. Dabei
  werden eventuell benutzte logische Namen uebersetzt.
*/
char *translate_vms(fname)
char *fname;
{
 static char fbuf[1024]; 
 static int level = 0;
 int str,zero = 0,attr,dlen,acmode = PSL$C_USER,inattr = 0;
 struct dsc$descriptor_s device;
 char *ptr,*tmp,*dst,lbuf[256];
 struct item_list_3 trn[4];
 short len;

 /* Konsistenztest */
 if ( strlen(fname) >= MAXSIZE ) return (char *)-1;
 /* Spezielle Namen in Hochkommas */
 if ( *fname == '"' )
  {
   /* Konvertieren */
   for ( ptr = fbuf, str = 0 ; *ptr++ = *++fname ; )
    if ( ptr[-1] == '"' )
     {
      if ( str ) ptr--;
      str = 1-str;
     }
    else if ( str )
     return NOSTR;
   /* Abschlusshochkomma eleminieren */
   if ( str ) ptr--;
   /* Zeichenkette abschliessen und fertig */
   ptr[-1] = '\0';
   return fbuf;
  }
 /* Devicenamen ermitteln */
 for ( ptr = fname ; *ptr && (*ptr != ':') ; ptr++ );
 if ( *ptr && (ptr[1] == ':') ) return (char *)-1;
 /* Laenge ermitteln */
 dlen = ptr-fname;
 /* Umwandeln in Grossbuchstaben */
 for ( tmp = fname, dst = fbuf ; tmp < ptr ; )
  if ( ((*dst++ = *tmp++) >= 'a') && (dst[-1] <= 'z') )
   dst[-1] += 'A'-'a';
 /* Struktur aufsetzen */
 trn[0].code = LNM$_INDEX;
 trn[0].blen = sizeof(zero);
 trn[0].addr = (char *)&zero;
 trn[0].rlen = 0;
 trn[1].code = LNM$_ATTRIBUTES;
 trn[1].blen = sizeof(attr);
 trn[1].addr = (char *)&attr;
 trn[1].rlen = 0;
 trn[2].code = LNM$_STRING;
 trn[2].blen = sizeof(lbuf)-1;
 trn[2].addr = lbuf;
 trn[2].rlen = &len;
 trn[3].code = trn[3].blen = 0;
 /* Devicedescriptor ausfsetzen */
 device.dsc$w_length = dlen;
 device.dsc$b_dtype = DSC$K_DTYPE_T;
 device.dsc$b_class = DSC$K_CLASS_S;
 device.dsc$a_pointer = fbuf;
 /* Informationen abfragen */
 if ( !(sys$trnlnm(&inattr,&DEFTAB,&device,&acmode,trn)&1) )
  {
   /* Kein logischer Name */
   strcpy(fbuf,fname);
   return fbuf;
  }
 lbuf[len] = '\0';
 /* Weiter zerlegen, falls noetig */
 if ( !(attr&LNM$M_TERMINAL) && (lbuf[0] != '_') )
  {
   /* Rekursiv aufrufen, falls noch nicht alle Ebenen ausgeschoepft */
   if ( level == 9 ) return NOSTR;
   /* Naechste Ebene aufrufen */
   level++;
   tmp = translate_vms(lbuf);
   level--;
   /* Ergebnis auswerten */
   if ( tmp != fbuf ) return tmp;
  }
 else
  strcpy(fbuf,lbuf+((lbuf[0] == '_') ? 1 : 0));
 /* Ergebnis komplettieren */
 if ( *ptr && *++ptr )
  {
   /* Trennzeichen setzen */
   if ( (len = strlen(fbuf)) && (fbuf[--len] != ':') && 
        (fbuf[len] != ']') && (fbuf[len] != '>') )
    fbuf[++len] = ':';
   /* Nur ein Doppelpunkt */
   if ( (*ptr == ':') && len && (fbuf[len] == ':') ) ptr++;
   /* Rest anhaengen */
   strcpy(fbuf+len+1,ptr);
  }
 /* Fertig */
 return fbuf;
} 

/*
  Dateiname umsetzen unter Berucksichtigung eines Defaultfilenamens.
*/
char *translate_vms_default(fname,def)
char *fname,*def;
{
 static char fbuf[256];
 static struct FAB fab;
 static struct NAM nam;

 /* Defaultdatei auf jeden Falle benutzen */
 if ( !def ) def = ""; 
 /* Ergebnis beschreiben */
 nam = cc$rms_nam;
 nam.nam$l_esa = fbuf;
 nam.nam$b_ess = sizeof(fbuf)-1;
 nam.nam$b_nop = NAM$M_SYNCHK;
 /* Filename und Defaultfilename beschreiben */
 fab = cc$rms_fab;
 fab.fab$l_fna = fname;
 fab.fab$b_fns = strlen(fab.fab$l_fna);
 fab.fab$l_dna = def;
 fab.fab$b_dns = strlen(fab.fab$l_dna);
 fab.fab$l_nam = &nam; 
 /* Ergebnis ermitteln */
 if ( !(sys$parse(&fab,0,0)&1) || !(fab.fab$l_sts&1) ) return NOSTR;
 /* Umsetzen des Ergebnisses */
 fbuf[nam.nam$b_esl] = '\0';
 return translate_vms(fbuf);
}
