/*
  Zeichenkette mit einem VAX/VMS-Wildcard Pattern vergleichen.
*/
match_wildcard(str,pattern)
char *str,*pattern;
{
 char cq,cp;

 /* Alle Zeichen durchgehen */
 do
  {
   /* Zeichen im Namen umwandeln */
   if ( ((cq = *str++) >= 'a') && (cq <= 'z') ) cq += 'A'-'a';
   /* Sonderbehandlung fuer '*' und '%' */
   switch (cp = *pattern++)
    {
     case '*' : /* Wildcardliste komprimieren */
		while ( (cp == '*') || (cp == '%') )
		 switch (cp = *pattern++)
		  {
		   case   0 : return 1;
		   case '%' : if ( !cq ) return 0;
		              if ( ((cq = *str++) >= 'a') && (cq <= 'z') ) cq += 'A'-'a';
		  }
		/* Zeichen umwandeln */
       		if ( (cp >= 'a') && (cp <= 'z') ) cp += 'A'-'a';
		/* Bis zum bitteren Ende */
       	        for ( ; ; )
		 {
		  /* Gewuenschtes Zeichen suchen */
		  while ( cq && (cq != cp) ) 
		   if ( ((cq = *str++) >= 'a') && (cq <= 'z') )
		    cq += 'A'-'a';
		  /* Rekursiv weitersuchen */ 
		  if ( !cq ) return 0;
		  if ( match_wildcard(str,pattern) ) return 1;
		  /* Naechstes Zeichen des Namens ermitteln */
		  if ( ((cq = *str++) >= 'a') && (cq <= 'z') ) cq += 'A'-'a';
		 }
     case '%' : /* Misserfolg bei Ende der Zeichenkette melden */
       	        if ( !cq ) return 0;
		/* Normal weitersuchen */
		cp = cq;
		continue;
     case   0 : /* Ergebnis melden */
       		return cq ? 0 : 1;
    }
   /* Normalen Vergleich ohne beruecksichtigung von Gross- und Kleinschreibung durchfuehren */
   if ( (cp >= 'a') && (cp <= 'z') ) cp += 'A'-'a';
  }
 while ( cp == cq );
 /* Misserfolg melden */
 return 0;
}
