/*
	troffcvt.h
*/


extern char	*strcpy ();
extern char	*strncpy ();
extern char	*strcat ();


/*
	Param - internal parameter type (should be 4 bytes at least).
	UChar - unsigned char (u_char not used so sys/types.h doesn't
		have to be included everywhere).  Needed anywhere escape
		or special character codes are allowed, since those may have
		bit 7 set.
*/

typedef	long		Param;
typedef unsigned char	UChar;

/*
	Some convenience defines for typecasting operations on UChar
	strings.
*/

# define	UStrCmp(a,b)	strcmp ((char *) a, (char *) b)
# define	UStrAlloc(s)	(UChar *) StrAlloc ((char *) s)
# define	UFree(s)	Free ((char *) s)


# define	scMask	((int) 0x8000)


/*
	Debugging flags and macro for testing debug setting
*/

# define	Bug(n)	(debug & (n))

# define	bugActionParse		(1L<<0)
# define	bugActionProcess	(1L<<1)
# define	bugMacroDef		(1L<<2)
# define	bugChIn0		(1L<<3)
# define	bugChIn02		(1L<<4)
# define	bugChIn			(1L<<5)
# define	bugUnChIn		(1L<<6)
# define	bugInputStack		(1L<<7)
# define	bugReqProcess		(1L<<8)
# define	bugConditional		(1L<<9)

/*
	Unit conversion stuff.  ToBU() is seldom used directly so that
	it isn't necessary to mess around casting the first argument to
	double all the time.
*/


# define	Units(n,u)	ToBU ((double) (n), (u))


/*
	Allocate object of type t, returning properly cast pointer.
	Panics if no memory available.
*/

# define	New(t)	((t *) Alloc ((int) sizeof (t)))


# define	bufSiz		1024
# define	maxTabStops	35
# define	maxMacArgs	9	/* $1..$9 */
# define	maxActArgs	4
# define	maxFonts	10	/* 0(reserved),1..9 */
# define	maxFontNameLen	10

# define	linefeed	'\n'
# define	cr		'\r'

# define	defEscChar	'\\'	/* default escape char */
# define	defCtrlChar	'.'	/* default control char */
# define	defNbCtrlChar	'\''	/* default no-break control */



# define	fill		1
# define	nofill		2

/* adjustment modes must be 1..4 */

# define	adjCenter	1
# define	adjLeft		2
# define	adjRight	3
# define	adjFull		4

/*
	Name types
*/

# define	reqDef	1
# define	macDef	2
# define	strDef	4
# define	regDef	8
# define	anyDef	(reqDef|macDef|strDef|regDef)

/*
	Number register formats
*/

# define	numFmt		1
# define	lRomanFmt	2
# define	uRomanFmt	3
# define	lAlphaFmt	4
# define	uAlphaFmt	5



typedef struct NameDef	NameDef;	/* request, macro, string, register */
typedef	struct Request	Request;	/* request defintion (actions) */
typedef	struct Macro	Macro;		/* macro definition */
typedef	struct String	String;		/* string definition */
typedef	struct Register	Register;	/* number register definition */
typedef	struct Action	Action;		/* request action */
typedef	struct SpChar	SpChar;		/* special char definition */

struct NameDef
{
	UChar	*ndName;
	int	ndHash;		/* hash value of name */
	int	ndType;
	NameDef	*ndNext;
	union
	{
		Request		*ndReqPtr;
		Macro		*ndMacPtr;
		String		*ndStrPtr;
		Register	*ndRegPtr;
	} ndObject;
# define	ndRequest	ndObject.ndReqPtr
# define	ndMacro		ndObject.ndMacPtr
# define	ndString	ndObject.ndStrPtr
# define	ndRegister	ndObject.ndRegPtr
};


struct Request
{
	Action	*reqPActions;
	Action	*reqActions;
};


struct Action
{
	char	*actName;
	int	(*actFunc) ();
	int	actArgc;
	char	*actArgv[maxActArgs];
	Action	*actNext;
};

struct Macro
{
	NameDef	*macParent;	/* parent NameDef */
	char	*macBuf;	/* macro body */
	int	macSiz;		/* current size of macro body */
	int	macMaxSiz;	/* maximum size of macBuf */
	int	macInUse;	/* currently being executed */
	int	macRemove;	/* set if redefined while being executed */
};

struct String
{
	char	*strValue;
	int	strInUse;
};

struct Register
{
	NameDef	*regParent;	/* parent NameDef */
	Param	regValue;
	Param	regIncrement;
	int	regFormat;
	int	regFmtWidth;
	int	regReadOnly;
};


/*
	Only 255 specials allowed.  Code is (0x80<<8)|index, where index
	is [1..255].
*/

struct SpChar
{
	char	*spName;
	int	spCode;		/* special char code */
	int	spHash;
	char	*spValue;
	SpChar	*spNext;
};


/*
	Environment structure
*/

typedef	struct Environ	Environ;

struct Environ
{
	Param	eSize;
	Param	ePrevSize;
	Param	eSpaceSize;
	char	eFont[maxFontNameLen];
	char	ePrevFont[maxFontNameLen];
	Param	eFillMode;
	Param	eAdjust;
	Param	eAdjMode;
	Param	eCenterCount;
	Param	eVSize;
	Param	ePrevVSize;
	Param	eLineSpacing;
	Param	ePrevLineSpacing;
	Param	eLineLen;
	Param	ePrevLineLen;
	Param	eIndent;
	Param	ePrevIndent;
	Param	eTempIndent;
	UChar	*eItMacro;
	Param	eItCount;
	Param	eTabCount;
	Param	eTabPos[maxTabStops];
	char	eTabType[maxTabStops];
	int	eTabChar;
	int	eLeaderChar;
	Param	eUlCount;
	Param	eCUlCount;
	int	eCtrlChar;
	int	eNbCtrlChar;
	Param	eHyphenMode;
	int	eHyphenChar;
	Param	eTitleLen;
	Param	ePrevTitleLen;
	/* nm not supported */
	/* nn not supported */
	/* mc not supported */
};


extern int	ReadActionFile ();
extern void	FreeActions ();

extern int	ProcessActionList ();
extern int	ProcessLine ();
extern void	ProcessRequest ();
extern void	ProcessText ();

extern UChar	*InterpretActionArg ();
extern int	ParseNumber ();
extern void	ParseWidth ();
extern UChar	*ParseNameRef ();
extern Param	ParseSizeRef ();

extern int	AParseARNumber ();
extern int	AParseChar ();
extern int	AParseCondition ();
extern int	AParseFileName ();
extern int	AParseMacroArgs ();
extern int	AParseName ();
extern int	AParseNumber ();
extern int	AParseRemoveList ();
extern int	AParseS ();
extern int	AParseStringValue ();
extern int	AParseTabStops ();
extern int	AParseTitle ();
extern int	AParseTransList ();
extern int	AProcessCondition ();

extern int	APointSize ();
extern int	ASpaceSize ();
extern int	AConstantWidth ();
extern int	AEmbolden ();
extern int	AFont ();
extern int	AFontPosition ();

extern int	APageLength ();
extern int	ABeginPage ();
extern int	APageNumber ();
extern int	AOffset ();
extern int	ANeed ();
extern int	AMarkVertical ();
extern int	AReturnVertical ();

extern int	ABreak ();
extern int	AFill ();
extern int	ANofill ();
extern int	AAdjust ();
extern int	ANoAdjust ();
extern int	ACenter ();

extern int	ASpacing ();
extern int	ALineSpacing ();
extern int	ASpace ();
extern int	ASaveSpace ();
extern int	AOutputSpace ();
extern int	ANoSpace ();

extern int	ALineLength ();
extern int	AIndent ();
extern int	ATempIndent ();

extern int	ADefineMacro ();
extern int	AAppendMacro ();
extern int	ADefineString ();
extern int	AAppendString ();
extern int	ARenameName ();
extern int	ADiversion ();
extern int	AAppendDiversion ();
extern char	*CurrentDiversion ();
extern int	AEndMacro ();
extern int	AInputTrap ();

extern int	ADefineRegister ();
extern int	ARegisterFormat ();

extern int	ATabStops ();
extern int	ASetTabChar ();
extern int	ASetLeaderChar ();
extern int	ASetFieldChars ();

extern int	ASetEscape ();
extern int	ANoEscape ();

extern int	ALigature ();

extern int	AUnderline ();
extern int	ACUnderline ();
extern int	AUnderlineFont ();

extern int	ASetControl ();
extern int	ASetControl2 ();

extern int	ATransliterate ();

extern int	AHyphenation ();
extern int	ASetHyphenChar ();
extern int	AHyphenWords ();

extern int	ATitle ();
extern int	APageNumChar ();
extern int	ATitleLength ();

extern int	ALineNumbering ();
extern int	ANoNumbering ();

extern int	AEnvironment ();

extern int	AExit ();
extern int	AAbort ();

extern int	APushFile ();
extern int	ASwitchFile ();

extern int	ASetMarginChar ();
extern int	AEcho ();
extern int	AIgnore ();

extern int	ASpecialChar ();
extern int	APushStr ();
extern int	AEol ();
extern int	AWriteControl ();
extern int	AWriteText ();
extern int	AWriteSpecial ();

extern int	ADebugFlag ();
extern int	ADumpMacro ();

extern Param	InterpretParam ();
extern int	InterpretParamChar ();

extern void	SetCFA ();
extern void	SetFill ();
extern void	SetAdjustment ();
extern void	SetSize ();
extern void	SetSpaceSize ();
extern void	SetFont ();
extern char	*GetFontName ();
extern char	*GetFontNameBySlot ();
extern void	SetFontNameBySlot ();
extern void	SetOffset ();
extern void	SetSpacing ();
extern void	SetLineSpacing ();
extern void	SetLineLength ();
extern void	SetIndent ();
extern void	SetTempIndent ();
extern void	SetHyphenation ();
extern void	SetTitleLength ();
extern void	SetPageNumber ();
extern void	SetTabStops ();

extern void	InitEnvironments ();
extern void	PushEnvironment ();
extern void	PopEnvironment ();

extern Request	*NewRequest ();
extern Macro	*NewMacro ();
extern String	*NewString ();
extern Register	*NewRegister ();
extern NameDef	*LookupName ();
extern Request	*LookupRequest ();
extern Macro	*LookupMacro ();
extern String	*LookupString ();
extern Register	*LookupRegister ();
extern SpChar	*LookupSpChar ();
extern SpChar	*LookupSpCharByCode ();
extern void	RenameName ();
extern void	RemoveName ();
extern void	RemoveNameDef ();

extern void	SetRegisterFormat ();
extern Register	*ParseRegisterRef ();
extern char	*FormatRegister ();
extern Param	GetRegisterValue ();
extern void	SetRegisterValue ();

extern char	*CharToStr ();

extern void	CopyMode ();
extern int	SwitchFile ();
extern int	PushFile ();
extern int	PushString ();
extern int	PushMacro ();
extern int	PushAnonString ();
extern int	ChPeek ();
extern int	ChIn ();
extern void	UnChIn ();
extern int	GetLine ();

extern void	InitTransliterate ();
extern void	Transliterate ();
extern void	Break ();
extern void	FlushOText ();
extern void	ControlOut ();
extern void	CommentOut ();
extern void	SpecialTextOut ();
extern void	TextChOut ();
extern void	ChOut ();
extern void	StrOut ();
extern int	AllowOutput ();

/*extern void	SkipToStr ();*/
extern void	SkipWhite ();
extern void	SkipToEol ();

extern int	ToEsc ();
extern int	FromEsc ();

extern int	Esc ();
extern int	Special ();
extern int	Eol ();
extern int	Sign ();
extern int	White ();
extern int	WhiteOrEol ();
extern int	UnitChar ();
extern int	Digit ();

extern int	EmptyArg ();
extern int	NumericArg ();

extern Param	ToBU ();
extern double	FromBU ();

extern double	Atof ();
extern long	Atol ();
extern int	Atoi ();

extern char	*UStrToStr ();
extern int	PlainStr ();

extern Param	GetPid ();

extern int	troff;

extern Param	resolution;

extern int	allowInput;
extern int	escChar;
extern int	doEscapes;

extern int	ctrlChar;
extern int	nbCtrlChar;
extern int	curCtrlChar;
extern int	fieldDelimChar;
extern int	fieldPadChar;
extern int	fieldDelimCount;
extern int	optHyphenChar;

extern int	tabChar;
extern int	leaderChar;

extern long	debug;

extern NameDef	*nameList;
extern SpChar	*spCharList;

extern int	needSpace;
extern int	inContinuation;
extern int	ifLevel;
extern int	ifResult;

extern char	fontTab[maxFonts][maxFontNameLen];
extern char	curFont[];
extern char	prevFont[];

extern UChar	*itMacro;
extern Param	itCount;
extern UChar	*endMacro;

extern Param	centerCount;
extern Param	ulCount;
extern Param	cUlCount;

extern Param	fillMode;
extern Param	adjMode;
extern Param	adjust;

extern Param	curSize;
extern Param	prevSize;
extern Param	curSpaceSize;

extern Param	curVSize;
extern Param	prevVSize;
extern Param	curLineSpacing;
extern Param	prevLineSpacing;

extern Param	curIndent;
extern Param	prevIndent;
extern Param	curTempIndent;
extern Param	curLineLen;
extern Param	prevLineLen;

extern Param	curOffset;
extern Param	prevOffset;
extern Param	curPageLen;
extern Param	curPageNum;

extern Param	curHyphenMode;

extern Param	pageNumChar;
extern Param	curTitleLen;
extern Param	prevTitleLen;

extern Param	curTabCount;
extern Param	tabPos[];
extern char	tabType[];
