extern char	*strcpy ();
extern char	*strcat ();


/*
	Adding a new control or special text keyword:
	
	1) #define it below somewhere.
	2) Add it to the appropriate lookup table in r-read.c.  If it's
	a control keyword, add it to the arg count table in r-read.c.
	3) Put it in the appropriate switch statements in your application,
	and add code to take whatever action is necessary when it occurs.
*/

# define	tcrEOF		0	/* eof on input */
# define	tcrControl	1	/* control word */
# define	tcrText		2	/* literal text char */
# define	tcrSText	3	/* special text */


/*
	Control class major numbers
*/

# define	tcrCUnknown	0
# define	tcrComment	1
# define	tcrBeginSetup	2
# define	tcrEndSetup	3
# define	tcrResolution	4

# define	tcrPointSize	10
# define	tcrSpaceSize	11
# define	tcrConstantWidth 12
# define	tcrEmbolden	13
# define	tcrSEmbolden	14
# define	tcrFont		15

# define	tcrPageLength	20
# define	tcrBeginPage	21
# define	tcrPageNumber	22
# define	tcrOffset	23
# define	tcrNeed		24
# define	tcrMark		25

# define	tcrBreak	30
# define	tcrCFA		31
# define		tcrNofill	0
# define		tcrCenter	1
# define		tcrAdjFull	2
# define		tcrAdjLeft	3
# define		tcrAdjRight	4
# define		tcrAdjCenter	5
# define	tcrBreakSpread	32

# define	tcrSpacing	40
# define	tcrLineSpacing	41
# define	tcrSpace	42
# define	tcrExtraSpace	43

# define	tcrLineLength	50
# define	tcrIndent	51
# define	tcrTempIndent	52

# define	tcrBegDiversion	60
# define	tcrAppDiversion	61
# define	tcrEndDiversion	62

# define	tcrResetTabs	70
# define	tcrFirstTab	71
# define	tcrNextTab	72
# define	tcrTabChar	73
# define	tcrLeaderChar	74

# define	tcrUnderline	80
# define	tcrNoUnderline	81
# define	tcrCUnderline	82
# define	tcrULineFont	83

# define	tcrMotion	90

# define	tcrBeginOverstrike 100
# define	tcrEndOverstrike 101
# define	tcrBeginBracket	102
# define	tcrEndBracket	103
# define	tcrZeroWidth	104
# define	tcrLine		105

# define	tcrHyphenate	110

# define	tcrTitleLength	120
# define	tcrBeginTitle	121
# define	tcrEndTitle	122


/*
	Special text major numbers.  The only ones explicitly
	assigned numbers are those built into troffcvt, for the
	most part.
*/

# define	tcrSTUnknown	0
# define	tcrBackslash	2
# define	tcrAtSign	3
# define	tcrRSglQuote	4
# define	tcrLSglQuote	5
# define	tcrRDblQuote	6
# define	tcrLDblQuote	7
# define	tcrZeroSpace	8
# define	tcrSixthSpace	9
# define	tcrTwelfthSpace	10
# define	tcrDigitSpace	11
# define	tcrHardSpace	12
# define	tcrMinus	13
# define	tcrAcuteAccent	14
# define	tcrGraveAccent	15
# define	tcrBackspace	16
# define	tcrEmDash	17
# define	tcrOptHyphen	18
# define	tcrTab		19
# define	tcrLeader	20
# define	tcrLeaderPad	21


# define	tcrBold		0x01
# define	tcrItal		0x02

typedef	struct TCRFont	TCRFont;	/* font information */

struct TCRFont
{
	char	*tcrTroffName;		/* font's troff name */
	char	*tcrTypeFace;		/* typeface (font family) */
	int	tcrAtts;		/* font attributes */
	int	tcrFontNum;		/* font number */
	TCRFont	*nextTCRFont;		/* next font in list */
};




extern void	TCRInit ();
extern int	TCRGetToken ();
extern int	TCRGetLine ();
extern long	TCRStrToNum ();
extern int	TCRReadFonts ();
extern TCRFont	*TCRLookupFont ();

extern TCRFont	*tcrFontList;
extern int	tcrClass;
extern int	tcrMajor;
extern int	tcrMinor;
extern int	tcrArgc;
extern char	*tcrArgv[];
