/*
	Still needs to split output lines.

	tc2text - read output from troffcvt and extract the text

	This troffcvt postprocessor is part of unroff - a smarter
	version of deroff.  For one thing, it can be configured to
	do different things with special characters simply by editing
	text-specials.

	20 Apr 92	Paul DuBois	dubois@primate.wisc.edu

	20 Apr 92 V1.00.  Created.
*/

# ifdef	THINK_C
# include	<console.h>
# endif /* THINK_C */
# include	<stdio.h>
# include	<ctype.h>
# if __STDC__
# include	<stdlib.h>	/* for atoi() */
# else
# include	<math.h>
# endif

# include	"etm.h"
# include	"memmgr.h"
# include	"tokenscan.h"

# include	"tcr.internal.h"
# include	"tcr.h"


# ifndef	LIBDIR
# define	LIBDIR	"/usr/lib/troffcvt"
# endif

# define	defSplitLen	68


/*
	Special character structure
*/


typedef	struct SpChar	SpChar;

struct SpChar
{
	char	*spName;
	char	*spValue;
	SpChar	*spNext;
};



static void	ReadFile ();
static void	ControlLine ();
static void	SpecialText ();
static void	PlainText ();
static void	DrawLine ();
static int	ReadSpecials ();
static SpChar	*LookupSpecial ();
static int	IsNumber ();
static void	ChOut ();
static void	StrOut ();


static SpChar	*spList;
static char	*libDir = LIBDIR;

static long	resolution = 432;

static int	split = 1;
static int	splitLen = defSplitLen;
static int	tossWhite = 0;
static int	oLen = 0;

static int	echo = 0;


static char	*usage = "tc2text [ -split nnn ] [ -join ] [ -e ] [ file ] ...";


int main (argc, argv)
int	argc;
char	**argv;
{
char	*p;
int	inc;

	ETMInit (NULL);

# ifdef	THINK_C
	argc = ccommand (&argv);
# endif /* THINK_C */

	--argc;
	++argv;
	while (argc > 0 && argv[0][0] == '-')
	{
		inc = 1;
		if (strcmp (argv[0], "-e") == 0)
			echo = 1;
		else if (strcmp (argv[0], "-join") == 0)
			split = 0;
		else if (strncmp (argv[0], "-split", 6) == 0)
		{
			split = 1;
			p = argv[0];
			if (p[6] != '\0')		/* -splitnnn */
			{
				p += 6;
				if (!IsNumber (p))
				{
					ETMMsg ("-split not followed by valid number");
					ETMPanic ("%s", usage);
				}
			}
			else if (argc < 2)
				p = (char *) NULL;
			else
			{
				p = argv[1];
				if (IsNumber (p))		/* -split nnn */
				{
					++inc;
					p = argv[1];
				}
				else				/* -split */
					p = (char *) NULL;
			}
			if (p != (char *) NULL)
			{
				splitLen = atoi (p);
				/*
				if (splitLen > maxSplitLen)
					ETMPanic ("unreasonable -split length");
				*/
			}
		}
		else
		{
			ETMMsg ("Unknown option: %s", argv[0]);
			ETMPanic ("%s", usage);
		}

		argc -= inc;
		argv += inc;
	}

	if (!ReadSpecials ((char *) NULL, "text-specials"))
	{
		if (!ReadSpecials (libDir, "text-specials"))
			ETMPanic ("cannot find text-specials file");
	}

	TCRInit ();

	if (argc == 0)		/* stdin */
		ReadFile ();
	else while (argc > 0)
	{
		if (freopen (argv[0], "r", stdin) == (FILE *) NULL)
			ETMMsg ("Cannot open: %s", argv[0]);
		else
			ReadFile ();
		--argc;
		++argv;
	}

	ETMEnd ();
	return (0);
}


static void ReadFile ()
{
int	i;

	while (TCRGetToken () != tcrEOF)
	{
		if (echo)
		{
			ETMMsg ("class %d maj %d min %d <%s>",
				tcrClass, tcrMajor, tcrMinor, tcrArgv[0]);
			if (tcrClass == tcrControl || tcrClass == tcrSText)
			{
				for (i = 1; i < tcrArgc; i++)
					ETMMsg ("\t<%s>", tcrArgv[i]);
			}
		}
		switch (tcrClass)
		{
		case tcrControl:	ControlLine (); break;
		case tcrText:		PlainText (); break;
		case tcrSText:		SpecialText (); break;
		default:	ETMPanic ("ReadFile: unknown class %d",
							tcrClass);
		}
	}
}


static void ControlLine ()
{
	switch (tcrMajor)
	{
	default:
		ETMMsg ("ControlLine: bad control major code: %d <%s>",
						tcrMajor, tcrArgv[0]);
		break;
	case tcrCUnknown:
		ETMMsg ("ControlLine: unknown control token: <%s>",
						tcrArgv[0]);
		break;
	case tcrBreak:
		ChOut ('\n');
		break;
	case tcrSpace:
		ChOut ('\n');
		break;
	case tcrCFA:
	case tcrComment:
	case tcrBeginSetup:
	case tcrEndSetup:
		break;
	case tcrResolution:
		resolution = TCRStrToNum (tcrArgv[1]);
		break;
	case tcrFont:
	case tcrPointSize:
	case tcrSpacing:
	case tcrLineSpacing:
	case tcrOffset:
	case tcrIndent:
	case tcrTempIndent:
	case tcrLineLength:
	case tcrPageLength:
	case tcrPageNumber:
	case tcrTitleLength:
	case tcrBeginTitle:
	case tcrEndTitle:
	case tcrUnderline:
	case tcrCUnderline:
	case tcrNoUnderline:
	case tcrULineFont:
	case tcrBeginBracket:
	case tcrEndBracket:
	case tcrBreakSpread:
	case tcrExtraSpace:
		break;
	case tcrLine:
		DrawLine (TCRStrToNum (tcrArgv[1]), tcrArgv[2][0]);
		break;
	case tcrMark:
	case tcrMotion:
	case tcrBeginOverstrike:
	case tcrEndOverstrike:
	case tcrBeginPage:
	case tcrZeroWidth:
	case tcrSpaceSize:
	case tcrConstantWidth:
	case tcrNeed:
	case tcrEmbolden:
	case tcrSEmbolden:
	case tcrResetTabs:
	case tcrFirstTab:
	case tcrNextTab:
	case tcrHyphenate:
	case tcrBegDiversion:
	case tcrAppDiversion:
	case tcrEndDiversion:
	case tcrTabChar:
	case tcrLeaderChar:
		break;
	}
}


static void PlainText ()
{
	if (tcrMajor != '\n' && tcrMajor != '\r')
		ChOut (tcrMajor);
}


/*
	Draw a line (horizontal only).  The number of - characters to
	write is just a guess appropriate for terminals; probably should
	be a way of controlling with a command line argument.
*/

static void DrawLine (length, direction)
long	length;
int	direction;
{
	if (tcrArgv[2][0] != 'h')	/* ignore vertical lines */
		return;
	length = length * 10 / resolution;	/* 10 chars/inch */
	while (length-- > 0)
		ChOut ('-');
}


static void SpecialText ()
{
SpChar	*sp;

	if ((sp = LookupSpecial (&tcrArgv[0][1])) == (SpChar *) NULL)
	{
		StrOut ("[[");
		StrOut (&tcrArgv[0][1]);
		StrOut ("]]");
	}
	else
		StrOut (sp->spValue);
}


/*
	Read special character list.
*/

static int ReadSpecials (dir, filename)
char	*dir;
char	*filename;
{
TSScanner	scanner;
FILE	*f;
char	buf[bufSiz];
SpChar	*sp;
char	*name, *value;

	if (dir == (char *) NULL || filename[0] == '/')
		(void) strcpy (buf, filename);
	else
		sprintf (buf, "%s/%s", dir, filename);
	if ((f = fopen (buf, "r")) == (FILE *) NULL)
		return (0);
	TSGetScanner (&scanner);		/* want default scanner */
	TSSetScanner ((TSScanner *) NULL);	/* behavior */
	while (TCRGetLine (buf, (int) sizeof (buf), f))
	{
		if (buf[0] == '#')
			continue;
		TSScanInit (buf);
		if ((name = TSScan ()) == (char *) NULL)	/* char name */
			continue;
		if ((value = TSScan ()) == (char *) NULL)	/* char value */
			value = "";
		sp = New (SpChar);
		sp->spName = StrAlloc (name);
		sp->spValue = StrAlloc (value);
		sp->spNext = spList;
		spList = sp;
	}
	(void) fclose (f);
	TSSetScanner (&scanner);
	return (1);
}


static SpChar *LookupSpecial (name)
char	*name;
{
SpChar	*sp;

	for (sp = spList; sp != (SpChar *) NULL; sp = sp->spNext)
	{
		if (strcmp (name, sp->spName) == 0)
			break;
	}
	return (sp);	/* NULL if not found */
}


/*
	Return non-zero if s isn't null or empty and consists of all digits.
*/

static int IsNumber (s)
char	*s;
{
	if (s == (char *) NULL || *s == '\0')
		return (0);
	while (*s != '\0')
	{
		if (!isdigit (*s))
			return (0);
		++s;
	}
	return (1);
}


static void StrOut (s)
char	*s;
{
	while (*s != '\0')
		ChOut (*s++);
}


static void ChOut (c)
int	c;
{
	if (!split)
	{
		putchar (c);
		return;
	}
	if (tossWhite && c == ' ')
		return;
	tossWhite = 0;
	if (oLen >= splitLen && c == ' ')	/* found split point */
	{
		putchar ('\n');
		oLen = 0;
		tossWhite = 1;
		return;
	}
	putchar (c);
	if (c != '\n')
		++oLen;
	else
		oLen = 0;
}
