/*
	tc2null - read output from troffcvt and do nothing with it.

	Actually, it's not quite true that nothing is done: unrecognized
	tokens are flagged, so tc2null in a way serves as a diagnostic
	program.

	The main use of this "translator" is to serve as a starting point
	for building troffcvt postprocessors.

	20 Apr 92	Paul DuBois	dubois@primate.wisc.edu

	20 Apr 92 V1.00.  Created.
*/

# ifdef	THINK_C
# include	<console.h>
# endif /* THINK_C */
# include	<stdio.h>
# include	<ctype.h>

# include	"etm.h"
# include	"memmgr.h"

# include	"tcr.internal.h"
# include	"tcr.h"


static void	ReadFile ();
static void	ControlLine ();
static void	PlainText ();
static void	SpecialText ();
static void	CenterFillAdjust ();


int	echo = 0;


int main (argc, argv)
int	argc;
char	**argv;
{
	ETMInit (NULL);

# ifdef	THINK_C
	argc = ccommand (&argv);
# endif /* THINK_C */

	--argc;
	++argv;
	while (argc > 0 && argv[0][0] == '-')
	{
		if (strcmp (argv[0], "-e") == 0)
			echo = 1;
		else
			ETMPanic ("Unknown option: %s", argv[0]);
		--argc;
		++argv;
	}

	TCRInit ();

	if (argc == 0)		/* stdin */
		ReadFile ();
	else while (argc > 0)
	{
		if (freopen (argv[0], "r", stdin) == (FILE *) NULL)
			ETMMsg ("Cannot open: %s", argv[0]);
		else
			ReadFile ();
		--argc;
		++argv;
	}

	ETMEnd ();
	return (0);
}


static void ReadFile ()
{
int	i;

	while (TCRGetToken () != tcrEOF)
	{
		if (echo)
		{
			printf ("class %d maj %d min %d <%s>\n",
				tcrClass, tcrMajor, tcrMinor, tcrArgv[0]);
			if (tcrClass == tcrControl || tcrClass == tcrSText)
			{
				for (i = 1; i < tcrArgc; i++)
					printf ("\t<%s>\n", tcrArgv[i]);
			}
		}
		switch (tcrClass)
		{
		case tcrControl:	ControlLine (); break;
		case tcrText:		PlainText (); break;
		case tcrSText:		SpecialText (); break;
		default:	ETMPanic ("ReadFile: unknown class %d",
							tcrClass);
		}
	}
}


static void ControlLine ()
{
	switch (tcrMajor)
	{
	default:
		ETMMsg ("ControlLine: bad control major code: %d <%s>",
						tcrMajor, tcrArgv[0]);
		break;
	case tcrCUnknown:
		ETMMsg ("ControlLine: unknown control token: <%s>",
						tcrArgv[0]);
		break;
	case tcrCFA:
		CenterFillAdjust ();
		break;
	case tcrComment:
	case tcrBeginSetup:
	case tcrEndSetup:
	case tcrResolution:
	case tcrBreak:
	case tcrFont:
	case tcrPointSize:
	case tcrSpacing:
	case tcrLineSpacing:
	case tcrOffset:
	case tcrIndent:
	case tcrTempIndent:
	case tcrLineLength:
	case tcrPageLength:
	case tcrPageNumber:
	case tcrTitleLength:
	case tcrBeginTitle:
	case tcrEndTitle:
	case tcrSpace:
	case tcrUnderline:
	case tcrCUnderline:
	case tcrNoUnderline:
	case tcrULineFont:
	case tcrBeginBracket:
	case tcrEndBracket:
	case tcrBreakSpread:
	case tcrExtraSpace:
	case tcrLine:
	case tcrMark:
	case tcrMotion:
	case tcrBeginOverstrike:
	case tcrEndOverstrike:
	case tcrBeginPage:
	case tcrZeroWidth:
	case tcrSpaceSize:
	case tcrConstantWidth:
	case tcrNeed:
	case tcrEmbolden:
	case tcrSEmbolden:
	case tcrResetTabs:
	case tcrFirstTab:
	case tcrNextTab:
	case tcrHyphenate:
	case tcrBegDiversion:
	case tcrAppDiversion:
	case tcrEndDiversion:
	case tcrTabChar:
	case tcrLeaderChar:
		break;
	}
}


static void PlainText ()
{
	if (tcrMajor != '\n' && tcrMajor != '\r')
	{
		/* do something with character */
	}
}


static void SpecialText ()
{
	switch (tcrMajor)
	{
	default:
		printf ("bad special text major code: %d <%s>\n",
						tcrMajor, tcrArgv[0]);
	case tcrSTUnknown:
	case tcrBackslash:
	case tcrAtSign:
	case tcrRSglQuote:
	case tcrLSglQuote:
	case tcrRDblQuote:
	case tcrLDblQuote:
	case tcrZeroSpace:
	case tcrSixthSpace:
	case tcrTwelfthSpace:
	case tcrDigitSpace:
	case tcrHardSpace:
	case tcrMinus:
	case tcrGraveAccent:
	case tcrAcuteAccent:
	case tcrBackspace:
	case tcrEmDash:
	case tcrOptHyphen:
	case tcrTab:
	case tcrLeader:
	case tcrLeaderPad:
		break;
	}
}


static void CenterFillAdjust ()
{
	switch (tcrMinor)
	{
	default:
		ETMMsg ("CenterFillAdjust: bad minor code %d <%s>",
						tcrMinor, tcrArgv[0]);
		break;
	case tcrCenter:
	case tcrNofill:
	case tcrAdjFull:
	case tcrAdjLeft:
	case tcrAdjRight:
	case tcrAdjCenter:
		break;
	}
}
