/*
	Underline setting isn't really correct yet.

	Routines for setting various processing parameters and writing out
	their values if they've changed.
*/

# include	<stdio.h>
# include	<ctype.h>

# include	"etm.h"

# include	"troffcvt.h"


# define	Max(a,b)	(a > b ? a : b)


static void	SpitSetting ();
static Param	GetFontNumber ();


void SetPageLength (val)
Param	val;
{
char	buf[bufSiz];

	if (val != curPageLen)
	{
		sprintf (buf, "page-length %ld", val);
		ControlOut (buf);
		curPageLen = val;
		SetRegisterValue (".p", curPageLen);
	}
}


/*
	Set centering, filling, adjusting stuff.  Test the various modes,
	from lowest priority to highest, to figure out which control to
	write out.  At the end, compare it with the one last written to
	determine whether it really needs to be written.

	This has the property of setting all four state variables properly
	and keeping them up to date internally, which only writing the
	current setting explicitly so postprocessors don't have to mess
	with interactions between them.  And of writing the minimum output.
*/

void SetCFA (nCenter, nFill, nAdjust, nAdjMode)
Param	nCenter, nFill, nAdjust, nAdjMode;
{
static char	*lastSetting = "";
char	*p = "";

	switch (adjMode = nAdjMode)
	{
	case adjLeft:	p = "adjust-left"; break;
	case adjRight:	p = "adjust-right"; break;
	case adjFull:	p = "adjust-full"; break;
	case adjCenter:	p = "adjust-center"; break;
	}

	if ((adjust = nAdjust) == 0)
		p = "adjust-left";
	if ((fillMode = nFill) == nofill)
		p = "nofill";
	if (nCenter < 0)	/* fix first if necessary */
		nCenter = 0;
	if ((centerCount = nCenter) > 0)
		p = "center";

	if (strcmp (p, lastSetting) != 0)	/* setting's changed */
		ControlOut (lastSetting = p);

	SetRegisterValue (".u", (Param) (fillMode == fill));
	SetRegisterValue (".j", (Param) (adjMode + (adjust ? 4 : 0)));
}


/*
	Set the underlining properly, turning it on or off depending
	on the current state and the new state.  If both are positive
	regular ul takes precedence over continuous ul.

	Default is to assume it's off, and turn on if find out otherwise.
*/

void SetUnderline (ul, cul)
Param	ul, cul;
{
static char	*lastSetting = "";
char	*p = "nounderline";

	if (ul < 0)
		ul = 0;
	if (cul < 0)
		cul = 0;

	if ((cUlCount = cul) > 0)		/* turn cul on */
		p = "cunderline";

	if ((ulCount = ul) > 0)			/* turn ul on */
		p = "underline";

	if (strcmp (p, lastSetting) != 0)	/* setting's changed */
		ControlOut (lastSetting = p);
}


/*
	.ft 0 and \f0 are equivalent; they refer to last named but never
	mounted font.

	It is necessary the new be a copy of the argument passed in if
	the argument isn't a number, otherwise SetFont(prevFont) would
	set curFont, but not cycle curFont into prevFont;
*/

void SetFont (name)
char	*name;
{
char	new[maxFontNameLen], *p;
char	buf[bufSiz];
Param	number;

	if (name == (char *) NULL || strlen (name) >= maxFontNameLen)
		return;
	new[0] = '\0';
	if (strcmp (name, "P") == 0)	/* revert to previous */
		(void) strcpy (new, prevFont);
	else if ((p = GetFontName (name)) != (char *) NULL)
		(void) strcpy (new, p);

	if (new[0] == '\0')
		return;

	if (strcmp (new, curFont) != 0)
	{
		sprintf (buf, "font %s", new);
		ControlOut (buf);
	}

	(void) strcpy (prevFont, curFont);
	(void) strcpy (curFont, new);
	if ((number = GetFontNumber (curFont)) < 0)
	{
		SetFontNameBySlot ((Param) 0, curFont);
		number = 0;
	}
	SetRegisterValue (".f", number);
}


/*
	Given a font reference as a number or name, return the name
	or NULL if the reference is bad.
*/

char *GetFontName (p)
char	*p;
{
	if (p != (char *) NULL && Digit (*p))
	{
		if (*(p+1) != '\0')	/* only one digit allowed */
			return ((char *) NULL);
		/* this will be NULL if bad */
		p = GetFontNameBySlot ((Param) (*p - '0'));
	}
	if (p == (char *) NULL || *p == '\0')	/* null or empty? */
		return ((char *) NULL);
	return (p);
}


static Param GetFontNumber (p)
char	*p;
{
Param	i;

	for (i = 0; i < maxFonts; i++)
	{
		if (fontTab[i] != (char *) NULL
			&& strcmp (fontTab[i], p) == 0)
				return (i);
	}
	return ((Param) -1);
}


/*
	The zeroth font table entry is reserved.  troff uses position 0
	for the hidden font (the last named, but unmounted font)
*/

char *GetFontNameBySlot (pos)
Param	pos;
{
	if (pos < 0 || pos >= maxFonts)
		return ((char *) NULL);
	return (fontTab[pos]);
}


void SetFontNameBySlot (pos, name)
Param	pos;
char	*name;
{
int	len;

	if (pos < 0 || pos >= maxFonts)
		return;
	if (name == (char *) NULL || (len = strlen (name)) == 0
			|| len >= maxFontNameLen)
		return;
	if (!PlainStr (name))
	{
		ETMMsg ("disallowed font name <%s>", UStrToStr (name));
		return;
	}
	(void) strcpy (fontTab[pos], name);
}


/*
	If format isn't recognized, defaults are used.
*/

void SetRegisterFormat (rp, format)
Register	*rp;
char	*format;
{
int	fmt = numFmt, fmtWidth = 0;

	/*
		I suppose this should really check that ALL characters
		are numeric, but then what does it mean if they're not?
	*/
	if (Digit (*format))
	{
		if (strlen (format) > 1)	/* else leave at 0 */
			fmtWidth = strlen (format);
	}
	else switch (*format)
	{
	case 'i': fmt = lRomanFmt; break;
	case 'I': fmt = uRomanFmt; break;
	case 'a': fmt = lAlphaFmt; break;
	case 'A': fmt = uAlphaFmt; break;
	}
	rp->regFormat = fmt;
	rp->regFmtWidth = fmtWidth;
}


/*
	Format a register value and return a pointer to the (static)
	string result.  Registers with i, I, a or A format are number
	formatted if the value is less than 1.

	Roman and Alphabetic are broken.  The former isn't even attempted,
	and the algorithm for the latter doesn't always work.  I'm too
	lazy to fix it right now.
*/

char *FormatRegister (rp)
Register	*rp;
{
static char	buf[bufSiz];
char	*p = buf;
Param	value = rp->regValue;
int	format = rp->regFormat;
int	wid = rp->regFmtWidth;
int	i, n;

	if (1 /* format == numFmt || value < 1 */ )
	{
		if (wid == 0)
			sprintf (buf, "%ld", value);
		else
			sprintf (buf, "%0*ld", wid, value);
		return (buf);
	}
	if (format == lAlphaFmt || format == uAlphaFmt)
	{
		n = 1;
		while (n <= value)
		{
			n *= 26;
			if (n < 0)	/* uh-oh...underflow */
				ETMPanic ("FormatRegister: numeric underflow");
		}
		while (n > 1)
		{
			n /= 26;
			i = 0;
			*p = 'a';
			while (value > n)
			{
				value -= n;
				(*p)++;
			}
			++p;
		}
		*p = '\0';
	}
	else	/* format is roman */
	{
		sprintf (buf, "%ld", value);	/* wimp out for now */
	}
	/* now uppercase the string if necessary */
	if (format == uAlphaFmt || format == uRomanFmt)
	{
		for (p = buf; *p != '\0'; p++)
		{
			if (islower (*p))
				*p = toupper (*p);
		}
	}
	return (buf);
}


Param GetRegisterValue (name)
char	*name;
{
Register	*rp;

	if ((rp = LookupRegister (name)) == (Register *) NULL)
		return ((Param) 0);
	return (rp->regValue);
}


/*
	Perhaps this should auto-create registers?
*/

void SetRegisterValue (name, val)
char	*name;
Param	val;
{
Register	*rp;

	if ((rp = LookupRegister (name)) == (Register *) NULL)
		ETMMsg ("attempt to set non-existent register <%s>",
								UStrToStr (name));
	else
		rp->regValue = val;
}


/*
	The following SetXXX() routines maintain the asked-for value
	internally, to maintain the integrity of matching relative
	changes (e.g., .xx -N followed by .xx +N), but won't write out
	ridiculous values.  Instead they write out a lower-limit value
	instead.

	Some parameters need to be clipped, however (e.g., indent, line
	length).  For those, cur should be clipped before calling
	SpitSetting().
*/

static void SpitSetting (name, cur, new, lower)
char	*name;
Param	cur, new, lower;
{
char	buf[bufSiz];

	if (cur != new)
	{
		sprintf (buf, "%s %ld", name, Max (lower, new));
		ControlOut (buf);
	}
}


/*
	Point size is maintained in points, not units.
*/

void SetSize (val)
Param	val;
{
	SpitSetting ("point-size", curSize, val, Units (1, 'x'));
	prevSize = curSize;
	curSize = val;
	SetRegisterValue (".s", curSize);
}


void SetSpaceSize (val)
Param	val;
{
	SpitSetting ("space-size", curSpaceSize, val, Units (0, 'x'));
	curSpaceSize = val;
}


/*
	groff allows page offset to be set negative, but no other
	troff/nroff/*roff I've found does so, so value is clipped
	to zero here.
*/

void SetOffset (val)
Param	val;
{
	val = Max (val, Units (0, 'i'));	/* can't set negative */
	SpitSetting ("offset", curOffset, val, Units (0, 'i'));
	prevOffset = curOffset;
	curOffset = val;
	SetRegisterValue (".o", curOffset);
}


void SetSpacing (val)
Param	val;
{
	SpitSetting ("spacing", curVSize, val, Units (1, 'p'));
	prevVSize = curVSize;
	curVSize = val;
	SetRegisterValue (".v", curVSize);
}


void SetLineSpacing (val)
Param	val;
{
	val = Max (val, Units (1, 'x'));	/* can't set < 1 */
	SpitSetting ("line-spacing", curLineSpacing, val, Units (1, 'x'));
	prevLineSpacing = curLineSpacing;
	curLineSpacing = val;
	SetRegisterValue (".L", curLineSpacing);
}


void SetLineLength (val)
Param	val;
{
	val = Max (val, Units (0.1, 'i'));	/* can't set < .1i */
	SpitSetting ("line-length", curLineLen, val, Units (0.1, 'i'));
	prevLineLen = curLineLen;
	curLineLen = val;
	SetRegisterValue (".l", curLineLen);
}


void SetIndent (val)
Param	val;
{
	val = Max (val, Units (0, 'i'));	/* can't set negative */
	SpitSetting ("indent", curIndent, val, Units (0, 'i'));
	prevIndent = curIndent;
	curIndent = val;
	SetRegisterValue (".i", curIndent);
}


/*
	Temp indents are set relative to current indent.  Successive
	temp-indents before next output line don't cascade; only the
	last one is used.

	Cannot temp-indent left by more than current indent.

	Pass val+1 for "current" value because this parameter has
	an effect only transiently and we can't tell whether it's
	still in effect or not.  So force it to print on every
	occurrence.
*/

void SetTempIndent (val)
Param	val;
{
	SpitSetting ("temp-indent", val + 1, val, -curIndent);
	curTempIndent = val;
}


void SetHyphenation (val)
Param	val;
{
char	buf[bufSiz];

	if (val != curHyphenMode)
	{
		sprintf (buf, "hyphenate %ld", val);
		ControlOut (buf);
	}
	curHyphenMode = val;
}


void SetTitleLength (val)
Param	val;
{
	val = Max (val, Units (0, 'i'));	/* can't set negative */
	SpitSetting ("title-length", curTitleLen, val, Units (0, 'i'));
	prevTitleLen = curTitleLen;
	curTitleLen = val;
}


void SetPageNumber (val)
Param	val;
{
	SpitSetting ("page-number", curPageNum, val, Units (-99999, 'x'));
	SetRegisterValue ("%", curPageNum = val);
}


void SetTabStops (n, pos, type)
Param	n, pos[];
char	type[];
{
char	buf[bufSiz];
int	same = 1;	/* assume all same until know otherwise */
int	i;

	if (n != curTabCount)
		same = 0;
	else for (i = 0; i < curTabCount; i++)
	{
		if (pos[i] != tabPos[i] || type[i] != tabType[i])
		{
			same = 0;
			break;
		}
	}
	if (same)
		return;		/* no output necessary */
	if ((curTabCount = n) == 0)
		ControlOut ("reset-tabs");
	else for (i = 0; i < curTabCount; i++)
	{
		sprintf (buf, "%s-tab %ld %c",
				i == 0 ? "first" : "next",
				tabPos[i] = pos[i],
				tabType[i] = type[i]);
		ControlOut (buf);
	}
}
