/*
	troffcvt reader font machinery.
*/

# include	<stdio.h>
# include	<ctype.h>

# include	"etm.h"
# include	"memmgr.h"
# include	"tokenscan.h"

# include	"tcr.internal.h"
# include	"tcr.h"


TCRFont	*tcrFontList = (TCRFont *) NULL;


/*
	Read font information file.  Format of lines is

	troff-font-name typeface attributes

	attributes is empty, "italic" or "bold", indicating what
	style attributes the font has in relation to to plain font
	for the typeface.  E.g.,

	R	Times
	I	Times	italic
	B	Times	bold
*/

int TCRReadFonts (dir, filename)
char	*dir;
char	*filename;
{
FILE	*f;
char	buf[bufSiz];
TCRFont	*fp, *fp2;
char	*tName;
char	*face;
char	*p;
static int	fnum = 0;

	if (dir == (char *) NULL || filename[0] == '/')
		(void) strcpy (buf, filename);
	else
		sprintf (buf, "%s/%s", dir, filename);
	if ((f = fopen (buf, "r")) == (FILE *) NULL)
		return (0);
	while (TCRGetLine (buf, (int) sizeof (buf), f))
	{
		if (buf[0] == '#')
			continue;
		TSScanInit (buf);
		if ((tName = TSScan ()) == (char *) NULL
				|| (face = TSScan ()) == (char *) NULL)
			continue;
		fp = New (TCRFont);
		fp->tcrTroffName = StrAlloc (tName);
		fp->tcrTypeFace = StrAlloc (face);
		fp->tcrAtts = 0;
		while ((p = TSScan ()) != NULL)
		{
			if (strcmp (p, "italic") == 0)
				fp->tcrAtts |= tcrItal;
			else if (strcmp (p, "bold") == 0)
				fp->tcrAtts |= tcrBold;
		}
		/*
			See if this is first font in family and assign
			new number if so; use existing number otherwise.
		*/
		for (fp2 = tcrFontList; fp2 != (TCRFont *) NULL; fp2 = fp2->nextTCRFont)
		{
			if (strcmp (fp2->tcrTypeFace, face) == 0)
				break;
		}
		if (fp2 == (TCRFont *) NULL)
			fp->tcrFontNum = ++fnum;
		else
			fp->tcrFontNum = fp2->tcrFontNum;
		fp->nextTCRFont = tcrFontList;
		tcrFontList = fp;
	}
	(void) fclose (f);
	return (1);
}


TCRFont *TCRLookupFont (name)
char	*name;
{
TCRFont	*fp;

	for (fp = tcrFontList; fp != (TCRFont *) NULL; fp = fp->nextTCRFont)
	{
		if (strcmp (name, fp->tcrTroffName) == 0)
			return (fp);
	}
	return ((TCRFont *) NULL);
}
