/*
	output.c - basic output operations
*/

# include	<stdio.h>

# include	"etm.h"

# include	"troffcvt.h"


/*
	Level 2 output routines
*/


static int	inPara = 0;
static int	inOTextLine = 0;
static UChar	transTab[256];	/* transliteration table */


void InitTransliterate ()
{
int	i;

	for (i = 0; i < 256; i++)
		transTab[i] = i;
}


void Transliterate (in, out)
int	in, out;
{
	if (in < 0 || in > 255 || out < 0 || out > 255)
		ETMMsg ("Transliterate: bad values (%d, %d)", in, out);
	else
		transTab[in] = out;
}


/*
	Shove out a break if necessary.	 Nothing is written if there is
	no paragraph active.

	A break flushes the current text output line, turns off any \c
	continuation, and turns off the need for a space between successive
	text lines.
*/

void Break ()
{
	inContinuation = 0;
	needSpace = 0;
	if (inPara)
	{
		FlushOText ();
		ControlOut ("break");
		inPara = 0;
		fieldDelimCount = 0;
	}
}


void ControlOut (s)
char	*s;
{
	FlushOText ();
	ChOut ('\\');
	StrOut (s);
	ChOut (linefeed);
}


void CommentOut (s)
char	*s;
{
char	buf[bufSiz];

	sprintf (buf, "comment %s", s);
	ControlOut (buf);
}


/*
	Write out a control word which is really part of paragraph
	text (e.g., for a special character).  Note the fact that a
	paragraph is now active.
*/

void SpecialTextOut (s)
char	*s;
{
	FlushOText ();
	ChOut ('@');
	StrOut (s);
	ChOut (linefeed);
	inPara = 1;
}


/*
	Write out a paragraph text string.  No interpretation of
	the string is done.
*/

void TextStrOut (s)
char	*s;
{
	if (s != (char *) NULL)
	{
		while (*s != '\0')
			TextChOut (*s++);
	}
}


/*
	Write out a paragraph text character.  Note the fact that a paragraph
	is now active and that there is an output text line in progress.

	A few characters are special and are mapped onto text control words.
*/

void TextChOut (c)
int	c;
{
	if (Special (c))
		ETMPanic ("TextChOut: woof");

	/* perform transliteration and de-escaping */
	c = FromEsc ((int) transTab[c]);

	if (c == '\\')
		SpecialTextOut ("backslash");
	else if (c == '@')
		SpecialTextOut ("at");
	else if (c == '\t')
		SpecialTextOut ("tab");
	else if (c == 1)
		SpecialTextOut ("leader");
	else if (c == '\b')
		SpecialTextOut ("backspace");
	else
	{
		ChOut (c);
		inPara = 1;
		inOTextLine = 1;
	}
}


/*
	Flush any output text line that may be in progress.
*/

void FlushOText ()
{
	if (inOTextLine)
	{
		ChOut (linefeed);
		inOTextLine = 0;
	}
}


/*
	Level 1 output routines

	StrOut () - write out a string.
	ChOut () - write out a character.  ALL output (except ETM messages)
	comes through this routine.
	AllowOutput () - allow or throttle output.
*/


static int	oAllow = 1;


void StrOut (p)
char	*p;
{
	while (*p != '\0')
		ChOut (*p++);
}


void ChOut (c)
char	c;
{
	if (oAllow && putc (c, stdout) == EOF)
		ETMPanic ("Write error, cannot continue");
}


int AllowOutput (yesno)
int	yesno;
{
int	prev = oAllow;

	oAllow = yesno;
	return (prev);
}
