/*
	Environment stuff.
*/

# include	<stdio.h>

# include	"etm.h"
# include	"memmgr.h"

# include	"troffcvt.h"


# define	maxEnvirons	3
# define	maxEStack	10	/* more than necessary? */


static void	SaveToEnvironment ();
static void	SetFromEnvironment ();


static Environ	env[maxEnvirons];
static int	eStack[maxEStack];
static int	esTop = -1;


/*
	Initialize all the environments with the current settings.
	This is done *after* reading the initial action files, which
	allows the files to reset the normal troff defaults (e.g.,
	for legal size paper), and have those values propagate into
	all environments.
*/

void InitEnvironments ()
{
int	i;

	for (i = 0; i < maxEnvirons; i++)
	{
		env[i].eItMacro = (UChar *) NULL;
		SaveToEnvironment (i);
	}
	eStack[++esTop] = 0;	/* initially in environment 0 */
}


void PushEnvironment (n)
int	n;
{
	if (esTop + 1 >= maxEStack)
		ETMPanic ("PushEnvironment: environment stack overflow");
	if (n < 0 || n >= maxEnvirons)
		ETMMsg ("PushEnvironment: bad environment number: %d", n);
	else
	{
		SaveToEnvironment (eStack[esTop]);
		SetFromEnvironment (eStack[++esTop] = n);
	}
}


void PopEnvironment ()
{
	if (esTop <= 0)
	{
		ETMMsg ("PopEnvironment: environment stack underflow");
		return;
	}
	SaveToEnvironment (eStack[esTop]);
	SetFromEnvironment (eStack[--esTop]);
}


/*
	Save current parameters to a given environment
*/

static void SaveToEnvironment (n)
int	n;
{
Environ	*ep = &env[n];
int	i;

	ep->eSize = curSize;
	ep->ePrevSize = prevSize;
	ep->eSpaceSize = curSpaceSize;
	(void) strcpy (ep->eFont, curFont);
	(void) strcpy (ep->ePrevFont, prevFont);
	ep->eFillMode = fillMode;
	ep->eAdjust = adjust;
	ep->eAdjMode = adjMode;
	ep->eCenterCount,
	ep->eVSize = curVSize;
	ep->ePrevVSize = prevVSize;
	ep->eLineSpacing = curLineSpacing;
	ep->ePrevLineSpacing = prevLineSpacing;
	ep->eLineLen = curLineLen;
	ep->ePrevLineLen = prevLineLen;
	ep->eIndent = curIndent;
	ep->ePrevIndent = prevIndent;
	ep->eTempIndent = curTempIndent;
	UFree (ep->eItMacro);
	if (itMacro == (UChar *) NULL)
		ep->eItMacro = (UChar *) NULL;
	else
		ep->eItMacro = UStrAlloc (itMacro);
	ep->eItCount = itCount;
	ep->eTabCount = curTabCount;
	for (i = 0; i < maxTabStops; i++)
	{
		ep->eTabPos[i] = tabPos[i];
		ep->eTabType[i] = tabType[i];
	}
	ep->eTabChar = tabChar;
	ep->eLeaderChar = leaderChar;
	ep->eUlCount = ulCount;
	ep->eCUlCount = cUlCount;
	ep->eCtrlChar = ctrlChar;
	ep->eNbCtrlChar = nbCtrlChar;
	ep->eHyphenMode = curHyphenMode;
	ep->eHyphenChar = optHyphenChar;
	ep->eTitleLen = curTitleLen;
	ep->ePrevTitleLen = prevTitleLen;
}


/*
	Set current parameters from a given environment
*/

static void SetFromEnvironment (n)
int	n;
{
Environ	*ep = &env[n];

	SetSize (ep->eSize);
	prevSize = ep->ePrevSize;
	SetSpaceSize (ep->eSpaceSize);
	SetFont (ep->eFont);
	(void) strcpy (prevFont, ep->ePrevFont);
	SetCFA (ep->eCenterCount, ep->eFillMode, ep->eAdjust, ep->eAdjMode);
	SetSpacing (ep->eVSize);
	prevVSize = ep->ePrevVSize;
	SetLineSpacing (ep->eLineSpacing);
	prevLineSpacing = ep->ePrevLineSpacing;
	SetLineLength (ep->eLineLen);
	prevLineLen = ep->ePrevLineLen;
	SetIndent (ep->eIndent);
	prevIndent = ep->ePrevIndent;
	SetTempIndent (ep->eTempIndent);
	UFree (itMacro);
	if (ep->eItMacro == (UChar *) NULL)
		itMacro = (UChar *) NULL;
	else
		itMacro = UStrAlloc (ep->eItMacro);
	itCount = ep->eItCount;
	SetTabStops (ep->eTabCount, ep->eTabPos, ep->eTabType);
	tabChar = ep->eTabChar;
	leaderChar = ep->eLeaderChar;
	SetUnderline (ep->eUlCount, ep->eCUlCount);
	ctrlChar = ep->eCtrlChar;
	nbCtrlChar = ep->eNbCtrlChar;
	SetHyphenation (ep->eHyphenMode);
	optHyphenChar = ep->eHyphenChar;
	SetTitleLength (ep->eTitleLen);
	prevTitleLen = ep->ePrevTitleLen;
}
