# include	<stdio.h>
# include	<ctype.h>

# include	"etm.h"

# include	"troffcvt.h"


/*
	Convert a character following escChar into the equivalent
	escape-char code, or convert an escape-char code to the regular
	character that would follow escChar.

	Escape codes are the character ASCII value with bit 7 turns on.
	This makes them distinct from regular ASCII range (0..127) and EOF.

	It is ASSUMED (for now) that the character isn't a special character
	code.
*/

int ToEsc (c)
int	c;
{
	if (Special (c))
		ETMPanic ("ToEsc: woof");
	return (c | 0x80);	/* set high bit */
}


int FromEsc (c)
int	c;
{
	if (Special (c))
		return (c);
	return (c &= ~0x80);	/* clear high bit */
}


/*
	Character type testers.

	Esc(c)		Whether c is an escape+char code.
	Special(c)	Whether c is a special char code.
	White(c)	Whether c is whitespace (isspace(c) doesn't work).
	Eol(c)		Whether c ends a line.  EOF is considered to end
			a line, since a file need not end with a linefeed-
			terminated line.
	WhiteOrEol(c)	Obvious.
	UnitChar(c)	Whether c is a unit indicator char.
*/


int Esc (c)
int	c;
{
	return (!Special (c) && (c & 0x80) != 0);
}


int Special (c)
int	c;
{
	return ((c & scMask) != 0);
}


int Sign (c)
int	c;
{
	return (c == '+' || c == '-');
}


int White (c)
int	c;
{
	return (c == ' ' || c == '\t');
}


int Eol (c)
int	c;
{
	return (c == linefeed || c == EOF);
}


int WhiteOrEol (c)
int	c;
{
	return (c == ' ' || c == '\t' || c == linefeed || c == EOF);
}


int UnitChar (c)
int	c;
{
	return (c == 'x' || c == 'u' || c == 'v' || c == 'n'
			|| c == 'm' || c == 'P' || c == 'p'
			|| c == 'c' || c == 'i');
}


/*
	Version of isdigit() suitable for any value.  Don't want to pass
	specials to native isdigit()!!  May not work on non-ASCII machines.
*/

int Digit (c)
int	c;
{
	return (c >= '0' && c <= '9');
}


/*
	Test whether an argument is empty (all white is considered empty)
	or numeric.

	The numeric-arg tester allows for a unit indicator at the end.
*/

int EmptyArg (arg)
UChar	*arg;
{
	while (*arg != '\0')
	{
		if (!White (*arg++))
			return (0);
	}
	return (1);
}


int NumericArg (arg)
UChar	*arg;
{
	if (Sign (*arg))
		++arg;
	if (*arg == '\0')
		return (0);
	while (Digit (*arg))
		++arg;
	if (*arg == '.')
	{
		++arg;
		while (Digit (*arg))
			++arg;
	}
	if (UnitChar (*arg))
		++arg;
	return (*arg == '\0');
}


/*
	Convert a string which might have special char or escape
	codes lurking in it to something printable.  Should only be
	used for diagnostic purposes.
*/

char *UStrToStr (s)
UChar	*s;
{
static char	buf[bufSiz];
char	*p = buf;
int	c;
SpChar	*sp;

	while ((c = *s++) != '\0')
	{
		if (c == 0x80)
		{
			if ((c = *s++) == 0)
				ETMPanic ("UStrToStr: woof");
			if ((sp = LookupSpCharByCode (c | scMask)) == (SpChar *) NULL)
				(void) strcpy (p, "[[\\(??]]");
			else
			{
				*p++ = escChar;
				*p++ = '(';
				(void) strcpy (p, sp->spName);
			}
			p += strlen (p);
		}
		else if (Esc (c))
		{
			*p++ = escChar;
			*p++ = FromEsc (c);
		}
		else
			*p++ = c;
	}
	*p = '\0';
	return (buf);
}


/*
	Return non-zero if string is composed completely of plain
	characters (no escaped or special characters), zero otherwise.
*/

int PlainStr (s)
UChar	*s;
{
int	c;

	while ((c = *s++) != '\0')
	{
		if (c >= 0x80)
			return (0);
	}
	return (1);
}
