/*
 * RIPE version marten@ripe.net
 * 1.1 92/07/24
 *
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1980 Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)whois.c	5.11 (Berkeley) 3/2/91";
#endif /* not lint */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#ifdef TOPDOMAIN
#define RIPE
#endif

#ifdef CLEVER
#define RIPE
#endif

#ifdef RIPE
#include <sys/param.h>
#define	NICHOST	"whois.ripe.net"
#else
#define	NICHOST	"nic.ddn.mil"
#endif

#ifdef RIPE
occurs(str, pat)
char *str, *pat;
{
        register char *point = str;
        extern char *index();
        extern int strncmp();

        while (point=index(point, *pat))
        {
                if (strncmp(point, pat, strlen(pat)) == 0)
                        return(1);
                point++;
        }
        return(0);
}
#endif

main(argc, argv)
	int argc;
	char **argv;
{
	extern char *optarg;
	extern int optind;
	register FILE *sfi, *sfo;
	register int ch;
	struct sockaddr_in sin;
	struct hostent *hp;
	struct servent *sp;
	int s;
	char *host;
#ifdef RIPE
	int alldatabases=0, myerror, verb=0, opthost=0;
	char *mytoplevel;
	char *myhost;
	char *whoishost;
	extern char *rindex();
	extern char *malloc();
#endif

#ifdef TOPDOMAIN
	host = strcat(TOPDOMAIN, "-whois.ripe.net");
#else
	host = NICHOST;
#endif

#ifdef RIPE
	while ((ch = getopt(argc, argv, "vah:")) != EOF)
#else
	while ((ch = getopt(argc, argv, "h:")) != EOF)
#endif
		switch((char)ch) {
		case 'h':
			host = optarg;
#ifdef RIPE
			opthost = 1;
#endif
			break;
#ifdef RIPE
		case 'a':
			alldatabases=1;
			break;
		case 'v':
			verb=1;
			break;
#endif
		case '?':
		default:
			usage();
		}
	argc -= optind;
	argv += optind;

	if (!argc)
		usage();
#ifdef RIPE
if (!opthost) {
	whoishost = malloc(MAXHOSTNAMELEN);
#ifdef CLEVER
	myhost = malloc(MAXHOSTNAMELEN);
	myerror = gethostname(myhost, MAXHOSTNAMELEN);
	if (myerror >= 0) {
		if (occurs(myhost, ".")) {
			mytoplevel = rindex(myhost,'.');
			mytoplevel++;
			whoishost=sprintf(whoishost, "%s-whois.ripe.net", mytoplevel);
			if (verb) fprintf(stderr, "Clever guess: %s\n", whoishost);
		}
	}
#else
	whoishost=host;
#endif

	hp = gethostbyname(whoishost);
	if ((hp == NULL) && (verb)) 
	fprintf(stderr,"No such host: %s\n", whoishost);

	whoishost=NICHOST;

	if (hp == NULL) {
		if (verb) fprintf(stderr, "Default host: %s\n\n", whoishost);
		hp = gethostbyname(whoishost);

		if (hp == NULL) {
			fprintf(stderr,"No such host: %s\n", whoishost);
			if (verb) fprintf(stderr, "Now I give up ...\n");
                	perror("Unknown host");
                	exit(1);
		}
	}
}
else {
                if (verb) fprintf(stderr, "Trying: %s\n\n", host);
                hp = gethostbyname(host);
                if (hp == NULL) {
                        (void)fprintf(stderr, "whois: %s: ", host);
                        perror("Unknown host");
                        exit(1);
		}
}

#else
	hp = gethostbyname(host);
	if (hp == NULL) {
		(void)fprintf(stderr, "whois: %s: ", host);
		perror("Unknown host");
		exit(1);
	}
#endif
	host = hp->h_name;
	s = socket(hp->h_addrtype, SOCK_STREAM, 0);
	if (s < 0) {
		perror("whois: socket");
		exit(1);
	}
	bzero((caddr_t)&sin, sizeof (sin));
	sin.sin_family = hp->h_addrtype;
	if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		perror("whois: bind");
		exit(1);
	}
	bcopy(hp->h_addr, (char *)&sin.sin_addr, hp->h_length);
	sp = getservbyname("whois", "tcp");
	if (sp == NULL) {
		(void)fprintf(stderr, "whois: whois/tcp: unknown service\n");
		exit(1);
	}
	sin.sin_port = sp->s_port;
	if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		perror("whois: connect");
		exit(1);
	}
	sfi = fdopen(s, "r");
	sfo = fdopen(s, "w");
	if (sfi == NULL || sfo == NULL) {
		perror("whois: fdopen");
		(void)close(s);
		exit(1);
	}
#ifdef RIPE
	if (alldatabases)
		(void)fprintf(sfo, "-a ");
#endif
	while (argc-- > 1)
		(void)fprintf(sfo, "%s ", *argv++);
	(void)fprintf(sfo, "%s\r\n", *argv);
	(void)fflush(sfo);
	while ((ch = getc(sfi)) != EOF)
		putchar(ch);
	exit(0);
}

usage()
{
#ifdef RIPE
	(void)fprintf(stderr, "usage: whois [-a] [-v] [-h hostname] key ...\n");
#else
	(void)fprintf(stderr, "usage: whois [-h hostname] name ...\n");
#endif
	exit(1);
}
