
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*      April 1991                                                          */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/

 

/* 
 *     testif.c
 *
 *  Test version of Ethernet interface read routine: read packets from file.
 *
 *  Note: this version assumes file contains headers of form of Sun 3.x NIT.
 */
   
#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <net/if.h>
#include <net/nit.h>

    /* Following needed for packet (size)  */
#include "packet.h"

extern int errno;
extern long CurrTime, StarTime;
int    if_fd = -1;
int    ndebug = 0;
int    snaplen = 128;  /* exact value does not matter... */
        
#define ALIGNMENT        4   /* align on integer boundaries */
#define FBUFSIZE        600000
u_long  chunksize = FBUFSIZE;

u_char  *buf;
extern  char *TraceFile;  /* External trace file */                                   
readether()
    {
    register u_char *bp, *bufstop, *cp;
    int cc, datalen, drops, len, pktlen;
    struct nit_hdr *nh;
    
    len = 0;  /* buffer is empty */ 
    while (1) {
        
        if (if_fd < 0) return;
        
        if ((cc = read(if_fd, (u_char *)buf+len, (int)chunksize-len)) < 0) {
            perror("Packet buffer read");
            exit(1);
        }
        len += cc;
        if (len == 0) { /* EOF */
            return; 
        }        

        bp = buf;
        bufstop = buf + len;
        while (len >= sizeof (struct nit_hdr) ) {
        
                /* Loop through the buffer... */
                
            nh = (struct nit_hdr *) bp;
            cp = bp + sizeof(struct nit_hdr) ;

            if (nh->nh_state != NIT_CATCH) {
                switch (nh->nh_state) {
                case NIT_SEQNO:
                case NIT_NOMBUF:
                case NIT_NOCLUSTER:
                case NIT_NOSPACE:
                    break;
                default:
                    fprintf(stderr, "NNStat: bad nit state %d\n", nh->nh_state);
                    break;
                }
                bp += sizeof(struct nit_hdr); 
                len -= sizeof(struct nit_hdr);
                continue;
            }
            
            datalen = nh->nh_datalen;
            bp += (datalen + sizeof(struct nit_hdr) + 3) & ~3;
            if ((len = bufstop - bp) < 0) break;
                       /* ran off the end... Smush end of buffer back to 
                        * beginning and exit loop to read next block... 
                        */
            
            /* Call parser with packet */        
            parse( cp, datalen,  pktlen = nh->nh_wirelen,  nh->nh_timestamp); 
                                                       
#ifdef DEBUG               
            if (ndebug==1) {
                fprintf(stdout,
                   "cc: %d, datalen: %d, pktlen: %d, drops: %d\n",
                   cc,datalen,pktlen,drops);
            }
        
#endif
        }  /* end loop through buffer */
        
    if (len)
        memcpy(buf, bp, len);      
    }  /* End forever loop */
    
} /* readether() */


/*
 *   Create Network Interface Tap (NIT) Protocol socket and initialize it.
 *    Can look for specified Ethernet type, or NT_ALLTYPES.
 *
 */
initdevice(EtherType)
    int EtherType;
    {
    int n, pos;
    
    if (if_fd >= 0) return;
    
    if (TraceFile == NULL) {
         printf("Packet input file not specified\n");
         exit(1);
     }
             
    if ((buf = (u_char *) malloc(chunksize)) == NULL) {
        printf("MEMORY SHORTAGE: packet buf\n");
        exit(1);
    }      
        /* Input is to come from trace file, not NIT */
    if  ((if_fd = open(TraceFile, O_RDONLY)) < 0) {
        perror("Cannot open trace file");
        exit(1);
    }
         /* read first NIT header to set virtual time of day clock */
    if ((n = read(if_fd, (u_char *)buf, sizeof(struct nit_hdr))) < 
                                          sizeof(struct nit_hdr)) {
         perror("Init read");
         exit(1);
        }
    CurrTime = StarTime = ((struct nit_hdr *) buf )-> nh_timestamp.tv_sec;
    pos = lseek(if_fd, 0L, L_SET); /* rewind it... */
        
    printf("Ethernet data from file: %s\n", TraceFile);
} /* initdevice() */


deinitdevice()
{    
}
    
