: # *-*-perl-*-*
    eval 'exec perl -S $0 "$@"'
    if $running_under_some_shell;  
#
#  gopherget.pl - Retrieves data via Gopher
#
#  Usage: gopherget.pl localfile hostname port GopherRequest
#
#  where URL-path is the command to give gopher as defined by the URL spec
#  (eg. supports %xx character encodings).
#
#  For example, 
#  gopherget.pl - gopher.colorado.edu 70 0/About CU Gopher.../CU Gopher
#
#  Darren Hardy, hardy@cs.colorado.edu, April 1994
#
#  Based on gopher.pl by Oscar Nierstrasz 25/3/94 oscar@cui.unige.ch
#
#  $Id: gopherget.pl,v 1.2 1995/03/22 06:43:05 hardy Exp $
#
$ENV{'HARVEST_HOME'} = "/usr/local/harvest" if (!defined($ENV{'HARVEST_HOME'}));
unshift(@INC, "$ENV{'HARVEST_HOME'}/lib"); 	# use local installation
require "socket.ph";

&usage() if ($#ARGV != 3);

$lfile = shift(@ARGV);		# local filename
$host = shift(@ARGV);		# Gopher host
$port = shift(@ARGV);		# Gopher port
$cmd = shift(@ARGV);		# command
$XFER_TIMEOUT = 600;		# Ten minutes	[ 11/04/94 DPW ]

$ret = &gopher($host, $port, $cmd);
if ($lfile eq "-") {
	print STDOUT "$ret";
} else {
	open (OUT, "> $lfile") || die "$lfile: $!";
	print OUT "$ret";
	close(OUT);
}

exit(0);

sub usage {
	print "Usage: gopherget.pl localfile hostname port command\n";
	exit(1);
}

sub timeout { 
	die "$0: timeout after $XFER_TIMEOUT seconds";
}


# This doesn't always work -- gopher URLs sometimes contain
# a leading file type in the pathname which must be stripped off.
# needs work.  URLs may also contain blanks, tabs and other nasties.
# IS THIS THE RIGHT PROTOCOL FOR GOPHER???
sub gopher {
	local($host, $port, $request) = @_;

	$sockaddr = 'S n a4 x8';
	chop($thishost = `hostname`);
	($name, $aliases, $proto) = getprotobyname("tcp");
	($name, $aliases, $type, $len, $thisaddr) = gethostbyname($thishost);
	($fqdn, $aliases, $type, $len, $thataddr) = gethostbyname($host);
	$thissock = pack($sockaddr, &AF_INET, 0, $thisaddr);
	$that = pack($sockaddr, &AF_INET, $port, $thataddr);

	socket(FS, &AF_INET, &SOCK_STREAM, $proto) || die "socket: $!";
	bind(FS, $thissock) || die "bind: $!";

	local($/);
	$SIG{'ALRM'} = "timeout";
	alarm($XFER_TIMEOUT);
	connect(FS, $that) || die "connect: $!";
	select(FS); $| = 1; select(STDOUT);
	print FS "$request\r\n";
	$page = <FS>;
	$SIG{'ALRM'} = "IGNORE";
	close(FS);
	return $page;
}
