#!dpwish -f
#
#  Program: Manager
#  Requires: Tcl version: 7.3 (Tcl/Tk/XF)
#  Requires: Tk version: 3.6
#  Requires: XF version: 2.2
#
#  Manager.tcl - Harvest object cache manager
#
#  $Id: Manager.tcl,v 1.6 1995/04/03 04:43:20 hardy Exp $
#
#  Anawat Chankhunthod, University of Southern California, July 1994
#
#######################################################################
#  Copyright (c) 1994, 1995.  All rights reserved.
#  
#          Mic Bowman of Transarc Corporation.
#          Peter Danzig of the University of Southern California.
#          Darren R. Hardy of the University of Colorado at Boulder.
#          Udi Manber of the University of Arizona.
#          Michael F. Schwartz of the University of Colorado at Boulder. 
#          Duane Wessels of the University of Colorado at Boulder. 
#  
#  This copyright notice applies to all code in Harvest other than
#  subsystems developed elsewhere, which contain other copyright notices
#  in their source text.
#  
#  The Harvest software was developed by the Internet Research Task
#  Force Research Group on Resource Discovery (IRTF-RD).  The Harvest
#  software may be used for academic, research, government, and internal
#  business purposes without charge.  If you wish to sell or distribute
#  the Harvest software to commercial clients or partners, you must
#  license the software.  See
#  http://harvest.cs.colorado.edu/harvest/copyright,licensing.html#licensing.
#  
#  The Harvest software is provided ``as is'', without express or
#  implied warranty, and with no support nor obligation to assist in its
#  use, correction, modification or enhancement.  We assume no liability
#  with respect to the infringement of copyrights, trade secrets, or any
#  patents, and are not responsible for consequential damages.  Proper
#  use of the Harvest software is entirely the responsibility of the user.
#  
#  For those who are using Harvest for non-commercial purposes, you may
#  make derivative works, subject to the following constraints:
#  
#  - You must include the above copyright notice and these accompanying 
#    paragraphs in all forms of derivative works, and any documentation 
#    and other materials related to such distribution and use acknowledge 
#    that the software was developed at the above institutions.
#  
#  - You must notify IRTF-RD regarding your distribution of the 
#    derivative work.
#  
#  - You must clearly notify users that your are distributing a modified 
#    version and not the original Harvest software.
#  
#  - Any derivative product is also subject to the restrictions of the 
#    copyright, including distribution and use limitations.
#


# procedure to show window ShowWindow.top.0
proc ShowWindow.top0 { args} {
# xf ignore me 7

  # build widget .top0
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top0"
  } {
    catch "destroy .top0"
  }
  toplevel .top0   -background {White}  -borderwidth {1}

  # Window manager configurations
  global tkVersion
  wm positionfrom .top0 ""
  wm sizefrom .top0 ""
  wm maxsize .top0 1000 900
  wm minsize .top0 10 10
  wm title .top0 {Cache Parameter}


  # build widget .top0.frame1
  frame .top0.frame1  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top0.frame1.label2
  label .top0.frame1.label2  -background {White}  -borderwidth {1}  -font {6x13}  -text {Parameter}

  # pack widget .top0.frame1
  pack append .top0.frame1  .top0.frame1.label2 {top frame center expand fillx}

  # build widget .top0.frame
  frame .top0.frame  -background {White}  -borderwidth {1}  -relief {raised}

  # build widget .top0.frame.scrollbar1
  scrollbar .top0.frame.scrollbar1  -background {White}  -borderwidth {1}  -command {.top0.frame.text2 yview}  -foreground {Black}  -relief {raised}

  # build widget .top0.frame.text2
  text .top0.frame.text2  -background {White}  -borderwidth {2}  -font {6x13}  -insertborderwidth {1}  -relief {raised}  -wrap {none}  -yscrollcommand {.top0.frame.scrollbar1 set}
  # bindings
  bind .top0.frame.text2 <Any-Key> {NoFunction}

  # pack widget .top0.frame
  pack append .top0.frame  .top0.frame.scrollbar1 {right frame center filly}  .top0.frame.text2 {top frame center expand fill}

  # build widget .top0.frame3
  frame .top0.frame3  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top0.frame3.button4
  button .top0.frame3.button4  -background {White}  -borderwidth {1}  -command {UpdateParameter .top0.frame.text2 $hostname
}  -font {6x13}  -text {Update}

  # build widget .top0.frame3.button5
  button .top0.frame3.button5  -background {White}  -borderwidth {1}  -command {DestroyWindow.top0


}  -font {6x13}  -state {active}  -text {Close}

  # build widget .top0.frame3.checkbutton6
  checkbutton .top0.frame3.checkbutton6  -background {White}  -borderwidth {1}  -command {.top0.frame3.button4 invoke}  -font {6x13}  -text {Name:}  -variable {ParaNameSpecific}

  # build widget .top0.frame3.entry7
  entry .top0.frame3.entry7  -background {DeepSkyBlue}  -borderwidth {1}  -font {6x13}  -foreground {Red}  -insertborderwidth {1}  -relief {sunken}  -textvariable {ParaSpecName}
  # bindings
  bind .top0.frame3.entry7 <Key-Return> {NoFunction}

  # build widget .top0.frame3.checkbutton0
  checkbutton .top0.frame3.checkbutton0  -background {White}  -borderwidth {1}  -command {.top0.frame3.button4 invoke
}  -font {6x13}  -text {Comment}  -variable {ParaShowComment}

  # build widget .top0.frame3.button0
  button .top0.frame3.button0  -background {White}  -borderwidth {1}  -command {.top0.frame.text2 delete 0.1 end
}  -font {6x13}  -text {Clear}

  # pack widget .top0.frame3
  pack append .top0.frame3  .top0.frame3.button4 {left frame center expand fillx}  .top0.frame3.button0 {left frame center expand fillx}  .top0.frame3.checkbutton0 {left frame center fillx}  .top0.frame3.checkbutton6 {left frame center}  .top0.frame3.entry7 {left frame center expand fillx}  .top0.frame3.button5 {left frame center expand fillx}

  # build widget .top0.frame2
  frame .top0.frame2  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top0.frame2.label4
  label .top0.frame2.label4  -background {MidnightBlue}  -borderwidth {1}  -font {6x13}  -foreground {Yellow}  -text {     Name       Value   Comment                }

  # pack widget .top0.frame2
  pack append .top0.frame2  .top0.frame2.label4 {left frame center expand fillx}

  # pack widget .top0
  pack append .top0  .top0.frame1 {top frame center fillx}  .top0.frame3 {top frame center fillx}  .top0.frame2 {top frame center expand fillx}  .top0.frame {top frame center expand fill}

  .top0.frame.text2 insert end {}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top0"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top0 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top0]" != ""} {
      global xfShowWindow.top0
      set xfShowWindow.top0 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top0; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top0"
    update
  }
}


# procedure to show window ShowWindow.top1
proc ShowWindow.top1 { args} {
# xf ignore me 7

  # build widget .top1
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top1"
  } {
    catch "destroy .top1"
  }
  toplevel .top1   -background {White}  -borderwidth {1}  -relief {raised}

  # Window manager configurations
  global tkVersion
  wm positionfrom .top1 program
  wm sizefrom .top1 user
  wm maxsize .top1 609 607
  wm title .top1 {Server List}


  # build widget .top1.frame
  frame .top1.frame  -background {white}  -borderwidth {1}  -relief {raised}

  # build widget .top1.frame.scrollbar1
  scrollbar .top1.frame.scrollbar1  -background {White}  -borderwidth {1}  -command {.top1.frame.text2 yview}  -foreground {Black}  -relief {raised}

  # build widget .top1.frame.text2
  text .top1.frame.text2  -background {White}  -borderwidth {2}  -font {6x13}  -foreground {blue}  -insertborderwidth {1}  -relief {sunken}  -wrap {none}  -yscrollcommand {.top1.frame.scrollbar1 set}
  # bindings
  bind .top1.frame.text2 <Any-Key> {NoFunction}

  # pack widget .top1.frame
  pack append .top1.frame  .top1.frame.scrollbar1 {right frame center expand filly}  .top1.frame.text2 {top frame center expand filly}

  # build widget .top1.frame15
  frame .top1.frame15  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top1.frame15.button17
  button .top1.frame15.button17  -background {White}  -borderwidth {1}  -command {UpdateServer_list .top1.frame.text2 $hostname
}  -font {6x13}  -text {Update}

  # build widget .top1.frame15.button18
  button .top1.frame15.button18  -background {White}  -borderwidth {1}  -command {DestroyWindow.top1
}  -font {6x13}  -state {active}  -text {Close}

  # build widget .top1.frame15.button0
  button .top1.frame15.button0  -background {White}  -borderwidth {1}  -command {.top1.frame.text2 delete 0.1 end
}  -font {6x13}  -text {Clear}

  # pack widget .top1.frame15
  pack append .top1.frame15  .top1.frame15.button17 {left frame center expand fillx}  .top1.frame15.button0 {left frame center expand fillx}  .top1.frame15.button18 {left frame center expand fillx}

  # build widget .top1.frame19
  frame .top1.frame19  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top1.frame19.label20
  label .top1.frame19.label20  -background {MidnightBlue}  -borderwidth {1}  -font {6x13}  -foreground {Yellow}  -relief {raised}  -text {Server List}

  # pack widget .top1.frame19
  pack append .top1.frame19  .top1.frame19.label20 {top frame center expand fillx}

  # build widget .top1.frame0
  frame .top1.frame0  -background {MidnightBlue}  -borderwidth {2}  -relief {raised}

  # build widget .top1.frame0.label1
  label .top1.frame0.label1  -background {MidnightBlue}  -borderwidth {1}  -font {6x13}  -foreground {Yellow}  -text {Hostname                     Status      RTT(ms)   Bandwidht(bps)  Priority}

  # pack widget .top1.frame0
  pack append .top1.frame0  .top1.frame0.label1 {left frame center fillx}

  # pack widget .top1
  pack append .top1  .top1.frame19 {top frame center fill}  .top1.frame15 {top frame center fill}  .top1.frame0 {top frame center fill}  .top1.frame {bottom frame center expand fill}

  .top1.frame.text2 insert end {}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top1"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top1 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top1]" != ""} {
      global xfShowWindow.top1
      set xfShowWindow.top1 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top1; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top1"
    update
  }
}


# procedure to show window ShowWindow.top13
proc ShowWindow.top13 { args} {
# xf ignore me 7

  # build widget .top13
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top13"
  } {
    catch "destroy .top13"
  }
  toplevel .top13   -background {White}  -borderwidth {1}  -relief {raised}

  # Window manager configurations
  global tkVersion
  wm positionfrom .top13 program
  wm sizefrom .top13 user
  wm geometry .top13 496x607
  wm maxsize .top13 609 607
  wm title .top13 {Cached.conf}


  # build widget .top13.frame
  frame .top13.frame  -background {White}  -borderwidth {1}  -relief {raised}

  # build widget .top13.frame.scrollbar1
  scrollbar .top13.frame.scrollbar1  -background {White}  -borderwidth {1}  -command {.top13.frame.text2 yview}  -foreground {Black}  -relief {raised}

  # build widget .top13.frame.text2
  text .top13.frame.text2  -background {White}  -borderwidth {2}  -font {6x13}  -insertborderwidth {1}  -relief {sunken}  -wrap {none}  -yscrollcommand {.top13.frame.scrollbar1 set}
  # bindings
  bind .top13.frame.text2 <Any-Key> {NoFunction}

  # pack widget .top13.frame
  pack append .top13.frame  .top13.frame.scrollbar1 {right frame center expand filly}  .top13.frame.text2 {top frame center expand filly}

  # build widget .top13.frame15
  frame .top13.frame15  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top13.frame15.button17
  button .top13.frame15.button17  -background {White}  -borderwidth {1}  -command {UpdateCacheConf .top13.frame.text2 $hostname
}  -font {6x13}  -text {Update}

  # build widget .top13.frame15.button18
  button .top13.frame15.button18  -background {White}  -borderwidth {1}  -command {DestroyWindow.top13
}  -font {6x13}  -state {active}  -text {Close}

  # build widget .top13.frame15.button0
  button .top13.frame15.button0  -background {White}  -borderwidth {1}  -command {.top13.frame.text2 delete 0.1 end
}  -font {6x13}  -text {Clear}

  # pack widget .top13.frame15
  pack append .top13.frame15  .top13.frame15.button17 {left frame center expand fillx}  .top13.frame15.button0 {left frame center expand fillx}  .top13.frame15.button18 {left frame center expand fillx}

  # build widget .top13.frame19
  frame .top13.frame19  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top13.frame19.label20
  label .top13.frame19.label20  -background {White}  -borderwidth {1}  -font {6x13}  -relief {raised}  -text {Cached.conf}

  # pack widget .top13.frame19
  pack append .top13.frame19  .top13.frame19.label20 {top frame center expand fillx}

  # pack widget .top13
  pack append .top13  .top13.frame19 {top frame center fill}  .top13.frame15 {top frame center fill}  .top13.frame {bottom frame center expand fill}

  .top13.frame.text2 insert end {}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top13"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top13 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top13]" != ""} {
      global xfShowWindow.top13
      set xfShowWindow.top13 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top13; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top13"
    update
  }
}


# procedure to show window ShowWindow.top2
proc ShowWindow.top2 { args} {
# xf ignore me 7

  # build widget .top2
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top2"
  } {
    catch "destroy .top2"
  }
  toplevel .top2   -background {White}  -borderwidth {1}

  # Window manager configurations
  global tkVersion
  wm positionfrom .top2 ""
  wm sizefrom .top2 ""
  wm iconname .top2 {Cache Stat}
  wm maxsize .top2 506 344
  wm minsize .top2 10 10
  wm title .top2 {Cache Statistic}


  # build widget .top2.frame4
  frame .top2.frame4  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top2.frame4.label5
  label .top2.frame4.label5  -background {MidnightBlue}  -borderwidth {1}  -font {8x13}  -foreground {White}  -relief {raised}  -text {Statistics}

  # pack widget .top2.frame4
  pack append .top2.frame4  .top2.frame4.label5 {top frame center fillx}

  # build widget .top2.frame0
  frame .top2.frame0  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top2.frame0.button1
  button .top2.frame0.button1  -background {White}  -borderwidth {1}  -command {UpdateStatGen .top2.text1 $hostname
.top2.frame0.button3 invoke}  -font {6x13}  -text {Update}

  # build widget .top2.frame0.button2
  button .top2.frame0.button2  -background {White}  -borderwidth {1}  -command {ShowWindow.top4
.top4.frame15.button17 invoke
}  -font {6x13}  -text {Object}

  # build widget .top2.frame0.button3
  button .top2.frame0.button3  -background {White}  -borderwidth {1}  -command {UpdateStatUtil .top2.frame1.text6 $hostname 60 .top2.frame5.frame6.button11 .top2.frame13.frame6.button11 .top2.frame14.frame6.button11 .top2.frame15.frame6.button11 .top2.frame16.frame6.button11
}  -font {6x13}  -text {Utilization}

  # build widget .top2.frame0.button7
  button .top2.frame0.button7  -background {White}  -borderwidth {1}  -command {DestroyWindow.top2
}  -font {6x13}  -state {active}  -text {Close}

  # build widget .top2.frame0.button0
  button .top2.frame0.button0  -background {White}  -borderwidth {1}  -command {.top2.text1 delete 0.1 end
.top2.frame1.text6 delete 0.1 end
ClearStatBar .top2.frame5.frame6.button11 .top2.frame13.frame6.button11  .top2.frame14.frame6.button11 .top2.frame15.frame6.button11 .top2.frame16.frame6.button11

}  -font {6x13}  -text {Clear}

  # pack widget .top2.frame0
  pack append .top2.frame0  .top2.frame0.button1 {left frame center expand fillx}  .top2.frame0.button0 {left frame center expand fillx}  .top2.frame0.button2 {left frame center expand fillx}  .top2.frame0.button3 {left frame center expand fillx}  .top2.frame0.button7 {left frame center expand fillx}

  # build widget .top2.text1
  text .top2.text1  -background {White}  -borderwidth {2}  -font {6x13}  -height {8}  -insertborderwidth {1}  -relief {raised}  -wrap {none}
  # bindings
  bind .top2.text1 <Any-Key> {NoFunction}

  # build widget .top2.frame5
  frame .top2.frame5  -background {White}  -borderwidth {2}  -geometry {30x205}  -relief {raised}

  # build widget .top2.frame5.frame6
  frame .top2.frame5.frame6  -background {White}  -borderwidth {2}  -height {49}  -relief {sunken}  -width {303}

  # build widget .top2.frame5.frame6.label10
  label .top2.frame5.frame6.label10  -background {White}  -borderwidth {1}  -font {6x13}  -relief {raised}  -text {Overall}  -width {16}

  # build widget .top2.frame5.frame6.button11
  button .top2.frame5.frame6.button11  -background {Red}  -borderwidth {1}  -font {6x13}  -foreground {White}  -text {0.00}

  # pack widget .top2.frame5.frame6
  pack append .top2.frame5.frame6  .top2.frame5.frame6.label10 {left frame center}  .top2.frame5.frame6.button11 {left frame center}

  # pack widget .top2.frame5
  pack append .top2.frame5  .top2.frame5.frame6 {top frame center pady 4 expand fillx}

  # build widget .top2.frame13
  frame .top2.frame13  -background {White}  -borderwidth {2}  -geometry {30x205}  -relief {raised}

  # build widget .top2.frame13.frame6
  frame .top2.frame13.frame6  -background {White}  -borderwidth {2}  -height {49}  -relief {sunken}  -width {303}

  # build widget .top2.frame13.frame6.label10
  label .top2.frame13.frame6.label10  -background {White}  -borderwidth {1}  -font {6x13}  -relief {raised}  -text {FTP}  -width {16}

  # build widget .top2.frame13.frame6.button11
  button .top2.frame13.frame6.button11  -background {Red}  -borderwidth {1}  -font {6x13}  -foreground {White}  -text {0.00}

  # pack widget .top2.frame13.frame6
  pack append .top2.frame13.frame6  .top2.frame13.frame6.label10 {left frame center}  .top2.frame13.frame6.button11 {left frame center}

  # pack widget .top2.frame13
  pack append .top2.frame13  .top2.frame13.frame6 {top frame center pady 4 expand fillx}

  # build widget .top2.frame14
  frame .top2.frame14  -background {White}  -borderwidth {2}  -geometry {30x205}  -relief {raised}

  # build widget .top2.frame14.frame6
  frame .top2.frame14.frame6  -background {White}  -borderwidth {2}  -height {49}  -relief {sunken}  -width {303}

  # build widget .top2.frame14.frame6.label10
  label .top2.frame14.frame6.label10  -background {White}  -borderwidth {1}  -font {6x13}  -relief {raised}  -text {Gopher}  -width {16}

  # build widget .top2.frame14.frame6.button11
  button .top2.frame14.frame6.button11  -background {Red}  -borderwidth {1}  -font {6x13}  -foreground {White}  -text {0.00}

  # pack widget .top2.frame14.frame6
  pack append .top2.frame14.frame6  .top2.frame14.frame6.label10 {left frame center}  .top2.frame14.frame6.button11 {left frame center}

  # pack widget .top2.frame14
  pack append .top2.frame14  .top2.frame14.frame6 {top frame center pady 4 expand fillx}

  # build widget .top2.frame15
  frame .top2.frame15  -background {White}  -borderwidth {2}  -geometry {30x205}  -relief {raised}

  # build widget .top2.frame15.frame6
  frame .top2.frame15.frame6  -background {White}  -borderwidth {2}  -height {49}  -relief {sunken}  -width {303}

  # build widget .top2.frame15.frame6.label10
  label .top2.frame15.frame6.label10  -background {White}  -borderwidth {1}  -font {6x13}  -relief {raised}  -text {WWW}  -width {16}

  # build widget .top2.frame15.frame6.button11
  button .top2.frame15.frame6.button11  -background {Red}  -borderwidth {1}  -font {6x13}  -foreground {White}  -text {0.00}

  # pack widget .top2.frame15.frame6
  pack append .top2.frame15.frame6  .top2.frame15.frame6.label10 {left frame center}  .top2.frame15.frame6.button11 {left frame center}

  # pack widget .top2.frame15
  pack append .top2.frame15  .top2.frame15.frame6 {top frame center pady 4 expand fillx}

  # build widget .top2.frame16
  frame .top2.frame16  -background {White}  -borderwidth {2}  -geometry {30x205}  -relief {raised}

  # build widget .top2.frame16.frame6
  frame .top2.frame16.frame6  -background {White}  -borderwidth {2}  -height {49}  -relief {sunken}  -width {303}

  # build widget .top2.frame16.frame6.label10
  label .top2.frame16.frame6.label10  -background {White}  -borderwidth {1}  -font {6x13}  -relief {raised}  -text {WAIS}  -width {16}

  # build widget .top2.frame16.frame6.button11
  button .top2.frame16.frame6.button11  -background {Red}  -borderwidth {1}  -font {6x13}  -foreground {White}  -text {0}

  # pack widget .top2.frame16.frame6
  pack append .top2.frame16.frame6  .top2.frame16.frame6.label10 {left frame center}  .top2.frame16.frame6.button11 {left frame center}

  # pack widget .top2.frame16
  pack append .top2.frame16  .top2.frame16.frame6 {top frame center pady 4 expand fillx}

  # build widget .top2.frame1
  frame .top2.frame1  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top2.frame1.label4
  label .top2.frame1.label4  -background {MidnightBlue}  -borderwidth {1}  -font {6x13}  -foreground {White}  -relief {raised}  -text {Name    Objects    MMax    MCur    MMin  Hit   Rate    Ref    TxBytes         }

  # build widget .top2.frame1.text6
  text .top2.frame1.text6  -background {White}  -borderwidth {1}  -font {6x13}  -height {8}  -insertborderwidth {1}  -relief {sunken}

  # pack widget .top2.frame1
  pack append .top2.frame1  .top2.frame1.label4 {top frame center expand fillx}  .top2.frame1.text6 {top frame center}

  # pack widget .top2
  pack append .top2  .top2.frame4 {top frame center fillx}  .top2.frame0 {top frame center expand fill}  .top2.text1 {top frame center fill}  .top2.frame5 {top frame center fillx}  .top2.frame13 {top frame center fillx}  .top2.frame14 {top frame center fillx}  .top2.frame15 {top frame center fillx}  .top2.frame16 {top frame center fillx}  .top2.frame1 {top frame center fillx}

  .top2.text1 insert end {Stat            General            Information.                  
}
  .top2.frame1.text6 insert end {Total      6          85/      0/      0 0.00       0     8        290
HTTP       0           0/      0/      0 0.00       0     0          0
GOPHER     0           0/      0/      0 0.00       0     0          0
FTP        0           0/      0/      0 0.00       0     0          0
CACHEOBJ   6          85/      0/      0 0.00       0     8        290
}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top2"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top2 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top2]" != ""} {
      global xfShowWindow.top2
      set xfShowWindow.top2 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top2; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top2"
    update
  }
}


# procedure to show window ShowWindow.top3
proc ShowWindow.top3 { args} {
# xf ignore me 7

  # build widget .top3
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top3"
  } {
    catch "destroy .top3"
  }
  toplevel .top3   -background {White}  -borderwidth {1}  -relief {raised}

  # Window manager configurations
  global tkVersion
  wm positionfrom .top3 program
  wm sizefrom .top3 user
  wm maxsize .top3 609 607
  wm title .top3 {Log}


  # build widget .top3.frame
  frame .top3.frame  -background {White}  -borderwidth {1}  -relief {raised}

  # build widget .top3.frame.scrollbar1
  scrollbar .top3.frame.scrollbar1  -background {White}  -borderwidth {1}  -command {.top3.frame.text2 yview}  -foreground {Black}  -relief {raised}

  # build widget .top3.frame.text2
  text .top3.frame.text2  -background {White}  -borderwidth {2}  -font {6x13}  -insertborderwidth {1}  -relief {sunken}  -width {131}  -wrap {none}  -yscrollcommand {.top3.frame.scrollbar1 set}
  # bindings
  bind .top3.frame.text2 <Any-Key> {NoFunction}

  # pack widget .top3.frame
  pack append .top3.frame  .top3.frame.scrollbar1 {right frame center expand filly}  .top3.frame.text2 {left frame center expand fill}

  # build widget .top3.frame15
  frame .top3.frame15  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top3.frame15.button17
  button .top3.frame15.button17  -background {White}  -borderwidth {1}  -command {UpdateLog .top3.frame.text2 $hostname
}  -font {6x13}  -text {Update}

  # build widget .top3.frame15.button18
  button .top3.frame15.button18  -background {White}  -borderwidth {1}  -command {DestroyWindow.top3
}  -font {6x13}  -state {active}  -text {Close}

  # build widget .top3.frame15.button0
  button .top3.frame15.button0  -background {White}  -borderwidth {1}  -command {.top3.frame.text2 delete 0.1 end
}  -font {6x13}  -text {Clear}

  # build widget .top3.frame15.button1
  button .top3.frame15.button1  -background {White}  -borderwidth {1}  -command {UpdateLogStatus .top3.frame.text2 $hostname}  -font {6x13}  -text {Status}

  # build widget .top3.frame15.button3
  button .top3.frame15.button3  -background {White}  -borderwidth {1}  -command {catch {CommandServer $hostname "log/enable"}
}  -font {6x13}  -text {Enable Log}

  # build widget .top3.frame15.button4
  button .top3.frame15.button4  -background {White}  -borderwidth {1}  -command {catch {CommandServer $hostname "log/disable"}
}  -font {6x13}  -text {Disable Log}

  # build widget .top3.frame15.button5
  button .top3.frame15.button5  -background {White}  -borderwidth {1}  -command {catch {CommandServer $hostname "log/clear"}
}  -font {6x13}  -text {Clear Logfile}

  # pack widget .top3.frame15
  pack append .top3.frame15  .top3.frame15.button17 {left frame center expand fillx}  .top3.frame15.button0 {left frame center expand fillx}  .top3.frame15.button1 {left frame center expand fillx}  .top3.frame15.button3 {left frame center expand fillx}  .top3.frame15.button4 {left frame center expand fillx}  .top3.frame15.button5 {left frame center expand fillx}  .top3.frame15.button18 {left frame center expand fillx}

  # build widget .top3.frame19
  frame .top3.frame19  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top3.frame19.label20
  label .top3.frame19.label20  -background {White}  -borderwidth {1}  -font {6x13}  -relief {raised}  -text {Log}

  # pack widget .top3.frame19
  pack append .top3.frame19  .top3.frame19.label20 {top frame center expand fillx}

  # build widget .top3.frame0
  frame .top3.frame0  -background {MidnightBlue}  -borderwidth {2}  -relief {raised}

  # build widget .top3.frame0.label1
  label .top3.frame0.label1  -background {MidnightBlue}  -borderwidth {1}  -font {6x13}  -foreground {Yellow}  -text {TIME STAMP           Object Name                                                  Requester                      Size  Status}

  # pack widget .top3.frame0
  pack append .top3.frame0  .top3.frame0.label1 {left frame center fillx}

  # pack widget .top3
  pack append .top3  .top3.frame19 {top frame center fill}  .top3.frame15 {top frame center fill}  .top3.frame {bottom frame center expand fill}  .top3.frame0 {top frame center fill}

  .top3.frame.text2 insert end {Logfile is Disabled.
}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top3"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top3 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top3]" != ""} {
      global xfShowWindow.top3
      set xfShowWindow.top3 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top3; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top3"
    update
  }
}


# procedure to show window ShowWindow.top4
proc ShowWindow.top4 { args} {
# xf ignore me 7

  # build widget .top4
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top4"
  } {
    catch "destroy .top4"
  }
  toplevel .top4   -background {White}  -borderwidth {1}  -relief {raised}

  # Window manager configurations
  global tkVersion
  wm positionfrom .top4 program
  wm sizefrom .top4 user
  wm geometry .top4 901x700
  wm iconname .top4 {Object Lists}
  wm maxsize .top4 955 856
  wm minsize .top4 122 66
  wm title .top4 {Objects List}


  # build widget .top4.frame
  frame .top4.frame  -background {White}  -borderwidth {1}  -relief {raised}

  # build widget .top4.frame.scrollbar1
  scrollbar .top4.frame.scrollbar1  -background {White}  -borderwidth {1}  -command {.top4.frame.text2 yview}  -foreground {Black}  -relief {raised}

  # build widget .top4.frame.text2
  text .top4.frame.text2  -background {White}  -borderwidth {2}  -font {6x13}  -insertborderwidth {1}  -relief {sunken}  -width {131}  -wrap {none}  -yscrollcommand {.top4.frame.scrollbar1 set}
  # bindings
  bind .top4.frame.text2 <Any-Key> {NoFunction}

  # pack widget .top4.frame
  pack append .top4.frame  .top4.frame.scrollbar1 {right frame center expand filly}  .top4.frame.text2 {left frame center expand fill}

  # build widget .top4.frame15
  frame .top4.frame15  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top4.frame15.button17
  button .top4.frame15.button17  -background {White}  -borderwidth {1}  -command {UpdateObjects .top4.frame.text2 $hostname
}  -font {6x13}  -text {Update}

  # build widget .top4.frame15.button18
  button .top4.frame15.button18  -background {White}  -borderwidth {1}  -command {DestroyWindow.top4
}  -font {6x13}  -state {active}  -text {Close}

  # build widget .top4.frame15.button0
  button .top4.frame15.button0  -background {White}  -borderwidth {1}  -command {.top4.frame.text2 delete 0.1 end
}  -font {6x13}  -text {Clear}

  # pack widget .top4.frame15
  pack append .top4.frame15  .top4.frame15.button17 {left frame center expand fillx}  .top4.frame15.button0 {left frame center expand fillx}  .top4.frame15.button18 {left frame center expand fillx}

  # build widget .top4.frame19
  frame .top4.frame19  -background {White}  -borderwidth {2}  -relief {raised}

  # build widget .top4.frame19.label20
  label .top4.frame19.label20  -background {White}  -borderwidth {1}  -font {9x15}  -relief {raised}  -text {Objects List}

  # pack widget .top4.frame19
  pack append .top4.frame19  .top4.frame19.label20 {top frame center expand fillx}

  # build widget .top4.frame0
  frame .top4.frame0  -background {MidnightBlue}  -borderwidth {2}  -relief {raised}

  # build widget .top4.frame0.label1
  label .top4.frame0.label1  -background {MidnightBlue}  -borderwidth {1}  -font {6x13}  -foreground {Yellow}  -text {                  URL Name                                       Size   Last-Ref Obj-Flags Last-fetch  hhh:mm:ss Act Ref Sto  Stat }

  # pack widget .top4.frame0
  pack append .top4.frame0  .top4.frame0.label1 {left frame center fillx}

  # pack widget .top4
  pack append .top4  .top4.frame19 {top frame center fill}  .top4.frame15 {top frame center fill}  .top4.frame {bottom frame center expand fill}  .top4.frame0 {top frame center fill}

  .top4.frame.text2 insert end {cache_object://escondido.usc.edu/stats/utilization 158      769420532          acc      769420532          ttlb 0    0     ctrl       0  
cache_object://escondido.usc.edu/log               6        769420502          acc      769420502          ttlb 0    0     ctrl       0  
cache_object://escondido.usc.edu/stats/objects     0        0                  acc      0                  ttlb 0    0     ctrl       1  
cache_object://escondido.usc.edu/stats/general     51       769420532          acc      769420532          ttlb 0    0     ctrl       0  
cache_object://escondido.usc.edu/log/clear         1        769420510          acc      769420510          ttlb 0    0     ctrl       0  
cache_object://escondido.usc.edu/log/enable        1        769420506          acc      769420506          ttlb 0    0     ctrl       0  
cache_object://escondido.usc.edu/log/status        25       769420508          acc      769420508          ttlb 0    0     ctrl       0  
cache_object://escondido.usc.edu/log/disable       1        769420507          acc      769420507          ttlb 0    0     ctrl       0  
}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top4"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top4 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top4]" != ""} {
      global xfShowWindow.top4
      set xfShowWindow.top4 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top4; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top4"
    update
  }
}


# procedure to show window ShowWindow.top5
proc ShowWindow.top5 { args} {
# xf ignore me 7

  # build widget .top5
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top5"
  } {
    catch "destroy .top5"
  }
  toplevel .top5   -background {White}  -borderwidth {1}

  # Window manager configurations
  global tkVersion
  wm positionfrom .top5 ""
  wm sizefrom .top5 ""
  wm maxsize .top5 1000 900
  wm minsize .top5 10 10
  wm title .top5 {Shutdown}


  # build widget .top5.label7
  label .top5.label7  -background {Blue}  -borderwidth {1}  -font {6x13}  -foreground {White}  -relief {raised}  -text {Please Enter Shutdown Password}

  # build widget .top5.frame
  frame .top5.frame  -background {White}  -borderwidth {1}  -relief {raised}

  # build widget .top5.frame.label4
  label .top5.frame.label4  -background {White}  -borderwidth {1}  -font {6x13}  -padx {2}  -relief {raised}  -text {Password:}

  # build widget .top5.frame.entry5
  entry .top5.frame.entry5  -background {White}  -borderwidth {1}  -font {6x13}  -insertborderwidth {1}  -relief {sunken}  -textvariable {shutpass}
  # bindings
  bind .top5.frame.entry5 <Key-Return> {.top5.button8 invoke}

  # pack widget .top5.frame
  pack append .top5.frame  .top5.frame.label4 {left frame center}  .top5.frame.entry5 {top frame center expand fill}

  # build widget .top5.button8
  button .top5.button8  -background {Red}  -borderwidth {1}  -command {CacheShutdown $hostname $shutpass
DestroyWindow.top5
}  -font {6x13}  -foreground {White}  -text {Shutdown}

  # build widget .top5.button9
  button .top5.button9  -background {Green}  -borderwidth {1}  -command {DestroyWindow.top5}  -font {6x13}  -state {active}  -text {Cancel}

  # pack widget .top5
  pack append .top5  .top5.label7 {top frame center fillx}  .top5.frame {top frame center fill}  .top5.button8 {top frame center fillx}  .top5.button9 {top frame center fillx}

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top5"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top5 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top5]" != ""} {
      global xfShowWindow.top5
      set xfShowWindow.top5 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top5; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top5"
    update
  }
}


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . user
  wm sizefrom . ""
  wm maxsize . 1152 900
  wm title . {Cache Manager}


  # build widget .frame0
  frame .frame0 \
    -background {White} \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame0.menubutton1
  menubutton .frame0.menubutton1 \
    -background {White} \
    -borderwidth {1} \
    -font {6x13} \
    -menu {.frame0.menubutton1.m} \
    -text {File} \
    -underline {0}

  # build widget .frame0.menubutton1.m
  menu .frame0.menubutton1.m \
    -background {White} \
    -borderwidth {1} \
    -font {6x13}
  .frame0.menubutton1.m add command \
    -command {destroy .} \
    -label {Quit}

  # build widget .frame0.menubutton2
  menubutton .frame0.menubutton2 \
    -background {White} \
    -borderwidth {1} \
    -font {6x13} \
    -menu {.frame0.menubutton2.m} \
    -text {Help} \
    -underline {0}

  # build widget .frame0.menubutton2.m
  menu .frame0.menubutton2.m \
    -background {White} \
    -borderwidth {1} \
    -font {6x13}

  # build widget .frame0.menubutton3
  menubutton .frame0.menubutton3 \
    -background {White} \
    -borderwidth {1} \
    -font {6x13} \
    -menu {.frame0.menubutton3.m} \
    -text {Option} \
    -underline {0}

  # build widget .frame0.menubutton3.m
  menu .frame0.menubutton3.m \
    -background {White} \
    -borderwidth {1} \
    -font {6x13}

  # pack widget .frame0
  pack append .frame0 \
    .frame0.menubutton1 {left frame center} \
    .frame0.menubutton3 {left frame center fill} \
    .frame0.menubutton2 {right frame center}

  # build widget .frame4
  frame .frame4 \
    -background {White} \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame4.button6
  button .frame4.button6 \
    -background {White} \
    -borderwidth {1} \
    -command {UpdateAll .frame4.button12 .top13.frame15.button17  .top0.frame3.button4  .top1.frame15.button17  .top2.frame0.button1 .top3.frame15.button17 .top4.frame15.button17 } \
    -font {6x13} \
    -text {Update}

  # build widget .frame4.button7
  button .frame4.button7 \
    -background {White} \
    -borderwidth {1} \
    -command {ShowWindow.top13
.top13.frame15.button17 invoke

} \
    -font {6x13} \
    -text {Cached.Conf}

  # build widget .frame4.button8
  button .frame4.button8 \
    -background {White} \
    -borderwidth {1} \
    -command {ShowWindow.top0
.top0.frame3.button4 invoke

} \
    -font {6x13} \
    -text {Parameter}

  # build widget .frame4.button9
  button .frame4.button9 \
    -background {White} \
    -borderwidth {1} \
    -command {ShowWindow.top1
.top1.frame15.button17 invoke
} \
    -font {6x13} \
    -text {Server List}

  # build widget .frame4.button10
  button .frame4.button10 \
    -background {White} \
    -borderwidth {1} \
    -command {ShowWindow.top3
.top3.frame15.button17 invoke
} \
    -font {6x13} \
    -text {Log}

  # build widget .frame4.button11
  button .frame4.button11 \
    -background {White} \
    -borderwidth {1} \
    -command {ShowWindow.top2
.top2.frame0.button1 invoke
} \
    -font {6x13} \
    -text {Stat}

  # build widget .frame4.button12
  button .frame4.button12 \
    -background {White} \
    -borderwidth {1} \
    -command {UpdateInfo .frame5.text2 $hostname
} \
    -font {6x13} \
    -text {Info}

  # build widget .frame4.button0
  button .frame4.button0 \
    -background {White} \
    -borderwidth {1} \
    -command {set shutpass ""
ShowWindow.top5
} \
    -font {6x13} \
    -text {Shutdown}

  # pack widget .frame4
  pack append .frame4 \
    .frame4.button6 {left frame center expand fillx} \
    .frame4.button12 {left frame center expand fillx} \
    .frame4.button7 {left frame center expand fillx} \
    .frame4.button8 {left frame center expand fillx} \
    .frame4.button9 {left frame center expand fillx} \
    .frame4.button10 {left frame center expand fillx} \
    .frame4.button11 {left frame center expand fillx} \
    .frame4.button0 {left frame center expand fillx}

  # build widget .frame
  frame .frame \
    -background {White} \
    -borderwidth {1} \
    -relief {raised}

  # build widget .frame.label4
  label .frame.label4 \
    -background {White} \
    -borderwidth {1} \
    -font {6x13} \
    -padx {2} \
    -relief {raised} \
    -text {Cache Host:}

  # build widget .frame.entry5
  entry .frame.entry5 \
    -background {White} \
    -borderwidth {1} \
    -font {6x13} \
    -insertborderwidth {1} \
    -relief {sunken} \
    -textvariable {hostname} \
    -width {30}
  # bindings
  bind .frame.entry5 <Key-Return> {NoFunction}

  # pack widget .frame
  pack append .frame \
    .frame.label4 {left frame center} \
    .frame.entry5 {top frame center expand fill}

  # build widget .frame5
  frame .frame5 \
    -background {White} \
    -borderwidth {1} \
    -relief {raised}

  # build widget .frame5.scrollbar1
  scrollbar .frame5.scrollbar1 \
    -background {White} \
    -borderwidth {1} \
    -command {.frame5.text2 yview} \
    -foreground {Black} \
    -relief {raised}

  # build widget .frame5.text2
  text .frame5.text2 \
    -background {White} \
    -borderwidth {2} \
    -font {6x13} \
    -insertborderwidth {1} \
    -relief {raised} \
    -wrap {none} \
    -yscrollcommand {.frame5.scrollbar1 set}
  # bindings
  bind .frame5.text2 <Any-Key> {NoFunction}

  # pack widget .frame5
  pack append .frame5 \
    .frame5.scrollbar1 {right frame center expand filly} \
    .frame5.text2 {top frame center expand filly}

  # pack widget .
  pack append . \
    .frame0 {top frame center fill} \
    .frame {top frame center fill} \
    .frame4 {top frame center fillx} \
    .frame5 {top frame center expand fill}

  global tkVersion
  if {$tkVersion >= 3.0} {
    tk_menuBar .frame0 .frame0.menubutton1 .frame0.menubutton2 .frame0.menubutton3
  } {
    tk_menus . .frame0.menubutton1 .frame0.menubutton2 .frame0.menubutton3
  }

  .frame5.text2 insert end {}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree ."
    after 2 "catch {XFEditSetShowWindows}"
  }
}


# Procedure: Alias
if {"[info procs Alias]" == ""} {
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}
}


# Procedure: CacheShutdown
proc CacheShutdown { hostname password} {
catch {CommandServer $hostname "shutdown@$password"}
}


# Procedure: ClearStatBar
proc ClearStatBar { TotalBar FTPBar GopherBar WWWBar WAISBar} {


UpdateStatBar	Total 0 60 $TotalBar $FTPBar $GopherBar $WWWBar $WAISBar

UpdateStatBar	FTP 0 60 $TotalBar $FTPBar $GopherBar $WWWBar $WAISBar

UpdateStatBar	Gopher 0 60 $TotalBar $FTPBar $GopherBar $WWWBar $WAISBar

UpdateStatBar	WWW 0 60 $TotalBar $FTPBar $GopherBar $WWWBar $WAISBar

UpdateStatBar	WAIS 0 60 $TotalBar $FTPBar $GopherBar $WWWBar $WAISBar
}


# Procedure: CommandServer
proc CommandServer { hostname query} {
set host [lindex $hostname 0]
set port [lindex $hostname 1]
if {$port == ""} { set port 3128 }
set fd [ lindex [dp_connect $host $port] 0]
set q "get cache_object://$host/$query"
set CR \r
puts $fd $q$CR
dp_shutdown $fd 0
close $fd
return
}


# Procedure: FetchServer
proc FetchServer { hostname query} {
set host [lindex $hostname 0]
set port [lindex $hostname 1]
if {$port == ""} { set port 3128 }
set fd [ lindex [dp_connect $host $port] 0]
set q "get cache_object://$host/$query"
set CR \r
dp_send $fd $q$CR
set f [dp_receive $fd]
set result ""
while {$f != ""} {
	set result $result$f
	set f [dp_receive $fd]
}
catch {dp_shutdown $fd 0}
catch {close $fd}
return $result
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  set tk_popupPriv($xfMenu,focus) ""
  set tk_popupPriv($xfMenu,grab) ""
  if {"$xfModifier" != ""} {
    set press "$xfModifier-"
    set motion "$xfModifier-"
    set release "Any-"
  } {
    set press ""
    set motion ""
    set release ""
  }

  bind $xfMenu "<${motion}B${xfButton}-Motion>"  "MenuPopupMotion $xfMenu %W %X %Y"
  bind $xfMenu "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  if {"$xfCanvasTag" == ""} {
    bind $xfW "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    bind $xfW "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  } {
    $xfW bind $xfCanvasTag "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    $xfW bind $xfCanvasTag "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  }
}
}


# Procedure: MenuPopupMotion
if {"[info procs MenuPopupMotion]" == ""} {
proc MenuPopupMotion { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupMotion
# Description: handle the popup menu motion
# Arguments: xfMenu - the topmost menu
#            xfW - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    set xfPopMinX [winfo rootx $xfW]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfW]]
    if {$xfX >= $xfPopMinX && $xfX <= $xfPopMaxX} {
      $xfW activate @[expr $xfY-[winfo rooty $xfW]]
      if {![catch "$xfW entryconfig @[expr $xfY-[winfo rooty $xfW]] -menu" result]} {
        if {"[lindex $result 4]" != ""} {
          foreach binding [bind $xfMenu] {
            bind [lindex $result 4] $binding [bind $xfMenu $binding]
          }
        }
      }
    } {
      $xfW activate none
    }
  }
}
}


# Procedure: MenuPopupPost
if {"[info procs MenuPopupPost]" == ""} {
proc MenuPopupPost { xfMenu xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupPost
# Description: post the popup menu
# Arguments: xfMenu - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfMenu]" != ""} {
    if {![info exists tk_popupPriv($xfMenu,focus)]} {
      set tk_popupPriv($xfMenu,focus) [focus]
    } {
      if {"$tk_popupPriv($xfMenu,focus)" == ""} {
        set tk_popupPriv($xfMenu,focus) [focus]
      }
    }
    set tk_popupPriv($xfMenu,grab) $xfMenu

    catch "$xfMenu activate none"
    catch "$xfMenu post $xfX $xfY"
    catch "focus $xfMenu"
    catch "grab -global $xfMenu"
  }
}
}


# Procedure: MenuPopupRelease
if {"[info procs MenuPopupRelease]" == ""} {
proc MenuPopupRelease { xfMenu xfW} {
# xf ignore me 7
##########
# Procedure: MenuPopupRelease
# Description: remove the popup menu
# Arguments: xfMenu - the topmost menu widget
#            xfW - the menu widget
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv
  global tkVersion

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    if {$tkVersion >= 3.0} {
      catch "grab release $tk_popupPriv($xfMenu,grab)"
    } {
      catch "grab none"
    }
    catch "focus $tk_popupPriv($xfMenu,focus)"
    set tk_popupPriv($xfMenu,focus) ""
    set tk_popupPriv($xfMenu,grab) ""
    if {"[$xfW index active]" != "none"} {
      $xfW invoke active; catch "$xfMenu unpost"
    }
  }
  catch "$xfMenu unpost"
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
if {"[info procs Unalias]" == ""} {
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}
}


# Procedure: UpdateAll
proc UpdateAll { b1 b2 b3 b4 b5 b6 b7} {
catch "$b1 invoke"
catch "$b2 invoke"
catch "$b3 invoke"
catch "$b4 invoke"
catch "$b5 invoke"
catch "$b6 invoke"
catch "$b7 invoke"
}


# Procedure: UpdateCacheConf
proc UpdateCacheConf { w hostname} {
$w delete 1.0 end
set f [ FetchServer $hostname "cached.conf" ]
set i 0
eval "set g $f"
set len [llength $g]
while {$i < $len} {
	$w insert end [format "%s\n" [ lindex [lindex $g $i] 0 ] ]
	incr i
}
}


# Procedure: UpdateInfo
proc UpdateInfo { w hostname} {
$w delete 1.0 end
set f [ FetchServer $hostname "info" ]
set i 0
eval "set g $f"
set len [llength $g]
while { $i < $len } {
	$w insert end [format "%s\n" [lindex $g $i] ]
	incr i
}
}


# Procedure: UpdateLog
proc UpdateLog { w hostname} {
$w delete 1.0 end
set f [ FetchServer $hostname "log"]
set i 0
eval "set g $f"
set len [llength $g]
while { $i < $len } {
	set temp [lindex $g $i]
	set time [lindex $temp 0]
	set name [lindex $temp 1]
	set requester [lindex $temp 2]
	set size [lindex $temp 3]
	set status [lindex $temp 4]
	$w insert end [format "%-20s %-60s %-25s %10s %-10s\n" $time $name $requester $size $status] 
	incr i
}
}


# Procedure: UpdateLogStatus
proc UpdateLogStatus { w hostname} {
$w delete 1.0 end
set f [ FetchServer $hostname "log/status" ]
set i 0
eval "set g $f"
set len [llength $g]
while { $i < $len } {
	$w insert end [format "%s\n" [lindex $g $i] ]
	incr i
}
}


# Procedure: UpdateObjects
proc UpdateObjects { w hostname} {
$w delete 1.0 end
set f [ FetchServer $hostname "stats/objects"]
set i 0
eval "set g $f"
set len [llength $g]
while { $i < $len } {
	set temp [lindex $g $i]
	set name [string range [lindex $temp 0] 0 59]
	set size [lindex $temp 1]
	set lastref [lindex $temp 2]
	set accessrate [lindex $temp 3]
	set lastupdate [lindex $temp 4]
	set ttlbase [lindex $temp 5]
	set ttl [lindex $temp 6]
	set refcount [lindex $temp 7]
	set control [lindex $temp 8]
	set status [lindex $temp 9]

	$w insert end [format "%-60s % 8s % 10s %-8s % 10s % 10s % 3s % 3s %-3s %-5s\n" $name $size $lastref $accessrate $lastupdate $ttlbase $ttl $refcount $control $status]
	incr i
}
}


# Procedure: UpdateParameter
proc UpdateParameter { w hostname} {
global ParaShowComment
global ParaNameSpecific
global ParaSpecName
$w delete 1.0 end
set f [ FetchServer $hostname "parameter" ]
eval "set g $f"
set len [llength $g]
set i 0
while { $i < $len } {
	set st [lindex $g $i]
	set name [lindex $st 0]
	if { (!$ParaNameSpecific) || ($name == $ParaSpecName) } {
	set value [lindex $st 1]
	set comment [lindex $st 2]
	if {$ParaShowComment == 1} {
	  $w insert end [format "%30s %10s %-30s\n" $name $value $comment]
	} else {
	  $w insert end [format "%30s %10s\n" $name $value]
	}
	}
	incr i
}
}


# Procedure: UpdateServer_list
proc UpdateServer_list { w hostname} {
$w delete 1.0 end
set f [FetchServer $hostname "server_list"]
set i 0
$w tag configure bgstipple -background red -borderwidth 0 -bgstipple gray25
eval "set g $f"
while { [lindex $g $i] != "" } {
	set st [lindex $g $i]
	set a [lindex $st 0]
	set b [lindex $st 1]
	set c [lindex $st 2]
	set d [lindex $st 3]
	set e [lindex $st 4]
		if {$b == 0} {
			insertWithTags $w [format "%-30s Up   %10s %15s %10s\n" $a $c $d $e] 
		} else {
			insertWithTags $w [format "%-30s Down       %20s %10s\n" $a $d $e] bgstipple
		}
	
	incr i
}
}


# Procedure: UpdateStatBar
proc UpdateStatBar { name hitratio barwidth TotalBar FTPBar GopherBar WWWBar WAISBar} {

	switch $name {
	  "Total" { 
	     	$TotalBar config -width [expr {int($barwidth*$hitratio)}]
		$TotalBar config -text $hitratio
	  }

	  "FTP" { 
	     	$FTPBar config -width [expr {int($barwidth*$hitratio)}]
		$FTPBar config -text $hitratio
	  }

	  "GOPHER" { 
	     	$GopherBar config -width [expr {int($barwidth*$hitratio)}]
		$GopherBar config -text $hitratio
	  }

	  "HTTP" { 
	     	$WWWBar config -width [expr {int($barwidth*$hitratio)}]
		$WWWBar config -text $hitratio
	  }

	  "WAIS" { 
	     	$WAISBar config -width [expr {int($barwidth*$hitratio)}]
		$WAISBar config -text $hitratio
	  }

	}
}


# Procedure: UpdateStatGen
proc UpdateStatGen { w hostname} {
$w delete 1.0 end
set f [ FetchServer $hostname "stats/general" ]
eval "set g $f"
set len [llength $g]
set i 0
while { $i < $len } {
	set st [lindex $g $i]
	set name [lindex $st 0]
	set value [lindex $st 1]
	set comment [lindex $st 2]
 	$w insert end [format "%-15s %-18s %-30s\n" $name $value $comment]
	incr i
}
}


# Procedure: UpdateStatUtil
proc UpdateStatUtil { w hostname barwidth TotalBar FTPBar GopherBar WWWBar WAISBar} {
$w delete 1.0 end
set f [ FetchServer $hostname "stats/utilization" ]
eval "set g $f"
set len [llength $g]
set i 0
while { $i < $len } {
	set st [lindex $g $i]
	set name [lindex $st 0]
	set objectcount [lindex $st 1]
	set mem_max [lindex [lindex $st 2] 0]
	set mem_avg [lindex [lindex $st 2] 1]
	set mem_min [lindex [lindex $st 2] 2]
	set hitratio [lindex $st 3]
	set transferrate [lindex $st 4]
	set refcount [lindex $st 5]
	set transferbyte [lindex $st 6]
 	$w insert end [format "%-10s %-5s %7s/%7s/%7s %4s %7s %5s %10s\n" $name $objectcount $mem_max $mem_avg $mem_min  $hitratio $transferrate $refcount $transferbyte]

	UpdateStatBar $name $hitratio $barwidth $TotalBar $FTPBar $GopherBar $WWWBar $WAISBar

	incr i
}
}


# Procedure: insertWithTags
proc insertWithTags { w text args} {
set start [$w index insert]
$w insert insert $text
foreach tag [$w tag names $start] {
   $w tag remove $tag $start insert
}
foreach i $args {
   $w tag add $i $start insert
}
}



# module load procedure
proc XFLocalIncludeModule {{moduleName ""}} {
  global env
  global xfLoadInfo
  global xfLoadPath
  global xfStatus

  foreach p [split $xfLoadPath :] {
    if {[file exists "$p/$moduleName"]} {
      if {![file readable "$p/$moduleName"]} {
        puts stderr "Cannot read $p/$moduleName (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName..."
      }
      source "$p/$moduleName"
      return 1
    }
    # first see if we have a load command
    if {[info exists env(XF_VERSION_SHOW)]} {
      set xfCommand $env(XF_VERSION_SHOW)
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "exec $xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    }
    # are we able to load versions from wish ?
    if {[catch "afbind $p/$moduleName" aso]} {
      # try to use xf version load command
      global xfVersion
      if {[info exists xfVersion(showDefault)]} {
        set xfCommand $xfVersion(showDefault)
      } {
	# our last hope
        set xfCommand "vcat -q $p/$moduleName"
      }
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "$xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    } {
      # yes we can load versions directly
      if {[catch "$aso open r" inFile]} {
        puts stderr "Cannot open $p/[$aso attr af_bound] (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/[$aso attr af_bound]..."
      }
      if {[catch "read \{$inFile\}" contents]} {
        puts stderr "Cannot read $p/[$aso attr af_bound] (permission denied)"
        close $inFile
        continue
      }
      close $inFile
      eval $contents
      return 1
    }
  }
  puts stderr "Cannot load module $moduleName -- check your xf load path"
  puts stderr "Specify a xf load path with the environment variable:"
  puts stderr "  XF_LOAD_PATH (e.g \"export XF_LOAD_PATH=.\")"
  catch "destroy ."
  catch "exit 0"
}

# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      set list [split $line ":"]
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        if {![info exists xfAppDefaults]} {
          set xfAppDefaults ""
        }
        lappend xfAppDefaults [list $widname [string tolower $name] $value]
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {{xfClasses ""} {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env

  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      append xfFileList [split $env(XUSERFILESEARCHPATH) :]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      append xfFileList [split $env(XAPPLRESDIR) :]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      append xfFileList [split $env(XFILESEARCHPATH) :]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter $xfAppDefaults {
    if {"$xfCounter" == ""} {
      break
    }
    set widname [lindex $xfCounter 0]
    if {[string match $widname ${xfWidgetPath}] ||
        [string match "${xfWidgetPath}*" $widname]} {
      set name [string tolower [lindex $xfCounter 1]]
      set value [lindex $xfCounter 2]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"] &&
              [string match "${xfWidgetPath}*" $widget]} {
            catch "$widget configure -$name $value" 
          }
        }
      }
    }
  }
}



# startup source
proc StartupSrc {args} {
set hostname "[lindex [exec hostname] 0] 3128"
}

# startup source
StartupSrc

# initialize global variables
global {FTPutil}
set {FTPutil} {50%}
global {Gopherutil}
set {Gopherutil} {49%}
global {ParaNameSpecific}
set {ParaNameSpecific} {0}
global {ParaShowComment}
set {ParaShowComment} {1}
global {ParaSpecName}
set {ParaSpecName} {CacheMemMax}
global {TotalUtil}
set {TotalUtil} {50%}
global {WAISutil}
set {WAISutil} {50%}
global {WWWutil}
set {WWWutil} {70%}
global {checkbutton0}
set {checkbutton0} {0}
global {hostname}
set {hostname} "[lindex [exec hostname] 0] 3128"
global {result}
set {result} {window name "frame0" already exists in parent}
global {shutpass}
set {shutpass} {}
global {tmplt}
set {tmplt} {0}

# please don't modify the following
# variables. They are needed by xf.
global {autoLoadList}
set {autoLoadList(Manager)} {0}
set {autoLoadList(Manager.tcl)} {0}
set {autoLoadList(Manager_password)} {0}
set {autoLoadList(Manager_pw)} {0}
set {autoLoadList(main.tcl)} {0}
set {autoLoadList(manager)} {0}
global {internalAliasList}
set {internalAliasList} {}
global {moduleList}
set {moduleList(Manager)} {}
set {moduleList(Manager.tcl)} {}
set {moduleList(Manager_password)} {}
set {moduleList(Manager_pw)} {}
set {moduleList(manager)} {}
global {preloadList}
set {preloadList(xfInternal)} {}
global {symbolicName}
set {symbolicName(Cached.conf)} {.top13}
set {symbolicName(Log)} {.top3}
set {symbolicName(Log Status)} {.top3.frame15.button1}
set {symbolicName(Object)} {.top4}
set {symbolicName(Parameter)} {.top0}
set {symbolicName(ServerList)} {.top1}
set {symbolicName(Shutdown)} {.frame4.button0}
set {symbolicName(Stat)} {.top2}
set {symbolicName(root)} {.}
set {symbolicName(shutdown)} {.top5}
global {xfWmSetPosition}
set {xfWmSetPosition} {}
global {xfWmSetSize}
set {xfWmSetSize} {.top13 .top4}
global {xfAppDefToplevels}
set {xfAppDefToplevels} {}

# display/remove toplevel windows.
ShowWindow.

global xfShowWindow.top0
set xfShowWindow.top0 0

global xfShowWindow.top1
set xfShowWindow.top1 0

global xfShowWindow.top13
set xfShowWindow.top13 0

global xfShowWindow.top2
set xfShowWindow.top2 0

global xfShowWindow.top3
set xfShowWindow.top3 0

global xfShowWindow.top4
set xfShowWindow.top4 0

global xfShowWindow.top5
set xfShowWindow.top5 0

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# parse and apply application defaults.
XFLocalLoadAppDefs Manager
XFLocalSetAppDefs

# eof
#

