: # *-*-perl-*-*
    eval 'exec perl -S $0 "$@"'
    if $running_under_some_shell;  
#
# $Id: newsget.pl,v 1.10 1995/03/24 08:55:09 wessels Exp $
#
#######################################################################
#  Copyright (c) 1994, 1995.  All rights reserved.
#  
#          Mic Bowman of Transarc Corporation.
#          Peter Danzig of the University of Southern California.
#          Darren R. Hardy of the University of Colorado at Boulder.
#          Udi Manber of the University of Arizona.
#          Michael F. Schwartz of the University of Colorado at Boulder. 
#          Duane Wessels of the University of Colorado at Boulder. 
#  
#  This copyright notice applies to all code in Harvest other than
#  subsystems developed elsewhere, which contain other copyright notices
#  in their source text.
#  
#  The Harvest software was developed by the Internet Research Task
#  Force Research Group on Resource Discovery (IRTF-RD).  The Harvest
#  software may be used for academic, research, government, and internal
#  business purposes without charge.  If you wish to sell or distribute
#  the Harvest software to commercial clients or partners, you must
#  license the software.  See
#  http://harvest.cs.colorado.edu/harvest/copyright,licensing.html#licensing.
#  
#  The Harvest software is provided ``as is'', without express or
#  implied warranty, and with no support nor obligation to assist in its
#  use, correction, modification or enhancement.  We assume no liability
#  with respect to the infringement of copyrights, trade secrets, or any
#  patents, and are not responsible for consequential damages.  Proper
#  use of the Harvest software is entirely the responsibility of the user.
#  
#  For those who are using Harvest for non-commercial purposes, you may
#  make derivative works, subject to the following constraints:
#  
#  - You must include the above copyright notice and these accompanying 
#    paragraphs in all forms of derivative works, and any documentation 
#    and other materials related to such distribution and use acknowledge 
#    that the software was developed at the above institutions.
#  
#  - You must notify IRTF-RD regarding your distribution of the 
#    derivative work.
#  
#  - You must clearly notify users that your are distributing a modified 
#    version and not the original Harvest software.
#  
#  - Any derivative product is also subject to the restrictions of the 
#    copyright, including distribution and use limitations.
$ENV{'HARVEST_HOME'} = "/usr/local/harvest" if (!defined($ENV{'HARVEST_HOME'}));
unshift(@INC, "$ENV{'HARVEST_HOME'}/lib");	# use local files 

require "socket.ph";

alarm (300);		# limit process to 5 minutes real time

$nntp_sock = -1;
if ($ARGV[0] eq "-fd") {
	shift;
	$nntp_sock = shift;
}

die "usage: $0 localfile news:groupname\n  or   $0 localfile news:msgid\n"
  if ($#ARGV != 1);

$F   = shift;
$URL = shift;

$host="news";
$host=$ENV{NNTPSERVER} if ($ENV{NNTPSERVER} ne "");
$port=119;

open (F, ">$F")	|| die "$F: $!\n";

if ( $nntp_sock == -1 ) {
    $sockaddr = 'S n a4 x8';
    chop($thishost = `hostname`);
    ($name, $aliases, $proto) = getprotobyname("tcp");
    ($name, $aliases, $type, $len, $thisaddr) = gethostbyname($thishost);
    ($fqdn, $aliases, $type, $len, $thataddr) = gethostbyname($host);
    $thissock = pack($sockaddr, &AF_INET, 0, $thisaddr);
    $that = pack($sockaddr, &AF_INET, $port, $thataddr);

    socket(NNTP, &AF_INET, &SOCK_STREAM, $proto) || die "socket: $!\n";
    bind(NNTP, $thissock) || die "bind: $!\n";
    connect(NNTP, $that) || die "connect: $!\n";
    $NNTPR = NNTP;
    $NNTPW = NNTP;
} else {
	open (NNTPR, "<&$nntp_sock")	|| die "$nntp_sock: $!\n";
	open (NNTPW, ">&$nntp_sock")	|| die "$nntp_sock: $!\n";
	$NNTPR = NNTPR;
	$NNTPW = NNTPW;
}

select($NNTPW); $| = 1; select(F);

if ( $nntp_sock == -1 ) {
	$welcome = <$NNTPR>;
	($code, @stuff) = split (/[ \t\n]+/, $welcome);
	exit (1) if ($code != 200);
}

($access, $path) = split (/:/, $URL);
die "Specify a news: URL\n" if ($access ne "news");
if ($path =~ /@/) {
	&do_msgid ($path);
} else {
	&do_group ($path);
}

close F;
if ( $nntp_sock == -1 ) {
	print NNTP "QUIT\r\n";
	close NNTP;
}

exit 0;

# ----- SUBROUTINES --------------------------------------------------

sub do_group {
	local ($group) = shift @_;
	print $NNTPW "GROUP $group\r\n";
	$/="\n";
	$reply = <$NNTPR>;
	($code, $nmsgs, $min, $max, $realgroup) = split (/\s+/, $reply);
	exit (1) if ($code != 211);
	exit (0) if ($max == 0);
	print $NNTPW "XOVER $min-$max\r\n";
	($code, @stuff) = split (/\s+/, <$NNTPR>);
	exit (1) if ($code != 224);
	while (<$NNTPR>) {
		s/\r//g;		# remove CR
		last if (/^\.$/);
		print F $_;
	}
}

sub do_msgid {
	local ($msgid) = shift @_;
	print $NNTPW "ARTICLE <$msgid>\r\n";
	$/="\n";
	$reply = <$NNTPR>;
	($code, $nmsgs, $min, $max, $realgroup) = split (/\s+/, $reply);
	if ($code != 220) {
		print STDERR "newsget.pl: <$msgid> $reply";
		exit (1);
	}
	while (<$NNTPR>) {
		s/\r//g;                # remove CR
		last if (/^\.$/);
		print F $_;
	}
}
