#!/bin/sh

#  You may need to change these values
HARVEST_HOME=/usr/local/harvest
GZIP_PATH=/usr/local/bin

#
#  HarvestGather - WWW gateway for retrieving data via the Harvest Gatherer
#                  interface.  See http://harvest.cs.colorado.edu/.
#
#  $Id: HarvestGather,v 1.8 1995/03/03 06:05:00 wessels Exp $
#
#  Darren Hardy, hardy@cs.colorado.edu, December 1994
#
#  Copyright (c) 1994, 1995.  All rights reserved.
#  
#          Mic Bowman of Transarc Corporation.
#          Peter Danzig of the University of Southern California.
#          Darren R. Hardy of the University of Colorado at Boulder.
#          Udi Manber of the University of Arizona.
#          Michael F. Schwartz of the University of Colorado at Boulder. 
#          Duane Wessels of the University of Colorado at Boulder. 
#  
#  This copyright notice applies to all code in Harvest other than
#  subsystems developed elsewhere, which contain other copyright notices
#  in their source text.
#  
#  The Harvest software was developed by the Internet Research Task
#  Force Research Group on Resource Discovery (IRTF-RD).  The Harvest
#  software may be used for academic, research, government, and internal
#  business purposes without charge.  If you wish to sell or distribute
#  the Harvest software to commercial clients or partners, you must
#  license the software.  See
#  http://harvest.cs.colorado.edu/harvest/copyright,licensing.html#licensing.
#  
#  The Harvest software is provided ``as is'', without express or
#  implied warranty, and with no support nor obligation to assist in its
#  use, correction, modification or enhancement.  We assume no liability
#  with respect to the infringement of copyrights, trade secrets, or any
#  patents, and are not responsible for consequential damages.  Proper
#  use of the Harvest software is entirely the responsibility of the user.
#  
#  For those who are using Harvest for non-commercial purposes, you may
#  make derivative works, subject to the following constraints:
#  
#  - You must include the above copyright notice and these accompanying 
#    paragraphs in all forms of derivative works, and any documentation 
#    and other materials related to such distribution and use acknowledge 
#    that the software was developed at the above institutions.
#  
#  - You must notify IRTF-RD regarding your distribution of the 
#    derivative work.
#  
#  - You must clearly notify users that your are distributing a modified 
#    version and not the original Harvest software.
#  
#  - Any derivative product is also subject to the restrictions of the 
#    copyright, including distribution and use limitations.

#  Configure the environment
PATH=${HARVEST_HOME}/bin:${GZIP_PATH}:${PATH}
export HARVEST_HOME
export PATH
HTTP_CGIBIN=$HARVEST_HOME/cgi-bin

#
#  Locate the CGI parser
#
if [ ! -x $HTTP_CGIBIN/cgiparse.pl ]; then
	echo 'HTTP/1.0 500 Internal Error'
	echo 'MIME-Version: 1.0'
	echo 'Content-Type: text/plain'
	echo ''
	echo "$HTTP_CGIBIN/cgiparse.pl: not found or not executable."
	exit 0
fi

#
#  Parse the CGI interface into shell variables
#
eval `$HTTP_CGIBIN/cgiparse.pl`

if [ -n "$FORM_host" -a -n "$FORM_port" ]; then
	#
	#  They have given us enough information to gather.
	#
	echo 'HTTP/1.0 200 OK'
	echo 'MIME-Version: 1.0'
	echo 'Content-Type: text/plain'
	echo ''
	gather $FORM_flag $FORM_host $FORM_port $FORM_timestamp
	if [ $? -ne 0 ]; then
		if [ "$FORM_flag" != "-nocompress" ]; then
			gather -nocompress $FORM_host $FORM_port $FORM_timestamp
			if [ $? -eq 0 ]; then
				exit 0
			fi
		fi
		echo "FATAL ERROR: Cannot retrieve Gatherer's data."
	fi
	exit 0
else
	#
	#  They don't have any information so return a Form.
	#
	echo 'HTTP/1.0 200 OK'
	echo 'MIME-Version: 1.0'
	echo 'Content-Type: text/html'
	echo ''
	cat <<EOM
<TITLE>WWW interface for retrieving information from a Harvest Gatherer</TITLE>
<H1>WWW interface for retrieving information from a Harvest Gatherer</H1>

<P> 
<HR>
<FORM METHOD="GET" ACTION="/Harvest/cgi-bin/HarvestGather.cgi">
<dl>

<dt>
  Gatherer Host:
</dt>
<dd>
  <INPUT TYPE="text" NAME="host" SIZE=50 VALUE="harvest.cs.colorado.edu">
</dd>
<dt>
  Gatherer Port:
</dt>
<dd>
  <INPUT TYPE="text" NAME="port" SIZE=10 VALUE="8500">
</dd>
<dt>
  Timestamp
</dt>
<dd>
  <INPUT TYPE="text" NAME="timestamp" SIZE=15 VALUE="0">
</dd>
<dt>
  Compression
</dt>
<dd>
<SELECT NAME="flag">
<OPTION VALUE="">Use Maximum Compression
<OPTION VALUE="-nocompress">No Compression
</SELECT>
</dd>

</dl>

<p>
<INPUT TYPE="submit" VALUE="Gather from Host">
<INPUT TYPE="reset" VALUE="Clear Form">
</FORM>
EOM
fi
exit 0
