/*

Copyright: copy/use as you wish, but as soon as somebody figures out a way to
           make money out of this, I'd like a fair share ;)
           Also: make sure the contents of the README-files provided with this
           distribution stay's intact and the software is only copied together
           with those README-files ... thank you.

Send bug reports to paula@informatik.tu-muenchen.de
(flames as usual to /dev/null ;)

    This software is provided "as is" without express or implied warranty.

      Andreas Paul (1994)

--
 E-Mail : paula@informatik.tu-muenchen.de
 IRC    : Co
 URL    : http://wwwzenger.informatik.tu-muenchen.de/persons/paula.html

*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>

#include <movie.h>
#include <cl.h>

#include <gl.h>
#include <gl/image.h>

int output_format;
int output_to_stdout;

void writepic();
void writelongimagedata();
void writePPM();
void writeJPEG();

void usage(name)
char	*name;
{
	printf("Usage: %s [-vspi] [-o <outfile>] [-f <#>] [-n <#>] <movie-filename>\n",name);
	printf("        -s             show currently processed frame in a GL-Window\n");
	printf("        -v             show some basic information\n");
	printf("        -p             show progress count\n");
	printf("        -i             only print number of frames in movie-file and exit\n");
	printf("        -o <outfile>   set output filename\n");
	printf("                         '-o -' will direct output to stdout for\n");
	printf("                         PPM and JPEG formats\n");
	printf("        -n <#>         only extract frame Nr. # instead of all the frames\n");
	printf("        -f <#>         set output-format:\n");
	printf("                         0: SGI-RGB-Format (default)\n");
	printf("                         1: PPM-Format\n");
	printf("                         2: JPEG-Format\n");
	exit(0);
}

main(argc,argv)
int		argc;
char	**argv;
{
	int		in,out;
	int		i,j,t;

	MVid	theMovie;
	MVid	track;

	DMparams	*params;
	int			len;
	const char	*par_name;
	DMparamtype	par_type;

	const char	*comp_mode;
	int			frame_size;
	int			frame_x;
	int			frame_y;

	unsigned char	*buffer;

	char		movie_file[160];
	char		img_file[160];
	char		output_name[160];

	char		*tmp;

	int	showimage;
	int	verbose;
	int show_progress;

	int extract_frame_nr;
	int print_frames_only;

	movie_file[0]=NULL;
	img_file[0]=NULL;

	showimage=0;
	verbose=0;
	show_progress=0;

	extract_frame_nr = -1;
	output_format = 0;
	print_frames_only = 0;
	output_to_stdout = 0;

	for(i=1;i<argc;i++){
		if(argv[i][0] != '-') {
			if(movie_file[0]!=NULL) usage(argv[0]);
			else strcpy(movie_file,argv[i]);
			}
		else {
			for(j=1;j<strlen(argv[i]);j++) {
				switch(argv[i][j]) {
					case 'N':
					case 'n':
						if(i+1<argc) {
							i++;
							for(t=strlen(argv[i])-1;t>=0;t--) {
								if(argv[i][t]<'0' || argv[i][t]>'9') break;
								}
							t++;
							extract_frame_nr = atoi(&argv[i][t]);
							}
						else usage(argv[0]);
						j=strlen(argv[i]);
						break;
					case 'F':
					case 'f':
						if(i+1<argc) output_format = atoi(argv[++i]);
						else usage(argv[0]);
						j=strlen(argv[i]);
						break;
					case 'O':
					case 'o':
						if(i+1<argc) strcpy(img_file,argv[++i]);
						else usage(argv[0]);
						j=strlen(argv[i]);
						break;
					case 'I':
					case 'i': print_frames_only=1; break;
					case 'P':
					case 'p': show_progress=1; break;
					case 'S':
					case 's': showimage=1; break;
					case 'V':
					case 'v': verbose=1; break;
					default: usage(argv[0]); break;
					}
				}
			}
		}

	if(movie_file[0]==NULL || (output_format<0 || output_format>2)) usage(argv[0]);

	if(img_file[0]==NULL) {
		strcpy(img_file,movie_file);
		if((tmp=strrchr(img_file,'/'))!=NULL) tmp=strchr(tmp,'.');
		else tmp=strchr(img_file,'.');
		if(tmp!=NULL) tmp[0]=NULL;
		}
	else if(strcmp(img_file,"-")==NULL && output_format!=0) output_to_stdout = 1;

	in=open(movie_file,O_RDONLY);
	if(in==NULL) {
		fprintf(stderr,"ERROR: unable to open %s !\n",movie_file);
		exit(1);
		}

	if(!mvIsMovieFD(in)) {
		fprintf(stderr,"ERROR: %s is not a recognized movie-format !\n",movie_file);
		exit(1);
		}

	mvOpenFD(in,&theMovie);

	if(mvFindTrackByMedium(theMovie,DM_IMAGE,&track)==DM_SUCCESS) {
		params = mvGetParams(track);
		}
	else {
		fprintf(stderr,"ERROR: unable to locate Image-Track! \n");
		exit(1);
		}

	frame_size = dmImageFrameSize(params);

	len=dmParamsGetInt(params,"TRACK_LENGTH");
	comp_mode=dmParamsGetString(params,"DM_IMAGE_COMPRESSION");
	frame_y=dmParamsGetInt(params,"DM_IMAGE_HEIGHT"); 
	frame_x=dmParamsGetInt(params,"DM_IMAGE_WIDTH"); 

	if(print_frames_only) {
		printf("%d",len);
		exit(0);
		}

	if(len != -1 && extract_frame_nr > len) {
		fprintf(stderr,"ERROR: Unable to extract frame %d, there are only %d!\n",extract_frame_nr,len);
		exit(1);
		}

	if(verbose) {
		printf(" number of frames: %d\n",len);
		printf(" frame_size: %d\n",frame_size);
		printf(" frame_x: %d\n",frame_x);
		printf(" frame_y: %d\n",frame_y);
		printf(" compression: %s\n",comp_mode);
		}

	buffer = (unsigned char *) malloc(frame_size);

	if(showimage) {
		foreground();
		prefsize(frame_x,frame_y);
		winopen(argv[0]);
		RGBmode();
		gconfig();
		}

	if(extract_frame_nr == -1) {
		for(i=0;i<len;i++) {
			if(show_progress) fprintf(stderr,"\r processing frame %d of %d      ",i+1,len);
			mvReadFrames(track,i,1,frame_size,buffer);
			if(showimage) lrectwrite(0,0,frame_x-1,frame_y-1,(unsigned long *) buffer);
			sprintf(output_name,"%s.%.6d",img_file,i+1);
			writepic(output_name,frame_x,frame_y,frame_size,buffer);
			}
		}
	else {
		if(show_progress) fprintf(stderr,"\r processing frame %d of %d      ",extract_frame_nr,len);
		mvReadFrames(track,extract_frame_nr-1,1,frame_size,buffer);
		if(showimage) lrectwrite(0,0,frame_x-1,frame_y-1,(unsigned long *) buffer);
		sprintf(output_name,"%s.%.6d",img_file,extract_frame_nr);
		writepic(output_name,frame_x,frame_y,frame_size,buffer);
		}

	if(show_progress) fprintf(stderr,"\r done                                             \n");
	close(in);

	exit(0);
}

void writepic(fname,x_size,y_size,size,buffer)
char	*fname;
int		x_size,y_size,size;
unsigned char	*buffer;
{
	char	name[160];

	switch(output_format) {
		case 0: sprintf(name,"%s.rgb",fname); writelongimagedata(name,x_size,y_size,size,buffer); break;
		case 1: sprintf(name,"%s.ppm",fname); writePPM(name,x_size,y_size,size,buffer); break;
		case 2: sprintf(name,"%s.jpg",fname); writeJPEG(name,x_size,y_size,size,buffer); break;
		default:
			fprintf(stderr,"ERROR: unknown output format (%d)!\n",output_format);
			exit(1);
			break;
		}
}


void writelongimagedata(fname,x_size,y_size,size,buffer)
char	*fname;
int		x_size,y_size,size;
unsigned char	*buffer;
{
	IMAGE *image;
	int y, z, x;
	int band = 0;
	int interleave;

	unsigned short	*line;

	line = (unsigned short *) malloc(x_size*sizeof(unsigned short));
	
	image = iopen(fname,"w",RLE(1),3,x_size,y_size,3);
	for(y=0; y<y_size; y++) {
		for(z=0;z<3;z++) {
			for(x=0;x<x_size;x++) {
				line[x]=buffer[y*(x_size*4)+(x*4)+z+1];
				}
			putrow(image,line,y,2-z);
			}
		}
	iclose(image);

	free(line);
}


void writeJPEG(fname,x_size,y_size,size,buffer)
char	*fname;
int		x_size,y_size,size;
unsigned char	*buffer;
{
	int compressedBufferSize, maxCompressedBufferSize;
	int *compressedBuffer;

	int	out;

	clSetDefault(CL_JPEG,CL_ORIENTATION,CL_BOTTOM_UP);

	maxCompressedBufferSize = x_size*y_size*CL_BytesPerPixel(CL_RGBX) + clQueryMaxHeaderSize(CL_JPEG);
	compressedBuffer = (int *)malloc(maxCompressedBufferSize);
	clCompressImage(CL_JPEG,x_size,y_size,CL_RGBX,15.0,buffer,&compressedBufferSize, compressedBuffer);

	if(output_to_stdout) {
		out = 1;
		}
	else {
		out = open(fname, O_WRONLY | O_CREAT | O_TRUNC | O_SYNC , S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH );
		}
	write(out,compressedBuffer,compressedBufferSize);
	if(!output_to_stdout) close(out);
}

void writePPM(fname,x_size,y_size,size,buffer)
char	*fname;
int		x_size,y_size,size;
unsigned char	*buffer;
{
	FILE	*out;

    int x, y;
    unsigned char *cptr;
	unsigned char *cbuf;

	cbuf = (unsigned char *) malloc(3*x_size);

	if(output_to_stdout) {
		out = stdout;
		}
	else {
		out = fopen(fname,"w");
		}

    fprintf(out,"P6\n");
    fprintf(out,"%d %d\n",x_size,y_size);
    fprintf(out,"255\n");

    for(y=0; y<y_size; y++) {
	    cptr = cbuf;
	    for(x=0; x<x_size; x++) {
			*cptr++ = buffer[((y_size-y-1)*x_size*4)+(x*4)+3];
			*cptr++ = buffer[((y_size-y-1)*x_size*4)+(x*4)+2];
			*cptr++ = buffer[((y_size-y-1)*x_size*4)+(x*4)+1];
			}
	    fwrite(cbuf,3*x_size,1,out);
    	}

	if(!output_to_stdout) fclose(out);

	free(cbuf);
}
