//
//
//  soviewdemo.c++
//
//  


#include <Inventor/SoGL.h>
#include <Inventor/nodes/SoNodes.h>
#include <Inventor/manips/SoTrackballManip.h>
#include <gl/gl.h>
#include "forms.h"
#include "soview.h"


FL_FORM *form;		// a form with:
FL_OBJECT *soview,	// an soview object and
	  *exit_b,	// an exit button
	  *obj;
SoNode	  *scene;


// Build a simple form with an exit button
// and an soview object on it.
static FL_FORM *
create_form(void)
{
  FL_FORM *form;

  form = fl_bgn_form(FL_UP_BOX, 400.0, 400.0);
    exit_b = fl_add_button(FL_NORMAL_BUTTON, 10.0, 10.0, 100.0,  30.0, "Quit");
    soview = fl_add_soview(FL_NORMAL_SOVIEW, 10.0, 60.0, 380.0, 330.0, "SoViewer");
  fl_end_form();

  return form;
}


// create a simple scene containing
// a cone that is being manipulated
// by a trackball manipulator
static SoNode *
create_scene(void)
{
  SoSeparator         *root 	= new SoSeparator;
  SoPerspectiveCamera *camera 	= new SoPerspectiveCamera;
  SoTrackballManip    *tb_manip = new SoTrackballManip;
  SoTransform         *xform 	= new SoTransform;
  SoMaterial	      *material = new SoMaterial;

  root->ref();
  root->addChild(camera);
  root->addChild(new SoDirectionalLight);
  root->addChild(xform);
  material->diffuseColor.setValue(.9, .3, .3);
  root->addChild(material);
  root->addChild(new SoCone);
  SoPath *path = new SoPath(root);
  path->ref();
  tb_manip->ref();
  path->append(root->findChild(xform));
  tb_manip->attach(path);
  path->unref();
  root->addChild(tb_manip);
  camera->viewAll(root);

  return root;
}
  

main()
{
  SoGL::init();		// initialize Inventor
  fl_init();		// initialize the Forms Library

  form  = create_form();
  scene = create_scene();

  fl_soview_setSceneGraph(soview, scene); 	// tell soview to manage our scene

  fl_show_form(form, FL_PLACE_SIZE, TRUE, "SoView object"); 
   
  while (1) {
    obj = fl_do_forms();
    if (obj==exit_b) {
      fl_hide_form(form);
      return 0;
    }
  }
}
