//
//
//  pickdemo.c++
//
//  demonstrates pick action of soview object
//
//


#include <Inventor/SoGL.h>
#include <Inventor/nodes/SoNodes.h>
#include <Inventor/actions/SoRayPickAction.h>

#include <gl/gl.h>
#include "forms.h"
#include "soview.h"


FL_FORM *form;
FL_OBJECT *soview,
	  *exit_b,
	  *obj;
SoNode	  *scene;


// Build a simple form with an exit button
// and an soview object on it.
static FL_FORM *
create_form(void)
{
  FL_FORM *form;

  form = fl_bgn_form(FL_UP_BOX, 400.0, 400.0);
    exit_b = fl_add_button(FL_NORMAL_BUTTON, 10.0, 10.0, 100.0,  30.0, "Quit");
    soview = fl_add_soview(FL_NORMAL_SOVIEW, 10.0, 60.0, 380.0, 330.0, "SoViewer");
  fl_end_form();

  return form;
}



// create a simple scene consisting of a 
// cube, a cone, a sphere and a cylinder.
static SoNode *
create_scene(void)
{
  SoSeparator         *root	   = new SoSeparator;
  SoPerspectiveCamera *camera	   = new SoPerspectiveCamera;
  SoTranslation       *translation = new SoTranslation;
  SoMaterial          *material;


  root->ref();
  root->addChild(camera);
  root->addChild(new SoDirectionalLight);

  material = new SoMaterial;
  material->diffuseColor.setValue(.9, .3, .3);
  root->addChild(material);

  root->addChild(new SoCube);
  translation = new SoTranslation;
  translation->translation = SbVec3f(4.0, 0.0, 0.0);
  root->addChild(translation);
  material = new SoMaterial;
  material->diffuseColor.setValue(.9, .9, .3);
  root->addChild(material);
  root->addChild(new SoCone);
  translation = new SoTranslation;
  translation->translation = SbVec3f(0.0, 4.0, 0.0);
  root->addChild(translation);
  material = new SoMaterial;
  material->diffuseColor.setValue(.3, .9, .9);
  root->addChild(material);
  root->addChild(new SoSphere);
  translation = new SoTranslation;
  translation->translation = SbVec3f(-4.0, 0.0, 0.0);
  root->addChild(translation);
  material = new SoMaterial;
  material->diffuseColor.setValue(.3, .3, .9);
  root->addChild(material);
  root->addChild(new SoCylinder);

  camera->viewAll(root);
  return root;
}

  
main()
{
  SoGL::init();		// Initialize Inventor
  fl_init();		// Initialize the Forms Library

  form  = create_form();
  scene = create_scene();

  fl_soview_setSceneGraph(soview, scene); 
  fl_soview_setPickAction(soview, new SoRayPickAction(SbVec2s()));
  fl_soview_setPickMode(soview, 1);

  fl_show_form(form, FL_PLACE_SIZE, TRUE, "SoView object"); 
   
  while (1) {
    obj = fl_do_forms();
    if (obj==exit_b) {
      fl_hide_form(form);
      return 0;
    }
    else if (obj==soview) {	// pick action was applied
      SoRayPickAction *pa;	// Let's see what was hit

      pa = fl_soview_getPickAction(soview);
      SoPath *path = pa->getPath();
      if (path) {
	path->ref();
	printf("You picked: %s\n", path->getTail()->getTypeId().getName().getString());
	path->unref();
      }
    }
  }
}
