#!/usr/local/bin/perl
#
# badloginfinger.pl -- finger a host that failed to log in, and put
#	the result into a log file.
#

eval '/usr/local/bin/perl -S $0 ${1+"$@"}'
    if 0 ;
#
# Created on Thu Aug 13 13:56:50 PDT 1992 by Todd_Atkins@EE-CF.Stanford.EDU
#
# Copyright (c) Leland Stanford Junior University Board of Trustees
#
# Usage: badloginfinger login_message_from_syslog
#
$ENV{'PATH'} = '/usr/ucb:/usr/bin:/bin:/usr/local/bin' ;
$ENV{'IFS'} = '' if $ENV{'IFS'} ne '' ;

$FINGER = "/usr/ucb/finger" ;
$LOG_FILE = "/var/log/badloginfinger.log" ;

die "usage: $0 login_message_from_syslog\n" if ($#ARGV == -1) ;

##########################
### Parse Command Line
##########################
$Message = join(' ', @ARGV) ;

$first = index($Message, "FROM ") + 5 ;
$last = rindex($Message, ":") - $first ;
if ($last < 0) {
    $Host = substr($Message, $first) ;
} else {
    $Host = substr($Message, $first, $last) ;
}

if ($Host =~ /\+.*/) {
    $Host =~ s/\+.*$// ;
    $Host = "Tip-" . $Host ;
}

#############################
#### Log the information
#############################
open(LOG_FILE, ">>$LOG_FILE") || die "$0: cannot open $LOG_FILE: $!\n" ;
open(FINGER, "$FINGER @$Host|") || die "$0: $FINGER failed!: $!\n" ;

print LOG_FILE "$Message\n" ;
while(<FINGER>) {
    chop ;
    chop if ($_ =~ /
/) ;
    print LOG_FILE "$_\n" ;
}
print LOG_FILE "\n" ;

close(FINGER) ;
close(LOG_FILE) ;

