####################
#
# sw_sighandlers.pl -- Signal handlers
#
# Copyright (c) 1992 Leland Stanford Jr. University Board of Trustees
#
####################


#
# set_alarm -- set alarm to go off
#
# usage: &set_alarm($When) ;
#
sub set_alarm {
    local($When) = @_ ;
    local($Specific) = 1 ;
    local($AM) = 1 ;
    local($Hour) = 0 ;
    local($Minute) = 0 ;
    local($Seconds) = 0 ;
    local($CurTime) = 0 ;
    local($CurHour, $CurMin, $CurSec) ;
    local($H, $M, $S) ;

    $When =~ tr/A-Z/a-z/ ;

    if (($When =~ /[ap]m/) && ($When =~ /\+/)) {
	die "$0: restart time cannot contain a '+' and \"am\" or \"pm\"\n" ;
    }

    if ($When =~ /am/) {
        $When = substr($When, $[, rindex($When,"am")) ;
    } elsif ($When =~ /pm/) {
	$When = substr($When, $[, rindex($When,"pm")) ;
	$AM = 0 ;
    } elsif ($When =~ /[a-z]/) {
        die "$0: restart time must be in \"hour:minute\" format\n" ;
    }

    if ($When =~ /^\+/) {
        $Specific = 0 ;
	$When =~ s/^\+// ;
    }
    if ($When =~ /:/) {
	($Hour,$Minute) = split(":", $When) ;
	$Hour += 12 if (!$AM && $Hour < 12) ;
    } else {
	die "$0: restart time must be in \"hour:minute\" format\n" if $Specific;
	$Minute = $When ;
    }

	$CurTime = `/bin/date +%H:%M:%S` ;
    if ($Specific) {
	($CurHour, $CurMin, $CurSec) = split(/[:\n]/, $CurTime) ;
	$S = 60 - $CurSec ;
	$M = $Minute - $CurMin ;
	$M-- ;
	if ($M < 0) {
	   $M += 60 ;
	   $H-- ;
        }
	$H += $H + $Hour - $CurHour ;
	$H += 24 if ($H < 0) ;
	$Seconds = ((($H * 60) + $M) * 60) + $S ;
    } else {
	$Seconds = (($Hour * 60) + $Minute) * 60 ;
    }
    alarm($Seconds) ;
}



#
# quit -- terminate gracefully
#
# usage: &quit($SIGNAL) ;
#
sub quit {
    local($Sig) = @_ ;

    if ($Sig) { print "Caught a SIG$Sig -- shutting down\n" ; }
    unlink($Output) ;
    exit(0) ;
}


#
# restart -- kill the child, delete the script, and start over.
#
# usage: &restart() ;
#
sub restart {
    local($Sig) = @_ ;
    print "Caught a SIG$Sig -- restarting\n" ;
    kill('TERM', $pid) ;
    waitpid($pid, 0) ;
    unlink($Output) ;
    $Restart = 1 ;
    &set_alarm($RestartTime) if ($RestartTime && $Sig eq 'ALRM') ;
}
