#########################################
#
# sw_new_script.pl -- Watcher script creation subroutines
#
# Copyright (c) 1992 Leland Stanford Jr. University Board of Trustees
#
#########################################

#
# put_header -- print out the start of our swatch generated perl script
#
# usage: &put_header() ;
#
sub put_header {
    # get the perl version information
    local($junk,$junk,$junk,$Revision,$junk,$Date,$junk,$junk,$junk,$junk,$PatchLevel) = split(/[ \t\n]+/,$]);

    print  OUTPUT "#!$PERL\n" ;
    print  OUTPUT "#\n" ;
    printf OUTPUT "# Created on %s", &ctime(time) ;
    print  OUTPUT "# Created by $0 $VERSION using Perl $Revision Patch Level $PatchLevel ($Date)\n";
    print  OUTPUT "#\n" ;
    print  OUTPUT "# Copyright 1992 Stanford University Board of Trustees\n" ;
    print  OUTPUT "#\n" ;
    print  OUTPUT "require '$SWATCH_PERL_LIB/sw_actions.pl' ;\n" ;
    print  OUTPUT "require 'syscall.ph' ;\n" ;
    print  OUTPUT "\n" ;
    print  OUTPUT "\$Input = '$Input' ;\n" ;
    print  OUTPUT "\$SIG{'TERM'} = 'goodbye' ;\n" ;
    print  OUTPUT "\n" ;
    if ($Pipe) {
      print  OUTPUT "\$| = 1 ;\n" ;
      print  OUTPUT "pipe(INPUT, OUTPUT) " ;
      print  OUTPUT "|| die \"\$0: cannot lay pipe: \$!\\n\" ;\n" ;
      print  OUTPUT "FORK: {\n" ;
      print  OUTPUT "  if (\$pid = fork) {			# parent\n" ;
      print  OUTPUT "    close(OUTPUT) ;\n" ;
      print  OUTPUT "  } elsif (defined \$pid) {			# child\n" ;
      print  OUTPUT "    close(INPUT) ;\n" ;
      print  OUTPUT "    syscall(&SYS_dup2, fileno(OUTPUT), fileno(STDOUT)) != -1\n" ;
      print  OUTPUT "      || die \"can't dup stdout: \$!\\n\" ;\n" ;
      print  OUTPUT "    exec(\$Input) ;\n" ;
      print  OUTPUT "    close(OUTPUT) ;\n" ;
      print  OUTPUT "    exit(0) ;\n" ;
      print  OUTPUT "  } elsif (\$! =~ /No more process/) {	# recoverable err: try again\n" ;
      print  OUTPUT "    sleep 5 ;\n" ;
      print  OUTPUT "    redo FORK ;\n" ;
      print  OUTPUT "  } else {			 	# weird error\n" ;
      print  OUTPUT "    die \"\$0: cannot fork: \$!\\n\" ;\n" ;
      print  OUTPUT "  }\n" ;
      print  OUTPUT "}\n" ;
    } else {
      print  OUTPUT "open(INPUT,\$Input) || die \"$0: cannot open \$Input: \$!\\n\" ;\n" ;
    }
    print  OUTPUT "\n" ;
    print  OUTPUT "LINE: while (<INPUT>) {\n" ;
}


#
# sw_cf2pl -- convert the configuration file to perl
#
# usage: cf2pl(input_file_name,output_file_name)
#

sub sw_cf2pl {
    local($InputFile,$OutputFile) = @_ ;
    local($UserName)		= $ENV{'USER'} ;
    local($BoldPrint)		=  "\033[1m" ;
    local($BlinkPrint)		=  "\033[5m" ;
    local($InversePrint)	=  "\033[7m" ;
    local($NormalPrint)		=  "\033[0m" ;
    local($UnderscorePrint)	=  "\033[4m" ;

    $OutputFile = '+>>' . $OutputFile ;
    open(INPUT, $InputFile) || die "$0: cannot open $InputFile: $!\n" ;
    open(OUTPUT, $OutputFile) || die "$0: cannot open $OutputFile: $!\n" ;

    $FirstLine = 1 ;

    INPUTLOOP: while (<INPUT>) {
	chop ;

	next INPUTLOOP if substr($_, 0, 1) eq '#' || !length($_) ;

	($PatternList, $ActionList) = split(/[\t]+/,$_,2) ;

	@Patterns = split(',', $PatternList) ;
	@Actions = split(',', $ActionList) ;

	if ($FirstLine) {
	    print OUTPUT "    if (" ;
	    $FirstLine = 0 ;
	} else {
	    print OUTPUT "    } elsif (" ;
	}

	$FirstPattern = 1 ;
	foreach $Pattern (@Patterns) {
	    if ($FirstPattern) {
		print  OUTPUT " $Pattern" ;
	        $FirstPattern = 0 ;
	    } else {
		print  OUTPUT " || $Pattern"  ;
	    }
        }
	print OUTPUT " ) {\n" ;
	

	foreach $Action (@Actions) {
	    ($Action,$Value) = split("=", $Action, 2) ;
	    $Action =~ tr/A-Z/a-z/ ;

	    if ("bell" eq $Action) {
		printf OUTPUT "\t\&do_bell(%d) ;\n", $Value ? $Value : 1 ;
	    } elsif ("echo" eq $Action) {
		undef $PrintMode ;
		$Value =~ tr/A-Z/a-z/ ;
		$Value =~ s/ //g ;
		$PrintMode .= $BoldPrint if index($Value, "bold") != -1 ;
		$PrintMode .= $BlinkPrint if index($Value, "blink") != -1 ;
		$PrintMode .= $InversePrint if index($Value, "inverse") != -1 ;
		$PrintMode .= $NormalPrint if index($Value, "normal") != -1 ;
		$PrintMode .= $UnderscorePrint if index($Value, "underscore") != -1 ;
		printf OUTPUT "\tprint \"%s\$_%s\";\n",
		       $PrintMode,
		       $PrintMode ? $NormalPrint : "" ;
            } elsif ("exec" eq $Action) {
                die "$0: 'exec' action requires a value\n" if !$Value ;
                print  OUTPUT "\t\$[ = 1 ;\n" ;
                print  OUTPUT "\tsplit ;\n" ;
		printf OUTPUT "\t&exec_it(%s) ;\n", &convert_command($Value) ;
                print  OUTPUT "\t\$[ = 0 ;\n" ;
	    } elsif ("ignore" eq $Action) {
		printf OUTPUT "\n" ;
	    } elsif ("mail" eq $Action) {
		printf OUTPUT "\t&mail_it('%s', \$_) ;\n",
		       $Value ? $Value : $UserName ; 
	    } elsif ("pipe" eq $Action) {
                die "$0: 'pipe' action requires a value\n" if !$Value ;
		printf OUTPUT "\t&pipe_it('%s', \$_) ;\n", $Value ;
	    } elsif ("write" eq $Action) {
		printf OUTPUT "\t&write_it('%s', \$_) ;\n",
		       $Value ? $Value : $UserName ;
	    } else {
		die "$0: unrecognized action: $Action\n" ;
	    }
        }
	print  OUTPUT "\tnext LINE ;\n" ;
    }
    print OUTPUT "    }\n" ;
    close(INPUT) ;
}


#
# convert_command -- convert wildcards for fields in command from
#	awk type to perl type
#
# usage: &convert_command($Command) ;
#
sub convert_command {
    local($Command) = @_ ;

    $Command =~ s/\$[0*]/\$_/g ;
    $Command =~ s/\$([1-9])/\$_[\1]/g ;

    return $Command ;
}


#
# put_footer -- finish our swatch generated perl script.
#
# usage: &put_footer() ;
#
sub put_footer {
    print  OUTPUT "}\n" ;
    print  OUTPUT "&goodbye() ;\n" ;
    print  OUTPUT "\n" ;
    print  OUTPUT "sub goodbye {\n" ;
    print  OUTPUT "  close(INPUT) ;\n" ;
    print  OUTPUT "  kill('KILL', \$pid) ;\n" if ($Pipe) ;
    print  OUTPUT "  \&close_pipe_if_open() ;\n" ;
    print  OUTPUT "  exit(0) ;\n" ;
    print  OUTPUT "}\n" ;
}


