#!PERL_BIN_DIR/perl
#
# swatch -- system watcher
#
# usage: swatch [ -c config_file ] [ -r restart_time ]
#   [ [ -f file_to_examine ] || [ -p program_to_pipe_from ]
#   || [ -t file_to_tail ] ]
#
# default: swatch -c ~/.swatchrc -t /var/log/syslog
#
# Created on Thu Mar 19 10:10:19 PST 1992 by Todd_Atkins@EE-CF.Stanford.EDU
#
# Copyright (c) 1992 Leland Stanford Jr. University Board of Trustees
#
#
eval 'PERL_BIN_DIR/perl -S $0 ${1+"$@"}'
    if 0 ;
#
$ENV{'PATH'} = '/usr/ucb:/usr/bin:/bin:PERL_BIN_DIR' ;
$ENV{'IFS'} = '' if $ENV{'IFS'} ne '' ;

$VERSION = '1.8.1' ;

# The location of our supporting cast
$SWATCH_PERL_LIB = 'PERL_LIB_DIR' ;

require 'ctime.pl' ;
require 'yagrip.pl' ;
require 'sys/wait.ph' ;

# Some defaults
$PERL = 'PERL_BIN_DIR/perl' ;
$TAIL = '/usr/ucb/tail -f' ;
$DEF_INPUT = "$TAIL /var/log/syslog" ;
$Pipe = 1 ;
$ConfigFile = "$ENV{'HOME'}/.swatchrc" ;

$Done = 0 ;	### Done watching
$Restart = 0 ;	### Restart watcher


#######################################################
# Get the command line arguments and process them
#######################################################

&getopt("c:r:df:p:t:") ||
  die &usage("$0","c:r:f:p:t:","config_file","time_to_restart",
	     "file_to_examine","program_to_pipe_from","file_to_tail") ;

if    ($opt_c)	{ $ConfigFile = $opt_c ; }
if    ($opt_r)	{ $RestartTime = $opt_r ; &set_alarm($RestartTime) ; }

if    ($opt_f)	{ $Input = $opt_f ; $Pipe = 0 ; }
elsif ($opt_p)	{ $Input = "$opt_p" ; }
elsif ($opt_t)	{ $Input = "$TAIL $opt_t" ; }
else		{ $Input = $DEF_INPUT ; }

if ($opt_d) { # debugging
    $Output = "&STDOUT" ;
} else {
    $Output = "SWATCH_TMP_DIR/..swatch..$$" ;
}

############################
# Set up signal handlers
############################

# catch these signals so that we can clean up before dying
$SIG{'INT'} = $SIG{'QUIT'} =  $SIG{'TERM'} = 'quit' ;
# catch these signals so that we can restart swatch more easily
$SIG{'ALRM'} = $SIG{'HUP'} = 'restart' ;

####################
# Main section
####################

do {
    $Restart = 0 ;
    &doit() ;
} until $Done ;

sub doit {
    #
    # create the perl script 
    #
    open(OUTPUT,">$Output") || die "$0: can't open $Output: $!\n" ;

    &put_header() ;
    &sw_cf2pl($ConfigFile,$Output) ;
    &put_footer() ;

    close(OUTPUT) ;

    #
    # Run the perl script unless we are debugging
    #
    if (! $opt_d ) { 
        undef $pid ;
        FORK: {
          if ($pid = fork) {
              waitpid($pid, 0) ;
          } elsif (defined $pid) {
    	      chmod 0755, $Output ;
              exec($Output) ;
          } elsif ($! =~ /No more processes/) {
              # EAGAIN, supposedly recoverable fork error
              sleep 5;
              redo FORK;
          } else {
              die "Can't fork: $!\n";
          }
        }
	$Done = 1 if !$Restart ;
    } else {
	$Done = 1 ;
    }
}

#########################
# End of Main section
#########################


