/*

  sshadt_map.h

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 1999 SSH Communications Security, Finland
  All rights reserved.

  Created Tue Sep 14 09:26:13 1999.

  */

#ifndef SSH_ADT_MAP_H_INCLUDED
#define SSH_ADT_MAP_H_INCLUDED

extern const SshADTContainerType ssh_adt_type_map;

#define SSH_ADT_MAP (ssh_adt_type_map)

/* Set the mapped image of `object_to_be_mapped'. */
void ssh_adt_map_set_map(SshADTContainer map,
                         SshADTHandle object_to_be_mapped,
                         void *image);

/* Map the object `object_to_be_mapped' and return the result. */
void *ssh_adt_map_map(SshADTContainer map,
                      SshADTHandle object_to_be_mapped);

/* Tell the mapping object that the object at
   `object_with_changed_contents' has been changed [and that its hash
   value should be recomputed]. */
void ssh_adt_map_changed(SshADTContainer map,
                         SshADTHandle object_with_changed_contents);

#endif /* SSH_ADT_MAP_H_INCLUDED */
