/*
  sshappcommon.h

  Authors: Sami Lehtinen <sjl@ssh.fi>

  Copyright (C) 1999 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Common functions for all ssh-applications.
 */

#ifndef SSHAPPCOMMON_H
#define SSHAPPCOMMON_H

#include "sshdllist.h"

/* Function for conveying informational messages to user. The output
   is _not_ followed by a newline. */
void ssh_informational(const char *format, ...);

void ssh_informational_callback_register(void (*callback)
                                         (const char *message, void *context),
                                         void *context);

/* Prints version string to stderr. */
void ssh2_version(const char *name);

/* Registeres the program name. */
void ssh_register_program_name(const char *name);

/* Get program name. */
const char *ssh_get_program_name(void);

typedef void (*SshAppListNodeDeleteProc)(void *item);

/* Helper function, that destroys a list, and frees it's contents,
   too. If delete_proc is non-NULL, it is used to delete the list
   item. Otherwise, the item is just ssh_xfree()d. */
void ssh_app_free_list(SshDlList list, SshAppListNodeDeleteProc delete_proc);

/* Helper function, that combines two lists. dst will receive nodes
   from src, and src will be freed. (so the pointer isn't valid after
   this call.) If one or both arguments are NULL, does nothing. */
void ssh_app_combine_lists(SshDlList dst, SshDlList src);

#endif /* SSHAPPCOMMON_H */
