/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_del_cert.C	1.7 95/11/21"

/*
 * Author: Ashar Aziz
 */
#include <stdio.h>
#include <fcntl.h>
#include <ndbm.h>
#include <stdlib.h>
#include <unistd.h>
#include "Bigint.h"
#include "Bstream.h"
#include "SkipCert.h"
#include "skip_conf.h"
#include "skip_certbase.h"

extern int nsid_sizes[];

void
usage()
{
	fprintf(stderr, "skip_del_cert -n NSID -t certtype  <hostid1>\n");
	exit(1);
}
 
int
main(int argc, char **argv)
{
	Bstream certstr;
	if (argc < 4)
		usage();
	int numcerts = argc - 1;
	int i, retval;
	Bstream boxid;
	u_char nsid, certtype;
	int c;
	extern char *optarg;
	extern int  optind;

	while ((c=getopt(argc,argv,"n:t:"))!= -1) {
                switch (c) {
                        case 'n':
                                nsid = atoi(optarg);
                                break;
                        case 't':
				certtype = atoi(optarg);
				if (certtype == 0) 
					certtype = Certname_to_num(optarg);
                                break;
			default:
				usage();
		}
	}
	if (optind >= argc || nsid == 0 || certtype == 0) 
		usage();

	boxid=Bstream((int)strlen(argv[optind]),(u_char *)argv[optind]);
	if (boxid.getlength()==0)
		usage();
	if (boxid.getlength()!=nsid_sizes[nsid]) {
		fprintf(stderr,"Length of keyid %d != keylength for NSID(%d) %d \n",boxid.getlength(), nsid, nsid_sizes[nsid]);
		exit(1);
	}

	retval = skip_del_dh_cert(boxid, nsid ,certtype );
	if (retval) {
		fprintf(stderr, "Error in deleting certificate for boxid %s\n",
				argv[i]);
		exit(1);
	}
	printf("Deleted %s hostid from certificate database\n", 
		(const char *)(argv[optind]));
}
